/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.util.UUID;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BinaryType;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.Type;

public class BinaryUUIDType
extends BinaryType {
    public static final int binaryUUIDPrecision = 16;

    protected BinaryUUIDType() {
        super(-11, 16L);
    }

    @Override
    public int displaySize() {
        return 36;
    }

    @Override
    public int getJDBCTypeCode() {
        return -2;
    }

    @Override
    public Class getJDBCClass() {
        return byte[].class;
    }

    @Override
    public String getJDBCClassName() {
        return "[B";
    }

    @Override
    public String getNameString() {
        return "UUID";
    }

    @Override
    public String getNameFullString() {
        return "UUID";
    }

    @Override
    public String getDefinition() {
        return this.getNameString();
    }

    @Override
    public boolean isBinaryType() {
        return true;
    }

    @Override
    public boolean isUUIDType() {
        return true;
    }

    @Override
    public boolean acceptsPrecision() {
        return false;
    }

    @Override
    public long getMaxPrecision() {
        return 16L;
    }

    @Override
    public boolean requiresPrecision() {
        return false;
    }

    @Override
    public int precedenceDegree(Type other) {
        if (other.typeCode == this.typeCode) {
            return 0;
        }
        if (!other.isBinaryType()) {
            return Integer.MIN_VALUE;
        }
        return other.typeCode == 30 ? 4 : 2;
    }

    @Override
    public Type getAggregateType(Type other) {
        if (other == null) {
            return this;
        }
        if (other == SQL_ALL_TYPES) {
            return this;
        }
        if (this.typeCode == other.typeCode) {
            return this;
        }
        if (other.isCharacterType()) {
            return this;
        }
        switch (other.typeCode) {
            case -11: 
            case 30: 
            case 60: 
            case 61: {
                return this;
            }
        }
        throw Error.error(5562);
    }

    @Override
    public Type getCombinedType(Session session, Type other, int operation) {
        return Type.SQL_VARBINARY_DEFAULT;
    }

    @Override
    public int compare(Session session, Object a, Object b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a instanceof BinaryData && b instanceof BinaryData) {
            byte[] data2;
            byte[] data1 = ((BinaryData)a).getBytes();
            int length = data1.length > (data2 = ((BinaryData)b).getBytes()).length ? data2.length : data1.length;
            for (int i = 0; i < length; ++i) {
                if (data1[i] == data2[i]) continue;
                return (data1[i] & 0xFF) > (data2[i] & 0xFF) ? 1 : -1;
            }
            if (data1.length == data2.length) {
                return 0;
            }
            return data1.length > data2.length ? 1 : -1;
        }
        throw Error.runtimeError(201, "BinaryUUIDType");
    }

    @Override
    public Object convertToTypeLimits(SessionInterface session, Object a) {
        return this.castOrConvertToType(session, a, this, false);
    }

    @Override
    public Object castToType(SessionInterface session, Object a, Type otherType) {
        return this.castOrConvertToType(session, a, otherType, true);
    }

    @Override
    public Object convertToType(SessionInterface session, Object a, Type otherType) {
        return this.castOrConvertToType(session, a, otherType, false);
    }

    @Override
    public Object convertJavaToSQL(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        if (a instanceof byte[]) {
            return new BinaryData((byte[])a, true);
        }
        if (a instanceof UUID) {
            return BinaryUUIDType.getBinary((UUID)a);
        }
        throw Error.error(5561);
    }

    @Override
    public Object convertSQLToJava(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        return BinaryUUIDType.getJavaUUID((BinaryData)a);
    }

    @Override
    Object castOrConvertToType(SessionInterface session, Object a, Type otherType, boolean cast) {
        BlobData b;
        if (a == null) {
            return null;
        }
        switch (otherType.typeCode) {
            case 40: {
                a = Type.SQL_VARCHAR.convertToType(session, a, otherType);
            }
            case 1: 
            case 12: {
                b = session.getScanner().convertToBinary((String)a, true);
                otherType = this;
                break;
            }
            case -11: 
            case 30: 
            case 60: 
            case 61: {
                b = (BlobData)a;
                break;
            }
            default: {
                throw Error.error(3471);
            }
        }
        if (otherType.typeCode == 30) {
            long blobLength = b.length(session);
            if (blobLength != this.precision) {
                throw Error.error(3401);
            }
            byte[] bytes = b.getBytes(session, 0L, (int)this.precision);
            b = new BinaryData(bytes, false);
        } else if (b.length(session) != this.precision) {
            throw Error.error(3401);
        }
        return b;
    }

    @Override
    public Object convertToDefaultType(SessionInterface session, Object a) {
        if (a == null) {
            return a;
        }
        if (a instanceof byte[]) {
            BinaryData b = new BinaryData((byte[])a, false);
            this.castOrConvertToType(session, b, Type.SQL_VARBINARY, false);
        } else {
            if (a instanceof BinaryData) {
                return this.castOrConvertToType(session, a, Type.SQL_VARBINARY, false);
            }
            if (a instanceof String) {
                return this.castOrConvertToType(session, a, Type.SQL_VARCHAR, false);
            }
        }
        throw Error.error(3471);
    }

    @Override
    public String convertToString(Object a) {
        if (a == null) {
            return null;
        }
        return StringConverter.toStringUUID(((BlobData)a).getBytes());
    }

    @Override
    public String convertToSQLString(Object a) {
        if (a == null) {
            return "NULL";
        }
        return StringConverter.toStringUUID(((BlobData)a).getBytes());
    }

    @Override
    public boolean canConvertFrom(Type otherType) {
        return otherType.typeCode == 0 || otherType.isBinaryType() || otherType.isCharacterType();
    }

    @Override
    public int canMoveFrom(Type otherType) {
        if (otherType == this) {
            return 0;
        }
        switch (otherType.typeCode) {
            case -11: {
                return 0;
            }
            case 1: 
            case 12: 
            case 60: 
            case 61: {
                return -1;
            }
        }
        return -1;
    }

    @Override
    public long position(SessionInterface session, BlobData data, BlobData otherData, Type otherType, long offset) {
        if (data == null || otherData == null) {
            return -1L;
        }
        long otherLength = data.length(session);
        if (offset + otherLength > data.length(session)) {
            return -1L;
        }
        return data.position(session, otherData, offset);
    }

    @Override
    public BlobData substring(SessionInterface session, BlobData data, long offset, long length, boolean hasLength) {
        long end;
        long dataLength = data.length(session);
        if (hasLength) {
            end = offset + length;
        } else {
            long l = end = dataLength > offset ? dataLength : offset;
        }
        if (offset > end) {
            throw Error.error(3431);
        }
        if (end < 0L) {
            offset = 0L;
            end = 0L;
        }
        if (offset < 0L) {
            offset = 0L;
        }
        if (end > dataLength) {
            end = dataLength;
        }
        length = end - offset;
        byte[] bytes = data.getBytes(session, offset, (int)length);
        return new BinaryData(bytes, false);
    }

    @Override
    int getRightTrimSize(BlobData data) {
        byte[] bytes = data.getBytes();
        int endindex = bytes.length;
        --endindex;
        while (endindex >= 0 && bytes[endindex] == 0) {
            --endindex;
        }
        return ++endindex;
    }

    @Override
    public BlobData trim(Session session, BlobData data, int trim, boolean leading, boolean trailing) {
        int startindex;
        if (data == null) {
            return null;
        }
        long length = data.length(session);
        if (length > Integer.MAX_VALUE) {
            throw Error.error(3460);
        }
        byte[] bytes = data.getBytes(session, 0L, (int)length);
        int endindex = bytes.length;
        if (trailing) {
            --endindex;
            while (endindex >= 0 && bytes[endindex] == trim) {
                --endindex;
            }
            ++endindex;
        }
        if (leading) {
            for (startindex = 0; startindex < endindex && bytes[startindex] == trim; ++startindex) {
            }
        }
        byte[] newBytes = bytes;
        if (startindex != 0 || endindex != bytes.length) {
            newBytes = new byte[endindex - startindex];
            System.arraycopy(bytes, startindex, newBytes, 0, endindex - startindex);
        }
        return new BinaryData(newBytes, newBytes == bytes);
    }

    @Override
    public BlobData overlay(Session session, BlobData data, BlobData overlay, long offset, long length, boolean hasLength) {
        if (data == null || overlay == null) {
            return null;
        }
        if (!hasLength) {
            length = overlay.length(session);
        }
        BinaryData binary = new BinaryData(session, this.substring(session, data, 0L, offset, true), overlay);
        binary = new BinaryData(session, binary, this.substring(session, data, offset + length, 0L, false));
        return binary;
    }

    @Override
    public Object concat(Session session, Object a, Object b) {
        if (a == null || b == null) {
            return null;
        }
        long length = ((BlobData)a).length(session) + ((BlobData)b).length(session);
        if (length > this.precision) {
            throw Error.error(3401);
        }
        return new BinaryData(session, (BlobData)a, (BlobData)b);
    }

    public static BinaryData getBinary(long hi, long lo) {
        return new BinaryData(ArrayUtil.toByteArray(hi, lo), false);
    }

    public static BinaryData getBinary(UUID uuid) {
        return BinaryUUIDType.getBinary(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public static UUID getJavaUUID(BinaryData data) {
        if (data == null) {
            return null;
        }
        byte[] bytes = data.getBytes();
        long msb = ArrayUtil.byteSequenceToLong(bytes, 0);
        long lsb = ArrayUtil.byteSequenceToLong(bytes, 8);
        return new UUID(msb, lsb);
    }
}

