/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.sql.Clob;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCClobClient;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.Collation;
import org.hsqldb.types.Type;

public final class ClobType
extends CharacterType {
    public static final long maxClobPrecision = 0x10000000000L;
    public static final int defaultClobSize = 0x40000000;
    public static final int defaultShortClobSize = 0x1000000;

    public ClobType(long precision) {
        super(40, precision);
    }

    public ClobType(Collation collation, long precision) {
        super(collation, 40, precision);
    }

    @Override
    public int displaySize() {
        return this.precision > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.precision;
    }

    @Override
    public int getJDBCTypeCode() {
        return 2005;
    }

    @Override
    public Class getJDBCClass() {
        return Clob.class;
    }

    @Override
    public String getJDBCClassName() {
        return "java.sql.Clob";
    }

    @Override
    public int getSQLGenericTypeCode() {
        return this.typeCode;
    }

    @Override
    public String getDefinition() {
        long factor = this.precision;
        String multiplier = null;
        if (this.precision % 1024L == 0L) {
            if (this.precision % 0x40000000L == 0L) {
                factor = this.precision / 0x40000000L;
                multiplier = "G";
            } else if (this.precision % 0x100000L == 0L) {
                factor = this.precision / 0x100000L;
                multiplier = "M";
            } else {
                factor = this.precision / 1024L;
                multiplier = "K";
            }
        }
        StringBuilder sb = new StringBuilder(16);
        sb.append(this.getNameString());
        sb.append('(');
        sb.append(factor);
        if (multiplier != null) {
            sb.append(multiplier);
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public long getMaxPrecision() {
        return 0x10000000000L;
    }

    @Override
    public boolean isLobType() {
        return true;
    }

    @Override
    public int compare(Session session, Object a, Object b) {
        return this.compare(session, a, b, 40);
    }

    @Override
    public int compare(Session session, Object a, Object b, int opType) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (b instanceof String) {
            long lobId = ((ClobData)a).getId();
            return session.database.lobManager.compare(this.collation, lobId, (String)b);
        }
        return session.database.lobManager.compare(this.collation, (ClobData)a, (ClobData)b);
    }

    @Override
    public Object convertToDefaultType(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        if (a instanceof ClobData) {
            return a;
        }
        if (a instanceof String) {
            ClobDataID clob = session.createClob(((String)a).length());
            clob.setString(session, 0L, (String)a);
            return clob;
        }
        throw Error.error(5561);
    }

    @Override
    public String convertToString(Object a) {
        if (a == null) {
            return null;
        }
        return Long.toString(((ClobData)a).getId());
    }

    @Override
    public String convertToSQLString(Object a) {
        if (a == null) {
            return "NULL";
        }
        return this.convertToString(a);
    }

    @Override
    public Object convertJavaToSQL(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        if (a instanceof JDBCClobClient) {
            return ((JDBCClobClient)a).getClob();
        }
        throw Error.error(5561);
    }

    @Override
    public Object convertSQLToJava(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        if (a instanceof ClobDataID) {
            ClobDataID clob = (ClobDataID)a;
            return new JDBCClobClient(session, clob);
        }
        throw Error.error(5561);
    }

    @Override
    public long position(SessionInterface session, Object data, Object otherData, Type otherType, long start) {
        if (otherType.typeCode == 40) {
            return ((ClobData)data).position(session, (ClobData)otherData, start);
        }
        if (otherType.isCharacterType()) {
            return ((ClobData)data).position(session, (String)otherData, start);
        }
        throw Error.runtimeError(201, "ClobType");
    }
}

