/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.math.BigDecimal;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.IntKeyIntValueHashMap;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.Type;

public abstract class DTIType
extends Type {
    public static final int secondsInDay = 86400;
    public static final long millisInSecond = 1000L;
    public static final long nanosInMilli = 1000000L;
    public static final long nanosInSecond = 1000000000L;
    public static final byte[] yearToSecondSeparators = new byte[]{45, 45, 32, 58, 58, 46};
    public static final int[] yearToSecondFactors = new int[]{12, 1, 86400, 3600, 60, 1, 0};
    public static final int[] yearToSecondLimits = new int[]{0, 12, 0, 24, 60, 60, 1000000000};
    public static final int INTERVAL_MONTH_INDEX = 1;
    public static final int INTERVAL_SECOND_INDEX = 5;
    public static final int INTERVAL_FRACTION_PART_INDEX = 6;
    public static final long[] precisionLimits = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L};
    static final int[] precisionFactors = new int[]{100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10, 1};
    static final int[] nanoScaleFactors = new int[]{1000000000, 100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10, 1};
    public static final int timezoneSecondsLimit = 64800;
    static final int[] intervalParts = new int[]{101, 102, 103, 104, 105, 106};
    static final int[][] intervalTypes = new int[][]{{101, 107, 0, 0, 0, 0}, {0, 102, 0, 0, 0, 0}, {0, 0, 103, 108, 109, 110}, {0, 0, 0, 104, 111, 112}, {0, 0, 0, 0, 105, 113}, {0, 0, 0, 0, 0, 106}};
    static final IntKeyIntValueHashMap intervalIndexMap = new IntKeyIntValueHashMap();
    public final int startIntervalType;
    public final int endIntervalType;
    public final int startPartIndex;
    public final int endPartIndex;
    public static final int defaultTimeFractionPrecision = 0;
    public static final int defaultTimestampFractionPrecision = 6;
    public static final int defaultIntervalPrecision = 2;
    public static final int defaultIntervalFractionPrecision = 6;
    public static final int maxIntervalPrecision = 9;
    public static final int maxIntervalSecondPrecision = 12;
    public static final int maxFractionPrecision = 9;
    public static final int limitNanoseconds = 1000000000;

    protected DTIType(int typeGroup, int type, long precision, int scale, int startIntervalType, int endIntervalType) {
        super(typeGroup, type, precision, scale);
        this.startIntervalType = startIntervalType;
        this.endIntervalType = endIntervalType;
        this.startPartIndex = intervalIndexMap.get(startIntervalType);
        this.endPartIndex = intervalIndexMap.get(endIntervalType);
    }

    protected DTIType(int typeGroup, int type, long precision, int scale) {
        super(typeGroup, type, precision, scale);
        switch (type) {
            case 91: {
                this.startIntervalType = 101;
                this.endIntervalType = 103;
                break;
            }
            case 92: 
            case 94: {
                this.startIntervalType = 104;
                this.endIntervalType = 106;
                break;
            }
            case 93: 
            case 95: {
                this.startIntervalType = 101;
                this.endIntervalType = 106;
                break;
            }
            default: {
                throw Error.runtimeError(201, "DTIType");
            }
        }
        this.startPartIndex = intervalIndexMap.get(this.startIntervalType);
        this.endPartIndex = intervalIndexMap.get(this.endIntervalType);
    }

    String intervalSecondToString(long seconds, int nanos, boolean signed) {
        int i;
        StringBuilder sb = new StringBuilder(64);
        if (seconds < 0L) {
            seconds = -seconds;
            sb.append('-');
        } else if (signed) {
            sb.append('+');
        }
        for (i = this.startPartIndex; i <= this.endPartIndex; ++i) {
            int factor = yearToSecondFactors[i];
            long part = seconds / (long)factor;
            if (i == this.startPartIndex) {
                int startDigits = this.precision == 0L ? 2 : (int)this.precision;
                int n = startDigits - DTIType.getPrecisionExponent(part);
            } else if (part < 10L) {
                sb.append('0');
            }
            sb.append(part);
            seconds %= (long)factor;
            if (i >= this.endPartIndex) continue;
            sb.append((char)yearToSecondSeparators[i]);
        }
        if (this.scale != 0) {
            sb.append((char)yearToSecondSeparators[5]);
        }
        if (nanos < 0) {
            nanos = -nanos;
        }
        for (i = 0; i < this.scale; ++i) {
            int digit = nanos / precisionFactors[i];
            nanos -= digit * precisionFactors[i];
            sb.append(digit);
        }
        return sb.toString();
    }

    public int getStartIntervalType() {
        return this.startIntervalType;
    }

    public int getEndIntervalType() {
        return this.endIntervalType;
    }

    public Type getExtractType(int part) {
        switch (part) {
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 136: {
                if (!this.isDateTimeType()) {
                    throw Error.error(5561);
                }
                if (part == 128 || part == 129) {
                    return Type.SQL_VARCHAR;
                }
                return Type.SQL_INTEGER;
            }
            case 106: {
                if (part == this.startIntervalType || part == this.endIntervalType) {
                    if (this.scale == 0) {
                        return Type.SQL_BIGINT;
                    }
                    return new NumberType(3, 12 + this.scale, this.scale);
                }
                throw Error.error(5561);
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                if (part < this.startIntervalType || part > this.endIntervalType) {
                    throw Error.error(5561);
                }
                return Type.SQL_INTEGER;
            }
            case 132: 
            case 133: 
            case 134: {
                return Type.SQL_BIGINT;
            }
            case 130: {
                if (!this.isDateTimeType() || this.endIntervalType < 106) {
                    throw Error.error(5561);
                }
                return Type.SQL_INTEGER;
            }
            case 121: 
            case 122: 
            case 135: {
                if (this.typeCode != 95 && this.typeCode != 94) {
                    throw Error.error(5561);
                }
                return Type.SQL_INTEGER;
            }
        }
        throw Error.runtimeError(201, "DTIType");
    }

    public static int normaliseFraction(int fraction, int precision) {
        return fraction / nanoScaleFactors[precision] * nanoScaleFactors[precision];
    }

    public static int normaliseFraction(int fraction, int digits, int precision) {
        return (fraction *= nanoScaleFactors[digits]) / nanoScaleFactors[precision] * nanoScaleFactors[precision];
    }

    static int getPrecisionExponent(long value) {
        int i;
        for (i = 1; i < precisionLimits.length && value >= precisionLimits[i]; ++i) {
        }
        return i;
    }

    public static int getFieldNameTypeForToken(int token) {
        switch (token) {
            case 341: {
                return 101;
            }
            case 183: {
                return 102;
            }
            case 78: {
                return 103;
            }
            case 137: {
                return 104;
            }
            case 179: {
                return 105;
            }
            case 264: {
                return 106;
            }
            case 872: {
                return 132;
            }
            case 871: {
                return 133;
            }
            case 873: {
                return 134;
            }
            case 299: {
                return 121;
            }
            case 300: {
                return 122;
            }
            case 828: {
                return 135;
            }
            case 734: {
                return 128;
            }
            case 773: {
                return 129;
            }
            case 787: {
                return 127;
            }
            case 735: {
                return 124;
            }
            case 736: {
                return 123;
            }
            case 737: {
                return 125;
            }
            case 851: {
                return 126;
            }
            case 852: {
                return 136;
            }
            case 805: {
                return 130;
            }
        }
        throw Error.runtimeError(201, "DTIType");
    }

    public static String getFieldNameTokenForType(int type) {
        switch (type) {
            case 101: {
                return "YEAR";
            }
            case 102: {
                return "MONTH";
            }
            case 103: {
                return "DAY";
            }
            case 104: {
                return "HOUR";
            }
            case 105: {
                return "MINUTE";
            }
            case 106: {
                return "SECOND";
            }
            case 121: {
                return "TIMEZONE_HOUR";
            }
            case 122: {
                return "TIMEZONE_MINUTE";
            }
            case 128: {
                return "DAY_NAME";
            }
            case 129: {
                return "MONTH_NAME";
            }
            case 127: {
                return "QUARTER";
            }
            case 124: {
                return "DAY_OF_MONTH";
            }
            case 123: {
                return "DAY_OF_WEEK";
            }
            case 125: {
                return "DAY_OF_YEAR";
            }
            case 126: {
                return "WEEK_OF_YEAR";
            }
            case 136: {
                return "ISO_WEEK_OF_YEAR";
            }
            case 130: {
                return "SECONDS_SINCE_MIDNIGHT";
            }
        }
        throw Error.runtimeError(201, "DTIType");
    }

    public static boolean isValidDatetimeRange(Type a, Type b) {
        if (!a.isDateTimeType()) {
            return false;
        }
        if (b.isDateTimeType()) {
            return (a.typeCode != 92 || b.typeCode != 91) && (a.typeCode != 91 || b.typeCode != 92);
        }
        if (b.isIntervalType()) {
            return ((DateTimeType)a).canAdd((IntervalType)b);
        }
        return false;
    }

    public abstract int getPart(Session var1, Object var2, int var3);

    public abstract BigDecimal getSecondPart(Session var1, Object var2);

    BigDecimal getSecondPart(long seconds, long nanos) {
        seconds *= precisionLimits[this.scale];
        return BigDecimal.valueOf(seconds += nanos / (long)nanoScaleFactors[this.scale], this.scale);
    }

    static {
        intervalIndexMap.put(101, 0);
        intervalIndexMap.put(102, 1);
        intervalIndexMap.put(103, 2);
        intervalIndexMap.put(104, 3);
        intervalIndexMap.put(105, 4);
        intervalIndexMap.put(106, 5);
    }
}

