/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.TimeZone;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.types.DTIType;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public final class DateTimeType
extends DTIType {
    public static final long epochSeconds = HsqlDateTime.getDateSeconds("1-01-01");
    public static final TimestampData epochTimestamp = new TimestampData(epochSeconds);
    public static final long epochLimitSeconds = HsqlDateTime.getDateSeconds("10000-01-01");
    public static final TimestampData epochLimitTimestamp = new TimestampData(epochLimitSeconds);
    public static final TimeZone systemTimeZone = TimeZone.getDefault();
    public static final HashSet zoneIDs = new HashSet(TimeZone.getAvailableIDs());
    public final boolean withTimeZone;
    private final String nameString;

    public DateTimeType(int typeGroup, int type, int scale) {
        super(typeGroup, type, 0L, scale);
        this.withTimeZone = type == 94 || type == 95;
        this.nameString = this.getNameStringPrivate();
    }

    @Override
    public int displaySize() {
        switch (this.typeCode) {
            case 91: {
                return 10;
            }
            case 92: {
                return 8 + (this.scale == 0 ? 0 : this.scale + 1);
            }
            case 94: {
                return 8 + (this.scale == 0 ? 0 : this.scale + 1) + 6;
            }
            case 93: {
                return 19 + (this.scale == 0 ? 0 : this.scale + 1);
            }
            case 95: {
                return 19 + (this.scale == 0 ? 0 : this.scale + 1) + 6;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public int getJDBCTypeCode() {
        switch (this.typeCode) {
            case 94: {
                return 2013;
            }
            case 95: {
                return 2014;
            }
        }
        return this.typeCode;
    }

    @Override
    public Class getJDBCClass() {
        switch (this.typeCode) {
            case 91: {
                return Date.class;
            }
            case 92: {
                return Time.class;
            }
            case 93: {
                return Timestamp.class;
            }
            case 94: {
                return OffsetTime.class;
            }
            case 95: {
                return OffsetDateTime.class;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public String getJDBCClassName() {
        switch (this.typeCode) {
            case 91: {
                return "java.sql.Date";
            }
            case 92: {
                return "java.sql.Time";
            }
            case 93: {
                return "java.sql.Timestamp";
            }
            case 94: {
                return "java.time.OffsetTime";
            }
            case 95: {
                return "java.time.OffsetDateTime";
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public int getJDBCPrecision() {
        return this.displaySize();
    }

    @Override
    public int getSQLGenericTypeCode() {
        return 9;
    }

    @Override
    public String getNameString() {
        return this.nameString;
    }

    @Override
    public boolean canCompareDirect(Type otherType) {
        return this.typeCode == otherType.typeCode;
    }

    private String getNameStringPrivate() {
        switch (this.typeCode) {
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 94: {
                return "TIME WITH TIME ZONE";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case 95: {
                return "TIMESTAMP WITH TIME ZONE";
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public String getDefinition() {
        String token;
        switch (this.typeCode) {
            case 91: {
                return "DATE";
            }
            case 92: 
            case 94: {
                if (this.scale == 0) {
                    return this.getNameString();
                }
                token = "TIME";
                break;
            }
            case 93: 
            case 95: {
                if (this.scale == 6) {
                    return this.getNameString();
                }
                token = "TIMESTAMP";
                break;
            }
            default: {
                throw Error.runtimeError(201, "DateTimeType");
            }
        }
        StringBuilder sb = new StringBuilder(16);
        sb.append(token);
        sb.append('(');
        sb.append(this.scale);
        sb.append(')');
        if (this.withTimeZone) {
            sb.append(" WITH TIME ZONE");
        }
        return sb.toString();
    }

    @Override
    public boolean isDateTimeType() {
        return true;
    }

    @Override
    public boolean isDateOrTimestampType() {
        switch (this.typeCode) {
            case 91: 
            case 93: 
            case 95: {
                return true;
            }
            case 92: 
            case 94: {
                return false;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public boolean isTimestampType() {
        switch (this.typeCode) {
            case 93: 
            case 95: {
                return true;
            }
            case 91: 
            case 92: 
            case 94: {
                return false;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public boolean isTimeType() {
        switch (this.typeCode) {
            case 91: 
            case 93: 
            case 95: {
                return false;
            }
            case 92: 
            case 94: {
                return true;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public boolean isDateTimeTypeWithZone() {
        return this.withTimeZone;
    }

    @Override
    public boolean acceptsFractionalPrecision() {
        return this.typeCode != 91;
    }

    @Override
    public Type getAggregateType(Type other) {
        int startType;
        if (other == null) {
            return this;
        }
        if (other == SQL_ALL_TYPES) {
            return this;
        }
        if (this.typeCode == other.typeCode) {
            return this.scale >= other.scale ? this : other;
        }
        if (other.typeCode == 0) {
            return this;
        }
        if (other.isCharacterType()) {
            return other.getAggregateType(this);
        }
        if (!other.isDateTimeType()) {
            throw Error.error(5562);
        }
        DateTimeType otherType = (DateTimeType)other;
        if (otherType.startIntervalType > this.endIntervalType || this.startIntervalType > otherType.endIntervalType) {
            throw Error.error(5562);
        }
        int newType = this.typeCode;
        int scale = this.scale > otherType.scale ? this.scale : otherType.scale;
        boolean zone = this.withTimeZone || otherType.withTimeZone;
        int n = startType = otherType.startIntervalType > this.startIntervalType ? this.startIntervalType : otherType.startIntervalType;
        newType = startType == 104 ? (zone ? 94 : 92) : (zone ? 95 : 93);
        return DateTimeType.getDateTimeType(newType, scale);
    }

    @Override
    public Type getCombinedType(Session session, Type other, int operation) {
        switch (operation) {
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                int startType;
                if (this.typeCode == other.typeCode) {
                    return this;
                }
                if (other.typeCode == 0) {
                    return this;
                }
                if (!other.isDateTimeType()) {
                    throw Error.error(5562);
                }
                DateTimeType otherType = (DateTimeType)other;
                if (otherType.startIntervalType > this.endIntervalType || this.startIntervalType > otherType.endIntervalType) {
                    throw Error.error(5562);
                }
                int newType = this.typeCode;
                int scale = this.scale > otherType.scale ? this.scale : otherType.scale;
                boolean zone = this.withTimeZone || otherType.withTimeZone;
                int n = startType = otherType.startIntervalType > this.startIntervalType ? this.startIntervalType : otherType.startIntervalType;
                newType = startType == 104 ? (zone ? 94 : 92) : (zone ? 95 : 93);
                return DateTimeType.getDateTimeType(newType, scale);
            }
            case 32: 
            case 33: {
                if (other.isIntervalType()) {
                    if (this.typeCode != 91 && other.scale > this.scale) {
                        return DateTimeType.getDateTimeType(this.typeCode, other.scale);
                    }
                    return this;
                }
                if (other.isDateTimeType()) {
                    if (operation != 33 || other.typeComparisonGroup != this.typeComparisonGroup) break;
                    if (this.typeCode == 91) {
                        return Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                    }
                    return Type.SQL_INTERVAL_DAY_TO_SECOND_MAX_PRECISION;
                }
                if (!other.isNumberType()) break;
                return this;
            }
        }
        throw Error.error(5562);
    }

    @Override
    public int compare(Session session, Object a, Object b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        switch (this.typeCode) {
            case 92: 
            case 94: {
                long diff = ((TimeData)a).seconds - ((TimeData)b).seconds;
                if (diff == 0L) {
                    diff = ((TimeData)a).nanos - ((TimeData)b).nanos;
                }
                return diff == 0L ? 0 : (diff > 0L ? 1 : -1);
            }
            case 91: 
            case 93: 
            case 95: {
                long diff = ((TimestampData)a).seconds - ((TimestampData)b).seconds;
                if (diff == 0L) {
                    diff = ((TimestampData)a).nanos - ((TimestampData)b).nanos;
                }
                return diff == 0L ? 0 : (diff > 0L ? 1 : -1);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public Object convertToTypeLimits(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        switch (this.typeCode) {
            case 91: {
                return a;
            }
            case 92: 
            case 94: {
                TimeData ti = (TimeData)a;
                int nanos = ti.nanos;
                int newNanos = this.scaleNanos(nanos);
                if (newNanos == nanos) {
                    return ti;
                }
                return new TimeData(ti.seconds, newNanos, ti.zone);
            }
            case 93: 
            case 95: {
                TimestampData ts = (TimestampData)a;
                int nanos = ts.nanos;
                int newNanos = this.scaleNanos(nanos);
                if (ts.seconds > epochLimitSeconds) {
                    throw Error.error(3408);
                }
                if (newNanos == nanos) {
                    return ts;
                }
                return new TimestampData(ts.seconds, newNanos, ts.zone);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    int scaleNanos(int nanos) {
        int divisor = nanoScaleFactors[this.scale];
        return nanos / divisor * divisor;
    }

    @Override
    public Object convertToType(SessionInterface session, Object a, Type otherType) {
        if (a == null) {
            return a;
        }
        switch (otherType.typeCode) {
            case 40: {
                a = Type.SQL_VARCHAR.convertToType(session, a, otherType);
            }
            case 1: 
            case 12: {
                switch (this.typeCode) {
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        try {
                            return session.getScanner().convertToDatetimeInterval(session, (String)a, this);
                        }
                        catch (HsqlException e) {
                            return DateTimeType.convertToDatetimeSpecial(session, (String)a, this);
                        }
                    }
                }
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                break;
            }
            default: {
                throw Error.error(5561);
            }
        }
        switch (this.typeCode) {
            case 91: {
                switch (otherType.typeCode) {
                    case 91: {
                        return a;
                    }
                    case 95: {
                        long seconds = ((TimestampData)a).seconds + (long)((TimestampData)a).zone;
                        seconds = DateTimeType.toDateSeconds(seconds);
                        return new TimestampData(seconds);
                    }
                    case 93: {
                        long seconds = ((TimestampData)a).seconds;
                        seconds = DateTimeType.toDateSeconds(seconds);
                        return new TimestampData(seconds);
                    }
                }
                throw Error.error(5561);
            }
            case 94: {
                switch (otherType.typeCode) {
                    case 94: {
                        return this.convertToTypeLimits(session, a);
                    }
                    case 92: {
                        TimeData ti = (TimeData)a;
                        int zoneSeconds = session.getZoneSeconds();
                        return new TimeData(ti.seconds - zoneSeconds, this.scaleNanos(ti.nanos), zoneSeconds);
                    }
                    case 95: {
                        TimestampData ts = (TimestampData)a;
                        int seconds = DateTimeType.toTimeSeconds(ts.seconds);
                        return new TimeData(seconds, this.scaleNanos(ts.nanos), ts.zone);
                    }
                    case 93: {
                        TimestampData ts = (TimestampData)a;
                        int zoneSeconds = session.getZoneSeconds();
                        int seconds = DateTimeType.toTimeSeconds(ts.seconds - (long)zoneSeconds);
                        return new TimeData(seconds, this.scaleNanos(ts.nanos), zoneSeconds);
                    }
                }
                throw Error.error(5561);
            }
            case 92: {
                switch (otherType.typeCode) {
                    case 94: {
                        TimeData ti = (TimeData)a;
                        int seconds = DateTimeType.toTimeSeconds(ti.seconds + ti.zone);
                        return new TimeData(seconds, this.scaleNanos(ti.nanos));
                    }
                    case 92: {
                        return this.convertToTypeLimits(session, a);
                    }
                    case 95: {
                        TimestampData ts = (TimestampData)a;
                        int seconds = DateTimeType.toTimeSeconds(ts.seconds + (long)ts.zone);
                        return new TimeData(seconds, this.scaleNanos(ts.nanos));
                    }
                    case 93: {
                        TimestampData ts = (TimestampData)a;
                        int seconds = DateTimeType.toTimeSeconds(ts.seconds);
                        return new TimeData(seconds, this.scaleNanos(ts.nanos));
                    }
                }
                throw Error.error(5561);
            }
            case 95: {
                switch (otherType.typeCode) {
                    case 92: 
                    case 94: {
                        TimeData ti = (TimeData)a;
                        return this.convertTimeToTimestamp(session.getCalendar(), ti.seconds + ti.zone, this.scaleNanos(ti.nanos));
                    }
                    case 95: {
                        return this.convertToTypeLimits(session, a);
                    }
                    case 91: 
                    case 93: {
                        if (!(a instanceof TimestampData)) {
                            throw Error.error(5561);
                        }
                        TimestampData ts = (TimestampData)a;
                        Calendar calendar = session.getCalendar();
                        long seconds = HsqlDateTime.convertSecondsFromCalendar(session.getCalendarGMT(), calendar, ts.seconds);
                        int zoneSeconds = DateTimeType.getZoneSeconds(seconds, calendar.getTimeZone());
                        return new TimestampData(seconds, this.scaleNanos(ts.nanos), zoneSeconds);
                    }
                }
                throw Error.error(5561);
            }
            case 93: {
                switch (otherType.typeCode) {
                    case 92: 
                    case 94: {
                        TimeData ti = (TimeData)a;
                        return this.convertTimeToTimestamp(session.getCalendar(), ti.seconds + ti.zone, this.scaleNanos(ti.nanos));
                    }
                    case 95: {
                        TimestampData ts = (TimestampData)a;
                        long seconds = ts.seconds + (long)ts.zone;
                        return new TimestampData(seconds, this.scaleNanos(ts.nanos));
                    }
                    case 93: {
                        return this.convertToTypeLimits(session, a);
                    }
                    case 91: {
                        return a;
                    }
                }
                throw Error.error(5561);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public Object convertToDefaultType(SessionInterface session, Object a) {
        DateTimeType otherType = a instanceof TimeData ? Type.SQL_TIME : Type.SQL_TIMESTAMP;
        return this.convertToType(session, a, otherType);
    }

    @Override
    public Object convertJavaToSQL(SessionInterface session, Object a) {
        return this.convertJavaToSQL(session, a, null);
    }

    public Object convertJavaToSQL(SessionInterface session, Object a, Calendar calendar) {
        if (a == null) {
            return null;
        }
        if (calendar == null) {
            calendar = session.getCalendar();
        }
        long seconds = 0L;
        int nanos = 0;
        int zoneSeconds = 0;
        boolean hasZone = false;
        boolean isTimeObject = false;
        boolean isDateObject = false;
        if (a instanceof java.util.Date) {
            long millis = ((java.util.Date)a).getTime();
            if (a instanceof Time) {
                isTimeObject = true;
                nanos = (int)(millis % 1000L * 1000000L);
            } else if (a instanceof Date) {
                isDateObject = true;
            } else if (a instanceof Timestamp) {
                nanos = ((Timestamp)a).getNanos();
                millis -= (long)nanos / 1000000L;
            } else {
                nanos = (int)(millis % 1000L * 1000000L);
            }
            seconds = millis / 1000L;
            zoneSeconds = DateTimeType.getZoneSeconds(seconds, calendar.getTimeZone());
        } else if (a instanceof LocalDate) {
            LocalDate ld = (LocalDate)a;
            DateTimeType.setDateComponents(calendar, ld);
            seconds = calendar.getTimeInMillis() / 1000L;
            zoneSeconds = DateTimeType.getZoneSeconds(seconds, calendar.getTimeZone());
            nanos = 0;
            isDateObject = true;
        } else if (a instanceof OffsetDateTime) {
            OffsetDateTime odt = (OffsetDateTime)a;
            seconds = odt.toEpochSecond();
            zoneSeconds = odt.get(ChronoField.OFFSET_SECONDS);
            nanos = odt.getNano();
            hasZone = true;
        } else if (a instanceof ZonedDateTime) {
            ZonedDateTime zdt = (ZonedDateTime)a;
            seconds = zdt.toEpochSecond();
            zoneSeconds = zdt.get(ChronoField.OFFSET_SECONDS);
            nanos = zdt.getNano();
            hasZone = true;
        } else if (a instanceof LocalDateTime) {
            LocalDateTime ldt = (LocalDateTime)a;
            DateTimeType.setDateTimeComponents(calendar, ldt);
            seconds = calendar.getTimeInMillis() / 1000L;
            zoneSeconds = DateTimeType.getZoneSeconds(seconds, calendar.getTimeZone());
            nanos = ldt.getNano();
        } else if (a instanceof Instant) {
            Instant ins = (Instant)a;
            seconds = ins.getEpochSecond();
            zoneSeconds = DateTimeType.getZoneSeconds(seconds, calendar.getTimeZone());
            nanos = ins.getNano();
        } else if (a instanceof OffsetTime) {
            OffsetTime ot = (OffsetTime)a;
            seconds = ot.toLocalTime().toSecondOfDay();
            zoneSeconds = ot.get(ChronoField.OFFSET_SECONDS);
            seconds -= (long)zoneSeconds;
            nanos = ot.getNano();
            isTimeObject = true;
            hasZone = true;
        } else if (a instanceof LocalTime) {
            LocalTime lt = (LocalTime)a;
            seconds = lt.toSecondOfDay();
            zoneSeconds = DateTimeType.getZoneSeconds(seconds, calendar.getTimeZone());
            nanos = lt.getNano();
            isTimeObject = true;
        } else {
            throw Error.error(5561);
        }
        if (!this.withTimeZone) {
            seconds += (long)zoneSeconds;
            zoneSeconds = 0;
        }
        switch (this.typeCode) {
            case 92: 
            case 94: {
                if (isDateObject) {
                    throw Error.error(5561);
                }
                nanos = DateTimeType.normaliseFraction(nanos, this.scale);
                return new TimeData((int)seconds, nanos, zoneSeconds);
            }
            case 91: {
                if (isTimeObject) {
                    throw Error.error(5561);
                }
                seconds = DateTimeType.toDateSeconds(seconds);
                return new TimestampData(seconds);
            }
            case 93: 
            case 95: {
                if (isTimeObject) {
                    return this.convertTimeToTimestamp(calendar, seconds + (long)zoneSeconds, nanos);
                }
                nanos = DateTimeType.normaliseFraction(nanos, this.scale);
                return new TimestampData(seconds, nanos, zoneSeconds);
            }
        }
        throw Error.error(5561);
    }

    public Object convertSQLToJavaGMT(SessionInterface session, Object a) {
        switch (this.typeCode) {
            case 92: 
            case 94: {
                long millis = (long)((TimeData)a).seconds * 1000L;
                return new Time(millis += (long)((TimeData)a).nanos / 1000000L);
            }
            case 91: {
                long millis = ((TimestampData)a).seconds * 1000L;
                return new Date(millis);
            }
            case 93: 
            case 95: {
                long millis = ((TimestampData)a).seconds * 1000L;
                Timestamp value = new Timestamp(millis);
                value.setNanos(((TimestampData)a).nanos);
                return value;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public Object convertSQLToJava(SessionInterface session, Object a) {
        Calendar cal = session.getCalendar();
        return this.convertSQLToJava(session, a, null);
    }

    public Object convertSQLToJava(SessionInterface session, Object a, Calendar cal) {
        if (a == null) {
            return null;
        }
        if (cal == null) {
            cal = session.getCalendar();
        }
        switch (this.typeCode) {
            case 92: {
                TimeData td = (TimeData)a;
                DateTimeType.setTimeComponents(cal, td.seconds);
                long millis = cal.getTimeInMillis() + (long)td.nanos / 1000000L;
                return new Time(millis);
            }
            case 94: {
                TimeData ts = (TimeData)a;
                ZoneOffset zone = ZoneOffset.ofTotalSeconds(ts.zone);
                int seconds = DateTimeType.toTimeSeconds(ts.seconds + ts.zone);
                long nanos = (long)seconds * 1000000000L;
                LocalTime ldt = LocalTime.ofNanoOfDay(nanos + (long)ts.nanos);
                return OffsetTime.of(ldt, zone);
            }
            case 91: {
                Calendar calGMT = session.getCalendarGMT();
                long millis = ((TimestampData)a).getMillis();
                HsqlDateTime.convertMillisFromCalendar(calGMT, cal, millis);
                HsqlDateTime.zeroFromPart(cal, 103);
                millis = cal.getTimeInMillis();
                return new Date(millis);
            }
            case 93: {
                Calendar calGMT = session.getCalendarGMT();
                long millis = ((TimestampData)a).getMillis();
                millis = HsqlDateTime.convertMillisFromCalendar(calGMT, cal, millis);
                Timestamp value = new Timestamp(millis);
                value.setNanos(((TimestampData)a).nanos);
                return value;
            }
            case 95: {
                TimestampData ts = (TimestampData)a;
                ZoneOffset zone = ZoneOffset.ofTotalSeconds(ts.zone);
                LocalDateTime ldt = LocalDateTime.ofEpochSecond(ts.seconds, ts.nanos, zone);
                return OffsetDateTime.of(ldt, zone);
            }
        }
        throw Error.error(5561);
    }

    @Override
    public String convertToString(Object a) {
        boolean zone = false;
        if (a == null) {
            return null;
        }
        switch (this.typeCode) {
            case 91: {
                return HsqlDateTime.getDateString(((TimestampData)a).seconds);
            }
            case 92: 
            case 94: {
                TimeData t = (TimeData)a;
                int seconds = DateTimeType.toTimeSeconds(t.seconds + t.zone);
                String s = this.intervalSecondToString(seconds, t.nanos, false);
                if (!this.withTimeZone) {
                    return s;
                }
                s = s + Type.SQL_INTERVAL_HOUR_TO_MINUTE.intervalSecondToString(t.zone, 0, true);
                return s;
            }
            case 93: 
            case 95: {
                TimestampData ts = (TimestampData)a;
                String tss = HsqlDateTime.getTimestampString(ts.seconds + (long)ts.zone, ts.nanos, this.scale);
                if (this.withTimeZone) {
                    String s = Type.SQL_INTERVAL_HOUR_TO_MINUTE.intervalSecondToString(ts.zone, 0, true);
                    tss = tss + s;
                }
                return tss;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public String convertToSQLString(Object a) {
        if (a == null) {
            return "NULL";
        }
        StringBuilder sb = new StringBuilder(32);
        switch (this.typeCode) {
            case 91: {
                sb.append("DATE");
                break;
            }
            case 92: 
            case 94: {
                sb.append("TIME");
                break;
            }
            case 93: 
            case 95: {
                sb.append("TIMESTAMP");
            }
        }
        sb.append(StringConverter.toQuotedString(this.convertToString(a), '\'', false));
        return sb.toString();
    }

    @Override
    public void convertToJSON(Object a, StringBuilder sb) {
        if (a == null) {
            sb.append("null");
            return;
        }
        sb.append('\"');
        sb.append(this.convertToString(a));
        sb.append('\"');
    }

    @Override
    public boolean canConvertFrom(Type otherType) {
        if (otherType.typeCode == 0) {
            return true;
        }
        if (otherType.isCharacterType()) {
            return true;
        }
        if (!otherType.isDateTimeType()) {
            return false;
        }
        if (otherType.typeCode == 91) {
            return this.typeCode != 92;
        }
        if (otherType.typeCode == 92) {
            return this.typeCode != 91;
        }
        return true;
    }

    @Override
    public int canMoveFrom(Type otherType) {
        if (otherType == this) {
            return 0;
        }
        if (this.typeCode == otherType.typeCode) {
            return this.scale >= otherType.scale ? 0 : -1;
        }
        return -1;
    }

    @Override
    public Object add(Session session, Object a, Object b, Type otherType) {
        if (a == null || b == null) {
            return null;
        }
        if (otherType.isNumberType()) {
            if (this.typeCode == 91) {
                b = ((NumberType)otherType).floor(b);
            }
            b = Type.SQL_INTERVAL_SECOND_MAX_PRECISION.multiply(IntervalSecondData.oneDay, b);
        }
        switch (this.typeCode) {
            case 92: 
            case 94: {
                if (b instanceof IntervalMonthData) {
                    throw Error.runtimeError(201, "DateTimeType");
                }
                if (!(b instanceof IntervalSecondData)) break;
                return DateTimeType.addSeconds((TimeData)a, ((IntervalSecondData)b).units, ((IntervalSecondData)b).nanos);
            }
            case 91: 
            case 93: 
            case 95: {
                if (b instanceof IntervalMonthData) {
                    return DateTimeType.addMonths(session, (TimestampData)a, ((IntervalMonthData)b).units);
                }
                if (!(b instanceof IntervalSecondData)) break;
                return DateTimeType.addSeconds((TimestampData)a, ((IntervalSecondData)b).units, ((IntervalSecondData)b).nanos);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public Object subtract(Session session, Object a, Object b, Type otherType) {
        if (a == null || b == null) {
            return null;
        }
        if (otherType.isNumberType()) {
            if (this.typeCode == 91) {
                b = ((NumberType)otherType).floor(b);
            }
            b = Type.SQL_INTERVAL_SECOND_MAX_PRECISION.multiply(IntervalSecondData.oneDay, b);
        }
        switch (this.typeCode) {
            case 92: 
            case 94: {
                if (b instanceof IntervalMonthData) {
                    throw Error.runtimeError(201, "DateTimeType");
                }
                if (!(b instanceof IntervalSecondData)) break;
                return DateTimeType.addSeconds((TimeData)a, -((IntervalSecondData)b).units, -((IntervalSecondData)b).nanos);
            }
            case 91: 
            case 93: 
            case 95: {
                if (b instanceof IntervalMonthData) {
                    return DateTimeType.addMonths(session, (TimestampData)a, -((IntervalMonthData)b).units);
                }
                if (!(b instanceof IntervalSecondData)) break;
                return DateTimeType.addSeconds((TimestampData)a, -((IntervalSecondData)b).units, -((IntervalSecondData)b).nanos);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    public static double convertToDouble(Object a) {
        double fraction;
        double seconds;
        if (a instanceof TimeData) {
            seconds = ((TimeData)a).seconds;
            fraction = (double)((TimeData)a).nanos / 1.0E9;
        } else {
            seconds = ((TimestampData)a).seconds;
            fraction = (double)((TimestampData)a).nanos / 1.0E9;
        }
        return seconds + fraction;
    }

    public TimestampData convertFromDouble(Session session, double value) {
        long units = (long)value;
        int nanos = (int)((value - (double)units) * 1.0E9);
        return this.getDateTimeValue(session, units, nanos);
    }

    public Object truncate(Session session, Object a, int part) {
        if (a == null) {
            return null;
        }
        long millis = this.getTotalMillis(a);
        Calendar calendar = session.getCalendarGMT();
        millis = HsqlDateTime.getTruncatedPart(calendar, millis, part);
        millis -= this.getZoneMillis(a);
        switch (this.typeCode) {
            case 92: 
            case 94: {
                millis = HsqlDateTime.getNormalisedTime(calendar, millis);
                return new TimeData((int)(millis / 1000L), 0, ((TimeData)a).zone);
            }
            case 91: 
            case 93: 
            case 95: {
                return new TimestampData(millis / 1000L, 0, ((TimestampData)a).zone);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    public Object round(Session session, Object a, int part) {
        if (a == null) {
            return null;
        }
        long millis = this.getTotalMillis(a);
        Calendar calendar = session.getCalendarGMT();
        millis = HsqlDateTime.getRoundedPart(calendar, millis, part);
        millis -= this.getZoneMillis(a);
        switch (this.typeCode) {
            case 92: 
            case 94: {
                millis = HsqlDateTime.getNormalisedTime(millis);
                return new TimeData((int)(millis / 1000L), 0, ((TimeData)a).zone);
            }
            case 91: 
            case 93: 
            case 95: {
                return new TimestampData(millis / 1000L, 0, ((TimestampData)a).zone);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DateTimeType) {
            return super.equals(other) && ((DateTimeType)other).withTimeZone == this.withTimeZone;
        }
        return false;
    }

    @Override
    public int getPart(Session session, Object dateTime, int part) {
        int calendarPart;
        int increment = 0;
        int divisor = 1;
        switch (part) {
            case 101: {
                calendarPart = 1;
                break;
            }
            case 102: {
                increment = 1;
                calendarPart = 2;
                break;
            }
            case 103: 
            case 124: {
                calendarPart = 5;
                break;
            }
            case 104: {
                calendarPart = 11;
                break;
            }
            case 105: {
                calendarPart = 12;
                break;
            }
            case 106: {
                calendarPart = 13;
                break;
            }
            case 123: {
                calendarPart = 7;
                break;
            }
            case 126: 
            case 136: {
                calendarPart = 3;
                break;
            }
            case 130: {
                long seconds = this.getTotalSeconds(dateTime);
                return DateTimeType.toTimeSeconds(seconds);
            }
            case 121: {
                if (this.typeCode == 95) {
                    return ((TimestampData)dateTime).zone / 3600;
                }
                return ((TimeData)dateTime).zone / 3600;
            }
            case 122: {
                if (this.typeCode == 95) {
                    return ((TimestampData)dateTime).zone / 60 % 60;
                }
                return ((TimeData)dateTime).zone / 60 % 60;
            }
            case 135: {
                if (this.typeCode == 95) {
                    return ((TimestampData)dateTime).zone / 60;
                }
                return ((TimeData)dateTime).zone / 60;
            }
            case 127: {
                increment = 1;
                divisor = 3;
                calendarPart = 2;
                break;
            }
            case 125: {
                calendarPart = 6;
                break;
            }
            case 132: {
                if (this.isDateOrTimestampType()) {
                    return ((TimestampData)dateTime).nanos / 1000000;
                }
                return ((TimeData)dateTime).nanos / 1000000;
            }
            case 133: {
                if (this.isDateOrTimestampType()) {
                    return ((TimestampData)dateTime).nanos / 1000;
                }
                return ((TimeData)dateTime).nanos / 1000;
            }
            case 134: {
                if (this.isDateOrTimestampType()) {
                    return ((TimestampData)dateTime).nanos;
                }
                return ((TimeData)dateTime).nanos;
            }
            default: {
                throw Error.runtimeError(201, "DateTimeType - " + part);
            }
        }
        long millis = this.getTotalMillis(dateTime);
        Calendar calendar = session.getCalendarGMT();
        calendar.setTimeInMillis(millis);
        return calendar.get(calendarPart) / divisor + increment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDateTimePart(Calendar calendar, long m, int part) {
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            calendar.setTimeInMillis(m);
            return calendar.get(part);
        }
    }

    public Object addMonthsSpecial(Session session, Object dateTime, int months) {
        TimestampData ts = (TimestampData)dateTime;
        Calendar cal = session.getCalendarGMT();
        long millis = (ts.seconds + (long)ts.zone) * 1000L;
        HsqlDateTime.setTimeInMillis(cal, millis);
        cal.set(5, 1);
        cal.add(2, 1);
        cal.add(5, -1);
        boolean lastDay = millis == cal.getTimeInMillis();
        HsqlDateTime.setTimeInMillis(cal, millis);
        cal.add(2, months);
        if (lastDay) {
            cal.set(5, 1);
            cal.add(2, 1);
            cal.add(5, -1);
        }
        millis = cal.getTimeInMillis();
        return new TimestampData(millis / 1000L, 0, 0);
    }

    public Object getLastDayOfMonth(Session session, Object dateTime) {
        TimestampData ts = (TimestampData)dateTime;
        Calendar cal = session.getCalendarGMT();
        long millis = (ts.seconds + (long)ts.zone) * 1000L;
        HsqlDateTime.setTimeInMillis(cal, millis);
        cal.set(5, 1);
        cal.add(2, 1);
        cal.add(5, -1);
        millis = cal.getTimeInMillis();
        return new TimestampData(millis / 1000L, 0, 0);
    }

    long getTotalMillis(Object dateTime) {
        return this.getTotalSeconds(dateTime) * 1000L;
    }

    long getTotalSeconds(Object dateTime) {
        if (this.typeCode == 92 || this.typeCode == 94) {
            TimeData td = (TimeData)dateTime;
            return td.seconds + td.zone;
        }
        TimestampData ts = (TimestampData)dateTime;
        return ts.seconds + (long)ts.zone;
    }

    long getZoneMillis(Object dateTime) {
        long millis = dateTime instanceof TimeData ? (long)((TimeData)dateTime).zone * 1000L : (long)((TimestampData)dateTime).zone * 1000L;
        return millis;
    }

    @Override
    public BigDecimal getSecondPart(Session session, Object dateTime) {
        long seconds = this.getPart(session, dateTime, 106);
        int nanos = 0;
        if (this.typeCode == 93 || this.typeCode == 95) {
            nanos = ((TimestampData)dateTime).nanos;
        } else if (this.typeCode == 92 || this.typeCode == 94) {
            nanos = ((TimeData)dateTime).nanos;
        }
        return this.getSecondPart(seconds, nanos);
    }

    public String getPartString(Session session, Object dateTime, int part) {
        String javaPattern = "";
        switch (part) {
            case 128: {
                javaPattern = "EEEE";
                break;
            }
            case 129: {
                javaPattern = "MMMM";
            }
        }
        SimpleDateFormat format = session.getSimpleDateFormatGMT();
        try {
            format.applyPattern(javaPattern);
        }
        catch (Exception exception) {
            // empty catch block
        }
        java.util.Date date = (java.util.Date)this.convertSQLToJavaGMT(session, dateTime);
        return format.format(date);
    }

    TimestampData convertTimeToTimestamp(Calendar calendar, long seconds, int nanos) {
        calendar.setTimeInMillis(System.currentTimeMillis());
        DateTimeType.setTimeComponentsOnly(calendar, (int)seconds);
        seconds = calendar.getTimeInMillis() / 1000L;
        int zoneSeconds = DateTimeType.getZoneSeconds(seconds, calendar.getTimeZone());
        if (!this.withTimeZone) {
            seconds += (long)zoneSeconds;
            zoneSeconds = 0;
        }
        return new TimestampData(seconds, zoneSeconds, nanos);
    }

    public static TimestampData toLocalTimestampValue(TimestampData tsWithZone) {
        return new TimestampData(tsWithZone.seconds + (long)tsWithZone.zone, tsWithZone.nanos);
    }

    public static TimestampData toCurrentDateValue(TimestampData tsWithZone) {
        long seconds = DateTimeType.toDateSeconds(tsWithZone.seconds + (long)tsWithZone.zone);
        return new TimestampData(seconds);
    }

    public static TimeData toCurrentTimeValue(TimestampData tsWithZone) {
        int seconds = DateTimeType.toTimeSeconds(tsWithZone.seconds + (long)tsWithZone.zone);
        return new TimeData(seconds, tsWithZone.nanos);
    }

    public static TimeData toCurrentTimeWithZoneValue(TimestampData tsWithZone) {
        int seconds = DateTimeType.toTimeSeconds(tsWithZone.seconds);
        return new TimeData(seconds, tsWithZone.nanos, tsWithZone.zone);
    }

    public TimestampData getDateTimeValue(SessionInterface session, long seconds, int nanos) {
        nanos = DateTimeType.normaliseFraction(nanos, this.scale);
        switch (this.typeCode) {
            case 91: {
                seconds = DateTimeType.toDateSeconds(seconds);
                return new TimestampData(seconds);
            }
            case 93: {
                return new TimestampData(seconds, nanos);
            }
            case 95: {
                return new TimestampData(seconds, nanos, session.getZoneSeconds());
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    public static DateTimeType getDateTimeType(int type, int scale) {
        if (scale > 9) {
            throw Error.error(5592);
        }
        switch (type) {
            case 91: {
                return SQL_DATE;
            }
            case 92: {
                if (scale == 0) {
                    return SQL_TIME;
                }
                return new DateTimeType(92, type, scale);
            }
            case 94: {
                if (scale == 0) {
                    return SQL_TIME_WITH_TIME_ZONE;
                }
                return new DateTimeType(92, type, scale);
            }
            case 93: {
                if (scale == 6) {
                    return SQL_TIMESTAMP;
                }
                if (scale == 0) {
                    return SQL_TIMESTAMP_NO_FRACTION;
                }
                return new DateTimeType(93, type, scale);
            }
            case 95: {
                if (scale == 6) {
                    return SQL_TIMESTAMP_WITH_TIME_ZONE;
                }
                return new DateTimeType(93, type, scale);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    public Object changeZoneToUTC(Object a) {
        if (a instanceof TimestampData) {
            TimestampData ts = (TimestampData)a;
            if (ts.zone != 0) {
                return new TimestampData(ts.seconds, ts.nanos);
            }
        } else {
            TimeData ts = (TimeData)a;
            if (ts.zone != 0) {
                return new TimeData(ts.seconds, ts.nanos);
            }
        }
        return a;
    }

    public Object changeZone(Session session, Object a, String zoneString) {
        TimestampData value = (TimestampData)a;
        long seconds = value.seconds + (long)value.zone;
        Calendar calendar = session.getCalendar();
        TimeZone zone = TimeZone.getTimeZone(zoneString);
        TimeZone sessionZone = calendar.getTimeZone();
        calendar.setTimeZone(zone);
        seconds = HsqlDateTime.convertSecondsFromCalendar(session.getCalendarGMT(), calendar, seconds);
        int offset = zone.getOffset(seconds * 1000L) / 1000;
        calendar.setTimeZone(sessionZone);
        return new TimestampData(seconds, value.nanos, offset);
    }

    public Object changeZone(Session session, Object a, Type otherType, String zoneString) {
        TimestampData value = (TimestampData)a;
        long seconds = value.seconds;
        Calendar calendar = session.getCalendar();
        if (!zoneIDs.contains(zoneString)) {
            throw Error.error(3409, zoneString);
        }
        if (!otherType.isDateTimeTypeWithZone()) {
            seconds = HsqlDateTime.convertSecondsFromCalendar(session.getCalendarGMT(), calendar, seconds);
        }
        TimeZone zone = TimeZone.getTimeZone(zoneString);
        int offset = DateTimeType.getZoneSeconds(seconds, zone);
        return new TimestampData(seconds, value.nanos, offset);
    }

    public Object changeZone(Session session, Object a, Type otherType, int zoneSeconds, boolean atLocal) {
        if (a == null) {
            return null;
        }
        if (zoneSeconds > 64800 || -zoneSeconds > 64800) {
            throw Error.error(3409);
        }
        switch (this.typeCode) {
            case 94: {
                TimeData value = (TimeData)a;
                if (atLocal) {
                    zoneSeconds = session.getZoneSeconds();
                }
                if (otherType.isDateTimeTypeWithZone()) {
                    if (value.zone == zoneSeconds) {
                        return value;
                    }
                    return new TimeData(value.seconds, value.nanos, zoneSeconds);
                }
                int localZone = session.getZoneSeconds();
                int seconds = value.seconds - localZone;
                seconds = DateTimeType.toTimeSeconds(seconds);
                return new TimeData(seconds, value.nanos, zoneSeconds);
            }
            case 95: {
                TimestampData value = (TimestampData)a;
                long seconds = value.seconds;
                Calendar calendar = session.getCalendar();
                if (!otherType.isDateTimeTypeWithZone()) {
                    seconds = HsqlDateTime.convertSecondsFromCalendar(session.getCalendarGMT(), calendar, seconds);
                }
                if (atLocal) {
                    zoneSeconds = DateTimeType.getZoneSeconds(seconds, calendar.getTimeZone());
                }
                if (value.seconds == seconds && value.zone == zoneSeconds) {
                    return value;
                }
                return new TimestampData(seconds, value.nanos, zoneSeconds);
            }
        }
        return a;
    }

    public boolean canAdd(IntervalType other) {
        return other.startPartIndex >= this.startPartIndex && other.endPartIndex <= this.endPartIndex;
    }

    public int getSqlDateTimeSub() {
        switch (this.typeCode) {
            case 91: {
                return 1;
            }
            case 92: {
                return 2;
            }
            case 93: {
                return 3;
            }
        }
        return 0;
    }

    public static Type normalizeInput(Session session, Object[] a, Type[] ta, Object[] b, Type[] tb, boolean pointOfTime) {
        Object temp;
        if (a == null || b == null) {
            return null;
        }
        if (a[0] == null || b[0] == null) {
            return null;
        }
        if (a[1] == null) {
            return null;
        }
        if (!pointOfTime && b[1] == null) {
            return null;
        }
        if (!ta[0].isDateTimeType() || !tb[0].isDateTimeType()) {
            throw Error.error(5562);
        }
        DateTimeType commonType = SQL_TIMESTAMP_WITH_TIME_ZONE;
        a[0] = commonType.castToType(session, a[0], ta[0]);
        b[0] = commonType.castToType(session, b[0], tb[0]);
        a[1] = ta[1].isIntervalType() ? ((Type)commonType).add(session, a[0], a[1], ta[1]) : commonType.castToType(session, a[1], ta[1]);
        b[1] = tb[1].isIntervalType() ? ((Type)commonType).add(session, b[0], b[1], tb[1]) : (pointOfTime ? b[0] : commonType.castToType(session, b[1], tb[1]));
        if (((Type)commonType).compare(session, a[0], a[1]) >= 0) {
            temp = a[0];
            a[0] = a[1];
            a[1] = temp;
        }
        if (!pointOfTime && ((Type)commonType).compare(session, b[0], b[1]) >= 0) {
            temp = b[0];
            b[0] = b[1];
            b[1] = temp;
        }
        return commonType;
    }

    public static Type normalizeInputRelaxed(Session session, Object[] a, Type[] ta, Object[] b, Type[] tb) {
        Object temp;
        if (a == null || b == null) {
            return null;
        }
        if (a[0] == null || b[0] == null) {
            return null;
        }
        if (a[1] == null) {
            a[1] = a[0];
        }
        if (b[1] == null) {
            b[1] = b[0];
        }
        Type commonType = ta[0].getCombinedType(session, tb[0], 40);
        a[0] = commonType.castToType(session, a[0], ta[0]);
        b[0] = commonType.castToType(session, b[0], tb[0]);
        a[1] = ta[1].isIntervalType() ? commonType.add(session, a[0], a[1], ta[1]) : commonType.castToType(session, a[1], ta[1]);
        b[1] = tb[1].isIntervalType() ? commonType.add(session, b[0], b[1], tb[1]) : commonType.castToType(session, b[1], tb[1]);
        if (commonType.compare(session, a[0], a[1]) > 0) {
            temp = a[0];
            a[0] = a[1];
            a[1] = temp;
        }
        if (commonType.compare(session, b[0], b[1]) > 0) {
            temp = b[0];
            b[0] = b[1];
            b[1] = temp;
        }
        return commonType;
    }

    public static Boolean overlaps(Session session, Object[] a, Type[] ta, Object[] b, Type[] tb) {
        Type commonType = DateTimeType.normalizeInput(session, a, ta, b, tb, false);
        if (commonType == null) {
            return null;
        }
        if (commonType.compare(session, a[0], b[0]) > 0) {
            Object[] temp = a;
            a = b;
            b = temp;
        }
        if (commonType.compare(session, a[1], b[0]) > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean overlapsRelaxed(Session session, Object[] a, Type[] ta, Object[] b, Type[] tb) {
        Type commonType = DateTimeType.normalizeInputRelaxed(session, a, ta, b, tb);
        if (commonType == null) {
            return null;
        }
        if (commonType.compare(session, a[0], b[0]) > 0) {
            Object[] temp = a;
            a = b;
            b = temp;
        }
        if (commonType.compare(session, a[1], b[0]) > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean precedes(Session session, Object[] a, Type[] ta, Object[] b, Type[] tb) {
        Type commonType = DateTimeType.normalizeInput(session, a, ta, b, tb, false);
        if (commonType == null) {
            return null;
        }
        if (commonType.compare(session, a[1], b[0]) <= 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean immediatelyPrecedes(Session session, Object[] a, Type[] ta, Object[] b, Type[] tb) {
        Type commonType = DateTimeType.normalizeInput(session, a, ta, b, tb, false);
        if (commonType == null) {
            return null;
        }
        if (commonType.compare(session, a[1], b[0]) == 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean immediatelySucceeds(Session session, Object[] a, Type[] ta, Object[] b, Type[] tb) {
        Type commonType = DateTimeType.normalizeInput(session, a, ta, b, tb, false);
        if (commonType == null) {
            return null;
        }
        if (commonType.compare(session, a[0], b[1]) == 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean succeeds(Session session, Object[] a, Type[] ta, Object[] b, Type[] tb) {
        Type commonType = DateTimeType.normalizeInput(session, a, ta, b, tb, false);
        if (commonType == null) {
            return null;
        }
        if (commonType.compare(session, a[0], b[1]) >= 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean equals(Session session, Object[] a, Type[] ta, Object[] b, Type[] tb) {
        Type commonType = DateTimeType.normalizeInput(session, a, ta, b, tb, false);
        if (commonType == null) {
            return null;
        }
        if (commonType.compare(session, a[0], b[0]) == 0 && commonType.compare(session, a[1], b[1]) == 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean contains(Session session, Object[] a, Type[] ta, Object[] b, Type[] tb, boolean pointOfTime) {
        Type commonType = DateTimeType.normalizeInput(session, a, ta, b, tb, pointOfTime);
        if (commonType == null) {
            return null;
        }
        int compareStart = commonType.compare(session, a[0], b[0]);
        int compareEnd = commonType.compare(session, a[1], b[1]);
        if (compareStart <= 0 && compareEnd >= 0) {
            if (pointOfTime && compareEnd == 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static BigDecimal subtractMonthsSpecial(Session session, TimestampData a, TimestampData b) {
        long s1 = (a.seconds + (long)a.zone) * 1000L;
        long s2 = (b.seconds + (long)b.zone) * 1000L;
        boolean minus = false;
        if (s1 < s2) {
            minus = true;
            long temp = s1;
            s1 = s2;
            s2 = temp;
        }
        Calendar cal = session.getCalendarGMT();
        s1 = HsqlDateTime.getNormalisedDate(cal, s1);
        s2 = HsqlDateTime.getNormalisedDate(cal, s2);
        cal.setTimeInMillis(s1);
        int months1 = cal.get(2) + cal.get(1) * 12;
        int day1 = cal.get(5);
        cal.set(5, 1);
        cal.add(2, 1);
        cal.add(5, -1);
        int lastDay1 = cal.get(5);
        cal.setTimeInMillis(s2);
        int months2 = cal.get(2) + cal.get(1) * 12;
        int day2 = cal.get(5);
        cal.set(5, 1);
        cal.add(2, 1);
        cal.add(5, -1);
        int lastDay2 = cal.get(5);
        if (day1 == day2 || day1 == lastDay1 && day2 == lastDay2) {
            double months = months1 - months2;
            if (minus) {
                months = -months;
            }
            return BigDecimal.valueOf(months);
        }
        if (day2 > day1) {
            double months = months1 - months2 - 1;
            double days = lastDay2 - day2 + day1;
            months += days / 31.0;
            if (minus) {
                months = -months;
            }
            return BigDecimal.valueOf(months);
        }
        double months = months1 - months2;
        double days = day1 - day2;
        months += days / 31.0;
        if (minus) {
            months = -months;
        }
        return BigDecimal.valueOf(months);
    }

    public static int subtractMonths(Session session, TimestampData a, TimestampData b, boolean isYear) {
        Calendar calendar = session.getCalendarGMT();
        boolean negate = false;
        if (b.seconds > a.seconds) {
            negate = true;
            TimestampData temp = a;
            a = b;
            b = temp;
        }
        calendar.setTimeInMillis(a.seconds * 1000L);
        int months = calendar.get(2);
        int years = calendar.get(1);
        calendar.setTimeInMillis(b.seconds * 1000L);
        months -= calendar.get(2);
        years -= calendar.get(1);
        if (isYear) {
            months = years * 12;
        } else {
            if (months < 0) {
                months += 12;
                --years;
            }
            months += years * 12;
        }
        if (negate) {
            months = -months;
        }
        return months;
    }

    public static TimeData addSeconds(TimeData source, long seconds, int nanos) {
        seconds += (long)((nanos += source.nanos) / 1000000000);
        if ((nanos %= 1000000000) < 0) {
            nanos += 1000000000;
            --seconds;
        }
        seconds += (long)source.seconds;
        return new TimeData((int)(seconds %= 86400L), nanos, source.zone);
    }

    public static TimestampData addMonths(Session session, TimestampData source, int months) {
        int n = source.nanos;
        Calendar cal = session.getCalendarGMT();
        HsqlDateTime.setTimeInMillis(cal, source.seconds * 1000L);
        cal.add(2, months);
        return new TimestampData(cal.getTimeInMillis() / 1000L, n, source.zone);
    }

    public static TimestampData addSeconds(TimestampData source, long seconds, int nanos) {
        seconds += (long)((nanos += source.nanos) / 1000000000);
        if ((nanos %= 1000000000) < 0) {
            nanos += 1000000000;
            --seconds;
        }
        long newSeconds = source.seconds + seconds;
        return new TimestampData(newSeconds, nanos, source.zone);
    }

    public static TimestampData convertToDatetimeSpecial(SessionInterface session, String s, DateTimeType type) {
        switch (type.typeCode) {
            case 93: {
                String pattern;
                if (!(session instanceof Session) || !((Session)session).database.sqlSyntaxOra) break;
                switch (s.length()) {
                    case 8: 
                    case 9: {
                        pattern = "DD-MON-YY";
                        break;
                    }
                    case 10: 
                    case 11: {
                        pattern = "DD-MON-YYYY";
                        break;
                    }
                    case 19: 
                    case 20: {
                        pattern = "DD-MON-YYYY HH24:MI:SS";
                        break;
                    }
                    default: {
                        pattern = "DD-MON-YYYY HH24:MI:SS.FF";
                    }
                }
                SimpleDateFormat format = session.getSimpleDateFormatGMT();
                return HsqlDateTime.toDate(s, pattern, format, true);
            }
        }
        throw Error.error(3407);
    }

    public static TimestampData nextDayOfWeek(Session session, TimestampData d, int day) {
        Calendar cal = session.getCalendarGMT();
        cal.setTimeInMillis(d.getMillis());
        int start = cal.get(7);
        if (start >= day) {
            day += 7;
        }
        int diff = day - start;
        cal.add(5, diff);
        long millis = cal.getTimeInMillis();
        millis = HsqlDateTime.getNormalisedDate(cal, millis);
        return new TimestampData(millis / 1000L);
    }

    public static int getDayOfWeek(String name) {
        if (name.length() > 0) {
            char c = Character.toUpperCase(name.charAt(0));
            switch (c) {
                case 'M': {
                    return 2;
                }
                case 'T': {
                    if (name.length() < 2) break;
                    if (Character.toUpperCase(name.charAt(1)) == 'U') {
                        return 3;
                    }
                    if (Character.toUpperCase(name.charAt(1)) != 'H') break;
                    return 5;
                }
                case 'W': {
                    return 4;
                }
                case 'F': {
                    return 6;
                }
                case 'S': {
                    if (name.length() < 2) break;
                    if (Character.toUpperCase(name.charAt(1)) == 'A') {
                        return 7;
                    }
                    if (Character.toUpperCase(name.charAt(1)) != 'U') break;
                    return 1;
                }
            }
        }
        throw Error.error(3407, name);
    }

    public static int toTimeSeconds(long seconds) {
        int timeSeconds = (int)(seconds % 86400L);
        if (timeSeconds < 0) {
            timeSeconds += 86400;
        }
        return timeSeconds;
    }

    static long toDateSeconds(long seconds) {
        long timeSeconds = seconds % 86400L;
        if (timeSeconds < 0L) {
            timeSeconds += 86400L;
        }
        return seconds - timeSeconds;
    }

    public static TimestampData newSysDateTimestamp() {
        long millis = System.currentTimeMillis();
        long seconds = millis / 1000L;
        int offset = systemTimeZone.getOffset(millis) / 1000;
        return new TimestampData(seconds + (long)offset);
    }

    public static TimestampData newSystemTimestampWithZone() {
        return DateTimeType.newCurrentTimestamp(systemTimeZone);
    }

    public static int getZoneSeconds(long utcSeconds, TimeZone zone) {
        return zone.getOffset(utcSeconds * 1000L) / 1000;
    }

    static void setTimeComponents(Calendar calendar, int seconds) {
        calendar.clear();
        calendar.set(1, 1970);
        calendar.set(2, 0);
        calendar.set(5, 1);
        DateTimeType.setTimeComponentsOnly(calendar, seconds %= 86400);
    }

    static void setTimeComponentsOnly(Calendar calendar, int seconds) {
        seconds = DateTimeType.toTimeSeconds(seconds);
        calendar.set(11, seconds / 3600);
        calendar.set(12, seconds % 3600 / 60);
        calendar.set(13, seconds % 60);
    }

    public static TimestampData newCurrentTimestamp(TimeZone zone) {
        Instant instant = Instant.now();
        long seconds = instant.getEpochSecond();
        int nanos = instant.getNano() / 1000 * 1000;
        int zoneSeconds = zone.getOffset(seconds * 1000L) / 1000;
        return new TimestampData(seconds, nanos, zoneSeconds);
    }

    public static TimestampData newSystemTimestampUTC() {
        Instant instant = Instant.now();
        long seconds = instant.getEpochSecond();
        int nanos = instant.getNano() / 1000 * 1000;
        return new TimestampData(seconds, nanos);
    }

    public static void setDateTimeComponents(Calendar calendar, LocalDateTime ldt) {
        calendar.clear();
        calendar.set(1, ldt.getYear());
        calendar.set(2, ldt.getMonthValue() - 1);
        calendar.set(5, ldt.getDayOfMonth());
        calendar.set(11, ldt.getHour());
        calendar.set(12, ldt.getMinute());
        calendar.set(13, ldt.getSecond());
    }

    public static void setDateComponents(Calendar calendar, LocalDate ldt) {
        calendar.clear();
        calendar.set(1, ldt.getYear());
        calendar.set(2, ldt.getMonthValue() - 1);
        calendar.set(5, ldt.getDayOfMonth());
    }

    public static void setTimeComponents(Calendar calendar, LocalTime ldt) {
        calendar.clear();
        calendar.set(1, 1970);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(11, ldt.getHour());
        calendar.set(12, ldt.getMinute());
        calendar.set(13, ldt.getSecond());
    }

    public Instant toInstant(SessionInterface session, TimestampData v) {
        long seconds = this.withTimeZone ? v.seconds : HsqlDateTime.convertSecondsFromCalendar(session.getCalendarGMT(), session.getCalendar(), v.seconds);
        return Instant.ofEpochSecond(seconds, v.nanos);
    }

    public LocalDate toLocalDate(SessionInterface session, TimestampData v) {
        long millis = (v.seconds + (long)v.zone) * 1000L;
        Calendar cal = session.getCalendarGMT();
        cal.setTimeInMillis(millis);
        return LocalDate.of(cal.get(1), cal.get(2) + 1, cal.get(5));
    }

    public LocalDateTime toLocalDateTime(SessionInterface session, TimestampData v) {
        long millis = (v.seconds + (long)v.zone) * 1000L;
        int nanos = v.nanos;
        Calendar cal = session.getCalendarGMT();
        cal.setTimeInMillis(millis);
        return LocalDateTime.of(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), nanos);
    }

    public LocalTime toLocalTime(SessionInterface session, TimeData v) {
        int seconds = DateTimeType.toTimeSeconds(v.seconds + v.zone);
        return LocalTime.ofNanoOfDay((long)seconds * 1000000000L + (long)v.nanos);
    }

    public LocalTime toLocalTime(SessionInterface session, TimestampData v) {
        int seconds = DateTimeType.toTimeSeconds(v.getSeconds() + (long)v.zone);
        return LocalTime.ofNanoOfDay((long)seconds * 1000000000L + (long)v.nanos);
    }

    public OffsetTime toOffsetTime(SessionInterface session, TimeData v) {
        int zoneSeconds = this.withTimeZone ? v.zone : session.getZoneSeconds();
        ZoneOffset zone = ZoneOffset.ofTotalSeconds(zoneSeconds);
        LocalTime lt = this.toLocalTime(session, v);
        return OffsetTime.of(lt, zone);
    }

    public OffsetTime toOffsetTime(SessionInterface session, TimestampData v) {
        int zoneSeconds = this.withTimeZone ? v.zone : session.getZoneSeconds();
        ZoneOffset zone = ZoneOffset.ofTotalSeconds(zoneSeconds);
        LocalTime lt = this.toLocalTime(session, v);
        return OffsetTime.of(lt, zone);
    }

    public OffsetDateTime toOffsetDateTime(SessionInterface session, TimestampData v) {
        int zoneSeconds;
        if (this.withTimeZone) {
            zoneSeconds = v.zone;
        } else {
            long seconds = HsqlDateTime.convertSecondsFromCalendar(session.getCalendarGMT(), session.getCalendar(), v.seconds);
            zoneSeconds = DateTimeType.getZoneSeconds(seconds, session.getCalendar().getTimeZone());
        }
        ZoneOffset zone = ZoneOffset.ofTotalSeconds(zoneSeconds);
        LocalDateTime lt = this.toLocalDateTime(session, v);
        return OffsetDateTime.of(lt, zone);
    }
}

