/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import org.hsqldb.error.Error;
import org.hsqldb.types.DTIType;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.Type;

public class IntervalMonthData {
    public final int units;

    public static IntervalMonthData newInterval(double value, int typeCode) {
        int index = DTIType.intervalIndexMap.get(typeCode);
        return new IntervalMonthData((long)(value *= (double)DTIType.yearToSecondFactors[index]));
    }

    public static IntervalMonthData newIntervalYear(long years, IntervalType type) {
        return new IntervalMonthData(years * 12L, type);
    }

    public static IntervalMonthData newIntervalMonth(long months, IntervalType type) {
        return new IntervalMonthData(months, type);
    }

    public IntervalMonthData(long months, IntervalType type) {
        if (months >= type.getIntervalValueLimit()) {
            throw Error.error(3406);
        }
        if (type.typeCode == 101) {
            months -= months % 12L;
        }
        this.units = (int)months;
    }

    public IntervalMonthData(long months) {
        this.units = (int)months;
    }

    public boolean equals(Object other) {
        if (other instanceof IntervalMonthData) {
            return this.units == ((IntervalMonthData)other).units;
        }
        return false;
    }

    public int hashCode() {
        return this.units;
    }

    public int compareTo(IntervalMonthData b) {
        if (this.units > b.units) {
            return 1;
        }
        if (this.units < b.units) {
            return -1;
        }
        return 0;
    }

    public int getMonths() {
        return this.units;
    }

    public String toString() {
        return Type.SQL_INTERVAL_MONTH_MAX_PRECISION.convertToString(this);
    }
}

