/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.sql.ResultSet;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.SortAndSlice;
import org.hsqldb.error.Error;
import org.hsqldb.types.Type;
import org.hsqldb.types.TypedComparator;

public class RowType
extends Type {
    final Type[] dataTypes;
    TypedComparator comparator;

    public RowType(Type[] dataTypes) {
        super(19, 19, 0L, 0);
        this.dataTypes = dataTypes;
    }

    @Override
    public int displaySize() {
        return 0;
    }

    @Override
    public int getJDBCTypeCode() {
        return 0;
    }

    @Override
    public Class getJDBCClass() {
        return ResultSet.class;
    }

    @Override
    public String getJDBCClassName() {
        return "java.sql.ResultSet";
    }

    @Override
    public int getJDBCScale() {
        return 0;
    }

    @Override
    public int getJDBCPrecision() {
        return 0;
    }

    @Override
    public int getSQLGenericTypeCode() {
        return 19;
    }

    @Override
    public boolean isRowType() {
        return true;
    }

    @Override
    public int getDegree() {
        return this.dataTypes.length;
    }

    @Override
    public String getNameString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ROW");
        sb.append('(');
        for (int i = 0; i < this.dataTypes.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.dataTypes[i].getDefinition());
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public String getDefinition() {
        return this.getNameString();
    }

    @Override
    public int compare(Session session, Object a, Object b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        Object[] arrb = (Object[])b;
        Object[] arra = (Object[])a;
        int length = arra.length;
        if (arrb.length < length) {
            length = arrb.length;
        }
        for (int i = 0; i < length; ++i) {
            int result = this.dataTypes[i].compare(session, arra[i], arrb[i]);
            if (result == 0) continue;
            return result;
        }
        if (arra.length > arrb.length) {
            return 1;
        }
        if (arra.length < arrb.length) {
            return -1;
        }
        return 0;
    }

    @Override
    public Object convertToTypeLimits(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        Object[] arra = (Object[])a;
        Object[] arrb = new Object[arra.length];
        for (int i = 0; i < arra.length; ++i) {
            arrb[i] = this.dataTypes[i].convertToTypeLimits(session, arra[i]);
        }
        return arrb;
    }

    @Override
    public Object convertToType(SessionInterface session, Object a, Type otherType) {
        if (a == null) {
            return null;
        }
        if (otherType == null) {
            return a;
        }
        if (!otherType.isRowType()) {
            throw Error.error(5562);
        }
        Type[] otherTypes = ((RowType)otherType).getTypesArray();
        if (this.dataTypes.length != otherTypes.length) {
            throw Error.error(5564);
        }
        Object[] arra = (Object[])a;
        Object[] arrb = new Object[arra.length];
        for (int i = 0; i < arra.length; ++i) {
            arrb[i] = this.dataTypes[i].convertToType(session, arra[i], otherTypes[i]);
        }
        return arrb;
    }

    @Override
    public Object convertToDefaultType(SessionInterface sessionInterface, Object o) {
        return o;
    }

    @Override
    public String convertToString(Object a) {
        if (a == null) {
            return null;
        }
        return this.convertToSQLString(a);
    }

    @Override
    public String convertToSQLString(Object a) {
        if (a == null) {
            return "NULL";
        }
        Object[] array = (Object[])a;
        StringBuilder sb = new StringBuilder();
        sb.append("ROW");
        sb.append('(');
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            String string = this.dataTypes[i].convertToSQLString(array[i]);
            sb.append(string);
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public void convertToJSON(Object a, StringBuilder sb) {
        Object[] array = (Object[])a;
        if (a == null) {
            sb.append("null");
            return;
        }
        sb.append('{');
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            this.dataTypes[i].convertToJSON(array[i], sb);
        }
        sb.append('}');
    }

    @Override
    public boolean canConvertFrom(Type otherType) {
        if (otherType == null) {
            return true;
        }
        if (!otherType.isRowType()) {
            return false;
        }
        Type[] otherTypes = ((RowType)otherType).getTypesArray();
        if (this.dataTypes.length != otherTypes.length) {
            return false;
        }
        for (int i = 0; i < this.dataTypes.length; ++i) {
            if (this.dataTypes[i].canConvertFrom(otherTypes[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canBeAssignedFrom(Type otherType) {
        if (otherType == null) {
            return true;
        }
        if (!otherType.isRowType()) {
            return false;
        }
        Type[] otherTypes = ((RowType)otherType).getTypesArray();
        if (this.dataTypes.length != otherTypes.length) {
            return false;
        }
        for (int i = 0; i < this.dataTypes.length; ++i) {
            if (this.dataTypes[i].canBeAssignedFrom(otherTypes[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public Type getAggregateType(Type other) {
        if (other == null) {
            return this;
        }
        if (other == SQL_ALL_TYPES) {
            return this;
        }
        if (other == this) {
            return this;
        }
        if (!other.isRowType()) {
            throw Error.error(5562);
        }
        Type[] newTypes = new Type[this.dataTypes.length];
        Type[] otherTypes = ((RowType)other).getTypesArray();
        if (this.dataTypes.length != otherTypes.length) {
            throw Error.error(5564);
        }
        for (int i = 0; i < this.dataTypes.length; ++i) {
            newTypes[i] = this.dataTypes[i].getAggregateType(otherTypes[i]);
        }
        return new RowType(newTypes);
    }

    @Override
    public Type getCombinedType(Session session, Type other, int operation) {
        if (operation != 36) {
            return this.getAggregateType(other);
        }
        if (other == null) {
            return this;
        }
        if (!other.isRowType()) {
            throw Error.error(5562);
        }
        Type[] newTypes = new Type[this.dataTypes.length];
        Type[] otherTypes = ((RowType)other).getTypesArray();
        if (this.dataTypes.length != otherTypes.length) {
            throw Error.error(5564);
        }
        for (int i = 0; i < this.dataTypes.length; ++i) {
            newTypes[i] = this.dataTypes[i].getAggregateType(otherTypes[i]);
        }
        return new RowType(newTypes);
    }

    public Type[] getTypesArray() {
        return this.dataTypes;
    }

    @Override
    public int compare(Session session, Object a, Object b, SortAndSlice sort) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        Object[] arra = (Object[])a;
        Object[] arrb = (Object[])b;
        int length = sort.columnCount;
        for (int i = 0; i < length; ++i) {
            int result;
            int pos = sort.sortOrder[i];
            a = arra[pos];
            b = arrb[pos];
            if (a == b) continue;
            if (sort.sortNullsLast[i]) {
                if (a == null) {
                    return 1;
                }
                if (b == null) {
                    return -1;
                }
            }
            if ((result = this.dataTypes[pos].compare(session, a, b)) == 0) continue;
            if (sort.sortDescending[i]) {
                return -result;
            }
            return result;
        }
        return 0;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof RowType && super.equals(other)) {
            Type[] otherTypes = ((RowType)other).dataTypes;
            if (otherTypes.length != this.dataTypes.length) {
                return false;
            }
            for (int i = 0; i < this.dataTypes.length; ++i) {
                if (this.dataTypes[i].equals(otherTypes[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode(Object a) {
        if (a == null) {
            return 0;
        }
        int hash = 0;
        Object[] array = (Object[])a;
        for (int i = 0; i < this.dataTypes.length && i < 4; ++i) {
            hash += this.dataTypes[i].hashCode(array[i]);
        }
        return hash;
    }

    synchronized TypedComparator getComparator(Session session) {
        if (this.comparator == null) {
            TypedComparator c = new TypedComparator(session);
            SortAndSlice sort = new SortAndSlice();
            sort.prepareMultiColumn(this.dataTypes.length);
            c.setType(this, sort);
            this.comparator = c;
        }
        return this.comparator;
    }

    public static String convertToSQLString(Object[] array, Type[] types, int maxUnitLength) {
        if (array == null) {
            return "NULL";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            String string = types[i].convertToSQLString(array[i]);
            if (maxUnitLength > 10 && string.length() > maxUnitLength) {
                sb.append(string, 0, maxUnitLength - 4);
                sb.append(" ...");
                continue;
            }
            sb.append(string);
        }
        sb.append(')');
        return sb.toString();
    }
}

