/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import org.hsqldb.Constraint;
import org.hsqldb.Expression;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.rights.Grantee;
import org.hsqldb.types.Collation;
import org.hsqldb.types.Type;

public class UserTypeModifier {
    final HsqlNameManager.HsqlName name;
    final int schemaObjectType;
    final Type dataType;
    Constraint[] constraints = Constraint.emptyArray;
    Expression defaultExpression;
    boolean isNullable = true;

    public UserTypeModifier(HsqlNameManager.HsqlName name, int type, Type dataType) {
        this.name = name;
        this.schemaObjectType = type;
        this.dataType = dataType;
    }

    public int schemaObjectType() {
        return this.schemaObjectType;
    }

    public void addConstraint(Constraint c) {
        int position = this.constraints.length;
        this.constraints = (Constraint[])ArrayUtil.resizeArray(this.constraints, position + 1);
        this.constraints[position] = c;
        this.setNotNull();
    }

    public void removeConstraint(String name) {
        for (int i = 0; i < this.constraints.length; ++i) {
            if (!this.constraints[i].getName().name.equals(name)) continue;
            this.constraints = (Constraint[])ArrayUtil.toAdjustedArray(this.constraints, null, i, -1);
            break;
        }
        this.setNotNull();
    }

    public Constraint getConstraint(String name) {
        for (int i = 0; i < this.constraints.length; ++i) {
            if (!this.constraints[i].getName().name.equals(name)) continue;
            return this.constraints[i];
        }
        return null;
    }

    public Constraint[] getConstraints() {
        return this.constraints;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public Expression getDefaultClause() {
        return this.defaultExpression;
    }

    public void setDefaultClause(Expression defaultExpression) {
        this.defaultExpression = defaultExpression;
    }

    public void removeDefaultClause() {
        this.defaultExpression = null;
    }

    private void setNotNull() {
        this.isNullable = true;
        for (int i = 0; i < this.constraints.length; ++i) {
            if (!this.constraints[i].isNotNull()) continue;
            this.isNullable = false;
            break;
        }
    }

    public int getType() {
        return this.schemaObjectType;
    }

    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    public HsqlNameManager.HsqlName getSchemaName() {
        return this.name.schema;
    }

    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    public OrderedHashSet getReferences() {
        OrderedHashSet<HsqlNameManager.HsqlName> set = new OrderedHashSet<HsqlNameManager.HsqlName>();
        for (int i = 0; i < this.constraints.length; ++i) {
            OrderedHashSet subSet = this.constraints[i].getReferences();
            if (subSet == null) continue;
            set.addAll(subSet);
        }
        Collation collation = this.dataType.getCollation();
        if (collation != null && collation.isObjectCollation()) {
            set.add(collation.getName());
        }
        return set;
    }

    public final OrderedHashSet getComponents() {
        if (this.constraints == null) {
            return null;
        }
        OrderedHashSet<Constraint> set = new OrderedHashSet<Constraint>();
        set.addAll(this.constraints);
        return set;
    }

    public void compile(Session session) {
        for (int i = 0; i < this.constraints.length; ++i) {
            this.constraints[i].compile(session, null);
        }
    }

    public String getSQL() {
        StringBuilder sb = new StringBuilder();
        if (this.schemaObjectType == 12) {
            Collation collation;
            sb.append("CREATE").append(' ').append("TYPE").append(' ');
            sb.append(this.name.getSchemaQualifiedStatementName());
            sb.append(' ').append("AS").append(' ');
            sb.append(this.dataType.getDefinition());
            if (this.dataType.isCharacterType() && (collation = this.dataType.getCollation()).isObjectCollation()) {
                sb.append(' ').append(collation.getCollateSQL());
            }
        } else {
            Collation collation;
            sb.append("CREATE").append(' ').append("DOMAIN").append(' ');
            sb.append(this.name.getSchemaQualifiedStatementName());
            sb.append(' ').append("AS").append(' ');
            sb.append(this.dataType.getDefinition());
            if (this.dataType.isCharacterType() && (collation = this.dataType.getCollation()).isObjectCollation()) {
                sb.append(' ').append(collation.getCollateSQL());
            }
            if (this.defaultExpression != null) {
                sb.append(' ').append("DEFAULT").append(' ');
                sb.append(this.defaultExpression.getSQL());
            }
            for (int i = 0; i < this.constraints.length; ++i) {
                sb.append(' ').append("CONSTRAINT").append(' ');
                sb.append(this.constraints[i].getName().statementName).append(' ');
                sb.append("CHECK").append('(').append(this.constraints[i].getCheckSQL()).append(')');
            }
        }
        return sb.toString();
    }
}

