/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Enumeration;
import java.util.Hashtable;
import org.hsqldb.util.ConnectionDialogCommon;
import org.hsqldb.util.ConnectionSetting;

class ConnectionDialog
extends Dialog
implements ActionListener,
ItemListener {
    protected Connection mConnection;
    protected TextField mName;
    protected TextField mDriver;
    protected TextField mURL;
    protected TextField mUser;
    protected TextField mPassword;
    protected Label mError;
    private String[][] connTypes;
    private Hashtable settings;
    private Choice types;
    private Choice recent;

    public static Connection createConnection(String driver, String url, String user, String password) throws Exception {
        Class.forName(driver);
        return DriverManager.getConnection(url, user, password);
    }

    ConnectionDialog(Frame owner, String title) {
        super(owner, title, true);
    }

    private void create() {
        Panel pClearButton;
        Panel pButton;
        Panel pText;
        Panel pLabel;
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLayout(new BorderLayout());
        Panel p = new Panel(new BorderLayout());
        if (d.width >= 640) {
            pLabel = new Panel(new GridLayout(8, 1, 10, 10));
            pText = new Panel(new GridLayout(8, 1, 10, 10));
            pButton = new Panel(new GridLayout(1, 2, 10, 10));
            pClearButton = new Panel(new GridLayout(8, 1, 10, 10));
        } else {
            pLabel = new Panel(new GridLayout(8, 1));
            pText = new Panel(new GridLayout(8, 1));
            pButton = new Panel(new GridLayout(1, 2));
            pClearButton = new Panel(new GridLayout(8, 1));
        }
        p.add("West", pLabel);
        p.add("Center", pText);
        p.add("South", pButton);
        p.add("North", ConnectionDialog.createLabel(""));
        p.add("East", pClearButton);
        p.setBackground(SystemColor.control);
        pText.setBackground(SystemColor.control);
        pLabel.setBackground(SystemColor.control);
        pButton.setBackground(SystemColor.control);
        pLabel.add(ConnectionDialog.createLabel("Recent:"));
        this.recent = new Choice();
        try {
            this.settings = ConnectionDialogCommon.loadRecentConnectionSettings();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.recent.add(ConnectionDialogCommon.emptySettingName);
        Enumeration en = this.settings.elements();
        while (en.hasMoreElements()) {
            this.recent.add(((ConnectionSetting)en.nextElement()).getName());
        }
        this.recent.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                String s = (String)e.getItem();
                ConnectionSetting setting = (ConnectionSetting)ConnectionDialog.this.settings.get(s);
                if (setting != null) {
                    ConnectionDialog.this.mName.setText(setting.getName());
                    ConnectionDialog.this.mDriver.setText(setting.getDriver());
                    ConnectionDialog.this.mURL.setText(setting.getUrl());
                    ConnectionDialog.this.mUser.setText(setting.getUser());
                    ConnectionDialog.this.mPassword.setText(setting.getPassword());
                }
            }
        });
        pText.add(this.recent);
        Button b = new Button("Clr");
        b.setActionCommand("Clear");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionDialogCommon.deleteRecentConnectionSettings();
                ConnectionDialog.this.settings = new Hashtable();
                ConnectionDialog.this.recent.removeAll();
                ConnectionDialog.this.recent.add(ConnectionDialogCommon.emptySettingName);
                ConnectionDialog.this.mName.setText(null);
            }
        });
        pClearButton.add(b);
        pLabel.add(ConnectionDialog.createLabel("Setting Name:"));
        this.mName = new TextField("");
        pText.add(this.mName);
        pLabel.add(ConnectionDialog.createLabel("Type:"));
        this.types = new Choice();
        this.connTypes = ConnectionDialogCommon.getTypes();
        for (int i = 0; i < this.connTypes.length; ++i) {
            this.types.add(this.connTypes[i][0]);
        }
        this.types.addItemListener(this);
        pText.add(this.types);
        pLabel.add(ConnectionDialog.createLabel("Driver:"));
        this.mDriver = new TextField(this.connTypes[0][1]);
        pText.add(this.mDriver);
        pLabel.add(ConnectionDialog.createLabel("URL:"));
        this.mURL = new TextField(this.connTypes[0][2]);
        this.mURL.addActionListener(this);
        pText.add(this.mURL);
        pLabel.add(ConnectionDialog.createLabel("User:"));
        this.mUser = new TextField("SA");
        this.mUser.addActionListener(this);
        pText.add(this.mUser);
        pLabel.add(ConnectionDialog.createLabel("Password:"));
        this.mPassword = new TextField("");
        this.mPassword.addActionListener(this);
        this.mPassword.setEchoChar('*');
        pText.add(this.mPassword);
        b = new Button("Ok");
        b.setActionCommand("ConnectOk");
        b.addActionListener(this);
        pButton.add(b);
        b = new Button("Cancel");
        b.setActionCommand("ConnectCancel");
        b.addActionListener(this);
        pButton.add(b);
        this.add("East", ConnectionDialog.createLabel(""));
        this.add("West", ConnectionDialog.createLabel(""));
        this.mError = new Label("");
        Panel pMessage = ConnectionDialog.createBorderPanel(this.mError);
        this.add("South", pMessage);
        this.add("North", ConnectionDialog.createLabel(""));
        this.add("Center", p);
        this.doLayout();
        this.pack();
        Dimension size = this.getSize();
        if (d.width >= 640) {
            this.setLocation((d.width - size.width) / 2, (d.height - size.height) / 2);
        } else {
            this.setLocation(0, 0);
            this.setSize(d);
        }
        this.setVisible(true);
    }

    public static Connection createConnection(Frame owner, String title) {
        ConnectionDialog dialog = new ConnectionDialog(owner, title);
        dialog.create();
        return dialog.mConnection;
    }

    protected static Label createLabel(String s) {
        Label l = new Label(s);
        l.setBackground(SystemColor.control);
        return l;
    }

    protected static Panel createBorderPanel(Component center) {
        Panel p = new Panel();
        p.setBackground(SystemColor.control);
        p.setLayout(new BorderLayout());
        p.add("Center", center);
        p.add("North", ConnectionDialog.createLabel(""));
        p.add("South", ConnectionDialog.createLabel(""));
        p.add("East", ConnectionDialog.createLabel(""));
        p.add("West", ConnectionDialog.createLabel(""));
        p.setBackground(SystemColor.control);
        return p;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String s = ev.getActionCommand();
        if (s.equals("ConnectOk") || ev.getSource() instanceof TextField) {
            try {
                if (this.mURL.getText().indexOf(171) >= 0) {
                    throw new Exception("please specify db path");
                }
                this.mConnection = ConnectionDialog.createConnection(this.mDriver.getText(), this.mURL.getText(), this.mUser.getText(), this.mPassword.getText());
                if (this.mName.getText() != null && this.mName.getText().trim().length() != 0) {
                    ConnectionSetting newSetting = new ConnectionSetting(this.mName.getText(), this.mDriver.getText(), this.mURL.getText(), this.mUser.getText(), this.mPassword.getText());
                    ConnectionDialogCommon.addToRecentConnectionSettings(this.settings, newSetting);
                }
                this.dispose();
            }
            catch (IOException ioe) {
                this.dispose();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.mError.setText(e.toString());
            }
        } else if (s.equals("ConnectCancel")) {
            this.dispose();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        String s = (String)e.getItem();
        for (int i = 0; i < this.connTypes.length; ++i) {
            if (!s.equals(this.connTypes[i][0])) continue;
            this.mDriver.setText(this.connTypes[i][1]);
            this.mURL.setText(this.connTypes[i][2]);
        }
    }
}

