/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.awt.Component;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

class GridSwing
extends AbstractTableModel {
    JTable jtable = null;
    Object[] headers = new Object[0];
    ArrayList<Object[]> rows = new ArrayList();

    @Override
    public String getColumnName(int i) {
        return this.headers[i].toString();
    }

    public Class getColumnClass(int i) {
        Object o;
        if (this.rows.size() > 0 && (o = this.getValueAt(0, i)) != null) {
            if (o instanceof Timestamp || o instanceof Time) {
                return Object.class;
            }
            return o.getClass();
        }
        return super.getColumnClass(i);
    }

    @Override
    public int getColumnCount() {
        return this.headers.length;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    public Object[] getHead() {
        return this.headers;
    }

    public ArrayList<Object[]> getData() {
        return this.rows;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.rows.size()) {
            return null;
        }
        Object[] colArray = this.rows.get(row);
        if (col >= colArray.length) {
            return null;
        }
        return colArray[col];
    }

    public void setHead(Object[] h) {
        this.headers = Arrays.copyOf(h, h.length);
    }

    public void addRow(Object[] r) {
        Object[] row = new Object[r.length];
        for (int i = 0; i < r.length; ++i) {
            row[i] = r[i];
        }
        this.rows.add(row);
    }

    public void clear() {
        this.rows.clear();
    }

    public void setJTable(JTable table) {
        this.jtable = table;
    }

    @Override
    public void fireTableChanged(TableModelEvent e) {
        super.fireTableChanged(e);
        GridSwing.autoSizeTableColumns(this.jtable);
    }

    public static void autoSizeTableColumns(JTable table) {
        TableModel model = table.getModel();
        TableCellRenderer headerRenderer = table.getTableHeader().getDefaultRenderer();
        for (int i = 0; i < table.getColumnCount(); ++i) {
            TableColumn column = table.getColumnModel().getColumn(i);
            Component comp = headerRenderer.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, 0, 0);
            int headerWidth = comp.getPreferredSize().width + 10;
            int maxCellWidth = Integer.MIN_VALUE;
            for (int j = 0; j < Math.min(model.getRowCount(), 30); ++j) {
                TableCellRenderer r = table.getCellRenderer(j, i);
                comp = r.getTableCellRendererComponent(table, model.getValueAt(j, i), false, false, j, i);
                int cellWidth = comp.getPreferredSize().width;
                if (cellWidth < maxCellWidth) continue;
                maxCellWidth = cellWidth;
            }
            column.setPreferredWidth(Math.max(headerWidth, maxCellWidth) + 10);
        }
    }
}

