/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.hsqldb.util.Traceable;
import org.hsqldb.util.TransferDb;
import org.hsqldb.util.TransferHelper;
import org.hsqldb.util.TransferTable;

class PostgresTransferHelper
extends TransferHelper {
    private static final int PostgreSQL = 0;
    private static final int HSQLDB = 1;
    String[][] Funcs = new String[][]{{"now()", "'now'"}};

    PostgresTransferHelper() {
    }

    PostgresTransferHelper(TransferDb database, Traceable t, String q) {
        super(database, t, q);
    }

    @Override
    int convertToType(int type) {
        if (type == 3) {
            type = 2;
            this.tracer.trace("Converted DECIMAL to NUMERIC");
        }
        return type;
    }

    @Override
    String fixupColumnDefRead(TransferTable t, ResultSetMetaData meta, String columnType, ResultSet columnDesc, int columnIndex) throws SQLException {
        String SeqName = "_" + columnDesc.getString(4) + "_seq";
        int spaceleft = 31 - SeqName.length();
        SeqName = t.Stmts.sDestTable.length() > spaceleft ? t.Stmts.sDestTable.substring(0, spaceleft) + SeqName : t.Stmts.sDestTable + SeqName;
        String CompareString = "nextval('\"" + SeqName + "\"'";
        if (columnType.contains(CompareString)) {
            columnType = "SERIAL";
        }
        for (int Idx = 0; Idx < this.Funcs.length; ++Idx) {
            String PostgreSQL_func = this.Funcs[Idx][0];
            int iStartPos = columnType.indexOf(PostgreSQL_func);
            if (iStartPos < 0) continue;
            String NewColumnType = columnType.substring(0, iStartPos);
            NewColumnType = NewColumnType + this.Funcs[Idx][1];
            columnType = NewColumnType = NewColumnType + columnType.substring(iStartPos + PostgreSQL_func.length());
        }
        return columnType;
    }

    @Override
    String fixupColumnDefWrite(TransferTable t, ResultSetMetaData meta, String columnType, ResultSet columnDesc, int columnIndex) throws SQLException {
        if (columnType.equals("SERIAL")) {
            String SeqName = "_" + columnDesc.getString(4) + "_seq";
            int spaceleft = 31 - SeqName.length();
            SeqName = t.Stmts.sDestTable.length() > spaceleft ? t.Stmts.sDestTable.substring(0, spaceleft) + SeqName : t.Stmts.sDestTable + SeqName;
            String DropSequence = "DROP SEQUENCE " + SeqName + ";";
            t.Stmts.sDestDrop = t.Stmts.sDestDrop + DropSequence;
        }
        for (int Idx = 0; Idx < this.Funcs.length; ++Idx) {
            String HSQLDB_func = this.Funcs[Idx][1];
            int iStartPos = columnType.indexOf(HSQLDB_func);
            if (iStartPos < 0) continue;
            String NewColumnType = columnType.substring(0, iStartPos);
            NewColumnType = NewColumnType + this.Funcs[Idx][0];
            columnType = NewColumnType = NewColumnType + columnType.substring(iStartPos + HSQLDB_func.length());
        }
        return columnType;
    }

    @Override
    void beginDataTransfer() {
        try {
            this.db.setAutoCommit(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    void endDataTransfer() {
        try {
            this.db.commit();
            this.db.execute("VACUUM ANALYZE");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

