/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class RCData {
    public static final String DEFAULT_JDBC_DRIVER = "org.hsqldb.jdbc.JDBCDriver";
    private String defaultJdbcDriverName = "org.hsqldb.jdbc.JDBCDriver";
    public String id;
    public String url;
    public String username;
    public String password;
    public String ti;
    public String driver;
    public String charset;
    public String truststore;
    public String libpath;

    public void setDefaultJdbcDriver(String defaultJdbcDriverName) {
        this.defaultJdbcDriverName = defaultJdbcDriverName;
    }

    public String getDefaultJdbcDriverName() {
        return this.defaultJdbcDriverName;
    }

    public String toString() {
        return "id: " + RCData.angleBracketNull(this.id) + ", url: " + RCData.angleBracketNull(this.url) + ", username: " + RCData.angleBracketNull(this.username) + ", password: <" + (this.password == null ? "NULL" : "PRESENT") + ">, ti: " + RCData.angleBracketNull(this.ti) + ", driver: " + RCData.angleBracketNull(this.driver) + ", truststore: " + RCData.angleBracketNull(this.truststore) + ", libpath: " + RCData.angleBracketNull(this.libpath);
    }

    private static String angleBracketNull(String s) {
        return s == null ? "<NULL>" : s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RCData(File file, String dbKey) throws Exception {
        HashSet<String> idPatterns = new HashSet<String>();
        if (file == null) {
            throw new IllegalArgumentException("RC file name not specified");
        }
        if (!file.canRead()) {
            throw new IOException("Please set up authentication file '" + file + "'");
        }
        boolean loadingStanza = false;
        int linenum = 0;
        BufferedReader br = new BufferedReader(new FileReader(file));
        try {
            String s;
            while ((s = br.readLine()) != null) {
                String value;
                String keyword;
                ++linenum;
                if ((s = s.trim()).isEmpty() || s.charAt(0) == '#') continue;
                StringTokenizer tokenizer = new StringTokenizer(s);
                if (tokenizer.countTokens() == 1) {
                    keyword = tokenizer.nextToken();
                    value = "";
                } else if (tokenizer.countTokens() > 1) {
                    keyword = tokenizer.nextToken();
                    value = tokenizer.nextToken("").trim();
                } else {
                    throw new Exception("Corrupt line " + linenum + " in '" + file + "':  " + s);
                }
                if (keyword.equals("urlid")) {
                    String[] tokens = value.split("\\s*,\\s*", -1);
                    for (int i = 0; i < tokens.length; ++i) {
                        if (idPatterns.contains(tokens[i])) {
                            throw new Exception("ID Pattern '" + tokens[i] + "' repeated at line " + linenum + " in '" + file + "'");
                        }
                        idPatterns.add(tokens[i]);
                        if (dbKey == null) {
                            System.out.println(tokens[i]);
                            continue;
                        }
                        loadingStanza = Pattern.compile(tokens[i]).matcher(dbKey).matches();
                        if (this.id != null || !loadingStanza) continue;
                        this.id = dbKey;
                    }
                    continue;
                }
                if (dbKey == null || !loadingStanza) continue;
                if (keyword.equals("url")) {
                    this.url = value;
                    continue;
                }
                if (keyword.equals("username")) {
                    this.username = value;
                    continue;
                }
                if (keyword.equals("driver")) {
                    this.driver = value;
                    continue;
                }
                if (keyword.equals("charset")) {
                    this.charset = value;
                    continue;
                }
                if (keyword.equals("truststore")) {
                    this.truststore = value;
                    continue;
                }
                if (keyword.equals("password")) {
                    this.password = value;
                    continue;
                }
                if (keyword.equals("transiso")) {
                    this.ti = value;
                    continue;
                }
                if (keyword.equals("libpath")) {
                    this.libpath = value;
                    continue;
                }
                throw new Exception("Bad line " + linenum + " in '" + file + "':  " + s);
            }
        }
        finally {
            try {
                br.close();
            }
            catch (IOException iOException) {}
            br = null;
        }
        if (dbKey == null) {
            return;
        }
        if (this.libpath != null) {
            throw new IllegalArgumentException("Sorry, 'libpath' not supported yet");
        }
        if (this.id == null) {
            throw new IllegalArgumentException("No match for '" + dbKey + "' in file '" + file + "'");
        }
    }

    public RCData(String id, String url, String username, String password, String driver, String charset, String truststore) throws Exception {
        this(id, url, username, password, driver, charset, truststore, null);
    }

    public RCData(String id, String url, String username, String password, String driver, String charset, String truststore, String libpath) throws Exception {
        this(id, url, username, password, driver, charset, truststore, libpath, null);
    }

    public RCData(String id, String url, String username, String password, String driver, String charset, String truststore, String libpath, String ti) throws Exception {
        this.id = id;
        this.url = url;
        this.username = username;
        this.password = password;
        this.ti = ti;
        this.driver = driver;
        this.charset = charset;
        this.truststore = truststore;
        this.libpath = libpath;
        if (libpath != null) {
            throw new IllegalArgumentException("Sorry, 'libpath' not supported yet");
        }
        if (id == null) {
            throw new Exception("id was not set");
        }
    }

    public Connection getConnection() throws SQLException, MalformedURLException {
        return this.getConnection(null, null);
    }

    public Connection getConnection(String curDriverIn, String curTrustStoreIn) throws MalformedURLException, SQLException {
        Connection c;
        String urlString;
        String curDriver = null;
        String curTrustStore = null;
        Properties sysProps = System.getProperties();
        curDriver = curDriverIn == null ? (this.driver == null ? DEFAULT_JDBC_DRIVER : this.driver) : RCData.expandSysPropVars(curDriverIn);
        if (curTrustStoreIn == null) {
            if (this.truststore != null) {
                curTrustStore = RCData.expandSysPropVars(this.truststore);
            }
        } else {
            curTrustStore = RCData.expandSysPropVars(curTrustStoreIn);
        }
        if (curTrustStore == null) {
            sysProps.remove("javax.net.ssl.trustStore");
        } else {
            sysProps.put("javax.net.ssl.trustStore", curTrustStore);
        }
        if (this.url == null) {
            throw new MalformedURLException("url string is required to establish a connection, but is null");
        }
        try {
            urlString = RCData.expandSysPropVars(this.url);
        }
        catch (IllegalArgumentException iae) {
            throw new MalformedURLException(iae.toString() + " for URL '" + this.url + "'");
        }
        String userString = null;
        if (this.username != null) {
            try {
                userString = RCData.expandSysPropVars(this.username);
            }
            catch (IllegalArgumentException iae) {
                throw new MalformedURLException(iae.toString() + " for user name '" + this.username + "'");
            }
        }
        String passwordString = null;
        if (this.password != null) {
            try {
                passwordString = RCData.expandSysPropVars(this.password);
            }
            catch (IllegalArgumentException iae) {
                throw new MalformedURLException(iae.toString() + " for password");
            }
        }
        Connection connection = c = userString == null ? DriverManager.getConnection(urlString) : DriverManager.getConnection(urlString, userString, passwordString);
        if (this.ti != null) {
            RCData.setTI(c, this.ti);
        }
        return c;
    }

    public static String expandSysPropVars(String inString) {
        int varEnd;
        int varOffset;
        String outString = inString;
        while ((varOffset = outString.indexOf("${")) >= 0 && (varEnd = outString.indexOf(125, varOffset + 2)) >= 0) {
            String varName = outString.substring(varOffset + 2, varEnd);
            if (varName.length() < 1) {
                throw new IllegalArgumentException("Bad variable setting");
            }
            String varVal = System.getProperty(varName);
            if (varVal == null) {
                throw new IllegalArgumentException("No Java system property with name '" + varName + "'");
            }
            outString = outString.substring(0, varOffset) + varVal + outString.substring(varEnd + 1);
        }
        return outString;
    }

    public static void setTI(Connection c, String tiString) throws SQLException {
        int i = -1;
        if (tiString.equals("TRANSACTION_READ_UNCOMMITTED")) {
            i = 1;
        }
        if (tiString.equals("TRANSACTION_READ_COMMITTED")) {
            i = 2;
        }
        if (tiString.equals("TRANSACTION_REPEATABLE_READ")) {
            i = 4;
        }
        if (tiString.equals("TRANSACTION_SERIALIZABLE")) {
            i = 8;
        }
        if (tiString.equals("TRANSACTION_NONE")) {
            i = 0;
        }
        if (i < 0) {
            throw new SQLException("Trans. isol. value not supported by " + RCData.class.getName() + ": " + tiString);
        }
        c.setTransactionIsolation(i);
    }

    public static String tiToString(int ti) {
        switch (ti) {
            case 1: {
                return "TRANSACTION_READ_UNCOMMITTED";
            }
            case 2: {
                return "TRANSACTION_READ_COMMITTED";
            }
            case 4: {
                return "TRANSACTION_REPEATABLE_READ";
            }
            case 8: {
                return "TRANSACTION_SERIALIZABLE";
            }
            case 0: {
                return "TRANSACTION_NONE";
            }
        }
        return "Custom Transaction Isolation numerical value: " + ti;
    }
}

