/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import org.hsqldb.util.DataAccessPoint;
import org.hsqldb.util.Traceable;
import org.hsqldb.util.TransferDb;
import org.hsqldb.util.TransferTable;

class TransferCommon {
    static void savePrefs(String f, DataAccessPoint sourceDb, DataAccessPoint targetDb, Traceable tracer, Vector tTable) {
        try {
            TransferTable t;
            int i;
            FileOutputStream fos = new FileOutputStream(f);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            for (i = 0; i < tTable.size(); ++i) {
                t = (TransferTable)tTable.elementAt(i);
                t.sourceDb = null;
                t.destDb = null;
                t.tracer = null;
            }
            oos.writeObject(tTable);
            for (i = 0; i < tTable.size(); ++i) {
                t = (TransferTable)tTable.elementAt(i);
                t.tracer = tracer;
                t.sourceDb = (TransferDb)sourceDb;
                t.destDb = targetDb;
            }
        }
        catch (IOException e) {
            System.out.println("pb in SavePrefs : " + e.toString());
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Vector loadPrefs(String f, DataAccessPoint sourceDb, DataAccessPoint targetDb, Traceable tracer) {
        Vector tTable = null;
        ObjectInputStream ois = null;
        try {
            FileInputStream fis = new FileInputStream(f);
            ois = new ObjectInputStream(fis);
            tTable = (Vector)ois.readObject();
            for (int i = 0; i < tTable.size(); ++i) {
                TransferTable t = (TransferTable)tTable.elementAt(i);
                t.tracer = tracer;
                t.sourceDb = (TransferDb)sourceDb;
                t.destDb = targetDb;
            }
        }
        catch (ClassNotFoundException e) {
            System.out.println("class not found pb in LoadPrefs : " + e.toString());
            tTable = new Vector();
        }
        catch (IOException e) {
            System.out.println("IO pb in LoadPrefs : actionPerformed" + e.toString());
            tTable = new Vector();
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {}
            }
        }
        return tTable;
    }

    private TransferCommon() {
    }
}

