/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.hsqldb.util.DataAccessPoint;
import org.hsqldb.util.DataAccessPointException;
import org.hsqldb.util.HelperFactory;
import org.hsqldb.util.Traceable;
import org.hsqldb.util.TransferResultSet;
import org.hsqldb.util.TransferTable;

class TransferDb
extends DataAccessPoint {
    Connection conn;
    DatabaseMetaData meta;
    protected Statement srcStatement = null;

    TransferDb(Connection c, Traceable t) throws DataAccessPointException {
        super(t);
        this.conn = c;
        if (c != null) {
            try {
                this.meta = c.getMetaData();
                this.databaseToConvert = c.getCatalog();
                String productLowerName = this.meta.getDatabaseProductName();
                productLowerName = productLowerName == null ? "" : productLowerName.toLowerCase();
                this.helper = HelperFactory.getHelper(productLowerName);
                this.helper.set(this, t, this.meta.getIdentifierQuoteString());
            }
            catch (SQLException e) {
                throw new DataAccessPointException(e.toString());
            }
        }
    }

    @Override
    boolean isConnected() {
        return this.conn != null;
    }

    @Override
    boolean getAutoCommit() throws DataAccessPointException {
        boolean result = false;
        try {
            result = this.conn.getAutoCommit();
        }
        catch (SQLException e) {
            throw new DataAccessPointException(e.toString());
        }
        return result;
    }

    @Override
    void commit() throws DataAccessPointException {
        if (this.srcStatement != null) {
            try {
                this.srcStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.srcStatement = null;
        }
        try {
            this.conn.commit();
        }
        catch (SQLException e) {
            throw new DataAccessPointException(e.toString());
        }
    }

    @Override
    void rollback() throws DataAccessPointException {
        if (this.srcStatement != null) {
            try {
                this.srcStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.srcStatement = null;
        }
        try {
            this.conn.rollback();
        }
        catch (SQLException e) {
            throw new DataAccessPointException(e.toString());
        }
    }

    @Override
    void setAutoCommit(boolean flag) throws DataAccessPointException {
        try {
            this.conn.setAutoCommit(flag);
        }
        catch (SQLException e) {
            throw new DataAccessPointException(e.toString());
        }
    }

    @Override
    boolean execute(String statement) throws DataAccessPointException {
        boolean result = false;
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement();
            result = stmt.execute(statement);
        }
        catch (SQLException e) {
            throw new DataAccessPointException(e.toString());
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return result;
    }

    @Override
    TransferResultSet getData(String statement) throws DataAccessPointException {
        ResultSet rsData = null;
        try {
            if (this.srcStatement != null) {
                this.srcStatement.close();
            }
            this.srcStatement = this.conn.createStatement();
            rsData = this.srcStatement.executeQuery(statement);
        }
        catch (SQLException e) {
            try {
                this.srcStatement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.srcStatement = null;
            rsData = null;
            throw new DataAccessPointException(e.toString());
        }
        return new TransferResultSet(rsData);
    }

    @Override
    void putData(String statement, TransferResultSet r, int iMaxRows) throws DataAccessPointException {
        if (statement == null || statement.equals("") || r == null) {
            return;
        }
        PreparedStatement destPrep = null;
        try {
            destPrep = this.conn.prepareStatement(statement);
            int i = 0;
            int len = r.getColumnCount();
            int[] tmpTypes = null;
            while (r.next()) {
                if (tmpTypes == null) {
                    tmpTypes = new int[len + 1];
                    for (int j = 1; j <= len; ++j) {
                        tmpTypes[j] = r.getColumnType(j);
                    }
                }
                this.transferRow(r, destPrep, len, tmpTypes);
                if (iMaxRows != 0 && i == iMaxRows) {
                    break;
                }
                if (iMaxRows == 0 && ++i % 100 != 0) continue;
                this.tracer.trace("Transfered " + i + " rows");
            }
        }
        catch (SQLException e) {
            throw new DataAccessPointException(e.toString());
        }
        finally {
            if (destPrep != null) {
                try {
                    destPrep.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    Vector getSchemas() throws DataAccessPointException {
        Vector<String> ret = new Vector<String>();
        ResultSet result = null;
        try {
            result = this.meta.getSchemas();
        }
        catch (SQLException e) {
            result = null;
        }
        try {
            if (result != null) {
                while (result.next()) {
                    ret.addElement(result.getString(1));
                }
                result.close();
            }
        }
        catch (SQLException e) {
            throw new DataAccessPointException(e.toString());
        }
        return ret;
    }

    @Override
    Vector getCatalog() throws DataAccessPointException {
        Vector<String> ret = new Vector<String>();
        ResultSet result = null;
        if (this.databaseToConvert != null && this.databaseToConvert.length() > 0) {
            ret.addElement(this.databaseToConvert);
            return ret;
        }
        try {
            result = this.meta.getCatalogs();
        }
        catch (SQLException e) {
            result = null;
        }
        try {
            if (result != null) {
                while (result.next()) {
                    ret.addElement(result.getString(1));
                }
                result.close();
            }
        }
        catch (SQLException e) {
            throw new DataAccessPointException(e.toString());
        }
        return ret;
    }

    @Override
    void setCatalog(String sCatalog) throws DataAccessPointException {
        if (sCatalog != null && sCatalog.length() > 0) {
            try {
                this.conn.setCatalog(sCatalog);
            }
            catch (SQLException e) {
                throw new DataAccessPointException(e.toString());
            }
        }
    }

    @Override
    Vector getTables(String sCatalog, String[] sSchemas) throws DataAccessPointException {
        Vector<TransferTable> tTable = new Vector<TransferTable>();
        ResultSet result = null;
        this.tracer.trace("Reading source tables");
        int nbloops = 1;
        if (sSchemas != null) {
            nbloops = sSchemas.length;
        }
        try {
            for (int SchemaIdx = 0; SchemaIdx < nbloops; ++SchemaIdx) {
                if (sSchemas != null && sSchemas[SchemaIdx] != null) {
                    result = this.meta.getTables(sCatalog, sSchemas[SchemaIdx], null, null);
                } else {
                    try {
                        result = this.meta.getTables(sCatalog, "", null, null);
                    }
                    catch (SQLException e) {
                        result = this.meta.getTables(sCatalog, null, null, null);
                    }
                }
                while (result.next()) {
                    String name = result.getString(3);
                    String type = result.getString(4);
                    String schema = "";
                    if (sSchemas != null && sSchemas[SchemaIdx] != null) {
                        schema = sSchemas[SchemaIdx];
                    }
                    if (type.compareTo("TABLE") == 0 || type.compareTo("VIEW") == 0) {
                        TransferTable t = new TransferTable(this, name, schema, type, this.tracer);
                        tTable.addElement(t);
                        continue;
                    }
                    this.tracer.trace("Found table of type :" + type + " - this type is ignored");
                }
            }
        }
        catch (SQLException e) {
            throw new DataAccessPointException(e.toString());
        }
        finally {
            if (result != null) {
                try {
                    result.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return tTable;
    }

    @Override
    void getTableStructure(TransferTable TTable, DataAccessPoint Dest) throws DataAccessPointException {
        ResultSetMetaData select_rsmdata;
        ResultSet select_rs;
        Statement stmt;
        int colnum;
        ResultSet col;
        Vector<Integer> v;
        String DropIndex;
        String CreateIndex;
        boolean indices;
        String PrimaryKeysConstraint;
        boolean primarykeys;
        String alterCreate;
        boolean importedkeys;
        String insert;
        String create;
        block64: {
            block63: {
                create = "CREATE " + TTable.Stmts.sType + " " + Dest.helper.formatName(TTable.Stmts.sDestTable);
                insert = "";
                ResultSet ImportedKeys = null;
                importedkeys = false;
                alterCreate = "";
                String alterDrop = "";
                String ConstraintName = "";
                String RefTableName = "";
                String foreignKeyName = "";
                String columnName = "";
                Dest.helper.setSchema(TTable.Stmts.sSchema);
                TTable.Stmts.sDestDrop = "DROP " + TTable.Stmts.sType + " " + Dest.helper.formatName(TTable.Stmts.sDestTable) + ";";
                if (TTable.Stmts.sType.compareTo("TABLE") == 0) {
                    TTable.Stmts.sDestDelete = "DELETE FROM " + Dest.helper.formatName(TTable.Stmts.sDestTable) + ";";
                    create = create + "(";
                } else if (TTable.Stmts.sType.compareTo("VIEW") == 0) {
                    TTable.Stmts.bDelete = false;
                    TTable.Stmts.sDestDelete = "";
                    create = create + " AS SELECT ";
                }
                if (TTable.Stmts.sType.compareTo("TABLE") == 0) {
                    insert = "INSERT INTO " + Dest.helper.formatName(TTable.Stmts.sDestTable) + " VALUES(";
                } else if (TTable.Stmts.sType.compareTo("VIEW") == 0) {
                    TTable.Stmts.bInsert = false;
                    insert = "";
                }
                if (TTable.Stmts.sType.compareTo("VIEW") == 0) {
                    TTable.Stmts.bTransfer = false;
                    TTable.Stmts.bCreate = true;
                    TTable.Stmts.bDelete = false;
                    TTable.Stmts.bDrop = true;
                    TTable.Stmts.bCreateIndex = false;
                    TTable.Stmts.bDropIndex = false;
                    TTable.Stmts.bInsert = false;
                    TTable.Stmts.bAlter = false;
                    return;
                }
                ImportedKeys = null;
                try {
                    ImportedKeys = this.meta.getImportedKeys(TTable.Stmts.sDatabaseToConvert, TTable.Stmts.sSchema, TTable.Stmts.sSourceTable);
                }
                catch (SQLException e) {
                    ImportedKeys = null;
                }
                try {
                    if (ImportedKeys != null) {
                        while (ImportedKeys.next()) {
                            importedkeys = true;
                            if (!ImportedKeys.getString(12).equals(ConstraintName)) {
                                if (!ConstraintName.equals("")) {
                                    alterCreate = alterCreate + Dest.helper.formatIdentifier(columnName.substring(0, columnName.length() - 1)) + ") REFERENCES " + Dest.helper.formatName(RefTableName);
                                    if (foreignKeyName.length() > 0) {
                                        alterCreate = alterCreate + " (" + Dest.helper.formatIdentifier(foreignKeyName.substring(0, foreignKeyName.length() - 1)) + ")";
                                    }
                                    alterCreate = alterCreate + ";";
                                    alterDrop = alterDrop.substring(0, alterDrop.length() - 1) + ";";
                                    foreignKeyName = "";
                                    columnName = "";
                                }
                                RefTableName = ImportedKeys.getString(3);
                                ConstraintName = ImportedKeys.getString(12);
                                alterCreate = alterCreate + "ALTER TABLE " + Dest.helper.formatName(TTable.Stmts.sDestTable) + " ADD CONSTRAINT ";
                                alterCreate = TTable.Stmts.bFKForced && !ConstraintName.startsWith("FK_") ? alterCreate + Dest.helper.formatIdentifier("FK_" + ConstraintName) + " " : alterCreate + Dest.helper.formatIdentifier(ConstraintName) + " ";
                                alterCreate = alterCreate + "FOREIGN KEY (";
                                alterDrop = alterDrop + "ALTER TABLE " + Dest.helper.formatName(TTable.Stmts.sDestTable) + " DROP CONSTRAINT ";
                                alterDrop = TTable.Stmts.bFKForced && !ConstraintName.startsWith("FK_") ? alterDrop + Dest.helper.formatIdentifier("FK_" + ConstraintName) + " " : alterDrop + Dest.helper.formatIdentifier(ConstraintName) + " ";
                            }
                            columnName = columnName + ImportedKeys.getString(8) + ",";
                            foreignKeyName = foreignKeyName + ImportedKeys.getString(4) + ",";
                        }
                        ImportedKeys.close();
                    }
                    if (importedkeys) {
                        alterCreate = alterCreate + columnName.substring(0, columnName.length() - 1) + ") REFERENCES " + Dest.helper.formatName(RefTableName);
                        if (foreignKeyName.length() > 0) {
                            alterCreate = alterCreate + " (" + Dest.helper.formatIdentifier(foreignKeyName.substring(0, foreignKeyName.length() - 1)) + ")";
                        }
                        alterCreate = alterCreate + ";";
                        alterDrop = alterDrop.substring(0, alterDrop.length() - 1) + ";";
                        TTable.Stmts.sDestDrop = alterDrop + TTable.Stmts.sDestDrop;
                    }
                }
                catch (SQLException e) {
                    throw new DataAccessPointException(e.toString());
                }
                primarykeys = false;
                PrimaryKeysConstraint = "";
                ResultSet PrimaryKeys = null;
                try {
                    PrimaryKeys = this.meta.getPrimaryKeys(TTable.Stmts.sDatabaseToConvert, TTable.Stmts.sSchema, TTable.Stmts.sSourceTable);
                }
                catch (SQLException e) {
                    PrimaryKeys = null;
                }
                try {
                    if (PrimaryKeys != null) {
                        while (PrimaryKeys.next()) {
                            if (primarykeys) {
                                PrimaryKeysConstraint = PrimaryKeysConstraint + ", ";
                            } else {
                                if (PrimaryKeys.getString(6) != null) {
                                    PrimaryKeysConstraint = " CONSTRAINT " + Dest.helper.formatIdentifier(PrimaryKeys.getString(6));
                                }
                                PrimaryKeysConstraint = PrimaryKeysConstraint + " PRIMARY KEY (";
                            }
                            PrimaryKeysConstraint = PrimaryKeysConstraint + Dest.helper.formatIdentifier(PrimaryKeys.getString(4));
                            primarykeys = true;
                        }
                        PrimaryKeys.close();
                        if (primarykeys) {
                            PrimaryKeysConstraint = PrimaryKeysConstraint + ") ";
                        }
                    }
                }
                catch (SQLException e) {
                    throw new DataAccessPointException(e.toString());
                }
                indices = false;
                ResultSet Indices = null;
                String IndiceName = "";
                CreateIndex = "";
                DropIndex = "";
                try {
                    Indices = this.meta.getIndexInfo(TTable.Stmts.sDatabaseToConvert, TTable.Stmts.sSchema, TTable.Stmts.sSourceTable, false, false);
                }
                catch (SQLException e) {
                    Indices = null;
                }
                try {
                    if (Indices == null) break block63;
                    while (Indices.next()) {
                        String tmpIndexName = null;
                        try {
                            tmpIndexName = Indices.getString(6);
                        }
                        catch (SQLException e) {
                            tmpIndexName = null;
                        }
                        if (tmpIndexName == null) continue;
                        if (!tmpIndexName.equals(IndiceName)) {
                            if (!IndiceName.equals("")) {
                                CreateIndex = CreateIndex.substring(0, CreateIndex.length() - 1) + ");";
                                DropIndex = DropIndex + ";";
                            }
                            IndiceName = tmpIndexName;
                            DropIndex = DropIndex + "DROP INDEX ";
                            DropIndex = TTable.Stmts.bIdxForced && !IndiceName.startsWith("Idx_") ? DropIndex + Dest.helper.formatIdentifier("Idx_" + IndiceName) : DropIndex + Dest.helper.formatIdentifier(IndiceName);
                            CreateIndex = CreateIndex + "CREATE ";
                            if (!Indices.getBoolean(4)) {
                                CreateIndex = CreateIndex + "UNIQUE ";
                            }
                            CreateIndex = CreateIndex + "INDEX ";
                            CreateIndex = TTable.Stmts.bIdxForced && !IndiceName.startsWith("Idx_") ? CreateIndex + Dest.helper.formatIdentifier("Idx_" + IndiceName) : CreateIndex + Dest.helper.formatIdentifier(IndiceName);
                            CreateIndex = CreateIndex + " ON " + Dest.helper.formatName(TTable.Stmts.sDestTable) + "(";
                        }
                        CreateIndex = CreateIndex + Dest.helper.formatIdentifier(Indices.getString(9)) + ",";
                        indices = true;
                    }
                    Indices.close();
                    if (indices) {
                        CreateIndex = CreateIndex.substring(0, CreateIndex.length() - 1) + ");";
                        DropIndex = DropIndex + ";";
                    }
                }
                catch (SQLException e) {
                    throw new DataAccessPointException(e.toString());
                }
            }
            v = new Vector<Integer>();
            this.tracer.trace("Reading source columns for table " + TTable.Stmts.sSourceTable);
            col = null;
            colnum = 1;
            stmt = null;
            select_rs = null;
            select_rsmdata = null;
            try {
                stmt = this.conn.createStatement();
                select_rs = stmt.executeQuery(TTable.Stmts.sSourceSelect + " WHERE 1 = 2");
                select_rsmdata = select_rs.getMetaData();
                col = this.meta.getColumns(TTable.Stmts.sDatabaseToConvert, TTable.Stmts.sSchema, TTable.Stmts.sSourceTable, null);
            }
            catch (SQLException eSchema) {
                if (!TTable.Stmts.sSchema.equals("")) break block64;
                try {
                    col = this.meta.getColumns(TTable.Stmts.sDatabaseToConvert, null, TTable.Stmts.sSourceTable, null);
                }
                catch (SQLException eSchema1) {
                    eSchema1.printStackTrace();
                }
            }
        }
        try {
            while (col.next()) {
                String name = Dest.helper.formatIdentifier(col.getString(4));
                int type = col.getShort(5);
                String source = col.getString(6);
                int column_size = col.getInt(7);
                String DefaultVal = col.getString(13);
                boolean rsmdata_NoNulls = select_rsmdata.isNullable(colnum) == 0;
                boolean rsmdata_isAutoIncrement = false;
                try {
                    rsmdata_isAutoIncrement = select_rsmdata.isAutoIncrement(colnum);
                }
                catch (SQLException e) {
                    rsmdata_isAutoIncrement = false;
                }
                int rsmdata_precision = select_rsmdata.getPrecision(colnum);
                int rsmdata_scale = select_rsmdata.getScale(colnum);
                type = this.helper.convertFromType(type);
                type = Dest.helper.convertToType(type);
                Integer inttype = type;
                String datatype = (String)TTable.hTypes.get(inttype);
                if (datatype == null) {
                    datatype = source;
                    this.tracer.trace("No mapping for type: " + name + " type: " + type + " source: " + source);
                }
                if (type == 2 || type == 3) {
                    datatype = datatype + "(" + Integer.toString(rsmdata_precision);
                    if (rsmdata_scale > 0) {
                        datatype = datatype + "," + Integer.toString(rsmdata_scale);
                    }
                    datatype = datatype + ")";
                } else if (type == 1 || type == 12 || type == -2 || type == -3) {
                    datatype = datatype + "(" + Integer.toString(column_size) + ")";
                } else if (rsmdata_isAutoIncrement) {
                    datatype = "SERIAL";
                }
                if (DefaultVal != null) {
                    if (type != 1 && type != 12 && type != -1 && type != -2 && type != 91 && type != 92 && type != 93 || !DefaultVal.startsWith("'")) {
                        // empty if block
                    }
                    datatype = datatype + " DEFAULT " + DefaultVal;
                }
                if (rsmdata_NoNulls) {
                    datatype = datatype + " NOT NULL ";
                }
                v.addElement(inttype);
                datatype = this.helper.fixupColumnDefRead(TTable, select_rsmdata, datatype, col, colnum);
                datatype = Dest.helper.fixupColumnDefWrite(TTable, select_rsmdata, datatype, col, colnum);
                create = create + name + " " + datatype + ",";
                insert = insert + "?,";
                ++colnum;
            }
            select_rs.close();
            stmt.close();
            col.close();
        }
        catch (SQLException e) {
            throw new DataAccessPointException(e.toString());
        }
        if (primarykeys) {
            create = create + PrimaryKeysConstraint + ",";
        }
        TTable.Stmts.sDestCreate = create.substring(0, create.length() - 1) + ")";
        TTable.Stmts.sDestInsert = insert.substring(0, insert.length() - 1) + ")";
        if (importedkeys) {
            TTable.Stmts.bAlter = true;
            TTable.Stmts.sDestAlter = alterCreate;
        } else {
            TTable.Stmts.bAlter = false;
        }
        if (indices) {
            TTable.Stmts.bCreateIndex = true;
            TTable.Stmts.bDropIndex = true;
            TTable.Stmts.sDestCreateIndex = CreateIndex;
            TTable.Stmts.sDestDropIndex = DropIndex;
        } else {
            TTable.Stmts.bCreateIndex = false;
            TTable.Stmts.bDropIndex = false;
        }
    }

    @Override
    void close() {
        if (this.srcStatement != null) {
            try {
                this.srcStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.srcStatement = null;
        }
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.conn = null;
        }
    }

    private void transferRow(TransferResultSet r, PreparedStatement p, int len, int[] types) throws SQLException {
        for (int i = 1; i <= len; ++i) {
            int t = types[i];
            Object o = r.getObject(i);
            if (o == null) {
                if (p == null) continue;
                p.setNull(i, t);
                continue;
            }
            o = this.helper.convertColumnValue(o, i, t);
            p.setObject(i, o);
        }
        if (p != null) {
            p.execute();
        }
    }

    public DatabaseMetaData getMeta() {
        return this.meta;
    }

    public Connection getConn() {
        return this.conn;
    }
}

