/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util.preprocessor;

import java.io.File;
import java.io.IOException;
import org.hsqldb.util.preprocessor.IResolver;

public class BasicResolver
implements IResolver {
    private final File parentDir;

    public static IResolver forPath(String path) {
        if (path == null) {
            return new BasicResolver(null);
        }
        if (path.isEmpty()) {
            return new BasicResolver(new File(""));
        }
        File file = new File(path);
        if (!file.exists()) {
            if (file.mkdirs()) {
                return new BasicResolver(file);
            }
            throw new IllegalArgumentException("could not makedirs for: " + file.getAbsolutePath());
        }
        if (file.isDirectory()) {
            return new BasicResolver(file);
        }
        if (file.isFile()) {
            File parentFile = file.getParentFile();
            if (parentFile == null) {
                throw new IllegalArgumentException("path is not a directory and has no parent: " + file.getAbsolutePath());
            }
            if (parentFile.isFile()) {
                throw new IllegalArgumentException("parent path is a file: " + parentFile.getAbsolutePath());
            }
            if (parentFile.isDirectory()) {
                return new BasicResolver(file);
            }
            if (parentFile.exists()) {
                throw new IllegalArgumentException("parent path exists but is not a file or directory: " + file.getAbsolutePath());
            }
            if (parentFile.mkdirs()) {
                return new BasicResolver(parentFile);
            }
            throw new IllegalArgumentException("could not makedirs for: " + parentFile.getAbsolutePath());
        }
        throw new IllegalArgumentException("path exists but is not a file or a directory: " + file.getAbsolutePath());
    }

    public BasicResolver() {
        this(null);
    }

    public BasicResolver(File parentDir) {
        this.parentDir = parentDir;
    }

    @Override
    public String resolveProperties(String expression) {
        return expression;
    }

    @Override
    public File resolveFile(String path) {
        File dir = this.parentDir;
        String actualPath = path == null || path.isEmpty() ? "" : path;
        File file = new File(actualPath);
        if (dir != null && !file.isAbsolute()) {
            try {
                file = new File(dir.getCanonicalFile(), file.getPath());
            }
            catch (IOException ex) {
                file = new File(dir.getAbsoluteFile(), file.getPath());
            }
        }
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file.getAbsoluteFile();
        }
    }
}

