/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util.preprocessor;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class Document {
    private final List<String> lines = new ArrayList<String>(16);

    public static boolean isSupportedCharset(String charsetName) {
        return charsetName != null && !charsetName.trim().isEmpty() && Charset.isSupported(charsetName);
    }

    public Document() {
    }

    public Document(Document source) {
        this();
        if (source != null) {
            Document target = this;
            target.appendDocument(source);
        }
    }

    public Document addSouceLine(String line) {
        if (line == null) {
            throw new IllegalArgumentException("line: null");
        }
        this.lines.add(line);
        return this;
    }

    public Document appendDocument(Document source) {
        if (source != null && source.size() > 0) {
            this.lines.addAll(source.lines);
        }
        return this;
    }

    public Document clear() {
        this.lines.clear();
        return this;
    }

    public boolean contains(CharSequence sequence) {
        if (sequence == null) {
            return false;
        }
        String toFind = sequence.toString();
        List<String> list = this.lines;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (-1 >= list.get(i).indexOf(toFind, 0)) continue;
            return true;
        }
        return false;
    }

    public Document deleteSourceLine(int index) {
        this.lines.remove(index);
        return this;
    }

    public boolean contentEquals(Document document) {
        return document == this ? true : (document == null ? this.isEmpty() : this.lines.equals(document.lines));
    }

    public String getSourceLine(int index) {
        return this.lines.get(index);
    }

    public boolean isEmpty() {
        return this.lines.isEmpty();
    }

    public Document insertSourceLine(int index, String line) {
        if (line == null) {
            throw new IllegalArgumentException("line: null");
        }
        this.lines.add(index, line);
        return this;
    }

    public Document replaceWith(Document source) {
        return this.clear().appendDocument(source);
    }

    public Document setSourceLine(int index, String line) {
        if (line == null) {
            throw new IllegalArgumentException("null");
        }
        this.lines.set(index, line);
        return this;
    }

    public int size() {
        return this.lines.size();
    }

    public Document load(InputStream inputStream, String encoding) throws IOException, IllegalArgumentException, NullPointerException {
        return this.load((Object)inputStream, encoding);
    }

    public Document load(Reader reader) throws IOException, NullPointerException {
        return this.load(reader, null);
    }

    public Document load(File file, String encoding) throws IOException, IllegalArgumentException {
        return this.load((Object)(file == null ? new File("") : file), encoding);
    }

    public Document load(String path, String encoding) throws IOException, IllegalArgumentException {
        return this.load((Object)(path == null ? "" : path), encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document load(Object source, String encoding) throws IOException, NullPointerException, IllegalArgumentException {
        FileInputStream fis;
        InputStreamReader isr;
        Charset charset;
        if (source == null) {
            throw new NullPointerException("source must not be null.");
        }
        Charset charset2 = charset = source instanceof Reader || encoding == null ? Charset.defaultCharset() : null;
        if (charset != null || !Document.isSupportedCharset(encoding)) {
            throw new IllegalArgumentException("encoding: " + encoding);
        }
        charset = Charset.forName(encoding);
        BufferedReader reader = null;
        boolean close = false;
        if (source instanceof InputStream) {
            InputStream is = (InputStream)source;
            isr = new InputStreamReader(is, charset);
            reader = new BufferedReader(isr);
        } else if (source instanceof File) {
            fis = new FileInputStream((File)source);
            isr = new InputStreamReader((InputStream)fis, charset);
            close = true;
            reader = new BufferedReader(isr);
        } else if (source instanceof String) {
            fis = new FileInputStream((String)source);
            isr = new InputStreamReader((InputStream)fis, charset);
            close = true;
            reader = new BufferedReader(isr);
        } else if (source instanceof BufferedReader) {
            reader = (BufferedReader)source;
        } else if (source instanceof Reader) {
            reader = new BufferedReader((Reader)source);
        } else {
            throw new IOException("unhandled load source: " + source);
        }
        this.clear();
        List<String> list = this.lines;
        try {
            String line;
            while (null != (line = reader.readLine())) {
                list.add(line);
            }
        }
        finally {
            if (close) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return this;
    }

    public Document save(OutputStream outputStream, String encoding) throws IOException {
        return this.save((Object)outputStream, encoding);
    }

    public Document save(File file, String encoding) throws IOException, IllegalArgumentException {
        return this.save((Object)(file == null ? new File("") : file), encoding);
    }

    public Document save(String path, String encoding) throws IOException, IllegalArgumentException {
        return this.save((Object)(path == null ? "" : path), encoding);
    }

    public Document save(Writer writer) throws IOException {
        return this.save(writer, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document save(Object target, String encoding) throws IOException {
        FileOutputStream fos;
        OutputStreamWriter osw;
        Charset charset;
        if (target == null) {
            throw new NullPointerException("target must not be null.");
        }
        Charset charset2 = charset = target instanceof Writer || encoding == null ? Charset.defaultCharset() : null;
        if (charset != null || !Document.isSupportedCharset(encoding)) {
            throw new IllegalArgumentException("encoding: " + encoding);
        }
        charset = Charset.forName(encoding);
        BufferedWriter writer = null;
        boolean close = false;
        if (target instanceof OutputStream) {
            OutputStream os = (OutputStream)target;
            osw = new OutputStreamWriter(os, charset);
            writer = new BufferedWriter(osw);
        } else if (target instanceof File) {
            fos = new FileOutputStream((File)target);
            osw = new OutputStreamWriter((OutputStream)fos, charset);
            close = true;
            writer = new BufferedWriter(osw);
        } else if (target instanceof String) {
            fos = new FileOutputStream((String)target);
            osw = new OutputStreamWriter((OutputStream)fos, charset);
            close = true;
            writer = new BufferedWriter(osw);
        } else if (target instanceof BufferedWriter) {
            writer = (BufferedWriter)target;
        } else if (target instanceof Writer) {
            writer = new BufferedWriter(writer);
        } else {
            throw new IOException("unhandled save target: " + target);
        }
        List<String> list = this.lines;
        int count = list.size();
        try {
            for (int i = 0; i < count; ++i) {
                writer.write(list.get(i));
                writer.newLine();
            }
            writer.flush();
        }
        finally {
            if (close) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        return this;
    }
}

