/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util.preprocessor;

import org.hsqldb.util.preprocessor.LineType;
import org.hsqldb.util.preprocessor.PreprocessorException;

public class Line {
    public static final String DIRECTIVE_PREFIX = "//#";
    public static final String SPACE_CHARS = " \t";
    public static final int DIRECTIVE_PREFIX_LENGTH = "//#".length();
    private static final int DIRECTIVE_PREFIX_LENGTH_PLUS_ONE = DIRECTIVE_PREFIX_LENGTH + 1;
    public static final String HIDE_DIRECTIVE = "//# ";
    private int type;
    private String sourceText;
    private String indent;
    private String text;
    private String arguments;

    public static int indexOfNonTabOrSpace(String line) {
        char ch;
        int pos;
        int len = line.length();
        for (pos = 0; pos < len && ((ch = line.charAt(pos)) == ' ' || ch == '\t'); ++pos) {
        }
        return pos;
    }

    public static int indexOfTabOrSpace(String string, int fromIndex) {
        int spos = string.indexOf(32, fromIndex);
        int tpos = string.indexOf(9, fromIndex);
        return tpos != -1 && tpos < spos || spos == -1 ? tpos : spos;
    }

    public Line(String line) throws PreprocessorException, NullPointerException {
        Line target = this;
        target.setSourceText(line);
    }

    public void setSourceText(String line) throws PreprocessorException, NullPointerException {
        this.sourceText = line;
        int pos = Line.indexOfNonTabOrSpace(line);
        this.indent = line.substring(0, pos);
        String subline = line.substring(pos);
        if (!subline.startsWith(DIRECTIVE_PREFIX)) {
            this.text = subline;
            this.arguments = null;
            this.type = 14;
        } else if (subline.length() == DIRECTIVE_PREFIX_LENGTH) {
            this.text = "";
            this.arguments = null;
            this.type = 8;
        } else if (SPACE_CHARS.indexOf(subline.charAt(DIRECTIVE_PREFIX_LENGTH)) != -1) {
            this.text = subline.substring(DIRECTIVE_PREFIX_LENGTH_PLUS_ONE);
            this.arguments = null;
            this.type = 8;
        } else {
            pos = Line.indexOfTabOrSpace(subline, DIRECTIVE_PREFIX_LENGTH_PLUS_ONE);
            if (pos == -1) {
                this.text = subline;
                this.arguments = null;
            } else {
                this.text = subline.substring(0, pos);
                this.arguments = subline.substring(pos + 1).trim();
            }
            Integer typeId = LineType.id(this.text);
            if (typeId == null) {
                throw new PreprocessorException("Unknown directive [" + this.text + "] in [" + subline + "]");
            }
            this.type = typeId;
        }
    }

    public String getArguments() throws PreprocessorException {
        if (this.arguments == null || this.arguments.isEmpty()) {
            throw new PreprocessorException("[" + this.text + "]: has no argument(s)");
        }
        return this.arguments;
    }

    public String getSourceText() {
        return this.sourceText;
    }

    public String getIndent() {
        return this.indent;
    }

    public String getText() {
        return this.text;
    }

    public int getType() {
        return this.type;
    }

    public boolean isType(int lineType) {
        return this.type == lineType;
    }

    public String toString() {
        return "" + LineType.label(this.type) + "(" + this.type + "): indent [" + this.indent + "] text [" + this.text + (this.arguments == null ? "]" : "] args [" + this.arguments + "]");
    }
}

