/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util.preprocessor;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class LineType {
    public static final int UNKNOWN = 0;
    public static final int DEF = 1;
    public static final int DEFINE = 1;
    public static final int ELIF = 2;
    public static final int ELIFDEF = 3;
    public static final int ELIFNDEF = 4;
    public static final int ELSE = 5;
    public static final int ENDIF = 6;
    public static final int ENDINCLUDE = 7;
    public static final int HIDDEN = 8;
    public static final int IF = 9;
    public static final int IFDEF = 10;
    public static final int IFNDEF = 11;
    public static final int INCLUDE = 12;
    public static final int UNDEF = 13;
    public static final int UNDEFINE = 13;
    public static final int VISIBLE = 14;
    private static Map<String, Integer> directives;
    private static Map<Integer, String> labels;

    public static String label(Integer key) {
        return labels.get(key);
    }

    public static Integer id(String key) {
        return directives.get(key);
    }

    private static void init() {
        directives = new HashMap<String, Integer>(23);
        labels = new HashMap<Integer, String>(23);
        Field[] fields = LineType.class.getDeclaredFields();
        boolean j = false;
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (!field.getType().equals(Integer.TYPE)) continue;
            String label = field.getName();
            try {
                int value = field.getInt(null);
                labels.put(value, label);
                switch (value) {
                    case 8: 
                    case 14: {
                        break;
                    }
                    default: {
                        String key = "//#" + label.toLowerCase(Locale.ENGLISH);
                        directives.put(key, new Integer(value));
                        break;
                    }
                }
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
    }

    private LineType() {
        throw new AssertionError((Object)"Pure Utiluity Class");
    }

    static {
        LineType.init();
    }
}

