/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util.preprocessor;

public class Option {
    public static final int DEFAULT = 0;
    public static final int BACKUP = 1;
    public static final int FILTER = 2;
    public static final int INDENT = 4;
    public static final int TEST_ONLY = 8;
    public static final int VERBOSE = 16;

    private Option() {
    }

    public static boolean isDefault(int options) {
        return options == 0;
    }

    public static int setDefault(int options, boolean _default) {
        return _default ? 0 : options;
    }

    public static boolean isBackup(int options) {
        return (options & 1) != 0;
    }

    public static int setBackup(int options, boolean backup) {
        return backup ? options | 1 : options & 0xFFFFFFFE;
    }

    public static boolean isFilter(int options) {
        return (options & 2) != 0;
    }

    public static int setFilter(int options, boolean filter) {
        return filter ? options | 2 : options & 0xFFFFFFFD;
    }

    public static boolean isIndent(int options) {
        return (options & 4) != 0;
    }

    public static int setIndent(int options, boolean indent) {
        return indent ? options | 4 : options & 0xFFFFFFFB;
    }

    public static boolean isTestOnly(int options) {
        return (options & 8) != 0;
    }

    public static int setTestOnly(int options, boolean testOnly) {
        return testOnly ? options | 8 : options & 0xFFFFFFF7;
    }

    public static boolean isVerbose(int options) {
        return (options & 0x10) != 0;
    }

    public static int setVerbose(int options, boolean verbose) {
        return verbose ? options | 0x10 : options & 0xFFFFFFEF;
    }

    public static String toOptionsString(int options) {
        Object[] values = new Object[]{Option.isBackup(options), Option.isFilter(options), Option.isIndent(options), Option.isTestOnly(options), Option.isVerbose(options)};
        return String.format("backup: %s, filter: %s, indent: %s, testOnly: %s, verbose: %s", values);
    }
}

