/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.junit4.internal.impl.testcaseworkaround;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.internal.runners.MethodValidator;
import org.junit.internal.runners.TestClass;
import org.powermock.reflect.Whitebox;

public class PowerMockJUnit4MethodValidator
extends MethodValidator {
    public PowerMockJUnit4MethodValidator(TestClass testClass) {
        super(testClass);
    }

    public void validateInstanceMethods() {
        this.validateTestMethods(After.class, false);
        this.validateTestMethods(Before.class, false);
        this.validateTestMethods(Test.class, false);
        TestClass testClass = (TestClass)Whitebox.getInternalState((Object)((Object)this), (String)"testClass", MethodValidator.class);
        Class classUnderTest = (Class)Whitebox.getInternalState((Object)testClass, (String)"klass");
        List fErrors = (List)Whitebox.getInternalState((Object)((Object)this), (String)"errors", MethodValidator.class);
        List<Method> methods = this.getTestMethods(testClass, classUnderTest);
        if (methods.size() == 0) {
            fErrors.add(new Exception("No runnable methods"));
        }
    }

    private List<Method> getTestMethods(TestClass testClass, Class<?> classUnderTest) {
        List methods = testClass.getAnnotatedMethods(Test.class);
        if (methods.isEmpty()) {
            methods.addAll(this.getTestMethodsWithNoAnnotation(classUnderTest));
        }
        return methods;
    }

    private void validateTestMethods(Class<? extends Annotation> annotation, boolean isStatic) {
        TestClass testClass = (TestClass)Whitebox.getInternalState((Object)((Object)this), (String)"testClass", MethodValidator.class);
        Class classUnderTest = (Class)Whitebox.getInternalState((Object)testClass, (String)"klass");
        List<Method> methods = TestCase.class.equals(classUnderTest.getSuperclass()) && !isStatic ? this.getTestMethodsWithNoAnnotation(classUnderTest) : testClass.getAnnotatedMethods(annotation);
        List fErrors = (List)Whitebox.getInternalState((Object)((Object)this), (String)"errors", MethodValidator.class);
        for (Method each : methods) {
            if (Modifier.isStatic(each.getModifiers()) != isStatic) {
                String state = isStatic ? "should" : "should not";
                fErrors.add(new Exception("Method " + each.getName() + "() " + state + " be static"));
            }
            if (!Modifier.isPublic(each.getDeclaringClass().getModifiers())) {
                fErrors.add(new Exception("Class " + each.getDeclaringClass().getName() + " should be public"));
            }
            if (!Modifier.isPublic(each.getModifiers())) {
                fErrors.add(new Exception("Method " + each.getName() + " should be public"));
            }
            if (each.getReturnType() != Void.TYPE) {
                fErrors.add(new Exception("Method " + each.getName() + " should be void"));
            }
            if (each.getParameterTypes().length == 0) continue;
            fErrors.add(new Exception("Method " + each.getName() + " should have no parameters"));
        }
    }

    private List<Method> getTestMethodsWithNoAnnotation(Class<?> testClass) {
        Method[] methods;
        LinkedList<Method> potentialTestMethods = new LinkedList<Method>();
        for (Method method : methods = testClass.getMethods()) {
            if (!method.getName().startsWith("test")) continue;
            potentialTestMethods.add(method);
        }
        return potentialTestMethods;
    }
}

