/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.fabric.netty.handlers;

import com.liferay.portal.fabric.agent.FabricAgentRegistry;
import com.liferay.portal.fabric.netty.agent.NettyFabricAgentConfig;
import com.liferay.portal.fabric.netty.agent.NettyFabricAgentStub;
import com.liferay.portal.fabric.netty.fileserver.handlers.FileResponseChannelHandler;
import com.liferay.portal.fabric.netty.handlers.NettyChannelAttributes;
import com.liferay.portal.fabric.netty.repository.NettyRepository;
import com.liferay.portal.fabric.repository.Repository;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class NettyFabricAgentRegistrationChannelHandler
extends SimpleChannelInboundHandler<NettyFabricAgentConfig> {
    private static final Log _log = LogFactoryUtil.getLog(NettyFabricAgentRegistrationChannelHandler.class);
    private final EventExecutorGroup _eventExecutorGroup;
    private final FabricAgentRegistry _fabricAgentRegistry;
    private final long _getFileTimeout;
    private final Path _repositoryParentPath;
    private final long _rpcRelayTimeout;
    private final long _startupTimeout;

    public NettyFabricAgentRegistrationChannelHandler(FabricAgentRegistry fabricAgentRegistry, Path repositoryParentPath, EventExecutorGroup eventExecutorGroup, long getFileTimeout, long rpcRelayTimeout, long startupTimeout) {
        if (fabricAgentRegistry == null) {
            throw new NullPointerException("Fabric agent registry is null");
        }
        if (repositoryParentPath == null) {
            throw new NullPointerException("Repository parent path is null");
        }
        if (eventExecutorGroup == null) {
            throw new NullPointerException("Event executor group is null");
        }
        this._fabricAgentRegistry = fabricAgentRegistry;
        this._repositoryParentPath = repositoryParentPath;
        this._eventExecutorGroup = eventExecutorGroup;
        this._getFileTimeout = getFileTimeout;
        this._rpcRelayTimeout = rpcRelayTimeout;
        this._startupTimeout = startupTimeout;
    }

    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        final Channel channel = channelHandlerContext.channel();
        _log.error((Object)("Closing " + channel + " due to:"), throwable);
        ChannelFuture channelFuture = channel.close();
        channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture channelFuture) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)(channel + " is closed"));
                }
            }
        });
    }

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, NettyFabricAgentConfig nettyFabricAgentConfig) throws IOException {
        Channel channel = channelHandlerContext.channel();
        String socketAddressString = String.valueOf(channel.localAddress());
        Path repositoryPath = Paths.get(this._repositoryParentPath.toString(), StringUtil.replace((String)socketAddressString, (char)':', (char)'-'));
        Files.createDirectories(repositoryPath, new FileAttribute[0]);
        NettyRepository repository = new NettyRepository(repositoryPath, this._getFileTimeout);
        ChannelPipeline channelPipeline = channel.pipeline();
        channelPipeline.addLast(new ChannelHandler[]{new FileResponseChannelHandler(repository.getAsyncBroker(), this._eventExecutorGroup)});
        NettyFabricAgentStub nettyFabricAgentStub = new NettyFabricAgentStub(channel, repository, nettyFabricAgentConfig.getRepositoryPath(), this._rpcRelayTimeout, this._startupTimeout);
        if (!this._fabricAgentRegistry.registerFabricAgent(nettyFabricAgentStub, new OnRegistration(channel, nettyFabricAgentStub, repository))) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Rejected duplicated fabric agent on " + channel));
            }
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Registered fabric agent on " + channel));
        }
    }

    protected class PostDisconnectChannelFutureListener
    implements ChannelFutureListener {
        private final Channel _channel;
        private final NettyFabricAgentStub _nettyFabricAgentStub;
        private final Repository<Channel> _repository;

        public PostDisconnectChannelFutureListener(Channel channel, NettyFabricAgentStub nettyFabricAgentStub, Repository<Channel> repository) {
            this._channel = channel;
            this._nettyFabricAgentStub = nettyFabricAgentStub;
            this._repository = repository;
        }

        public void operationComplete(ChannelFuture channelFuture) {
            if (NettyFabricAgentRegistrationChannelHandler.this._fabricAgentRegistry.unregisterFabricAgent(this._nettyFabricAgentStub, null)) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Unregistered fabric agent on " + this._channel));
                }
            } else if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to unregister fabric agent on " + this._channel));
            }
            this._repository.dispose(true);
        }
    }

    protected class OnRegistration
    implements Runnable {
        private final Channel _channel;
        private final NettyFabricAgentStub _nettyFabricAgentStub;
        private final Repository<Channel> _repository;

        public OnRegistration(Channel channel, NettyFabricAgentStub nettyFabricAgentStub, Repository<Channel> repository) {
            this._channel = channel;
            this._nettyFabricAgentStub = nettyFabricAgentStub;
            this._repository = repository;
        }

        @Override
        public void run() {
            NettyChannelAttributes.setNettyFabricAgentStub(this._channel, this._nettyFabricAgentStub);
            ChannelFuture channelFuture = this._channel.closeFuture();
            channelFuture.addListener((GenericFutureListener)new PostDisconnectChannelFutureListener(this._channel, this._nettyFabricAgentStub, this._repository));
        }
    }
}

