/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pwd;

import com.liferay.portal.kernel.exception.PwdEncryptorException;
import com.liferay.portal.kernel.security.SecureRandom;
import com.liferay.portal.kernel.security.pwd.PasswordEncryptor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.pwd.BasePasswordEncryptor;
import java.io.UnsupportedEncodingException;
import org.vps.crypt.Crypt;

public class CryptPasswordEncryptor
extends BasePasswordEncryptor
implements PasswordEncryptor {
    private static final String[] _SALT = ArrayUtil.toStringArray((char[])"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789./".toCharArray());

    public String encrypt(String algorithm, String plainTextPassword, String encryptedPassword) throws PwdEncryptorException {
        byte[] saltBytes = this.getSalt(encryptedPassword);
        try {
            return Crypt.crypt((byte[])saltBytes, (byte[])plainTextPassword.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new PwdEncryptorException(unsupportedEncodingException.getMessage(), (Throwable)unsupportedEncodingException);
        }
    }

    public String[] getSupportedAlgorithmTypes() {
        return new String[]{"UFC-CRYPT", "UFC-CRYPT"};
    }

    protected byte[] getSalt(String encryptedPassword) throws PwdEncryptorException {
        byte[] saltBytes = null;
        try {
            if (Validator.isNull((String)encryptedPassword)) {
                SecureRandom random = new SecureRandom();
                int x = random.nextInt(Integer.MAX_VALUE) % _SALT.length;
                int y = random.nextInt(Integer.MAX_VALUE) % _SALT.length;
                String salt = _SALT[x].concat(_SALT[y]);
                saltBytes = salt.getBytes("UTF-8");
            } else {
                String salt = encryptedPassword.substring(0, 2);
                saltBytes = salt.getBytes("UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new PwdEncryptorException("Unable to extract salt from encrypted password " + unsupportedEncodingException.getMessage(), (Throwable)unsupportedEncodingException);
        }
        return saltBytes;
    }
}

