/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.MembershipRequest;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.MembershipRequestServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;

public class MembershipRequestServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(MembershipRequestServiceHttp.class);
    private static final Class<?>[] _addMembershipRequestParameterTypes0 = new Class[]{Long.TYPE, String.class, ServiceContext.class};
    private static final Class<?>[] _deleteMembershipRequestsParameterTypes1 = new Class[]{Long.TYPE, Long.TYPE};
    private static final Class<?>[] _getMembershipRequestParameterTypes2 = new Class[]{Long.TYPE};
    private static final Class<?>[] _updateStatusParameterTypes3 = new Class[]{Long.TYPE, String.class, Long.TYPE, ServiceContext.class};

    public static MembershipRequest addMembershipRequest(HttpPrincipal httpPrincipal, long groupId, String comments, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(MembershipRequestServiceUtil.class, "addMembershipRequest", (Class[])_addMembershipRequestParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, comments, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (MembershipRequest)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void deleteMembershipRequests(HttpPrincipal httpPrincipal, long groupId, long statusId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(MembershipRequestServiceUtil.class, "deleteMembershipRequests", (Class[])_deleteMembershipRequestsParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, statusId});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static MembershipRequest getMembershipRequest(HttpPrincipal httpPrincipal, long membershipRequestId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(MembershipRequestServiceUtil.class, "getMembershipRequest", (Class[])_getMembershipRequestParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{membershipRequestId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (MembershipRequest)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void updateStatus(HttpPrincipal httpPrincipal, long membershipRequestId, String reviewComments, long statusId, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(MembershipRequestServiceUtil.class, "updateStatus", (Class[])_updateStatusParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{membershipRequestId, reviewComments, statusId, serviceContext});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }
}

