/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.PortletItem;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.PortletItemLocalService;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.service.base.PortletPreferencesServiceBaseImpl;
import java.io.IOException;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;

public class PortletPreferencesServiceImpl
extends PortletPreferencesServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(PortletPreferencesServiceImpl.class);
    @BeanReference(type=PortletItemLocalService.class)
    private PortletItemLocalService _portletItemLocalService;

    public void deleteArchivedPreferences(long portletItemId) throws PortalException {
        PortletItem portletItem = this._portletItemLocalService.getPortletItem(portletItemId);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)portletItem.getGroupId(), (String)"MANAGE_ARCHIVED_SETUPS");
        long ownerId = portletItemId;
        int ownerType = 5;
        long plid = 0L;
        this.portletPreferencesLocalService.deletePortletPreferences(ownerId, ownerType, plid, portletItem.getPortletId());
        this._portletItemLocalService.deletePortletItem(portletItemId);
    }

    public void restoreArchivedPreferences(long groupId, Layout layout, String portletId, long portletItemId, PortletPreferences jxPortletPreferences) throws PortalException {
        this.restoreArchivedPreferences(groupId, layout, portletId, this._portletItemLocalService.getPortletItem(portletItemId), jxPortletPreferences);
    }

    public void restoreArchivedPreferences(long groupId, Layout layout, String portletId, PortletItem portletItem, PortletPreferences jxPortletPreferences) throws PortalException {
        PortletPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (Layout)layout, (String)portletId, (String)"CONFIGURATION");
        long ownerId = portletItem.getPortletItemId();
        int ownerType = 5;
        long plid = 0L;
        PortletPreferences archivedJxPortletPreferences = this.portletPreferencesLocalService.getPreferences(portletItem.getCompanyId(), ownerId, ownerType, plid, PortletIdCodec.decodePortletName((String)portletId));
        this.copyPreferences(archivedJxPortletPreferences, jxPortletPreferences);
    }

    public void restoreArchivedPreferences(long groupId, String name, Layout layout, String portletId, PortletPreferences jxPortletPreferences) throws PortalException {
        PortletItem portletItem = this._portletItemLocalService.getPortletItem(groupId, name, portletId, com.liferay.portal.kernel.model.PortletPreferences.class.getName());
        this.restoreArchivedPreferences(groupId, layout, portletId, portletItem, jxPortletPreferences);
    }

    public void updateArchivePreferences(long userId, long groupId, String name, String portletId, PortletPreferences jxPortletPreferences) throws PortalException {
        PortletPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)0L, (String)portletId, (String)"CONFIGURATION");
        PortletItem portletItem = this._portletItemLocalService.updatePortletItem(userId, groupId, name, portletId, com.liferay.portal.kernel.model.PortletPreferences.class.getName());
        long ownerId = portletItem.getPortletItemId();
        int ownerType = 5;
        long plid = 0L;
        PortletPreferences archivedJxPortletPreferences = this.portletPreferencesLocalService.getPreferences(portletItem.getCompanyId(), ownerId, ownerType, plid, portletId);
        this.copyPreferences(jxPortletPreferences, archivedJxPortletPreferences);
    }

    protected void copyPreferences(PortletPreferences sourceJxPortletPreferences, PortletPreferences targetJxPortletPreferences) {
        try {
            Map targetJxPortletPreferencesMap = targetJxPortletPreferences.getMap();
            for (String key : targetJxPortletPreferencesMap.keySet()) {
                try {
                    targetJxPortletPreferences.reset(key);
                }
                catch (ReadOnlyException readOnlyException) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)readOnlyException, (Throwable)readOnlyException);
                }
            }
            Map sourceJxPortletPreferencesMap = sourceJxPortletPreferences.getMap();
            for (String key : sourceJxPortletPreferencesMap.keySet()) {
                try {
                    targetJxPortletPreferences.setValues(key, sourceJxPortletPreferences.getValues(key, new String[0]));
                }
                catch (ReadOnlyException readOnlyException) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)readOnlyException, (Throwable)readOnlyException);
                }
            }
            targetJxPortletPreferences.store();
        }
        catch (IOException ioException) {
            _log.error((Object)"Unable to copy jxPortletPreferences", (Throwable)ioException);
        }
        catch (ValidatorException validatorException) {
            throw new SystemException((Throwable)validatorException);
        }
    }
}

