/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.DuplicateTeamException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.TeamNameException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.persistence.GroupPersistence;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.base.TeamLocalServiceBaseImpl;
import java.util.LinkedHashMap;
import java.util.List;

public class TeamLocalServiceImpl
extends TeamLocalServiceBaseImpl {
    @BeanReference(type=GroupLocalService.class)
    private GroupLocalService _groupLocalService;
    @BeanReference(type=GroupPersistence.class)
    private GroupPersistence _groupPersistence;
    @BeanReference(type=ResourceLocalService.class)
    private ResourceLocalService _resourceLocalService;
    @BeanReference(type=RoleLocalService.class)
    private RoleLocalService _roleLocalService;
    @BeanReference(type=UserPersistence.class)
    private UserPersistence _userPersistence;

    public Team addTeam(long userId, long groupId, String name, String description, ServiceContext serviceContext) throws PortalException {
        User user = this._userPersistence.findByPrimaryKey(userId);
        this.validate(0L, groupId, name);
        long teamId = this.counterLocalService.increment();
        Team team = this.teamPersistence.create(teamId);
        team.setUuid(serviceContext.getUuid());
        team.setCompanyId(user.getCompanyId());
        team.setUserId(userId);
        team.setUserName(user.getFullName());
        team.setGroupId(groupId);
        team.setName(name);
        team.setDescription(description);
        team = (Team)this.teamPersistence.update((BaseModel)team);
        this._resourceLocalService.addResources(user.getCompanyId(), groupId, userId, Team.class.getName(), team.getTeamId(), false, true, true);
        this._roleLocalService.addRole(userId, Team.class.getName(), teamId, String.valueOf(teamId), null, null, 4, null, null);
        return team;
    }

    @Override
    public Team deleteTeam(long teamId) throws PortalException {
        Team team = this.teamPersistence.findByPrimaryKey(teamId);
        return this.deleteTeam(team);
    }

    @Override
    @SystemEvent(type=1)
    public Team deleteTeam(Team team) throws PortalException {
        this.teamPersistence.remove((BaseModel)team);
        this._resourceLocalService.deleteResource(team.getCompanyId(), Team.class.getName(), 4, team.getTeamId());
        List groups = this._groupPersistence.findByC_S(team.getCompanyId(), true);
        for (Group group : groups) {
            UnicodeProperties typeSettingsUnicodeUnicodeProperties = group.getTypeSettingsProperties();
            List defaultTeamIds = ListUtil.fromArray((long[])StringUtil.split((String)typeSettingsUnicodeUnicodeProperties.getProperty("defaultTeamIds"), (long)0L));
            if (!defaultTeamIds.contains(team.getTeamId())) continue;
            defaultTeamIds.remove(team.getTeamId());
            typeSettingsUnicodeUnicodeProperties.setProperty("defaultTeamIds", ListUtil.toString((List)defaultTeamIds, (String)""));
            this._groupLocalService.updateGroup(group.getGroupId(), typeSettingsUnicodeUnicodeProperties.toString());
        }
        this._roleLocalService.deleteRole(team.getRole());
        return team;
    }

    public void deleteTeams(long groupId) throws PortalException {
        List teams = this.teamPersistence.findByGroupId(groupId);
        for (Team team : teams) {
            this.deleteTeam(team.getTeamId());
        }
    }

    public Team fetchTeam(long groupId, String name) {
        return this.teamPersistence.fetchByG_N(groupId, name);
    }

    public List<Team> getGroupTeams(long groupId) {
        return this.teamPersistence.findByGroupId(groupId);
    }

    public int getGroupTeamsCount(long groupId) {
        return this.teamPersistence.countByGroupId(groupId);
    }

    public Team getTeam(long groupId, String name) throws PortalException {
        return this.teamPersistence.findByG_N(groupId, name);
    }

    public List<Team> getUserOrUserGroupTeams(long groupId, long userId) {
        return this.teamFinder.findByG_U(groupId, userId, -1, -1, null);
    }

    public List<Team> getUserTeams(long userId, long groupId) {
        return this.search(groupId, null, null, LinkedHashMapBuilder.put((Object)"usersTeams", (Object)userId).build(), -1, -1, null);
    }

    public List<Team> search(long groupId, String name, String description, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<Team> orderByComparator) {
        return this.teamFinder.findByG_N_D(groupId, name, description, params, start, end, orderByComparator);
    }

    public int searchCount(long groupId, String name, String description, LinkedHashMap<String, Object> params) {
        return this.teamFinder.countByG_N_D(groupId, name, description, params);
    }

    public Team updateTeam(long teamId, String name, String description) throws PortalException {
        Team team = this.teamPersistence.findByPrimaryKey(teamId);
        this.validate(teamId, team.getGroupId(), name);
        team.setName(name);
        team.setDescription(description);
        return (Team)this.teamPersistence.update((BaseModel)team);
    }

    protected void validate(long teamId, long groupId, String name) throws PortalException {
        if (Validator.isNull((String)name) || Validator.isNumber((String)name) || name.indexOf(44) != -1 || name.indexOf(42) != -1) {
            throw new TeamNameException();
        }
        Team team = this.teamPersistence.fetchByG_N(groupId, name);
        if (team != null && team.getTeamId() != teamId) {
            throw new DuplicateTeamException("{teamId=" + teamId + "}");
        }
    }
}

