/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.words;

import com.liferay.portal.kernel.jazzy.InvalidWord;
import com.swabunga.spell.engine.Word;
import com.swabunga.spell.event.SpellCheckEvent;
import com.swabunga.spell.event.SpellCheckListener;
import java.util.ArrayList;
import java.util.List;

public class BasicSpellCheckListener
implements SpellCheckListener {
    private final List<InvalidWord> _invalidWords = new ArrayList<InvalidWord>();
    private final String _text;
    private final char[] _textCharArray;

    public BasicSpellCheckListener(String text) {
        this._text = text;
        this._textCharArray = text.toCharArray();
    }

    public List<InvalidWord> getInvalidWords() {
        return this._invalidWords;
    }

    public void spellingError(SpellCheckEvent event) {
        ArrayList<String> suggestions = new ArrayList<String>();
        for (Word word : event.getSuggestions()) {
            suggestions.add(word.getWord());
        }
        int pos = event.getWordContextPosition();
        if (pos >= 0) {
            String invalidWord = event.getInvalidWord();
            if (pos == 0 || pos > 0 && !this._isInsideHtmlTag(pos) && this._text.charAt(pos - 1) != '&' && invalidWord.length() > 1) {
                this._invalidWords.add(new InvalidWord(invalidWord, suggestions, event.getWordContext(), pos));
            }
        }
    }

    private boolean _isInsideHtmlTag(int pos) {
        int i;
        boolean insideHtmlTag = false;
        for (i = pos; i >= 0; --i) {
            if (this._textCharArray[i] == '<') {
                insideHtmlTag = true;
                break;
            }
            if (this._textCharArray[i] == '>') break;
        }
        if (insideHtmlTag) {
            for (i = pos; i < this._textCharArray.length; ++i) {
                if (this._textCharArray[i] == '<') {
                    insideHtmlTag = false;
                    break;
                }
                if (this._textCharArray[i] == '>') break;
            }
        }
        return insideHtmlTag;
    }
}

