/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.xuggler;

import com.liferay.petra.log4j.Log4JUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xuggler.Xuggler;
import com.liferay.portal.kernel.xuggler.XugglerInstallException;
import com.liferay.portal.util.JarUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.xuggle.ferry.JNILibraryLoader;
import com.xuggle.xuggler.IContainer;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Map;

@Deprecated
public class XugglerImpl
implements Xuggler {
    private static final Log _log = LogFactoryUtil.getLog(XugglerImpl.class);
    private static boolean _informAdministrator = true;
    private static boolean _nativeLibraryCopied;
    private static boolean _nativeLibraryInstalled;

    public void installNativeLibraries(String name) throws Exception {
        try {
            JarUtil.downloadAndInstallJar(new URL(PropsValues.XUGGLER_JAR_URL + name), Paths.get(PropsValues.LIFERAY_LIB_PORTAL_DIR, name));
            _nativeLibraryCopied = true;
        }
        catch (Exception exception) {
            throw new XugglerInstallException.MustInstallJar(name, (Throwable)exception);
        }
    }

    public boolean isEnabled() {
        return this.isEnabled(true);
    }

    public boolean isEnabled(boolean checkNativeLibraries) {
        boolean enabled;
        block4: {
            enabled = false;
            try {
                enabled = PrefsPropsUtil.getBoolean("xuggler.enabled", PropsValues.XUGGLER_ENABLED);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)exception, (Throwable)exception);
            }
        }
        if (!checkNativeLibraries) {
            return enabled;
        }
        if (enabled) {
            return this.isNativeLibraryInstalled();
        }
        return false;
    }

    public boolean isNativeLibraryCopied() {
        return _nativeLibraryCopied;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNativeLibraryInstalled() {
        if (_nativeLibraryInstalled) {
            return _nativeLibraryInstalled;
        }
        Map priorities = Log4JUtil.getPriorities();
        String priority = (String)priorities.get(JNILibraryLoader.class.getName());
        if (Validator.isNull((String)priority)) {
            priority = "ALL";
        }
        try {
            Log4JUtil.setLevel((String)JNILibraryLoader.class.getName(), (String)"OFF", (boolean)false);
            IContainer.make();
            _nativeLibraryInstalled = true;
        }
        catch (NoClassDefFoundError ncdfe) {
            this.informAdministrator(ncdfe.getMessage());
        }
        catch (UnsatisfiedLinkError ule) {
            this.informAdministrator(ule.getMessage());
        }
        finally {
            Log4JUtil.setLevel((String)JNILibraryLoader.class.getName(), (String)priority, (boolean)false);
        }
        return _nativeLibraryInstalled;
    }

    protected void informAdministrator(String errorMessage) {
        if (!_informAdministrator || !_log.isWarnEnabled()) {
            return;
        }
        _informAdministrator = false;
        _log.warn((Object)StringBundler.concat((String[])new String[]{"Liferay does not have the Xuggler native libraries ", "installed. In order to generate video and audio previews, ", "please follow the instructions for Xuggler in the Server ", "Administration section of the Control Panel at: ", "http://<server>/group/control_panel/manage/-/server", "/external-services. Warning: ", errorMessage}));
    }
}

