/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.persistence.impl;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.service.persistence.DLFileEntryFinder;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.dao.orm.WildcardMode;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.documentlibrary.model.impl.DLFileEntryImpl;
import com.liferay.portlet.documentlibrary.service.persistence.impl.DLFileEntryFinderBaseImpl;
import com.liferay.portlet.documentlibrary.service.persistence.impl.DLFolderFinderImpl;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DLFileEntryFinderImpl
extends DLFileEntryFinderBaseImpl
implements DLFileEntryFinder {
    public static final String COUNT_BY_EXTRA_SETTINGS = DLFileEntryFinder.class.getName() + ".countByExtraSettings";
    public static final String COUNT_BY_G_F = DLFileEntryFinder.class.getName() + ".countByG_F";
    public static final String COUNT_BY_G_M_R = DLFileEntryFinder.class.getName() + ".countByG_M_R";
    public static final String COUNT_BY_G_U_F = DLFileEntryFinder.class.getName() + ".countByG_U_F";
    public static final String COUNT_BY_G_F_S = DLFileEntryFinder.class.getName() + ".countByG_F_S";
    public static final String FIND_BY_COMPANY_ID = DLFileEntryFinder.class.getName() + ".findByCompanyId";
    public static final String FIND_BY_DDM_STRUCTURE_IDS = DLFileEntryFinder.class.getName() + ".findByDDMStructureIds";
    public static final String FIND_BY_NO_ASSETS = DLFileEntryFinder.class.getName() + ".findByNoAssets";
    public static final String FIND_BY_EXTRA_SETTINGS = DLFileEntryFinder.class.getName() + ".findByExtraSettings";
    public static final String FIND_BY_ORPHANED_FILE_ENTRIES = DLFileEntryFinder.class.getName() + ".findByOrphanedFileEntries";
    public static final String FIND_BY_G_F = DLFileEntryFinder.class.getName() + ".findByG_F";
    public static final String FIND_BY_C_T = DLFileEntryFinder.class.getName() + ".findByC_T";
    public static final String FIND_BY_G_U_F = DLFileEntryFinder.class.getName() + ".findByG_U_F";

    public int countByExtraSettings() {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_EXTRA_SETTINGS);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            Iterator iterator = sqlQuery.iterate();
            if (iterator.hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByG_F(long groupId, List<Long> folderIds, QueryDefinition<DLFileEntry> queryDefinition) {
        return this.doCountByG_F(groupId, folderIds, queryDefinition, false);
    }

    public int countByG_R_F(long groupId, List<Long> repositoryIds, List<Long> folderIds, QueryDefinition<DLFileEntry> queryDefinition) {
        return this.doCountByG_U_R_F_M(groupId, 0L, repositoryIds, folderIds, null, queryDefinition, false);
    }

    public int countByG_U_F_M(long groupId, long userId, List<Long> folderIds, String[] mimeTypes, QueryDefinition<DLFileEntry> queryDefinition) {
        List<Long> repositoryIds = Collections.emptyList();
        return this.doCountByG_U_R_F_M(groupId, userId, repositoryIds, folderIds, mimeTypes, queryDefinition, false);
    }

    public int countByG_U_R_F_M(long groupId, long userId, List<Long> repositoryIds, List<Long> folderIds, String[] mimeTypes, QueryDefinition<DLFileEntry> queryDefinition) {
        return this.doCountByG_U_R_F_M(groupId, userId, repositoryIds, folderIds, mimeTypes, queryDefinition, false);
    }

    public int filterCountByG_F(long groupId, List<Long> folderIds, QueryDefinition<DLFileEntry> queryDefinition) {
        return this.doCountByG_F(groupId, folderIds, queryDefinition, true);
    }

    public int filterCountByG_R_F(long groupId, List<Long> repositoryIds, List<Long> folderIds, QueryDefinition<DLFileEntry> queryDefinition) {
        return this.doCountByG_U_R_F_M(groupId, 0L, repositoryIds, folderIds, null, queryDefinition, true);
    }

    public int filterCountByG_U_F_M(long groupId, long userId, List<Long> folderIds, String[] mimeTypes, QueryDefinition<DLFileEntry> queryDefinition) {
        List<Long> repositoryIds = Collections.emptyList();
        return this.doCountByG_U_R_F_M(groupId, userId, repositoryIds, folderIds, mimeTypes, queryDefinition, true);
    }

    public int filterCountByG_U_R_F_M(long groupId, long userId, List<Long> repositoryIds, List<Long> folderIds, String[] mimeTypes, QueryDefinition<DLFileEntry> queryDefinition) {
        return this.doCountByG_U_R_F_M(groupId, userId, repositoryIds, folderIds, mimeTypes, queryDefinition, true);
    }

    public List<DLFileEntry> filterFindByG_F(long groupId, List<Long> folderIds, QueryDefinition<DLFileEntry> queryDefinition) {
        List<Long> repositoryIds = Collections.emptyList();
        return this.doFindByG_U_R_F_M(groupId, 0L, repositoryIds, folderIds, null, queryDefinition, true);
    }

    public List<DLFileEntry> filterFindByG_R_F(long groupId, List<Long> repositoryIds, List<Long> folderIds, QueryDefinition<DLFileEntry> queryDefinition) {
        return this.doFindByG_U_R_F_M(groupId, 0L, repositoryIds, folderIds, null, queryDefinition, true);
    }

    public List<DLFileEntry> filterFindByG_U_F_M(long groupId, long userId, List<Long> folderIds, String[] mimeTypes, QueryDefinition<DLFileEntry> queryDefinition) {
        List<Long> repositoryIds = Collections.emptyList();
        return this.doFindByG_U_R_F_M(groupId, userId, repositoryIds, folderIds, mimeTypes, queryDefinition, true);
    }

    public List<DLFileEntry> filterFindByG_U_R_F_M(long groupId, long userId, List<Long> repositoryIds, List<Long> folderIds, String[] mimeTypes, QueryDefinition<DLFileEntry> queryDefinition) {
        return this.doFindByG_U_R_F_M(groupId, userId, repositoryIds, folderIds, mimeTypes, queryDefinition, true);
    }

    public List<DLFileEntry> findByCompanyId(long companyId, QueryDefinition<DLFileEntry> queryDefinition) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_COMPANY_ID, queryDefinition, (String)"DLFileVersion");
            sql = CustomSQLUtil.replaceOrderBy((String)sql, (OrderByComparator)queryDefinition.getOrderByComparator());
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("DLFileEntry", DLFileEntryImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            queryPos.add(queryDefinition.getStatus());
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd());
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<DLFileEntry> findByDDMStructureIds(long groupId, long[] ddmStructureIds, int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            if (ddmStructureIds == null || ddmStructureIds.length <= 0) {
                List<DLFileEntry> list = Collections.emptyList();
                return list;
            }
            String sql = CustomSQLUtil.get((String)FIND_BY_DDM_STRUCTURE_IDS);
            if (groupId <= 0L) {
                sql = StringUtil.removeSubstring((String)sql, (String)"(DLFileEntry.groupId = ?) AND");
            }
            sql = StringUtil.replace((String)sql, (String)"[$DDM_STRUCTURE_ID$]", (String)this.getDDMStructureIds(ddmStructureIds));
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("DLFileEntry", DLFileEntryImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            if (groupId > 0L) {
                queryPos.add(groupId);
            }
            queryPos.add(ddmStructureIds);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<DLFileEntry> findByDDMStructureIds(long[] ddmStructureIds, int start, int end) {
        return this.findByDDMStructureIds(0L, ddmStructureIds, start, end);
    }

    public List<DLFileEntry> findByNoAssets() {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_NO_ASSETS);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("DLFileEntry", DLFileEntryImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(PortalUtil.getClassNameId((String)DLFileEntryConstants.getClassName()));
            List list = sqlQuery.list(true);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<DLFileEntry> findByExtraSettings(int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_EXTRA_SETTINGS);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("fileEntryId", Type.LONG);
            List fileEntryIds = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            ArrayList<DLFileEntry> dlFileEntries = new ArrayList<DLFileEntry>(fileEntryIds.size());
            Object object = fileEntryIds.iterator();
            while (object.hasNext()) {
                long fileEntryId = (Long)object.next();
                dlFileEntries.add(this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId));
            }
            object = Collections.unmodifiableList(dlFileEntries);
            return object;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<DLFileEntry> findByOrphanedFileEntries() {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_ORPHANED_FILE_ENTRIES);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("DLFileEntry", DLFileEntryImpl.class);
            List list = sqlQuery.list(true);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<DLFileEntry> findByG_F(long groupId, List<Long> folderIds, QueryDefinition<DLFileEntry> queryDefinition) {
        List<Long> repositoryIds = Collections.emptyList();
        return this.doFindByG_U_R_F_M(groupId, 0L, repositoryIds, folderIds, null, queryDefinition, false);
    }

    public List<DLFileEntry> findByC_T(long classNameId, String treePath) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_C_T);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(CustomSQLUtil.keywords((String)treePath, (WildcardMode)WildcardMode.TRAILING)[0]);
            queryPos.add(classNameId);
            sqlQuery.addEntity("DLFileEntry", DLFileEntryImpl.class);
            List list = sqlQuery.list(true);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<DLFileEntry> findByG_R_F(long groupId, List<Long> repositoryIds, List<Long> folderIds, QueryDefinition<DLFileEntry> queryDefinition) {
        return this.doFindByG_U_R_F_M(groupId, 0L, repositoryIds, folderIds, null, queryDefinition, false);
    }

    public List<DLFileEntry> findByG_U_F(long groupId, long userId, List<Long> folderIds, QueryDefinition<DLFileEntry> queryDefinition) {
        List<Long> repositoryIds = Collections.emptyList();
        return this.doFindByG_U_R_F_M(groupId, userId, repositoryIds, folderIds, null, queryDefinition, false);
    }

    public List<DLFileEntry> findByG_U_F_M(long groupId, long userId, List<Long> folderIds, String[] mimeTypes, QueryDefinition<DLFileEntry> queryDefinition) {
        List<Long> repositoryIds = Collections.emptyList();
        return this.doFindByG_U_R_F_M(groupId, userId, repositoryIds, folderIds, mimeTypes, queryDefinition, false);
    }

    public List<DLFileEntry> findByG_U_R_F(long groupId, long userId, List<Long> repositoryIds, List<Long> folderIds, QueryDefinition<DLFileEntry> queryDefinition) {
        return this.doFindByG_U_R_F_M(groupId, userId, repositoryIds, folderIds, null, queryDefinition, false);
    }

    public List<DLFileEntry> findByG_U_R_F_M(long groupId, long userId, List<Long> repositoryIds, List<Long> folderIds, String[] mimeTypes, QueryDefinition<DLFileEntry> queryDefinition) {
        return this.doFindByG_U_R_F_M(groupId, userId, repositoryIds, folderIds, mimeTypes, queryDefinition, false);
    }

    protected int doCountByG_F(long groupId, List<Long> folderIds, QueryDefinition<DLFileEntry> queryDefinition, boolean inlineSQLHelper) {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            List<Long> repositoryIds = Collections.emptyList();
            String sql = this.getFileEntriesSQL(COUNT_BY_G_F_S, groupId, repositoryIds, folderIds, null, queryDefinition, inlineSQLHelper);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(queryDefinition.getStatus());
            Iterator iterator = sqlQuery.iterate();
            if (iterator.hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected int doCountByG_U_R_F_M(long groupId, long userId, List<Long> repositoryIds, List<Long> folderIds, String[] mimeTypes, QueryDefinition<DLFileEntry> queryDefinition, boolean inlineSQLHelper) {
        Session session = null;
        try {
            Long count;
            Iterator iterator;
            session = this.openSession();
            String id = null;
            id = userId <= 0L ? COUNT_BY_G_F : COUNT_BY_G_U_F;
            String sql = this.getFileEntriesSQL(id, groupId, repositoryIds, folderIds, mimeTypes, queryDefinition, inlineSQLHelper);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            if (userId > 0L) {
                queryPos.add(userId);
                queryPos.add(userId);
            }
            queryPos.add(queryDefinition.getStatus());
            for (Long repositoryId : repositoryIds) {
                queryPos.add(repositoryId);
            }
            if (mimeTypes != null) {
                queryPos.add(mimeTypes);
            }
            if ((iterator = sqlQuery.iterate()).hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<DLFileEntry> doFindByG_U_R_F_M(long groupId, long userId, List<Long> repositoryIds, List<Long> folderIds, String[] mimeTypes, QueryDefinition<DLFileEntry> queryDefinition, boolean inlineSQLHelper) {
        Session session = null;
        try {
            session = this.openSession();
            String id = null;
            id = userId <= 0L ? FIND_BY_G_F : FIND_BY_G_U_F;
            String sql = this.getFileEntriesSQL(id, groupId, repositoryIds, folderIds, mimeTypes, queryDefinition, inlineSQLHelper);
            sql = CustomSQLUtil.replaceOrderBy((String)sql, (OrderByComparator)queryDefinition.getOrderByComparator());
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("DLFileEntry", DLFileEntryImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            if (userId > 0L) {
                queryPos.add(userId);
                queryPos.add(userId);
            }
            queryPos.add(queryDefinition.getStatus());
            for (Long repositoryId : repositoryIds) {
                queryPos.add(repositoryId);
            }
            if (mimeTypes != null) {
                queryPos.add(mimeTypes);
            }
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd());
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getDDMStructureIds(long[] ddmStructureIds) {
        StringBundler sb = new StringBundler(ddmStructureIds.length * 2 - 1 + 2);
        sb.append("(");
        for (int i = 0; i < ddmStructureIds.length; ++i) {
            sb.append("DDMStructureLink.structureId = ?");
            if (i + 1 == ddmStructureIds.length) continue;
            sb.append(" OR ");
        }
        sb.append(")");
        return sb.toString();
    }

    protected String getFileEntriesSQL(String id, long groupId, List<Long> repositoryIds, List<Long> folderIds, String[] mimeTypes, QueryDefinition<DLFileEntry> queryDefinition, boolean inlineSQLHelper) {
        String tableName = "DLFileVersion";
        String sql = CustomSQLUtil.get((String)id, queryDefinition, (String)tableName);
        if (queryDefinition.getStatus() == -1) {
            sql = StringUtil.removeSubstring((String)sql, (String)"[$JOIN$]");
            tableName = "DLFileEntry";
        } else {
            sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)CustomSQLUtil.get((String)DLFolderFinderImpl.JOIN_FE_BY_DL_FILE_VERSION));
        }
        if (inlineSQLHelper && InlineSQLHelperUtil.isEnabled()) {
            sql = queryDefinition.getStatus() == -1 ? InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)DLFileEntry.class.getName(), (String)"DLFileEntry.fileEntryId", (long)groupId) : InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)DLFileEntry.class.getName(), (String)"DLFileVersion.fileEntryId", (long)groupId);
        }
        if (ListUtil.isNotEmpty(repositoryIds) || ListUtil.isNotEmpty(folderIds) || ArrayUtil.isNotEmpty((Object[])mimeTypes)) {
            StringBundler sb = new StringBundler(12);
            if (ListUtil.isNotEmpty(repositoryIds)) {
                sb.append(" AND ");
                sb.append("(");
                sb.append(this.getRepositoryIds(repositoryIds, tableName));
                sb.append(")");
            }
            if (ListUtil.isNotEmpty(folderIds)) {
                sb.append(" AND ");
                sb.append("(");
                sb.append(this.getFolderIds(folderIds, tableName));
                sb.append(")");
            }
            if (ArrayUtil.isNotEmpty((Object[])mimeTypes)) {
                sb.append(" AND ");
                sb.append("(");
                sb.append(this.getMimeTypes(mimeTypes, tableName));
                sb.append(")");
            }
            return StringUtil.replace((String)sql, (String)"[$FOLDER_ID$]", (String)sb.toString());
        }
        return StringUtil.removeSubstring((String)sql, (String)"[$FOLDER_ID$]");
    }

    protected String getFolderIds(List<Long> folderIds, String tableName) {
        if (folderIds.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(folderIds.size() * 3 + 1);
        sb.append("(");
        for (int i = 0; i < folderIds.size(); ++i) {
            sb.append(tableName);
            sb.append(".folderId = ");
            sb.append((Object)folderIds.get(i));
            if (i + 1 == folderIds.size()) continue;
            sb.append(" OR ");
        }
        sb.append(")");
        return sb.toString();
    }

    protected String getMimeTypes(String[] mimeTypes, String tableName) {
        if (mimeTypes.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(mimeTypes.length * 3 - 1);
        for (int i = 0; i < mimeTypes.length; ++i) {
            sb.append(tableName);
            sb.append(".mimeType = ?");
            if (i + 1 == mimeTypes.length) continue;
            sb.append(" OR ");
        }
        return sb.toString();
    }

    protected String getRepositoryIds(List<Long> repositoryIds, String tableName) {
        if (repositoryIds.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(repositoryIds.size() * 3 + 1);
        sb.append("(");
        for (int i = 0; i < repositoryIds.size(); ++i) {
            sb.append(tableName);
            sb.append(".repositoryId = ? ");
            if (i + 1 == repositoryIds.size()) continue;
            sb.append(" OR ");
        }
        sb.append(")");
        return sb.toString();
    }
}

