/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.util.AudioConverter;
import com.liferay.document.library.kernel.util.AudioProcessor;
import com.liferay.document.library.kernel.util.DLPreviewableProcessor;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.event.FileVersionPreviewEventListener;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.lang.time.StopWatch;

public class AudioProcessorImpl
extends DLPreviewableProcessor
implements AudioProcessor {
    private static final String[] _PREVIEW_TYPES = PropsValues.DL_FILE_ENTRY_PREVIEW_AUDIO_CONTAINERS;
    private static final Log _log = LogFactoryUtil.getLog(AudioProcessorImpl.class);
    private static volatile AudioConverter _audioConverter = (AudioConverter)ServiceProxyFactory.newServiceTrackedInstance(AudioConverter.class, AudioProcessorImpl.class, (String)"_audioConverter", (boolean)false);
    private static volatile FileVersionPreviewEventListener _fileVersionPreviewEventListener = (FileVersionPreviewEventListener)ServiceProxyFactory.newServiceTrackedInstance(FileVersionPreviewEventListener.class, AudioProcessorImpl.class, (String)"_fileVersionPreviewEventListener", (boolean)false, (boolean)false);
    private final Set<String> _audioMimeTypes = SetUtil.fromArray((Object[])PropsValues.DL_FILE_ENTRY_PREVIEW_AUDIO_MIME_TYPES);
    private final List<Long> _fileVersionIds = new Vector<Long>();

    public void afterPropertiesSet() {
        boolean valid = true;
        if (_PREVIEW_TYPES.length == 0 || _PREVIEW_TYPES.length > 2) {
            valid = false;
        } else {
            for (String previewType : _PREVIEW_TYPES) {
                if (previewType.equals("mp3") || previewType.equals("ogg")) continue;
                valid = false;
                break;
            }
        }
        if (!valid && _log.isWarnEnabled()) {
            _log.warn((Object)StringBundler.concat((String[])new String[]{"Liferay is incorrectly configured to generate video ", "previews using video containers other than MP3 or OGG. ", "Please change the property ", "dl.file.entry.preview.audio.containers", " in portal-ext.properties."}));
        }
        FileUtil.mkdirs((String)PREVIEW_TMP_PATH);
    }

    public void generateAudio(FileVersion sourceFileVersion, FileVersion destinationFileVersion) throws Exception {
        this._generateAudio(sourceFileVersion, destinationFileVersion);
    }

    public Set<String> getAudioMimeTypes() {
        return this._audioMimeTypes;
    }

    public InputStream getPreviewAsStream(FileVersion fileVersion, String type) throws Exception {
        return this.doGetPreviewAsStream(fileVersion, type);
    }

    public long getPreviewFileSize(FileVersion fileVersion, String type) throws Exception {
        return this.doGetPreviewFileSize(fileVersion, type);
    }

    public String getType() {
        return "AudioProcessor";
    }

    public boolean hasAudio(FileVersion fileVersion) {
        boolean hasAudio = false;
        try {
            hasAudio = this.hasPreviews(fileVersion);
            if (!hasAudio && this.isSupported(fileVersion)) {
                this._queueGeneration(null, fileVersion);
            }
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
        return hasAudio;
    }

    public boolean isAudioSupported(FileVersion fileVersion) {
        return this.isSupported(fileVersion);
    }

    public boolean isAudioSupported(String mimeType) {
        return this.isSupported(mimeType);
    }

    public boolean isEnabled() {
        return _audioConverter.isEnabled();
    }

    public boolean isSupported(String mimeType) {
        return this._audioMimeTypes.contains(mimeType) && _audioConverter.isEnabled();
    }

    public void trigger(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        super.trigger(sourceFileVersion, destinationFileVersion);
        this._queueGeneration(sourceFileVersion, destinationFileVersion);
    }

    protected void doExportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        this.exportPreviews(portletDataContext, fileEntry, fileEntryElement);
    }

    protected void doImportGeneratedFiles(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
        this.importPreviews(portletDataContext, fileEntry, importedFileEntry, fileEntryElement);
    }

    protected void exportPreviews(PortletDataContext portletDataContext, FileEntry fileEntry, Element fileEntryElement) throws Exception {
        FileVersion fileVersion = fileEntry.getFileVersion();
        if (!this.isSupported(fileVersion) || !this.hasPreviews(fileVersion)) {
            return;
        }
        if (!portletDataContext.isPerformDirectBinaryImport()) {
            if (_PREVIEW_TYPES.length == 0 || _PREVIEW_TYPES.length > 2) {
                return;
            }
            for (String previewType : _PREVIEW_TYPES) {
                if (!previewType.equals("mp3") && !previewType.equals("ogg")) continue;
                this.exportPreview(portletDataContext, fileEntry, fileEntryElement, "audio", previewType);
            }
        }
    }

    protected List<Long> getFileVersionIds() {
        return this._fileVersionIds;
    }

    protected String getPreviewType(FileVersion fileVersion) {
        return _PREVIEW_TYPES[0];
    }

    protected String[] getPreviewTypes() {
        return _PREVIEW_TYPES;
    }

    protected String getThumbnailType(FileVersion fileVersion) {
        return null;
    }

    protected void importPreviews(PortletDataContext portletDataContext, FileEntry fileEntry, FileEntry importedFileEntry, Element fileEntryElement) throws Exception {
        if (_PREVIEW_TYPES.length == 0 || _PREVIEW_TYPES.length > 2) {
            return;
        }
        for (String previewType : _PREVIEW_TYPES) {
            if (!previewType.equals("mp3") && !previewType.equals("ogg")) continue;
            this.importPreview(portletDataContext, fileEntry, importedFileEntry, fileEntryElement, "audio", previewType);
        }
    }

    private void _generateAudio(FileVersion fileVersion, File srcFile, File destFile, String containerType) throws Exception {
        if (this.hasPreview(fileVersion, containerType)) {
            return;
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            FileUtil.write((File)destFile, (InputStream)_audioConverter.generateAudioPreview(srcFile, containerType));
        }
        catch (Exception exception) {
            _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to process ", fileVersion.getFileVersionId(), " ", fileVersion.getTitle()}), (Throwable)exception);
        }
        this.addFileToStore(fileVersion.getCompanyId(), "document_preview/", this.getPreviewFilePath(fileVersion, containerType), destFile);
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Generated a ", containerType, " preview audio for ", fileVersion.getFileVersionId(), " in ", stopWatch.getTime(), "ms"}));
        }
    }

    private void _generateAudio(FileVersion fileVersion, File srcFile, File[] destFiles) {
        try {
            for (int i = 0; i < destFiles.length; ++i) {
                this._generateAudio(fileVersion, srcFile, destFiles[i], _PREVIEW_TYPES[i]);
            }
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _generateAudio(FileVersion sourceFileVersion, FileVersion destinationFileVersion) throws Exception {
        block28: {
            String tempFileId = DLUtil.getTempFileId((long)destinationFileVersion.getFileEntryId(), (String)destinationFileVersion.getVersion());
            File[] previewTempFiles = new File[_PREVIEW_TYPES.length];
            for (int i = 0; i < _PREVIEW_TYPES.length; ++i) {
                previewTempFiles[i] = this.getPreviewTempFile(tempFileId, _PREVIEW_TYPES[i]);
            }
            File audioTempFile = null;
            try {
                if (sourceFileVersion != null) {
                    this.copy(sourceFileVersion, destinationFileVersion);
                    return;
                }
                if (!_audioConverter.isEnabled() || this.hasPreviews(destinationFileVersion)) {
                    return;
                }
                audioTempFile = FileUtil.createTempFile((String)destinationFileVersion.getExtension());
                if (this.hasPreviews(destinationFileVersion)) break block28;
                try (InputStream inputStream = destinationFileVersion.getContentStream(false);){
                    FileUtil.write((File)audioTempFile, (InputStream)inputStream);
                }
                try {
                    this._generateAudio(destinationFileVersion, audioTempFile, previewTempFiles);
                    _fileVersionPreviewEventListener.onSuccess(destinationFileVersion);
                }
                catch (Exception exception) {
                    _fileVersionPreviewEventListener.onFailure(destinationFileVersion);
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to process ", destinationFileVersion.getFileVersionId(), " ", destinationFileVersion.getTitle()}));
                    }
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)exception, (Throwable)exception);
                    }
                    throw exception;
                }
            }
            catch (NoSuchFileEntryException noSuchFileEntryException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)noSuchFileEntryException, (Throwable)noSuchFileEntryException);
                }
                _fileVersionPreviewEventListener.onFailure(destinationFileVersion);
            }
            finally {
                this._fileVersionIds.remove(destinationFileVersion.getFileVersionId());
                for (File previewTempFile : previewTempFiles) {
                    FileUtil.delete((File)previewTempFile);
                }
                FileUtil.delete((File)audioTempFile);
            }
        }
    }

    private void _queueGeneration(FileVersion sourceFileVersion, FileVersion destinationFileVersion) {
        if (this._fileVersionIds.contains(destinationFileVersion.getFileVersionId()) || !this.isSupported(destinationFileVersion)) {
            return;
        }
        this._fileVersionIds.add(destinationFileVersion.getFileVersionId());
        this.sendGenerationMessage("liferay/document_library_audio_processor", sourceFileVersion, destinationFileVersion);
    }
}

