/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.VirtualHost;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.VirtualHostLocalServiceUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.struts.Action;
import com.liferay.portal.struts.model.ActionForward;
import com.liferay.portal.struts.model.ActionMapping;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.RobotsUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RobotsAction
implements Action {
    private static final Log _log = LogFactoryUtil.getLog(RobotsAction.class);

    @Override
    public ActionForward execute(ActionMapping actionMapping, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        try {
            String host = GetterUtil.getString((String)PortalUtil.getForwardedHost((HttpServletRequest)httpServletRequest));
            LayoutSet layoutSet = null;
            VirtualHost virtualHost = VirtualHostLocalServiceUtil.fetchVirtualHost((String)host);
            if (virtualHost != null && virtualHost.getLayoutSetId() > 0L) {
                layoutSet = LayoutSetLocalServiceUtil.fetchLayoutSet((String)host);
            } else {
                Company company = PortalUtil.getCompany((HttpServletRequest)httpServletRequest);
                if (host.equals(company.getVirtualHostname()) && Validator.isNotNull((String)PropsValues.VIRTUAL_HOSTS_DEFAULT_SITE_NAME)) {
                    Group defaultGroup = GroupLocalServiceUtil.getGroup((long)company.getCompanyId(), (String)PropsValues.VIRTUAL_HOSTS_DEFAULT_SITE_NAME);
                    layoutSet = defaultGroup.getPublicLayoutSet();
                }
            }
            String robots = RobotsUtil.getRobots(layoutSet, httpServletRequest.isSecure());
            ServletResponseUtil.sendFile((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, null, (byte[])robots.getBytes("UTF-8"), (String)"text/plain; charset=UTF-8");
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)exception, (Throwable)exception);
            }
            PortalUtil.sendError((int)500, (Exception)exception, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
        }
        return null;
    }
}

