/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.layout.admin.kernel.util.SitemapUtil;
import com.liferay.portal.kernel.exception.NoSuchLayoutSetException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.VirtualHost;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.VirtualHostLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.struts.Action;
import com.liferay.portal.struts.model.ActionForward;
import com.liferay.portal.struts.model.ActionMapping;
import com.liferay.portal.util.PropsValues;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SitemapAction
implements Action {
    private static final Log _log = LogFactoryUtil.getLog(SitemapAction.class);

    @Override
    public ActionForward execute(ActionMapping actionMapping, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        try {
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            String layoutUuid = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"layoutUuid");
            long groupId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"groupId");
            LayoutSet layoutSet = null;
            if (groupId > 0L) {
                Group group = GroupLocalServiceUtil.getGroup((long)groupId);
                if (group.isStagingGroup()) {
                    groupId = group.getLiveGroupId();
                }
                boolean privateLayout = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"privateLayout");
                layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)privateLayout);
            } else {
                String host = PortalUtil.getHost((HttpServletRequest)httpServletRequest);
                host = StringUtil.toLowerCase((String)host);
                VirtualHost virtualHost = VirtualHostLocalServiceUtil.fetchVirtualHost((String)(host = host.trim()));
                if (virtualHost != null && virtualHost.getLayoutSetId() != 0L) {
                    layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)virtualHost.getLayoutSetId());
                    Group group = layoutSet.getGroup();
                    if (group.isStagingGroup()) {
                        GroupPermissionUtil.check((PermissionChecker)themeDisplay.getPermissionChecker(), (long)group.getGroupId(), (String)"VIEW_STAGING");
                    }
                } else {
                    String groupName = PropsValues.VIRTUAL_HOSTS_DEFAULT_SITE_NAME;
                    if (Validator.isNull((String)groupName)) {
                        groupName = "Guest";
                    }
                    Group group = GroupLocalServiceUtil.getGroup((long)themeDisplay.getCompanyId(), (String)groupName);
                    layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)group.getGroupId(), (boolean)false);
                }
            }
            String sitemap = SitemapUtil.getSitemap((String)layoutUuid, (long)layoutSet.getGroupId(), (boolean)layoutSet.isPrivateLayout(), (ThemeDisplay)themeDisplay);
            ServletResponseUtil.sendFile((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, null, (byte[])sitemap.getBytes("UTF-8"), (String)"text/xml; charset=UTF-8");
        }
        catch (NoSuchLayoutSetException noSuchLayoutSetException) {
            PortalUtil.sendError((int)404, (Exception)((Object)noSuchLayoutSetException), (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)exception, (Throwable)exception);
            }
            PortalUtil.sendError((int)500, (Exception)exception, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
        }
        return null;
    }
}

