/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.auto;

import com.liferay.portal.deploy.DeployUtil;
import com.liferay.portal.kernel.deploy.auto.AutoDeployException;
import com.liferay.portal.kernel.deploy.auto.AutoDeployer;
import com.liferay.portal.kernel.deploy.auto.context.AutoDeploymentContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.tools.deploy.ThemeDeployer;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.util.ArrayList;

public class ThemeAutoDeployer
extends ThemeDeployer
implements AutoDeployer {
    private static final Log _log = LogFactoryUtil.getLog(ThemeAutoDeployer.class);

    public ThemeAutoDeployer() {
        try {
            this.baseDir = PropsValues.AUTO_DEPLOY_DEPLOY_DIR;
            this.destDir = DeployUtil.getAutoDeployDestDir();
            this.appServerType = ServerDetector.getServerId();
            this.themeTaglibDTD = DeployUtil.getResourcePath(this.tempDirPaths, "liferay-theme.tld");
            this.utilTaglibDTD = DeployUtil.getResourcePath(this.tempDirPaths, "liferay-util.tld");
            this.unpackWar = PropsValues.AUTO_DEPLOY_UNPACK_WAR;
            this.filePattern = "";
            this.jbossPrefix = PropsValues.AUTO_DEPLOY_JBOSS_PREFIX;
            this.tomcatLibDir = PropsValues.AUTO_DEPLOY_TOMCAT_LIB_DIR;
            this.wildflyPrefix = PropsValues.AUTO_DEPLOY_WILDFLY_PREFIX;
            ArrayList<String> jars = new ArrayList<String>();
            this.addRequiredJar(jars, "util-bridges.jar");
            this.addRequiredJar(jars, "util-java.jar");
            this.addRequiredJar(jars, "util-taglib.jar");
            this.jars = jars;
            this.checkArguments();
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
    }

    @Override
    public int autoDeploy(AutoDeploymentContext autoDeploymentContext) throws AutoDeployException {
        File file = autoDeploymentContext.getFile();
        if (file.isDirectory()) {
            try {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Modifying themes for " + file.getPath()));
                }
                this.deployDirectory(file, autoDeploymentContext.getContext(), false, autoDeploymentContext.getPluginPackage());
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Themes for " + file.getPath() + " modified successfully"));
                }
                return 1;
            }
            catch (Exception exception) {
                throw new AutoDeployException((Throwable)exception);
            }
        }
        return super.autoDeploy(autoDeploymentContext);
    }
}

