/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice;

import com.liferay.portal.kernel.bean.ClassLoaderBeanHandler;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceScannerStrategy;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceWrapper;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.spring.aop.AopInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;

public class SpringJSONWebServiceScannerStrategy
implements JSONWebServiceScannerStrategy {
    private static final Log _log = LogFactoryUtil.getLog(SpringJSONWebServiceScannerStrategy.class);

    public JSONWebServiceScannerStrategy.MethodDescriptor[] scan(Object service) {
        Class<?> clazz = this.getTargetClass(service);
        Method[] methods = clazz.getMethods();
        ArrayList<JSONWebServiceScannerStrategy.MethodDescriptor> methodDescriptors = new ArrayList<JSONWebServiceScannerStrategy.MethodDescriptor>(methods.length);
        for (Method method : methods) {
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass != clazz || !this.isInterfaceMethod(method)) continue;
            methodDescriptors.add(new JSONWebServiceScannerStrategy.MethodDescriptor(method));
        }
        return methodDescriptors.toArray(new JSONWebServiceScannerStrategy.MethodDescriptor[0]);
    }

    protected Class<?> getTargetClass(Object service) {
        while (ProxyUtil.isProxyClass(service.getClass())) {
            InvocationHandler invocationHandler = ProxyUtil.getInvocationHandler((Object)service);
            if (invocationHandler instanceof AopInvocationHandler) {
                AopInvocationHandler aopInvocationHandler = (AopInvocationHandler)invocationHandler;
                service = aopInvocationHandler.getTarget();
                continue;
            }
            if (!(invocationHandler instanceof ClassLoaderBeanHandler)) break;
            ClassLoaderBeanHandler classLoaderBeanHandler = (ClassLoaderBeanHandler)invocationHandler;
            Object bean = classLoaderBeanHandler.getBean();
            if (bean instanceof ServiceWrapper) {
                ServiceWrapper serviceWrapper = (ServiceWrapper)bean;
                service = serviceWrapper.getWrappedService();
                continue;
            }
            service = bean;
        }
        return service.getClass();
    }

    protected boolean isInterfaceMethod(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        if (declaringClass.isInterface()) {
            return true;
        }
        LinkedList queue = new LinkedList(Arrays.asList(declaringClass.getInterfaces()));
        Class<Object> superClass = declaringClass.getSuperclass();
        if (superClass != null) {
            queue.add(superClass);
        }
        Class clazz = null;
        while ((clazz = (Class)queue.poll()) != null) {
            if (clazz.isInterface()) {
                try {
                    clazz.getMethod(method.getName(), method.getParameterTypes());
                    return true;
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)reflectiveOperationException, (Throwable)reflectiveOperationException);
                    continue;
                }
            }
            Collections.addAll(queue, clazz.getInterfaces());
            superClass = clazz.getSuperclass();
            if (superClass == null) continue;
            queue.add(superClass);
        }
        return false;
    }
}

