/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice.action;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.json.data.FileData;
import com.liferay.portal.json.transformer.BeanAnalyzerTransformer;
import com.liferay.portal.kernel.javadoc.JavadocManagerUtil;
import com.liferay.portal.kernel.javadoc.JavadocMethod;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONSerializable;
import com.liferay.portal.kernel.json.JSONSerializer;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceAction;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionMapping;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionsManagerUtil;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceNaming;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.MethodParameter;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import jodd.util.ClassUtil;

public class JSONWebServiceDiscoverAction
implements JSONWebServiceAction {
    private static final Log _log = LogFactoryUtil.getLog(JSONWebServiceDiscoverAction.class);
    private final String _basePath;
    private final String _baseURL;
    private final String _contextName;
    private final JSONWebServiceNaming _jsonWebServiceNaming;
    private final List<Class<?>> _types = new ArrayList();

    public JSONWebServiceDiscoverAction(HttpServletRequest httpServletRequest) {
        this._basePath = httpServletRequest.getServletPath();
        this._baseURL = String.valueOf(httpServletRequest.getRequestURL());
        ServletContext servletContext = httpServletRequest.getServletContext();
        this._contextName = GetterUtil.getString((String)ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"contextName", (String)servletContext.getServletContextName()));
        this._jsonWebServiceNaming = JSONWebServiceActionsManagerUtil.getJSONWebServiceNaming();
    }

    public JSONWebServiceActionMapping getJSONWebServiceActionMapping() {
        return null;
    }

    public Object invoke() throws Exception {
        return new DiscoveryContent(LinkedHashMapBuilder.put((Object)"contextName", (Object)this._contextName).put((Object)"basePath", (Object)this._basePath).put((Object)"baseURL", (Object)this._baseURL).put((Object)"services", this._buildJsonWebServiceActionMappingMaps()).put((Object)"types", this._buildTypes()).put((Object)"version", (Object)ReleaseInfo.getVersion()).build());
    }

    private List<Map<String, Object>> _buildJsonWebServiceActionMappingMaps() {
        List jsonWebServiceActionMappings = JSONWebServiceActionsManagerUtil.getJSONWebServiceActionMappings((String)this._contextName);
        ArrayList<Map<String, Object>> jsonWebServiceActionMappingMaps = new ArrayList<Map<String, Object>>(jsonWebServiceActionMappings.size());
        for (JSONWebServiceActionMapping jsonWebServiceActionMapping : jsonWebServiceActionMappings) {
            String returnComment;
            String methodComment;
            JavadocMethod javadocMethod;
            String path = jsonWebServiceActionMapping.getPath();
            LinkedHashMap<String, Object> jsonWebServiceActionMappingMap = new LinkedHashMap<String, Object>();
            if (jsonWebServiceActionMapping.isDeprecated()) {
                jsonWebServiceActionMappingMap.put("deprecated", Boolean.TRUE);
            }
            if ((javadocMethod = JavadocManagerUtil.lookupJavadocMethod((Method)jsonWebServiceActionMapping.getRealActionMethod())) != null && (methodComment = javadocMethod.getComment()) != null) {
                jsonWebServiceActionMappingMap.put("description", javadocMethod.getComment());
            }
            jsonWebServiceActionMappingMap.put("method", jsonWebServiceActionMapping.getMethod());
            jsonWebServiceActionMappingMap.put("name", this._getName(jsonWebServiceActionMapping));
            MethodParameter[] methodParameters = jsonWebServiceActionMapping.getMethodParameters();
            ArrayList parametersList = new ArrayList(methodParameters.length);
            for (int i = 0; i < methodParameters.length; ++i) {
                String parameterComment;
                MethodParameter methodParameter = methodParameters[i];
                HashMap<String, String> parameterMap = new HashMap<String, String>();
                if (javadocMethod != null && !Validator.isBlank((String)(parameterComment = javadocMethod.getParameterComment(i)))) {
                    parameterMap.put("description", parameterComment);
                }
                parameterMap.put("name", methodParameter.getName());
                parameterMap.put("type", this._formatType(methodParameter.getType(), methodParameter.getGenericTypes(), false));
                parametersList.add(parameterMap);
            }
            jsonWebServiceActionMappingMap.put("parameters", parametersList);
            jsonWebServiceActionMappingMap.put("path", path);
            LinkedHashMap<String, String> returnsMap = new LinkedHashMap<String, String>();
            if (javadocMethod != null && !Validator.isBlank((String)(returnComment = javadocMethod.getReturnComment()))) {
                returnsMap.put("description", returnComment);
            }
            Method actionMethod = jsonWebServiceActionMapping.getActionMethod();
            returnsMap.put("type", this._formatType(actionMethod.getReturnType(), this._getGenericReturnTypes(jsonWebServiceActionMapping), true));
            jsonWebServiceActionMappingMap.put("returns", returnsMap);
            jsonWebServiceActionMappingMaps.add(jsonWebServiceActionMappingMap);
        }
        return jsonWebServiceActionMappingMaps;
    }

    private List<Map<String, String>> _buildPropertiesList(Class<?> type) {
        try {
            BeanAnalyzerTransformer beanAnalyzerTransformer = new BeanAnalyzerTransformer(type){

                @Override
                protected String getTypeName(Class<?> type) {
                    return JSONWebServiceDiscoverAction.this._formatType(type, null, false);
                }
            };
            return beanAnalyzerTransformer.collect();
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)exception, (Throwable)exception);
            }
            return null;
        }
    }

    private List<Map<String, Object>> _buildTypes() {
        this._completeTypes();
        ArrayList<Map<String, Object>> types = new ArrayList<Map<String, Object>>();
        for (Class<?> type : this._types) {
            List<Map<String, String>> propertiesList;
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            types.add(map);
            Class<?> modelType = this._getInterfaceType(type);
            if (modelType.isInterface() || Modifier.isAbstract(modelType.getModifiers())) {
                map.put("interface", Boolean.TRUE);
            }
            if ((propertiesList = this._buildPropertiesList(modelType)) != null) {
                map.put("properties", propertiesList);
            }
            map.put("type", type.getName());
        }
        return types;
    }

    private void _completeTypes() {
        int typesSize;
        do {
            typesSize = this._types.size();
            for (Class<?> type : new ArrayList(this._types)) {
                Class<?> modelType = this._getInterfaceType(type);
                this._buildPropertiesList(modelType);
            }
        } while (typesSize != this._types.size());
    }

    private String _formatType(Class<?> type, Class<?>[] genericTypes, boolean returnType) {
        if (type.isArray()) {
            String typeName = this._formatType(type.getComponentType(), genericTypes, returnType);
            return typeName + "[]";
        }
        if (type.isPrimitive()) {
            return type.getSimpleName();
        }
        if (type.equals(Boolean.class)) {
            return "boolean";
        }
        if (type.equals(Class.class)) {
            if (!returnType) {
                return "string";
            }
        } else {
            if (type.equals(Date.class)) {
                return "long";
            }
            if (type.equals(File.class)) {
                if (!returnType) {
                    return "file";
                }
                type = FileData.class;
            } else {
                if (type.equals(Locale.class) || type.equals(String.class) || type.equals(TimeZone.class)) {
                    return "string";
                }
                if (type.equals(Object.class) || type.equals(Serializable.class)) {
                    return "map";
                }
                if (ClassUtil.isTypeOf(type, Number.class)) {
                    String typeName = null;
                    typeName = type == Character.class ? "char" : (type == Integer.class ? "int" : StringUtil.toLowerCase((String)type.getSimpleName()));
                    return typeName;
                }
            }
        }
        String typeName = type.getName();
        if (type == Collection.class || ClassUtil.isTypeOf(type, List.class)) {
            typeName = "list";
        } else if (ClassUtil.isTypeOf(type, Map.class)) {
            typeName = "map";
        } else if (!this._types.contains(type)) {
            this._types.add(type);
        }
        if (genericTypes == null) {
            return typeName;
        }
        StringBundler sb = new StringBundler(genericTypes.length * 2 + 1);
        sb.append("<");
        for (int i = 0; i < genericTypes.length; ++i) {
            Class<?> genericType = genericTypes[i];
            if (i != 0) {
                sb.append(",");
            }
            if (genericType == null) {
                sb.append("*");
                continue;
            }
            sb.append(this._formatType(genericType, null, returnType));
        }
        sb.append(">");
        return typeName + sb.toString();
    }

    private Class<?>[] _getGenericReturnTypes(JSONWebServiceActionMapping jsonWebServiceActionMapping) {
        Method realActionMethod = jsonWebServiceActionMapping.getRealActionMethod();
        Type genericReturnType = realActionMethod.getGenericReturnType();
        if (!(genericReturnType instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType parameterizedType = (ParameterizedType)genericReturnType;
        Type[] genericTypes = parameterizedType.getActualTypeArguments();
        Class[] genericReturnTypes = new Class[genericTypes.length];
        for (int i = 0; i < genericTypes.length; ++i) {
            Type genericType = genericTypes[i];
            genericReturnTypes[i] = ClassUtil.getRawType((Type)genericType, (Class)jsonWebServiceActionMapping.getActionClass());
        }
        return genericReturnTypes;
    }

    private Class<?> _getInterfaceType(Class<?> type) {
        Class<?> modelType;
        block3: {
            modelType = type;
            if (type.isInterface()) {
                try {
                    Class<?> clazz = this.getClass();
                    ClassLoader classLoader = clazz.getClassLoader();
                    String modelImplClassName = this._jsonWebServiceNaming.convertModelClassToImplClassName(type);
                    modelType = classLoader.loadClass(modelImplClassName);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!_log.isDebugEnabled()) break block3;
                    _log.debug((Object)classNotFoundException, (Throwable)classNotFoundException);
                }
            }
        }
        return modelType;
    }

    private String _getName(JSONWebServiceActionMapping jsonWebServiceActionMapping) {
        Class clazz = jsonWebServiceActionMapping.getActionClass();
        String className = this._jsonWebServiceNaming.convertServiceClassToSimpleName(clazz);
        Method method = jsonWebServiceActionMapping.getRealActionMethod();
        return StringBundler.concat((String[])new String[]{className, "#", method.getName()});
    }

    public static class DiscoveryContent
    implements JSONSerializable {
        private final Map<String, Object> _resultsMap;

        public DiscoveryContent(Map<String, Object> resultsMap) {
            this._resultsMap = resultsMap;
        }

        public String toJSONString() {
            JSONSerializer jsonSerializer = JSONFactoryUtil.createJSONSerializer();
            jsonSerializer.include(new String[]{"types"});
            return jsonSerializer.serializeDeep(this._resultsMap);
        }
    }
}

