/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model;

import com.liferay.exportimport.kernel.staging.LayoutStagingUtil;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutRevisionLocalServiceUtil;
import com.liferay.portal.servlet.filters.cache.CacheUtil;

public class LayoutModelListener
extends BaseModelListener<Layout> {
    private static final Log _log = LogFactoryUtil.getLog(LayoutModelListener.class);

    public void onAfterCreate(Layout layout) {
        this.clearCache(layout);
    }

    public void onAfterRemove(Layout layout) {
        this.clearCache(layout);
    }

    public void onAfterUpdate(Layout originalLayout, Layout layout) {
        this.clearCache(layout);
    }

    public void onBeforeRemove(Layout layout) throws ModelListenerException {
        try {
            if (layout == null || !LayoutStagingUtil.isBranchingLayout((Layout)layout)) {
                return;
            }
            LayoutRevisionLocalServiceUtil.deleteLayoutLayoutRevisions((long)layout.getPlid());
        }
        catch (IllegalStateException illegalStateException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)illegalStateException, (Throwable)illegalStateException);
            }
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
        catch (SystemException systemException) {
            throw new ModelListenerException((Throwable)systemException);
        }
    }

    protected void clearCache(Layout layout) {
        if (layout == null) {
            return;
        }
        if (!layout.isPrivateLayout()) {
            CacheUtil.clearCache(layout.getCompanyId());
        }
    }
}

