/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLFileEntryLocalServiceUtil;
import com.liferay.document.library.kernel.store.DLStoreUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.service.ImageLocalServiceUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.model.impl.ImageBaseImpl;
import com.liferay.portal.util.PropsValues;
import java.io.InputStream;

public class ImageImpl
extends ImageBaseImpl {
    private static final long _REPOSITORY_ID = 0L;
    private static final Log _log = LogFactoryUtil.getLog(ImageImpl.class);
    private byte[] _textObj;

    public byte[] getTextObj() {
        if (this._textObj != null) {
            return this._textObj;
        }
        long imageId = this.getImageId();
        try {
            DLFileEntry dlFileEntry = null;
            if (PropsValues.WEB_SERVER_SERVLET_CHECK_IMAGE_GALLERY) {
                dlFileEntry = DLFileEntryLocalServiceUtil.fetchFileEntryByAnyImageId((long)imageId);
            }
            InputStream inputStream = null;
            if (dlFileEntry != null && dlFileEntry.getLargeImageId() == imageId) {
                inputStream = DLStoreUtil.getFileAsStream((long)dlFileEntry.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName());
            } else {
                Image image = ImageLocalServiceUtil.getImage((long)imageId);
                inputStream = DLStoreUtil.getFileAsStream((long)image.getCompanyId(), (long)0L, (String)this.getFileName());
            }
            byte[] bytes = FileUtil.getBytes((InputStream)inputStream);
            this._textObj = bytes;
        }
        catch (Exception exception) {
            _log.error((Object)("Error reading image " + imageId), (Throwable)exception);
        }
        return this._textObj;
    }

    public void setTextObj(byte[] textObj) {
        this._textObj = textObj;
    }

    protected String getFileName() {
        return this.getImageId() + "." + this.getType();
    }
}

