/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.oauth;

import com.liferay.portal.kernel.oauth.OAuthException;
import com.liferay.portal.kernel.oauth.OAuthFactory;
import com.liferay.portal.kernel.oauth.OAuthManager;
import com.liferay.portal.kernel.oauth.OAuthRequest;
import com.liferay.portal.kernel.oauth.Token;
import com.liferay.portal.kernel.oauth.Verb;
import com.liferay.portal.oauth.OAuthManagerImpl;
import com.liferay.portal.oauth.OAuthRequestImpl;
import com.liferay.portal.oauth.TokenImpl;
import com.liferay.portal.oauth.VerbTranslator;
import com.liferay.portal.oauth.VerifierImpl;
import org.scribe.model.Verifier;

public class OAuthFactoryImpl
implements OAuthFactory {
    public OAuthManager createOAuthManager(String key, String secret, String accessURL, String requestURL, String callbackURL, String scope) throws OAuthException {
        try {
            return new OAuthManagerImpl(key, secret, accessURL, requestURL, callbackURL, scope);
        }
        catch (Exception exception) {
            throw new OAuthException((Throwable)exception);
        }
    }

    public OAuthRequest createOAuthRequest(Verb verb, String url) throws OAuthException {
        try {
            return new OAuthRequestImpl(new org.scribe.model.OAuthRequest(VerbTranslator.translate(verb), url));
        }
        catch (Exception exception) {
            throw new OAuthException((Throwable)exception);
        }
    }

    public Token createToken(String token, String secret) throws OAuthException {
        try {
            return new TokenImpl(new org.scribe.model.Token(token, secret));
        }
        catch (Exception exception) {
            throw new OAuthException((Throwable)exception);
        }
    }

    public com.liferay.portal.kernel.oauth.Verifier createVerifier(String verifier) throws OAuthException {
        try {
            return new VerifierImpl(new Verifier(verifier));
        }
        catch (Exception exception) {
            throw new OAuthException((Throwable)exception);
        }
    }
}

