/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.poller.comet;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.notifications.ChannelHubManagerUtil;
import com.liferay.portal.kernel.notifications.ChannelListener;
import com.liferay.portal.kernel.notifications.UnknownChannelException;
import com.liferay.portal.kernel.poller.comet.BaseCometHandler;
import com.liferay.portal.kernel.poller.comet.CometHandler;
import com.liferay.portal.kernel.poller.comet.CometRequest;
import com.liferay.portal.kernel.poller.comet.CometSession;
import com.liferay.portal.poller.PollerRequestHandlerUtil;
import com.liferay.portal.poller.comet.PollerCometChannelListener;

public class PollerCometHandler
extends BaseCometHandler {
    private static final Log _log = LogFactoryUtil.getLog(PollerCometHandler.class);
    private ChannelListener _channelListener;
    private long _companyId;
    private long _userId;

    public CometHandler clone() {
        return new PollerCometHandler();
    }

    public void receiveData(String data) {
    }

    protected void doDestroy() throws Exception {
        block3: {
            if (this._channelListener != null) {
                try {
                    ChannelHubManagerUtil.unregisterChannelListener((long)this._companyId, (long)this._userId, (ChannelListener)this._channelListener);
                }
                catch (UnknownChannelException unknownChannelException) {
                    if (!_log.isDebugEnabled()) break block3;
                    _log.debug((Object)unknownChannelException, (Throwable)unknownChannelException);
                }
            }
        }
    }

    protected void doInit(CometSession cometSession) throws Exception {
        CometRequest cometRequest = cometSession.getCometRequest();
        this._companyId = cometRequest.getCompanyId();
        this._userId = cometRequest.getUserId();
        String pollerRequestString = cometRequest.getParameter("pollerRequest");
        JSONObject pollerResponseHeaderJSONObject = PollerRequestHandlerUtil.processRequest(cometRequest.getRequest(), pollerRequestString);
        if (pollerResponseHeaderJSONObject != null) {
            this._channelListener = new PollerCometChannelListener(cometSession, pollerResponseHeaderJSONObject);
            try {
                ChannelHubManagerUtil.registerChannelListener((long)this._companyId, (long)this._userId, (ChannelListener)this._channelListener);
            }
            catch (UnknownChannelException unknownChannelException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Terminating request for " + this._userId + " because user session ended"), (Throwable)unknownChannelException);
                }
                cometSession.close();
            }
        } else {
            cometSession.close();
        }
    }
}

