/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.jaas.ext;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.security.jaas.PortalPrincipal;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.security.jaas.JAASHelper;
import java.io.IOException;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

@Deprecated
public class BasicLoginModule
implements LoginModule {
    private static final Log _log = LogFactoryUtil.getLog(BasicLoginModule.class);
    private CallbackHandler _callbackHandler;
    private String _password;
    private Principal _principal;
    private Subject _subject;

    @Override
    public boolean abort() {
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        Principal principal = this.getPrincipal();
        if (principal != null) {
            Subject subject = this.getSubject();
            Set<Principal> principals = subject.getPrincipals();
            principals.add(this.getPrincipal());
            return true;
        }
        return false;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this._subject = subject;
        this._callbackHandler = callbackHandler;
    }

    @Override
    public boolean login() throws LoginException {
        String[] credentials = null;
        try {
            credentials = this.authenticate();
        }
        catch (Exception exception) {
            _log.error((Object)exception.getMessage());
            throw new LoginException();
        }
        if (credentials != null && credentials.length == 2) {
            this.setPrincipal(this.getPortalPrincipal(credentials[0]));
            this.setPassword(credentials[1]);
            return true;
        }
        throw new LoginException();
    }

    @Override
    public boolean logout() {
        Subject subject = this.getSubject();
        Set<Principal> principals = subject.getPrincipals();
        principals.clear();
        return true;
    }

    protected String[] authenticate() throws IOException, UnsupportedCallbackException {
        NameCallback nameCallback = new NameCallback("name: ");
        PasswordCallback passwordCallback = new PasswordCallback("password: ", false);
        this._callbackHandler.handle(new Callback[]{nameCallback, passwordCallback});
        String name = nameCallback.getName();
        String password = null;
        char[] passwordChar = passwordCallback.getPassword();
        if (passwordChar != null) {
            password = new String(passwordChar);
        }
        if (name == null) {
            return new String[]{"", ""};
        }
        try {
            List companies = CompanyLocalServiceUtil.getCompanies();
            for (Company company : companies) {
                long userId = JAASHelper.getJaasUserId(company.getCompanyId(), name);
                if (userId == 0L || !UserLocalServiceUtil.authenticateForJAAS((long)userId, (String)password)) continue;
                return new String[]{name, password};
            }
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
        return null;
    }

    protected String getPassword() {
        return this._password;
    }

    protected Principal getPortalPrincipal(String name) throws LoginException {
        return new PortalPrincipal(name);
    }

    protected Principal getPrincipal() {
        return this._principal;
    }

    protected Subject getSubject() {
        return this._subject;
    }

    protected void setPassword(String password) {
        this._password = password;
    }

    protected void setPrincipal(Principal principal) {
        this._principal = principal;
    }
}

