/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.AddressCityException;
import com.liferay.portal.kernel.exception.AddressStreetException;
import com.liferay.portal.kernel.exception.AddressZipException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.ListType;
import com.liferay.portal.kernel.model.ListTypeConstants;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Phone;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ListTypeLocalService;
import com.liferay.portal.kernel.service.PhoneLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.CountryPersistence;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.base.AddressLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AddressLocalServiceImpl
extends AddressLocalServiceBaseImpl {
    @BeanReference(type=ClassNameLocalService.class)
    private ClassNameLocalService _classNameLocalService;
    @BeanReference(type=CountryPersistence.class)
    private CountryPersistence _countryPersistence;
    @BeanReference(type=ListTypeLocalService.class)
    private ListTypeLocalService _listTypeLocalService;
    @BeanReference(type=PhoneLocalService.class)
    private PhoneLocalService _phoneLocalService;
    @BeanReference(type=UserPersistence.class)
    private UserPersistence _userPersistence;

    @Deprecated
    public Address addAddress(long userId, String className, long classPK, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, long typeId, boolean mailing, boolean primary, ServiceContext serviceContext) throws PortalException {
        return this.addressLocalService.addAddress(null, userId, className, classPK, null, null, street1, street2, street3, city, zip, regionId, countryId, typeId, mailing, primary, null, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public Address addAddress(String externalReferenceCode, long userId, String className, long classPK, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, long typeId, boolean mailing, boolean primary, String phoneNumber, ServiceContext serviceContext) throws PortalException {
        User user = this._userPersistence.findByPrimaryKey(userId);
        long classNameId = this._classNameLocalService.getClassNameId(className);
        this.validate(0L, user.getCompanyId(), classNameId, classPK, street1, city, zip, regionId, countryId, typeId, mailing, primary);
        long addressId = this.counterLocalService.increment();
        Address address = this.addressPersistence.create(addressId);
        address.setUuid(serviceContext.getUuid());
        address.setExternalReferenceCode(externalReferenceCode);
        address.setCompanyId(user.getCompanyId());
        address.setUserId(user.getUserId());
        address.setUserName(user.getFullName());
        address.setClassNameId(classNameId);
        address.setClassPK(classPK);
        address.setCountryId(countryId);
        address.setRegionId(regionId);
        address.setTypeId(typeId);
        address.setCity(city);
        address.setDescription(description);
        address.setMailing(mailing);
        address.setName(name);
        address.setPrimary(primary);
        address.setStreet1(street1);
        address.setStreet2(street2);
        address.setStreet3(street3);
        address.setZip(zip);
        address = (Address)this.addressPersistence.update((BaseModel)address);
        if (Validator.isNotNull((String)phoneNumber)) {
            this._addAddressPhone(addressId, phoneNumber);
        }
        return address;
    }

    public Address copyAddress(long addressId, String className, long classPK, ServiceContext serviceContext) throws PortalException {
        Address address = this.addressPersistence.findByPrimaryKey(addressId);
        return this.addressLocalService.addAddress(address.getExternalReferenceCode(), serviceContext.getUserId(), className, classPK, address.getName(), address.getDescription(), address.getStreet1(), address.getStreet2(), address.getStreet3(), address.getCity(), address.getZip(), address.getRegionId(), address.getCountryId(), address.getTypeId(), address.isMailing(), address.isPrimary(), address.getPhoneNumber(), serviceContext);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(action=1, type=1)
    public Address deleteAddress(Address address) {
        this.addressPersistence.remove((BaseModel)address);
        this._phoneLocalService.deletePhones(address.getCompanyId(), address.getClassName(), address.getAddressId());
        return address;
    }

    @Override
    public Address deleteAddress(long addressId) throws PortalException {
        Address address = this.addressPersistence.findByPrimaryKey(addressId);
        return this.addressLocalService.deleteAddress(address);
    }

    public void deleteAddresses(long companyId, String className, long classPK) {
        List addresses = this.addressPersistence.findByC_C_C(companyId, this._classNameLocalService.getClassNameId(className), classPK);
        for (Address address : addresses) {
            this.addressLocalService.deleteAddress(address);
        }
    }

    public void deleteCountryAddresses(long countryId) {
        List addresses = this.addressPersistence.findByCountryId(countryId);
        for (Address address : addresses) {
            this.addressLocalService.deleteAddress(address);
        }
    }

    public void deleteRegionAddresses(long regionId) {
        List addresses = this.addressPersistence.findByRegionId(regionId);
        for (Address address : addresses) {
            this.addressLocalService.deleteAddress(address);
        }
    }

    public List<Address> getAddresses() {
        return this.addressPersistence.findAll();
    }

    public List<Address> getAddresses(long companyId, String className, long classPK) {
        return this.addressPersistence.findByC_C_C(companyId, this._classNameLocalService.getClassNameId(className), classPK);
    }

    public List<Address> getAddresses(long companyId, String className, long classPK, int start, int end, OrderByComparator<Address> orderByComparator) {
        return this.addressPersistence.findByC_C_C(companyId, this._classNameLocalService.getClassNameId(className), classPK, start, end, orderByComparator);
    }

    public int getAddressesCount(long companyId, String className, long classPK) {
        return this.addressPersistence.countByC_C_C(companyId, this._classNameLocalService.getClassNameId(className), classPK);
    }

    public List<Address> getTypeAddresses(long companyId, String className, long classPK, long[] typeIds) {
        return this.addressPersistence.findByC_C_C_T(companyId, this._classNameLocalService.getClassNameId(className), classPK, typeIds);
    }

    public List<Address> getTypeAddresses(long companyId, String className, long classPK, long[] typeIds, int start, int end, OrderByComparator<Address> orderByComparator) {
        return this.addressPersistence.findByC_C_C_T(companyId, this._classNameLocalService.getClassNameId(className), classPK, typeIds, start, end, orderByComparator);
    }

    public BaseModelSearchResult<Address> searchAddresses(long companyId, String className, long classPK, String keywords, LinkedHashMap<String, Object> params, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, className, classPK, keywords, params, start, end, sort);
        return this.searchAddresses(searchContext);
    }

    public Address updateAddress(long addressId, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, long typeId, boolean mailing, boolean primary) throws PortalException {
        Address address = this.addressPersistence.findByPrimaryKey(addressId);
        return this.addressLocalService.updateAddress(addressId, address.getName(), address.getDescription(), street1, street2, street3, city, zip, regionId, countryId, typeId, mailing, primary, address.getPhoneNumber());
    }

    @Indexable(type=IndexableType.REINDEX)
    public Address updateAddress(long addressId, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, long typeId, boolean mailing, boolean primary, String phoneNumber) throws PortalException {
        this.validate(addressId, 0L, 0L, 0L, street1, city, zip, regionId, countryId, typeId, mailing, primary);
        Address address = this.addressPersistence.findByPrimaryKey(addressId);
        address.setCountryId(countryId);
        address.setRegionId(regionId);
        address.setTypeId(typeId);
        address.setCity(city);
        address.setDescription(description);
        address.setMailing(mailing);
        address.setName(name);
        address.setPrimary(primary);
        address.setStreet1(street1);
        address.setStreet2(street2);
        address.setStreet3(street3);
        address.setZip(zip);
        address = (Address)this.addressPersistence.update((BaseModel)address);
        if (Validator.isNotNull((String)phoneNumber)) {
            List phones = this._phoneLocalService.getPhones(address.getCompanyId(), Address.class.getName(), addressId);
            if (ListUtil.isEmpty((List)phones)) {
                this._addAddressPhone(addressId, phoneNumber);
            } else {
                Phone phone = (Phone)phones.get(0);
                phone.setNumber(phoneNumber);
                this._phoneLocalService.updatePhone(phone);
            }
        }
        return address;
    }

    protected SearchContext buildSearchContext(long companyId, String className, long classPK, String keywords, LinkedHashMap<String, Object> params, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttributes((Map)HashMapBuilder.put((Object)"classNameId", (Object)this._classNameLocalService.getClassNameId(className)).put((Object)"classPK", (Object)classPK).put((Object)"name", (Object)keywords).put((Object)"city", (Object)keywords).put((Object)"countryName", (Object)keywords).put((Object)"params", params).put((Object)"regionName", (Object)keywords).put((Object)"zip", (Object)keywords).build());
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        if (Validator.isNotNull((String)keywords)) {
            searchContext.setKeywords(keywords);
        }
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected List<Address> getAddresses(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<Address> addresses = new ArrayList<Address>(documents.size());
        for (Document document : documents) {
            long addressId = GetterUtil.getLong((String)document.get("entryClassPK"));
            Address address = this.fetchAddress(addressId);
            if (address == null) {
                addresses = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(Address.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (addresses == null) continue;
            addresses.add(address);
        }
        return addresses;
    }

    protected BaseModelSearchResult<Address> searchAddresses(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(Address.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext);
            List<Address> addresses = this.getAddresses(hits);
            if (addresses == null) continue;
            return new BaseModelSearchResult(addresses, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    protected void validate(long addressId, long companyId, long classNameId, long classPK, boolean mailing, boolean primary) {
        List addresses;
        if (mailing) {
            addresses = this.addressPersistence.findByC_C_C_M(companyId, classNameId, classPK, mailing);
            for (Address address : addresses) {
                if (addressId > 0L && address.getAddressId() == addressId) continue;
                address.setMailing(false);
                this.addressPersistence.update((BaseModel)address);
            }
        }
        if (primary) {
            addresses = this.addressPersistence.findByC_C_C_P(companyId, classNameId, classPK, primary);
            for (Address address : addresses) {
                if (addressId > 0L && address.getAddressId() == addressId) continue;
                address.setPrimary(false);
                this.addressPersistence.update((BaseModel)address);
            }
        }
    }

    protected void validate(long addressId, long companyId, long classNameId, long classPK, String street1, String city, String zip, long regionId, long countryId, long typeId, boolean mailing, boolean primary) throws PortalException {
        Country country;
        if (Validator.isNull((String)street1)) {
            throw new AddressStreetException();
        }
        if (Validator.isNull((String)city)) {
            throw new AddressCityException();
        }
        if (Validator.isNull((String)zip) && (country = this._countryPersistence.fetchByPrimaryKey(countryId)) != null && country.isZipRequired()) {
            throw new AddressZipException();
        }
        if (addressId > 0L) {
            Address address = this.addressPersistence.findByPrimaryKey(addressId);
            companyId = address.getCompanyId();
            classNameId = address.getClassNameId();
            classPK = address.getClassPK();
        }
        if (classNameId == this._classNameLocalService.getClassNameId(Company.class) || classNameId == this._classNameLocalService.getClassNameId(Contact.class) || classNameId == this._classNameLocalService.getClassNameId(Organization.class)) {
            this._listTypeLocalService.validate(typeId, classNameId, ".address");
        }
        this.validate(addressId, companyId, classNameId, classPK, mailing, primary);
    }

    private void _addAddressPhone(long addressId, String phoneNumber) throws PortalException {
        ListType listType = this._listTypeLocalService.getListType("phone-number", ListTypeConstants.ADDRESS_PHONE);
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        this._phoneLocalService.addPhone(serviceContext.getUserId(), Address.class.getName(), addressId, phoneNumber, null, listType.getListTypeId(), false, serviceContext);
    }
}

