/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.EmailAddressException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.EmailAddress;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ListTypeLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.base.EmailAddressLocalServiceBaseImpl;
import java.util.List;

public class EmailAddressLocalServiceImpl
extends EmailAddressLocalServiceBaseImpl {
    @BeanReference(type=ClassNameLocalService.class)
    private ClassNameLocalService _classNameLocalService;
    @BeanReference(type=ListTypeLocalService.class)
    private ListTypeLocalService _listTypeLocalService;
    @BeanReference(type=UserPersistence.class)
    private UserPersistence _userPersistence;

    public EmailAddress addEmailAddress(long userId, String className, long classPK, String address, long typeId, boolean primary, ServiceContext serviceContext) throws PortalException {
        User user = this._userPersistence.findByPrimaryKey(userId);
        long classNameId = this._classNameLocalService.getClassNameId(className);
        this.validate(0L, user.getCompanyId(), classNameId, classPK, address, typeId, primary);
        long emailAddressId = this.counterLocalService.increment();
        EmailAddress emailAddress = this.emailAddressPersistence.create(emailAddressId);
        emailAddress.setUuid(serviceContext.getUuid());
        emailAddress.setCompanyId(user.getCompanyId());
        emailAddress.setUserId(user.getUserId());
        emailAddress.setUserName(user.getFullName());
        emailAddress.setClassNameId(classNameId);
        emailAddress.setClassPK(classPK);
        emailAddress.setAddress(address);
        emailAddress.setTypeId(typeId);
        emailAddress.setPrimary(primary);
        return (EmailAddress)this.emailAddressPersistence.update((BaseModel)emailAddress);
    }

    @Override
    @SystemEvent(action=1, type=1)
    public EmailAddress deleteEmailAddress(EmailAddress emailAddress) {
        this.emailAddressPersistence.remove((BaseModel)emailAddress);
        return emailAddress;
    }

    @Override
    public EmailAddress deleteEmailAddress(long emailAddressId) throws PortalException {
        EmailAddress emailAddress = this.emailAddressPersistence.findByPrimaryKey(emailAddressId);
        return this.emailAddressLocalService.deleteEmailAddress(emailAddress);
    }

    public void deleteEmailAddresses(long companyId, String className, long classPK) {
        List emailAddresses = this.emailAddressPersistence.findByC_C_C(companyId, this._classNameLocalService.getClassNameId(className), classPK);
        for (EmailAddress emailAddress : emailAddresses) {
            this.emailAddressLocalService.deleteEmailAddress(emailAddress);
        }
    }

    public List<EmailAddress> getEmailAddresses() {
        return this.emailAddressPersistence.findAll();
    }

    public List<EmailAddress> getEmailAddresses(long companyId, String className, long classPK) {
        return this.emailAddressPersistence.findByC_C_C(companyId, this._classNameLocalService.getClassNameId(className), classPK);
    }

    public EmailAddress updateEmailAddress(long emailAddressId, String address, long typeId, boolean primary) throws PortalException {
        this.validate(emailAddressId, 0L, 0L, 0L, address, typeId, primary);
        EmailAddress emailAddress = this.emailAddressPersistence.findByPrimaryKey(emailAddressId);
        emailAddress.setAddress(address);
        emailAddress.setTypeId(typeId);
        emailAddress.setPrimary(primary);
        return (EmailAddress)this.emailAddressPersistence.update((BaseModel)emailAddress);
    }

    protected void validate(long emailAddressId, long companyId, long classNameId, long classPK, boolean primary) {
        if (primary) {
            List emailAddresses = this.emailAddressPersistence.findByC_C_C_P(companyId, classNameId, classPK, primary);
            for (EmailAddress emailAddress : emailAddresses) {
                if (emailAddressId > 0L && emailAddress.getEmailAddressId() == emailAddressId) continue;
                emailAddress.setPrimary(false);
                this.emailAddressPersistence.update((BaseModel)emailAddress);
            }
        }
    }

    protected void validate(long emailAddressId, long companyId, long classNameId, long classPK, String address, long typeId, boolean primary) throws PortalException {
        if (!Validator.isEmailAddress((String)address)) {
            throw new EmailAddressException();
        }
        if (emailAddressId > 0L) {
            EmailAddress emailAddress = this.emailAddressPersistence.findByPrimaryKey(emailAddressId);
            companyId = emailAddress.getCompanyId();
            classNameId = emailAddress.getClassNameId();
            classPK = emailAddress.getClassPK();
        }
        this._listTypeLocalService.validate(typeId, classNameId, ".emailAddress");
        this.validate(emailAddressId, companyId, classNameId, classPK, primary);
    }
}

