/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.announcements.kernel.service.AnnouncementsDeliveryLocalService;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.mail.kernel.model.MailMessage;
import com.liferay.mail.kernel.service.MailService;
import com.liferay.mail.kernel.template.MailTemplate;
import com.liferay.mail.kernel.template.MailTemplateContext;
import com.liferay.mail.kernel.template.MailTemplateContextBuilder;
import com.liferay.mail.kernel.template.MailTemplateFactoryUtil;
import com.liferay.petra.encryptor.Encryptor;
import com.liferay.petra.encryptor.EncryptorException;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheMapSynchronizeUtil;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.WildcardMode;
import com.liferay.portal.kernel.exception.CompanyMaxUsersException;
import com.liferay.portal.kernel.exception.ContactBirthdayException;
import com.liferay.portal.kernel.exception.ContactNameException;
import com.liferay.portal.kernel.exception.DuplicateGoogleUserIdException;
import com.liferay.portal.kernel.exception.DuplicateOpenIdException;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.NoSuchImageException;
import com.liferay.portal.kernel.exception.NoSuchOrganizationException;
import com.liferay.portal.kernel.exception.NoSuchTicketException;
import com.liferay.portal.kernel.exception.PasswordExpiredException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.PwdEncryptorException;
import com.liferay.portal.kernel.exception.RequiredRoleException;
import com.liferay.portal.kernel.exception.RequiredUserException;
import com.liferay.portal.kernel.exception.SendPasswordException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.exception.UserEmailAddressException;
import com.liferay.portal.kernel.exception.UserIdException;
import com.liferay.portal.kernel.exception.UserLockoutException;
import com.liferay.portal.kernel.exception.UserPasswordException;
import com.liferay.portal.kernel.exception.UserReminderQueryException;
import com.liferay.portal.kernel.exception.UserScreenNameException;
import com.liferay.portal.kernel.exception.UserSmsException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.PasswordPolicy;
import com.liferay.portal.kernel.model.PortalPreferences;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.model.Ticket;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.module.util.ServiceLatch;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.EmailAddressGenerator;
import com.liferay.portal.kernel.security.auth.EmailAddressValidator;
import com.liferay.portal.kernel.security.auth.FullNameDefinition;
import com.liferay.portal.kernel.security.auth.FullNameDefinitionFactory;
import com.liferay.portal.kernel.security.auth.FullNameGenerator;
import com.liferay.portal.kernel.security.auth.FullNameGeneratorFactory;
import com.liferay.portal.kernel.security.auth.FullNameValidator;
import com.liferay.portal.kernel.security.auth.PasswordModificationThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.auth.ScreenNameGenerator;
import com.liferay.portal.kernel.security.auth.ScreenNameValidator;
import com.liferay.portal.kernel.security.ldap.LDAPSettingsUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.pwd.PasswordEncryptorUtil;
import com.liferay.portal.kernel.service.BaseServiceImpl;
import com.liferay.portal.kernel.service.BrowserTrackerLocalService;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ContactLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.MembershipRequestLocalService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.PasswordPolicyLocalService;
import com.liferay.portal.kernel.service.PasswordPolicyRelLocalService;
import com.liferay.portal.kernel.service.PasswordTrackerLocalService;
import com.liferay.portal.kernel.service.PortalPreferencesLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.service.RecentLayoutBranchLocalService;
import com.liferay.portal.kernel.service.RecentLayoutRevisionLocalService;
import com.liferay.portal.kernel.service.RecentLayoutSetBranchLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.TicketLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserIdMapperLocalService;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalService;
import com.liferay.portal.kernel.service.persistence.CompanyPersistence;
import com.liferay.portal.kernel.service.persistence.ContactPersistence;
import com.liferay.portal.kernel.service.persistence.GroupPersistence;
import com.liferay.portal.kernel.service.persistence.OrganizationPersistence;
import com.liferay.portal.kernel.service.persistence.RolePersistence;
import com.liferay.portal.kernel.service.persistence.TeamPersistence;
import com.liferay.portal.kernel.service.persistence.UserGroupPersistence;
import com.liferay.portal.kernel.service.persistence.UserGroupRolePersistence;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PwdGenerator;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.model.impl.LayoutImpl;
import com.liferay.portal.model.impl.UserCacheModel;
import com.liferay.portal.model.impl.UserImpl;
import com.liferay.portal.security.auth.AuthPipeline;
import com.liferay.portal.security.auth.EmailAddressGeneratorFactory;
import com.liferay.portal.security.auth.EmailAddressValidatorFactory;
import com.liferay.portal.security.auth.FullNameValidatorFactory;
import com.liferay.portal.security.auth.ScreenNameGeneratorFactory;
import com.liferay.portal.security.auth.ScreenNameValidatorFactory;
import com.liferay.portal.security.pwd.PwdAuthenticator;
import com.liferay.portal.security.pwd.PwdToolkitUtil;
import com.liferay.portal.security.pwd.RegExpToolkit;
import com.liferay.portal.service.base.UserLocalServiceBaseImpl;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.ratings.kernel.service.RatingsStatsLocalService;
import com.liferay.social.kernel.model.SocialRelation;
import com.liferay.social.kernel.service.SocialActivityLocalService;
import com.liferay.social.kernel.service.SocialRequestLocalService;
import com.liferay.social.kernel.service.persistence.SocialRelationPersistence;
import com.liferay.users.admin.kernel.file.uploads.UserFileUploadsSettings;
import com.liferay.users.admin.kernel.util.UsersAdminUtil;
import java.io.IOException;
import java.io.Serializable;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.mail.internet.InternetAddress;
import javax.portlet.PortletPreferences;

public class UserLocalServiceImpl
extends UserLocalServiceBaseImpl {
    @BeanReference(type=MailService.class)
    protected MailService mailService;
    private static final Log _log = LogFactoryUtil.getLog(UserLocalServiceImpl.class);
    private static volatile UserFileUploadsSettings _userFileUploadsSettings = (UserFileUploadsSettings)ServiceProxyFactory.newServiceTrackedInstance(UserFileUploadsSettings.class, UserLocalServiceImpl.class, (String)"_userFileUploadsSettings", (boolean)false);
    @BeanReference(type=AnnouncementsDeliveryLocalService.class)
    private AnnouncementsDeliveryLocalService _announcementsDeliveryLocalService;
    @BeanReference(type=AssetEntryLocalService.class)
    private AssetEntryLocalService _assetEntryLocalService;
    @BeanReference(type=BrowserTrackerLocalService.class)
    private BrowserTrackerLocalService _browserTrackerLocalService;
    @BeanReference(type=CompanyLocalService.class)
    private CompanyLocalService _companyLocalService;
    @BeanReference(type=CompanyPersistence.class)
    private CompanyPersistence _companyPersistence;
    @BeanReference(type=ContactLocalService.class)
    private ContactLocalService _contactLocalService;
    @BeanReference(type=ContactPersistence.class)
    private ContactPersistence _contactPersistence;
    private final Map<Long, User> _defaultUsers = new ConcurrentHashMap<Long, User>();
    @BeanReference(type=ExpandoRowLocalService.class)
    private ExpandoRowLocalService _expandoRowLocalService;
    @BeanReference(type=GroupLocalService.class)
    private GroupLocalService _groupLocalService;
    @BeanReference(type=GroupPersistence.class)
    private GroupPersistence _groupPersistence;
    @BeanReference(type=ImageLocalService.class)
    private ImageLocalService _imageLocalService;
    @BeanReference(type=LayoutLocalService.class)
    private LayoutLocalService _layoutLocalService;
    @BeanReference(type=MembershipRequestLocalService.class)
    private MembershipRequestLocalService _membershipRequestLocalService;
    @BeanReference(type=OrganizationLocalService.class)
    private OrganizationLocalService _organizationLocalService;
    @BeanReference(type=OrganizationPersistence.class)
    private OrganizationPersistence _organizationPersistence;
    @BeanReference(type=PasswordPolicyLocalService.class)
    private PasswordPolicyLocalService _passwordPolicyLocalService;
    @BeanReference(type=PasswordPolicyRelLocalService.class)
    private PasswordPolicyRelLocalService _passwordPolicyRelLocalService;
    @BeanReference(type=PasswordTrackerLocalService.class)
    private PasswordTrackerLocalService _passwordTrackerLocalService;
    @BeanReference(type=PortalPreferencesLocalService.class)
    private PortalPreferencesLocalService _portalPreferencesLocalService;
    @BeanReference(type=PortletPreferencesLocalService.class)
    private PortletPreferencesLocalService _portletPreferencesLocalService;
    @BeanReference(type=RatingsStatsLocalService.class)
    private RatingsStatsLocalService _ratingsStatsLocalService;
    @BeanReference(type=RecentLayoutBranchLocalService.class)
    private RecentLayoutBranchLocalService _recentLayoutBranchLocalService;
    @BeanReference(type=RecentLayoutRevisionLocalService.class)
    private RecentLayoutRevisionLocalService _recentLayoutRevisionLocalService;
    @BeanReference(type=RecentLayoutSetBranchLocalService.class)
    private RecentLayoutSetBranchLocalService _recentLayoutSetBranchLocalService;
    @BeanReference(type=ResourceLocalService.class)
    private ResourceLocalService _resourceLocalService;
    @BeanReference(type=RoleLocalService.class)
    private RoleLocalService _roleLocalService;
    @BeanReference(type=RolePersistence.class)
    private RolePersistence _rolePersistence;
    @BeanReference(type=SocialActivityLocalService.class)
    private SocialActivityLocalService _socialActivityLocalService;
    @BeanReference(type=SocialRelationPersistence.class)
    private SocialRelationPersistence _socialRelationPersistence;
    @BeanReference(type=SocialRequestLocalService.class)
    private SocialRequestLocalService _socialRequestLocalService;
    private final PortalCacheMapSynchronizeUtil.Synchronizer<Serializable, Serializable> _synchronizer = new PortalCacheMapSynchronizeUtil.Synchronizer<Serializable, Serializable>(){

        public void onSynchronize(Map<? extends Serializable, ? extends Serializable> map, Serializable key, Serializable value, int timeToLive) {
            if (!(value instanceof UserCacheModel)) {
                return;
            }
            UserCacheModel userCacheModel = (UserCacheModel)value;
            if (userCacheModel.defaultUser) {
                UserLocalServiceImpl.this._defaultUsers.remove(userCacheModel.companyId);
            }
        }
    };
    @BeanReference(type=TeamPersistence.class)
    private TeamPersistence _teamPersistence;
    @BeanReference(type=TicketLocalService.class)
    private TicketLocalService _ticketLocalService;
    @BeanReference(type=UserGroupPersistence.class)
    private UserGroupPersistence _userGroupPersistence;
    @BeanReference(type=UserGroupRoleLocalService.class)
    private UserGroupRoleLocalService _userGroupRoleLocalService;
    @BeanReference(type=UserGroupRolePersistence.class)
    private UserGroupRolePersistence _userGroupRolePersistence;
    @BeanReference(type=UserIdMapperLocalService.class)
    private UserIdMapperLocalService _userIdMapperLocalService;
    @BeanReference(type=WorkflowInstanceLinkLocalService.class)
    private WorkflowInstanceLinkLocalService _workflowInstanceLinkLocalService;

    public User addDefaultAdminUser(long companyId, String screenName, String emailAddress, Locale locale, String firstName, String middleName, String lastName) throws PortalException {
        User screenNameUser;
        String password1;
        long creatorUserId = 0L;
        boolean autoPassword = false;
        String password2 = password1 = PropsValues.DEFAULT_ADMIN_PASSWORD;
        boolean autoScreenName = false;
        screenName = this.getLogin(screenName);
        int i = 1;
        while ((screenNameUser = this.userPersistence.fetchByC_SN(companyId, screenName)) != null) {
            screenName = screenName + i;
            ++i;
        }
        long facebookId = 0L;
        String openId = "";
        long prefixId = 0L;
        long suffixId = 0L;
        boolean male = true;
        int birthdayMonth = 0;
        int birthdayDay = 1;
        int birthdayYear = 1970;
        String jobTitle = "";
        Group guestGroup = this._groupLocalService.getGroup(companyId, "Guest");
        long[] groupIds = new long[]{guestGroup.getGroupId()};
        long[] organizationIds = null;
        Role adminRole = this._roleLocalService.getRole(companyId, "Administrator");
        Role powerUserRole = this._roleLocalService.getRole(companyId, "Power User");
        long[] roleIds = new long[]{adminRole.getRoleId(), powerUserRole.getRoleId()};
        long[] userGroupIds = null;
        boolean sendEmail = false;
        ServiceContext serviceContext = new ServiceContext();
        Company company = this._companyLocalService.getCompany(companyId);
        serviceContext.setPathMain(PortalUtil.getPathMain());
        serviceContext.setPortalURL(company.getPortalURL(0L));
        User defaultAdminUser = this.addUser(creatorUserId, companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, openId, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, sendEmail, serviceContext);
        this.updateEmailAddressVerified(defaultAdminUser.getUserId(), true);
        this.updateLastLogin(defaultAdminUser.getUserId(), defaultAdminUser.getLoginIP());
        this.updatePasswordReset(defaultAdminUser.getUserId(), false);
        return defaultAdminUser;
    }

    public boolean addDefaultGroups(long userId) throws PortalException {
        String[] defaultOrganizationGroupNames;
        Group group;
        String[] defaultGroupNames;
        User user = this.userPersistence.findByPrimaryKey(userId);
        long[] userGroupIds = user.getGroupIds();
        HashSet<Long> groupIdsSet = new HashSet<Long>();
        for (String defaultGroupName : defaultGroupNames = PrefsPropsUtil.getStringArray(user.getCompanyId(), "admin.default.group.names", "\n", PropsValues.ADMIN_DEFAULT_GROUP_NAMES)) {
            Company company = this._companyPersistence.findByPrimaryKey(user.getCompanyId());
            if (StringUtil.equalsIgnoreCase((String)defaultGroupName, (String)company.getName())) {
                defaultGroupName = "Guest";
            }
            if ((group = this._groupPersistence.fetchByC_GK(user.getCompanyId(), defaultGroupName)) == null) continue;
            if (!ArrayUtil.contains((long[])userGroupIds, (long)group.getGroupId())) {
                groupIdsSet.add(group.getGroupId());
                continue;
            }
            this.addDefaultRolesAndTeams(group.getGroupId(), new long[]{user.getUserId()});
        }
        for (String defaultOrganizationGroupName : defaultOrganizationGroupNames = PrefsPropsUtil.getStringArray(user.getCompanyId(), "admin.default.organization.group.names", "\n", PropsValues.ADMIN_DEFAULT_ORGANIZATION_GROUP_NAMES)) {
            defaultOrganizationGroupName = defaultOrganizationGroupName + " LFR_ORGANIZATION";
            group = this._groupPersistence.fetchByC_GK(user.getCompanyId(), defaultOrganizationGroupName);
            if (group == null) continue;
            if (!ArrayUtil.contains((long[])userGroupIds, (long)group.getGroupId())) {
                groupIdsSet.add(group.getGroupId());
                continue;
            }
            this.addDefaultRolesAndTeams(group.getGroupId(), new long[]{user.getUserId()});
        }
        if (groupIdsSet.isEmpty()) {
            return false;
        }
        long[] groupIds = ArrayUtil.toArray((Long[])groupIdsSet.toArray(new Long[0]));
        this.userPersistence.addGroups(userId, groupIds);
        for (long groupId : groupIds) {
            this.addDefaultRolesAndTeams(groupId, new long[]{userId});
        }
        return true;
    }

    public boolean addDefaultRoles(long userId) throws PortalException {
        String[] defaultRoleNames;
        User user = this.userPersistence.findByPrimaryKey(userId);
        long[] userRoleIds = user.getRoleIds();
        HashSet<Long> roleIdSet = new HashSet<Long>();
        for (String defaultRoleName : defaultRoleNames = PrefsPropsUtil.getStringArray(user.getCompanyId(), "admin.default.role.names", "\n", PropsValues.ADMIN_DEFAULT_ROLE_NAMES)) {
            Role role = this._rolePersistence.fetchByC_N(user.getCompanyId(), defaultRoleName);
            if (role == null || role.getType() != 1 || ArrayUtil.contains((long[])userRoleIds, (long)role.getRoleId())) continue;
            roleIdSet.add(role.getRoleId());
        }
        if (roleIdSet.isEmpty()) {
            return false;
        }
        long[] roleIds = ArrayUtil.toArray((Long[])roleIdSet.toArray(new Long[0]));
        roleIds = UsersAdminUtil.addRequiredRoles((User)user, (long[])roleIds);
        this.userPersistence.addRoles(userId, roleIds);
        return true;
    }

    public boolean addDefaultUserGroups(long userId) throws PortalException {
        String[] defaultUserGroupNames;
        User user = this.userPersistence.findByPrimaryKey(userId);
        long[] userUserGroupIds = user.getUserGroupIds();
        HashSet<Long> userGroupIdSet = new HashSet<Long>();
        for (String defaultUserGroupName : defaultUserGroupNames = PrefsPropsUtil.getStringArray(user.getCompanyId(), "admin.default.user.group.names", "\n", PropsValues.ADMIN_DEFAULT_USER_GROUP_NAMES)) {
            UserGroup userGroup = this._userGroupPersistence.fetchByC_N(user.getCompanyId(), defaultUserGroupName);
            if (userGroup == null || ArrayUtil.contains((long[])userUserGroupIds, (long)userGroup.getUserGroupId())) continue;
            userGroupIdSet.add(userGroup.getUserGroupId());
        }
        if (userGroupIdSet.isEmpty()) {
            return false;
        }
        long[] userGroupIds = ArrayUtil.toArray((Long[])userGroupIdSet.toArray(new Long[0]));
        this.userPersistence.addUserGroups(userId, userGroupIds);
        return true;
    }

    @Override
    public void addGroupUser(long groupId, long userId) {
        this._groupPersistence.addUser(groupId, userId);
        try {
            this.reindex(userId);
            this.addDefaultRolesAndTeams(groupId, new long[]{userId});
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    @Override
    public void addGroupUser(long groupId, User user) {
        this.addGroupUser(groupId, user.getUserId());
    }

    @Override
    public void addGroupUsers(long groupId, List<User> users) throws PortalException {
        ArrayList<Long> userIds = new ArrayList<Long>();
        for (User user : users) {
            userIds.add(user.getUserId());
        }
        this.addGroupUsers(groupId, ArrayUtil.toLongArray(userIds));
    }

    @Override
    public void addGroupUsers(long groupId, long[] userIds) throws PortalException {
        this._groupPersistence.addUsers(groupId, userIds);
        this.reindex(userIds);
        this.addDefaultRolesAndTeams(groupId, userIds);
    }

    @Override
    public void addOrganizationUser(long organizationId, long userId) {
        this._organizationPersistence.addUser(organizationId, userId);
        try {
            this.reindex(userId);
        }
        catch (SearchException searchException) {
            throw new SystemException((Throwable)searchException);
        }
    }

    @Override
    public void addOrganizationUser(long organizationId, User user) {
        this._organizationPersistence.addUser(organizationId, user);
        try {
            this.reindex(user);
        }
        catch (SearchException searchException) {
            throw new SystemException((Throwable)searchException);
        }
    }

    @Override
    public void addOrganizationUsers(long organizationId, List<User> users) throws PortalException {
        this._organizationPersistence.addUsers(organizationId, users);
        this.reindex(users);
    }

    @Override
    public void addOrganizationUsers(long organizationId, long[] userIds) throws PortalException {
        this._organizationPersistence.addUsers(organizationId, userIds);
        this.reindex(userIds);
    }

    public User addOrUpdateUser(String externalReferenceCode, long creatorUserId, long companyId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, Locale locale, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String jobTitle, boolean sendEmail, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.fetchByC_ERC(companyId, externalReferenceCode);
        if (user == null) {
            user = this.addUserWithWorkflow(creatorUserId, companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, new long[0], new long[0], new long[0], new long[0], sendEmail, serviceContext);
            user.setExternalReferenceCode(externalReferenceCode);
            user = (User)this.userPersistence.update((BaseModel)user);
        } else {
            Contact contact = user.getContact();
            boolean hasPortrait = false;
            if (user.getPortraitId() > 0L) {
                hasPortrait = true;
            }
            user = this.updateUser(user.getUserId(), null, password1, password2, false, user.getReminderQueryQuestion(), user.getReminderQueryAnswer(), screenName, emailAddress, hasPortrait, null, user.getLanguageId(), user.getTimeZoneId(), user.getGreeting(), user.getComments(), firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, contact.getSmsSn(), contact.getFacebookSn(), contact.getJabberSn(), contact.getSkypeSn(), contact.getTwitterSn(), jobTitle, user.getGroupIds(), user.getOrganizationIds(), user.getRoleIds(), this._userGroupRoleLocalService.getUserGroupRoles(user.getUserId()), user.getUserGroupIds(), serviceContext);
        }
        return user;
    }

    public void addPasswordPolicyUsers(long passwordPolicyId, long[] userIds) {
        this._checkPasswordReset(this._passwordPolicyLocalService.fetchPasswordPolicy(passwordPolicyId), userIds);
        this._passwordPolicyRelLocalService.addPasswordPolicyRels(passwordPolicyId, User.class.getName(), userIds);
    }

    @Override
    public void addRoleUser(long roleId, long userId) {
        this._rolePersistence.addUser(roleId, userId);
        try {
            this.reindex(userId);
        }
        catch (SearchException searchException) {
            throw new SystemException((Throwable)searchException);
        }
    }

    @Override
    public void addRoleUser(long roleId, User user) {
        this._rolePersistence.addUser(roleId, user);
        try {
            this.reindex(user);
        }
        catch (SearchException searchException) {
            throw new SystemException((Throwable)searchException);
        }
    }

    @Override
    public void addRoleUsers(long roleId, List<User> users) throws PortalException {
        this._rolePersistence.addUsers(roleId, users);
        this.reindex(users);
    }

    @Override
    public void addRoleUsers(long roleId, long[] userIds) throws PortalException {
        this._rolePersistence.addUsers(roleId, userIds);
        this.reindex(userIds);
    }

    @Override
    public void addTeamUser(long teamId, long userId) {
        this._teamPersistence.addUser(teamId, userId);
        try {
            this.reindex(userId);
        }
        catch (SearchException searchException) {
            throw new SystemException((Throwable)searchException);
        }
    }

    @Override
    public void addTeamUser(long teamId, User user) {
        this._teamPersistence.addUser(teamId, user);
        try {
            this.reindex(user);
        }
        catch (SearchException searchException) {
            throw new SystemException((Throwable)searchException);
        }
    }

    @Override
    public void addTeamUsers(long teamId, List<User> users) throws PortalException {
        this._teamPersistence.addUsers(teamId, users);
        this.reindex(users);
    }

    @Override
    public void addTeamUsers(long teamId, long[] userIds) throws PortalException {
        this._teamPersistence.addUsers(teamId, userIds);
        this.reindex(userIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User addUser(long creatorUserId, long companyId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, Locale locale, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, long[] userGroupIds, boolean sendEmail, ServiceContext serviceContext) throws PortalException {
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        try {
            WorkflowThreadLocal.setEnabled((boolean)false);
            if (serviceContext == null) {
                serviceContext = new ServiceContext();
            }
            if (serviceContext.getWorkflowAction() != 1) {
                serviceContext.setWorkflowAction(1);
            }
            User user = this.addUserWithWorkflow(creatorUserId, companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, sendEmail, serviceContext);
            return user;
        }
        finally {
            WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public User addUser(long creatorUserId, long companyId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, long facebookId, String openId, Locale locale, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, long[] userGroupIds, boolean sendEmail, ServiceContext serviceContext) throws PortalException {
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        try {
            WorkflowThreadLocal.setEnabled((boolean)false);
            if (serviceContext == null) {
                serviceContext = new ServiceContext();
            }
            if (serviceContext.getWorkflowAction() != 1) {
                serviceContext.setWorkflowAction(1);
            }
            User user = this.addUserWithWorkflow(creatorUserId, companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, openId, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, sendEmail, serviceContext);
            return user;
        }
        finally {
            WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
        }
    }

    @Override
    public void addUserGroupUser(long userGroupId, long userId) {
        try {
            this._userGroupPersistence.addUser(userGroupId, userId);
            this.reindex(userId);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    @Override
    public void addUserGroupUser(long userGroupId, User user) {
        this.addUserGroupUser(userGroupId, user.getUserId());
    }

    @Override
    public void addUserGroupUsers(long userGroupId, List<User> users) throws PortalException {
        ArrayList<Long> userIds = new ArrayList<Long>();
        for (User user : users) {
            userIds.add(user.getUserId());
        }
        try {
            this.addUserGroupUsers(userGroupId, ArrayUtil.toLongArray(userIds));
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    @Override
    public void addUserGroupUsers(long userGroupId, long[] userIds) throws PortalException {
        this._userGroupPersistence.addUsers(userGroupId, userIds);
        this.reindex(userIds);
    }

    public User addUserWithWorkflow(long creatorUserId, long companyId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, Locale locale, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, long[] userGroupIds, boolean sendEmail, ServiceContext serviceContext) throws PortalException {
        String passwordUnencrypted;
        Map workflowContext;
        long workflowUserId;
        String uuid;
        screenName = this.getLogin(screenName);
        if (PrefsPropsUtil.getBoolean(companyId, "users.screen.name.always.autogenerate")) {
            autoScreenName = true;
        }
        long userId = this.counterLocalService.increment();
        EmailAddressGenerator emailAddressGenerator = EmailAddressGeneratorFactory.getInstance();
        emailAddress = emailAddress == null || emailAddressGenerator.isGenerated(emailAddress) ? "" : StringUtil.toLowerCase((String)emailAddress.trim());
        if (!PrefsPropsUtil.getBoolean(companyId, "users.email.address.required") && Validator.isNull((String)emailAddress)) {
            emailAddress = emailAddressGenerator.generate(companyId, userId);
        }
        this.validate(companyId, userId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, null, firstName, middleName, lastName, organizationIds, locale);
        if (!autoPassword && (Validator.isNull((String)password1) || Validator.isNull((String)password2))) {
            throw new UserPasswordException.MustNotBeNull(userId);
        }
        if (autoScreenName) {
            ScreenNameGenerator screenNameGenerator = ScreenNameGeneratorFactory.getInstance();
            try {
                screenName = screenNameGenerator.generate(companyId, userId, emailAddress);
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
        }
        User defaultUser = this.getDefaultUser(companyId);
        FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
        String fullName = fullNameGenerator.getFullName(firstName, middleName, lastName);
        String greeting = LanguageUtil.format((Locale)locale, (String)"welcome-x", (Object)fullName, (boolean)false);
        User user = this.userPersistence.create(userId);
        if (serviceContext != null && Validator.isNotNull((String)(uuid = serviceContext.getUuid()))) {
            user.setUuid(uuid);
        }
        user.setCompanyId(companyId);
        user.setDefaultUser(false);
        user.setContactId(this.counterLocalService.increment());
        if (Validator.isNotNull((String)password1)) {
            PasswordModificationThreadLocal.setPasswordModified((boolean)true);
            PasswordModificationThreadLocal.setPasswordUnencrypted((String)password1);
            user.setPassword(PasswordEncryptorUtil.encrypt((String)password1));
            user.setPasswordUnencrypted(password1);
        }
        user.setPasswordEncrypted(true);
        PasswordPolicy passwordPolicy = defaultUser.getPasswordPolicy();
        if (passwordPolicy != null && passwordPolicy.isChangeable() && passwordPolicy.isChangeRequired()) {
            user.setPasswordReset(true);
        } else {
            user.setPasswordReset(false);
        }
        user.setScreenName(screenName);
        user.setEmailAddress(emailAddress);
        user.setDigest(user.getDigest(password1));
        Long ldapServerId = null;
        if (serviceContext != null) {
            ldapServerId = (Long)serviceContext.getAttribute("ldapServerId");
        }
        if (ldapServerId != null) {
            user.setLdapServerId(ldapServerId.longValue());
        } else {
            user.setLdapServerId(-1L);
        }
        user.setLanguageId(LocaleUtil.toLanguageId((Locale)locale));
        user.setTimeZoneId(defaultUser.getTimeZoneId());
        user.setGreeting(greeting);
        user.setFirstName(firstName);
        user.setMiddleName(middleName);
        user.setLastName(lastName);
        user.setJobTitle(jobTitle);
        user.setStatus(2);
        user.setExpandoBridgeAttributes(serviceContext);
        user = (User)this.userPersistence.update((BaseModel)user, serviceContext);
        String creatorUserName = "";
        if (creatorUserId <= 0L) {
            creatorUserId = user.getUserId();
        } else {
            User creatorUser = this.userPersistence.findByPrimaryKey(creatorUserId);
            creatorUserName = creatorUser.getFullName();
        }
        Contact contact = this._contactPersistence.create(user.getContactId());
        contact.setCompanyId(user.getCompanyId());
        contact.setUserId(creatorUserId);
        contact.setUserName(creatorUserName);
        contact.setClassName(User.class.getName());
        contact.setClassPK(user.getUserId());
        contact.setParentContactId(0L);
        contact.setEmailAddress(user.getEmailAddress());
        contact.setFirstName(firstName);
        contact.setMiddleName(middleName);
        contact.setLastName(lastName);
        contact.setPrefixId(prefixId);
        contact.setSuffixId(suffixId);
        contact.setMale(male);
        contact.setBirthday(this.getBirthday(birthdayMonth, birthdayDay, birthdayYear));
        contact.setJobTitle(jobTitle);
        this._contactPersistence.update((BaseModel)contact, serviceContext);
        this._groupLocalService.addGroup(user.getUserId(), 0L, User.class.getName(), user.getUserId(), 0L, (Map)null, null, 0, true, 0, "/" + screenName, false, true, null);
        if (!ArrayUtil.isEmpty((long[])groupIds)) {
            ArrayList<Group> groups = new ArrayList<Group>();
            for (long groupId : groupIds) {
                Group group = this._groupLocalService.fetchGroup(groupId);
                if (group != null) {
                    groups.add(group);
                    continue;
                }
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Group " + groupId + " does not exist"));
            }
            this._groupLocalService.addUserGroups(userId, groups);
        }
        this.addDefaultGroups(userId);
        this.updateOrganizations(userId, organizationIds, false);
        if (roleIds != null) {
            roleIds = UsersAdminUtil.addRequiredRoles((User)user, (long[])roleIds);
            this.userPersistence.setRoles(userId, roleIds);
        }
        this.addDefaultRoles(userId);
        if (userGroupIds != null) {
            this.userPersistence.setUserGroups(userId, userGroupIds);
        }
        this.addDefaultUserGroups(userId);
        this._resourceLocalService.addResources(companyId, 0L, creatorUserId, User.class.getName(), user.getUserId(), false, false, false);
        if (serviceContext != null) {
            this.updateAsset(creatorUserId, user, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        }
        if (serviceContext == null || serviceContext.isIndexingEnabled()) {
            this.reindex(user);
        }
        if ((workflowUserId = creatorUserId) == userId) {
            workflowUserId = defaultUser.getUserId();
        }
        ServiceContext workflowServiceContext = new ServiceContext();
        if (serviceContext != null) {
            workflowServiceContext = (ServiceContext)serviceContext.clone();
        }
        if ((workflowContext = (Map)((Object)workflowServiceContext.removeAttribute("workflowContext"))) == null) {
            workflowContext = Collections.emptyMap();
        }
        workflowServiceContext.setAttributes(new HashMap());
        workflowServiceContext.setAttribute("autoPassword", (Serializable)Boolean.valueOf(autoPassword));
        workflowServiceContext.setAttribute("sendEmail", (Serializable)Boolean.valueOf(sendEmail));
        user = (User)WorkflowHandlerRegistryUtil.startWorkflowInstance((long)companyId, (long)0L, (long)workflowUserId, (String)User.class.getName(), (long)userId, (Object)user, (ServiceContext)workflowServiceContext, workflowContext);
        if (serviceContext != null && Validator.isNotNull((String)(passwordUnencrypted = (String)((Object)serviceContext.getAttribute("passwordUnencrypted"))))) {
            user.setPasswordUnencrypted(passwordUnencrypted);
        }
        return user;
    }

    @Deprecated
    public User addUserWithWorkflow(long creatorUserId, long companyId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, long facebookId, String openId, Locale locale, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, long[] userGroupIds, boolean sendEmail, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.addUserWithWorkflow(creatorUserId, companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, sendEmail, serviceContext);
        openId = StringUtil.trim((String)openId);
        this.validateOpenId(companyId, user.getUserId(), openId);
        user.setFacebookId(facebookId);
        user.setOpenId(openId);
        return this.userLocalService.updateUser(user);
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        ServiceLatch serviceLatch = SystemBundleUtil.newServiceLatch();
        serviceLatch.waitFor(EntityCache.class, entityCache -> PortalCacheMapSynchronizeUtil.synchronize((PortalCache)entityCache.getPortalCache(UserImpl.class), this._defaultUsers, this._synchronizer));
        serviceLatch.openOn(() -> {});
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public int authenticateByEmailAddress(long companyId, String emailAddress, String password, Map<String, String[]> headerMap, Map<String, String[]> parameterMap, Map<String, Object> resultsMap) throws PortalException {
        return this.authenticate(companyId, emailAddress, password, "emailAddress", headerMap, parameterMap, resultsMap);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public int authenticateByScreenName(long companyId, String screenName, String password, Map<String, String[]> headerMap, Map<String, String[]> parameterMap, Map<String, Object> resultsMap) throws PortalException {
        return this.authenticate(companyId, screenName, password, "screenName", headerMap, parameterMap, resultsMap);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public int authenticateByUserId(long companyId, long userId, String password, Map<String, String[]> headerMap, Map<String, String[]> parameterMap, Map<String, Object> resultsMap) throws PortalException {
        return this.authenticate(companyId, String.valueOf(userId), password, "userId", headerMap, parameterMap, resultsMap);
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public long authenticateForBasic(long companyId, String authType, String login, String password) throws PortalException {
        if (PropsValues.AUTH_LOGIN_DISABLED) {
            return 0L;
        }
        User user = null;
        if (authType.equals("emailAddress")) {
            user = this.fetchUserByEmailAddress(companyId, login);
        } else if (authType.equals("screenName")) {
            user = this.fetchUserByScreenName(companyId, login);
        } else if (authType.equals("userId")) {
            user = this.userPersistence.fetchByPrimaryKey(GetterUtil.getLong((String)login));
        }
        if (user == null || !this.isUserAllowedToAuthenticate(user)) {
            return 0L;
        }
        user = this._checkPasswordPolicy(user);
        if (!PropsValues.BASIC_AUTH_PASSWORD_REQUIRED) {
            return user.getUserId();
        }
        String userPassword = user.getPassword();
        if (!user.isPasswordEncrypted()) {
            userPassword = PasswordEncryptorUtil.encrypt((String)userPassword);
        }
        String encPassword = PasswordEncryptorUtil.encrypt((String)password, (String)userPassword);
        if (userPassword.equals(password) || userPassword.equals(encPassword)) {
            this.resetFailedLoginAttempts(user);
            return user.getUserId();
        }
        this.handleAuthenticationFailure(login, authType, user, Collections.emptyMap(), Collections.emptyMap());
        return 0L;
    }

    @Deprecated
    @Transactional(propagation=Propagation.SUPPORTS)
    public long authenticateForDigest(long companyId, String userName, String realm, String nonce, String method, String uri, String response) throws PortalException {
        String[] digestArray;
        if (PropsValues.AUTH_LOGIN_DISABLED) {
            return 0L;
        }
        User user = this.fetchUserByEmailAddress(companyId, userName);
        if (user == null) {
            user = this.fetchUserByScreenName(companyId, userName);
        }
        if (user == null) {
            user = this.userPersistence.fetchByPrimaryKey(GetterUtil.getLong((String)userName));
        }
        if (user == null || !this.isUserAllowedToAuthenticate(user)) {
            return 0L;
        }
        if (Validator.isNull((String)(user = this._checkPasswordPolicy(user)).getDigest())) {
            _log.error((Object)("User must first login through the portal " + user.getUserId()));
            return 0L;
        }
        for (String ha1 : digestArray = StringUtil.split((String)user.getDigest())) {
            String ha2 = DigesterUtil.digestHex((String)"MD5", (String[])new String[]{method, uri});
            String curResponse = DigesterUtil.digestHex((String)"MD5", (String[])new String[]{ha1, nonce, ha2});
            if (!response.equals(curResponse)) continue;
            this.resetFailedLoginAttempts(user);
            return user.getUserId();
        }
        Company company = this._companyPersistence.findByPrimaryKey(companyId);
        this.handleAuthenticationFailure(userName, company.getAuthType(), user, new HashMap<String, String[]>(), new HashMap<String, String[]>());
        return 0L;
    }

    @Deprecated
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public boolean authenticateForJAAS(long userId, String encPassword) {
        if (PropsValues.AUTH_LOGIN_DISABLED) {
            return false;
        }
        try {
            User user = this.userPersistence.findByPrimaryKey(userId);
            if (user.isDefaultUser()) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"JAAS authentication is disabled for the default user");
                }
                return false;
            }
            if (!user.isActive()) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("JAAS authentication is disabled for inactive user " + userId));
                }
                return false;
            }
            String userPassword = user.getPassword();
            if (user.isPasswordEncrypted()) {
                if (userPassword.equals(encPassword)) {
                    return true;
                }
                if (!PropsValues.PORTAL_JAAS_STRICT_PASSWORD && userPassword.equals(encPassword = PasswordEncryptorUtil.encrypt((String)encPassword, (String)userPassword))) {
                    return true;
                }
            } else {
                if (!PropsValues.PORTAL_JAAS_STRICT_PASSWORD && userPassword.equals(encPassword)) {
                    return true;
                }
                if ((userPassword = PasswordEncryptorUtil.encrypt((String)userPassword, (String)encPassword)).equals(encPassword)) {
                    return true;
                }
            }
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to authenticate for JAAS", (Throwable)exception);
        }
        return false;
    }

    public void checkLockout(User user) throws PortalException {
        if (LDAPSettingsUtil.isPasswordPolicyEnabled((long)user.getCompanyId())) {
            return;
        }
        this.doCheckLockout(user, user.getPasswordPolicy());
    }

    public void checkLoginFailure(User user) {
        int failedLoginAttempts = user.getFailedLoginAttempts();
        user.setLastFailedLoginDate(new Date());
        user.setFailedLoginAttempts(++failedLoginAttempts);
        this.userPersistence.update((BaseModel)user);
    }

    public void checkLoginFailureByEmailAddress(long companyId, String emailAddress) throws PortalException {
        User user = this.getUserByEmailAddress(companyId, emailAddress);
        this.checkLoginFailure(user);
    }

    public void checkLoginFailureById(long userId) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        this.checkLoginFailure(user);
    }

    public void checkLoginFailureByScreenName(long companyId, String screenName) throws PortalException {
        User user = this.getUserByScreenName(companyId, screenName);
        this.checkLoginFailure(user);
    }

    public void checkPasswordExpired(User user) throws PortalException {
        if (LDAPSettingsUtil.isPasswordPolicyEnabled((long)user.getCompanyId())) {
            return;
        }
        this.doCheckPasswordExpired(user, user.getPasswordPolicy());
    }

    public void completeUserRegistration(User user, ServiceContext serviceContext) throws PortalException {
        boolean autoPassword = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"autoPassword");
        String password = "";
        if (autoPassword) {
            if (LDAPSettingsUtil.isPasswordPolicyEnabled((long)user.getCompanyId())) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"When LDAP password policy is enabled, it is ", "possible that portal generated passwords will ", "not match the LDAP policy. Using RegExpToolkit ", "to generate new password."}));
                }
                RegExpToolkit regExpToolkit = new RegExpToolkit();
                password = regExpToolkit.generate(null);
            } else {
                PasswordPolicy passwordPolicy = this._passwordPolicyLocalService.getPasswordPolicy(user.getCompanyId(), user.getOrganizationIds());
                password = PwdToolkitUtil.generate(passwordPolicy);
            }
            serviceContext.setAttribute("passwordUnencrypted", (Serializable)((Object)password));
            PasswordModificationThreadLocal.setPasswordModified((boolean)true);
            PasswordModificationThreadLocal.setPasswordUnencrypted((String)password);
            user.setPassword(PasswordEncryptorUtil.encrypt((String)password));
            user.setPasswordUnencrypted(password);
            user.setPasswordEncrypted(true);
            user.setPasswordModified(true);
            user.setPasswordModifiedDate(new Date());
            user = (User)this.userPersistence.update((BaseModel)user);
            user.setPasswordModified(false);
        }
        if (user.hasCompanyMx()) {
            this.mailService.addUser(user.getCompanyId(), user.getUserId(), password, user.getFirstName(), user.getMiddleName(), user.getLastName(), user.getEmailAddress());
        }
        boolean adminEmailUserAddedEnabled = PrefsPropsUtil.getBoolean(user.getCompanyId(), "admin.email.user.added.enabled");
        boolean sendEmail = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"sendEmail");
        if (adminEmailUserAddedEnabled && autoPassword && sendEmail) {
            this.notifyUser(user, serviceContext);
            return;
        }
        Company company = this._companyPersistence.findByPrimaryKey(user.getCompanyId());
        if (company.isStrangersVerify() && user.getLdapServerId() < 0L) {
            this.sendEmailAddressVerification(user, user.getEmailAddress(), serviceContext);
        } else if (adminEmailUserAddedEnabled && sendEmail) {
            this.notifyUser(user, serviceContext);
        }
    }

    public KeyValuePair decryptUserId(long companyId, String name, String password) throws PortalException {
        Company company = this._companyPersistence.findByPrimaryKey(companyId);
        try {
            name = Encryptor.decrypt((Key)company.getKeyObj(), (String)name);
        }
        catch (EncryptorException encryptorException) {
            throw new SystemException((Throwable)encryptorException);
        }
        try {
            password = Encryptor.decrypt((Key)company.getKeyObj(), (String)password);
        }
        catch (EncryptorException encryptorException) {
            throw new SystemException((Throwable)encryptorException);
        }
        long userId = GetterUtil.getLong((String)name);
        User user = this.userPersistence.findByPrimaryKey(userId);
        String userPassword = user.getPassword();
        String encPassword = PasswordEncryptorUtil.encrypt((String)password, (String)userPassword);
        if (userPassword.equals(encPassword)) {
            if (this.isPasswordExpired(user)) {
                user.setPasswordReset(true);
                this.userPersistence.update((BaseModel)user);
            }
            return new KeyValuePair(name, password);
        }
        throw new PrincipalException.MustBeAuthenticated(userId);
    }

    public void deletePortrait(long userId) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        PortalUtil.updateImageId((BaseModel)user, (boolean)false, null, (String)"portraitId", (long)0L, (int)0, (int)0);
    }

    @Override
    public void deleteRoleUser(long roleId, long userId) throws PortalException {
        this._rolePersistence.removeUser(roleId, userId);
        this.reindex(userId);
    }

    @Override
    public User deleteUser(long userId) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        return this.deleteUser(user);
    }

    @Override
    public User deleteUser(User user) throws PortalException {
        block7: {
            if (!PropsValues.USERS_DELETE) {
                throw new RequiredUserException();
            }
            this._browserTrackerLocalService.deleteUserBrowserTracker(user.getUserId());
            Group group = null;
            if (!user.isDefaultUser()) {
                group = user.getGroup();
            }
            if (group != null) {
                this._groupLocalService.deleteGroup(group);
            }
            try {
                this._imageLocalService.deleteImage(user.getPortraitId());
            }
            catch (NoSuchImageException noSuchImageException) {
                if (!_log.isWarnEnabled()) break block7;
                _log.warn((Object)("Unable to delete image " + user.getPortraitId()), (Throwable)noSuchImageException);
            }
        }
        this._passwordPolicyRelLocalService.deletePasswordPolicyRel(User.class.getName(), user.getUserId());
        this._passwordTrackerLocalService.deletePasswordTrackers(user.getUserId());
        this._userIdMapperLocalService.deleteUserIdMappers(user.getUserId());
        this._announcementsDeliveryLocalService.deleteDeliveries(user.getUserId());
        this._assetEntryLocalService.deleteEntry(User.class.getName(), user.getUserId());
        this._expandoRowLocalService.deleteRows(user.getUserId());
        this._membershipRequestLocalService.deleteMembershipRequestsByUserId(user.getUserId());
        PortalPreferences portalPreferences = this._portalPreferencesLocalService.fetchPortalPreferences(user.getUserId(), 4);
        if (portalPreferences != null) {
            this._portalPreferencesLocalService.deletePortalPreferences(portalPreferences);
        }
        this._portletPreferencesLocalService.deletePortletPreferencesByOwnerId(user.getUserId());
        this._ratingsStatsLocalService.deleteStats(User.class.getName(), user.getUserId());
        this._socialActivityLocalService.deleteUserActivities(user.getUserId());
        this._socialRequestLocalService.deleteReceiverUserRequests(user.getUserId());
        this._socialRequestLocalService.deleteUserRequests(user.getUserId());
        this._ticketLocalService.deleteTickets(user.getCompanyId(), User.class.getName(), user.getUserId());
        this.mailService.deleteUser(user.getCompanyId(), user.getUserId());
        Contact contact = this._contactLocalService.fetchContact(user.getContactId());
        if (contact != null) {
            this._contactLocalService.deleteContact(contact);
        }
        this._userGroupRoleLocalService.deleteUserGroupRolesByUserId(user.getUserId());
        this._recentLayoutBranchLocalService.deleteUserRecentLayoutBranches(user.getUserId());
        this._recentLayoutRevisionLocalService.deleteUserRecentLayoutRevisions(user.getUserId());
        this._recentLayoutSetBranchLocalService.deleteUserRecentLayoutSetBranches(user.getUserId());
        this._resourceLocalService.deleteResource(user.getCompanyId(), User.class.getName(), 4, user.getUserId());
        this.userPersistence.remove((BaseModel)user);
        this._workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(user.getCompanyId(), 0L, User.class.getName(), user.getUserId());
        return user;
    }

    @Override
    public void deleteUserGroupUser(long userGroupId, long userId) throws PortalException {
        this._userGroupPersistence.removeUser(userGroupId, userId);
        this.reindex(userId);
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public String encryptUserId(String name) throws PortalException {
        long userId = GetterUtil.getLong((String)name);
        User user = this.userPersistence.findByPrimaryKey(userId);
        Company company = this._companyPersistence.findByPrimaryKey(user.getCompanyId());
        try {
            return Encryptor.encrypt((Key)company.getKeyObj(), (String)name);
        }
        catch (EncryptorException encryptorException) {
            throw new SystemException((Throwable)encryptorException);
        }
    }

    public User fetchDefaultUser(long companyId) {
        User user = this._defaultUsers.get(companyId);
        if (user == null && (user = this.userPersistence.fetchByC_DU(companyId, true)) != null) {
            this._defaultUsers.put(companyId, user);
        }
        return user;
    }

    public User fetchUserByContactId(long contactId) {
        return this.userPersistence.fetchByContactId(contactId);
    }

    public User fetchUserByEmailAddress(long companyId, String emailAddress) {
        emailAddress = this.getLogin(emailAddress);
        return this.userPersistence.fetchByC_EA(companyId, emailAddress);
    }

    @Deprecated
    public User fetchUserByFacebookId(long companyId, long facebookId) {
        return this.userPersistence.fetchByC_FID(companyId, facebookId);
    }

    public User fetchUserByGoogleUserId(long companyId, String googleUserId) {
        return this.userPersistence.fetchByC_GUID(companyId, googleUserId);
    }

    public User fetchUserById(long userId) {
        return this.userPersistence.fetchByPrimaryKey(userId);
    }

    @Deprecated
    public User fetchUserByOpenId(long companyId, String openId) {
        return this.userPersistence.fetchByC_O(companyId, openId);
    }

    public User fetchUserByPortraitId(long portraitId) {
        return this.userPersistence.fetchByPortraitId(portraitId);
    }

    public User fetchUserByScreenName(long companyId, String screenName) {
        screenName = this.getLogin(screenName);
        return this.userPersistence.fetchByC_SN(companyId, screenName);
    }

    public List<User> getCompanyUsers(long companyId, int start, int end) {
        return this.userPersistence.findByCompanyId(companyId, start, end);
    }

    public int getCompanyUsersCount(long companyId) {
        return this.userPersistence.countByCompanyId(companyId);
    }

    @Transactional(enabled=false)
    public User getDefaultUser(long companyId) throws PortalException {
        User userModel = this._defaultUsers.get(companyId);
        if (userModel == null) {
            userModel = this.userLocalService.loadGetDefaultUser(companyId);
            this._defaultUsers.put(companyId, userModel);
        }
        return userModel;
    }

    @Transactional(enabled=false)
    public long getDefaultUserId(long companyId) throws PortalException {
        User user = this.getDefaultUser(companyId);
        return user.getUserId();
    }

    public long[] getGroupUserIds(long groupId) {
        return this._groupPersistence.getUserPrimaryKeys(groupId);
    }

    public List<User> getGroupUsers(long groupId, int status, int start, int end, OrderByComparator<User> orderByComparator) throws PortalException {
        Group group = this._groupPersistence.findByPrimaryKey(groupId);
        return this.search(group.getCompanyId(), null, status, (LinkedHashMap<String, Object>)LinkedHashMapBuilder.put((Object)"usersGroups", (Object)groupId).build(), start, end, orderByComparator);
    }

    public List<User> getGroupUsers(long groupId, int status, OrderByComparator<User> orderByComparator) throws PortalException {
        return this.getGroupUsers(groupId, status, -1, -1, orderByComparator);
    }

    public int getGroupUsersCount(long groupId, int status) throws PortalException {
        Group group = this._groupPersistence.findByPrimaryKey(groupId);
        return this.searchCount(group.getCompanyId(), null, status, LinkedHashMapBuilder.put((Object)"usersGroups", (Object)groupId).build());
    }

    public List<User> getInheritedRoleUsers(long roleId, int start, int end, OrderByComparator<User> orderByComparator) throws PortalException {
        Role role = this._rolePersistence.findByPrimaryKey(roleId);
        return this.search(role.getCompanyId(), null, 0, (LinkedHashMap<String, Object>)LinkedHashMapBuilder.put((Object)"inherit", (Object)Boolean.TRUE).put((Object)"usersRoles", (Object)roleId).build(), start, end, orderByComparator);
    }

    public List<User> getNoAnnouncementsDeliveries(String type) {
        return this.userFinder.findByNoAnnouncementsDeliveries(type);
    }

    public List<User> getNoGroups() {
        return this.userFinder.findByNoGroups();
    }

    public int getOrganizationsAndUserGroupsUsersCount(long[] organizationIds, long[] userGroupIds) {
        return this.userFinder.countByOrganizationsAndUserGroups(organizationIds, userGroupIds);
    }

    public long[] getOrganizationUserIds(long organizationId) {
        return this._organizationPersistence.getUserPrimaryKeys(organizationId);
    }

    public List<User> getOrganizationUsers(long organizationId, int status, int start, int end, OrderByComparator<User> orderByComparator) throws PortalException {
        Organization organization = this._organizationPersistence.findByPrimaryKey(organizationId);
        return this.search(organization.getCompanyId(), null, status, (LinkedHashMap<String, Object>)LinkedHashMapBuilder.put((Object)"usersOrgs", (Object)organizationId).build(), start, end, orderByComparator);
    }

    public List<User> getOrganizationUsers(long organizationId, int status, OrderByComparator<User> orderByComparator) throws PortalException {
        return this.getOrganizationUsers(organizationId, status, -1, -1, orderByComparator);
    }

    public int getOrganizationUsersCount(long organizationId, int status) throws PortalException {
        Organization organization = this._organizationPersistence.findByPrimaryKey(organizationId);
        return this.searchCount(organization.getCompanyId(), null, status, LinkedHashMapBuilder.put((Object)"usersOrgs", (Object)organizationId).build());
    }

    public long[] getRoleUserIds(long roleId) {
        return this._rolePersistence.getUserPrimaryKeys(roleId);
    }

    public int getRoleUsersCount(long roleId, int status) throws PortalException {
        Role role = this._rolePersistence.findByPrimaryKey(roleId);
        return this.searchCount(role.getCompanyId(), null, status, LinkedHashMapBuilder.put((Object)"usersRoles", (Object)roleId).build());
    }

    public List<User> getSocialUsers(long userId, int socialRelationType, String socialRelationTypeComparator, int start, int end, OrderByComparator<User> orderByComparator) throws PortalException {
        if (!socialRelationTypeComparator.equals("=") && !socialRelationTypeComparator.equals("!=")) {
            throw new IllegalArgumentException("Invalid social relation type comparator " + socialRelationTypeComparator);
        }
        if (start == -1 && end == -1) {
            List socialRelations = this._socialRelationPersistence.findByU1_T(userId, socialRelationType);
            if (socialRelationTypeComparator.equals("!=")) {
                socialRelations = ListUtil.remove((List)this._socialRelationPersistence.findByUserId1(userId), (List)socialRelations);
            }
            List<Object> users = new ArrayList<User>();
            for (SocialRelation socialRelation : socialRelations) {
                User user = this.userPersistence.findByPrimaryKey(socialRelation.getUserId2());
                if (user.isDefaultUser() || user.getStatus() != 0 || users.contains(user)) continue;
                users.add(user);
            }
            if (orderByComparator != null) {
                users = ListUtil.sort(users, orderByComparator);
            }
            return users;
        }
        User user = this.userPersistence.findByPrimaryKey(userId);
        return this.userFinder.findBySocialUsers(user.getCompanyId(), userId, socialRelationType, socialRelationTypeComparator, 0, start, end, orderByComparator);
    }

    public List<User> getSocialUsers(long userId1, long userId2, int socialRelationType, int start, int end, OrderByComparator<User> orderByComparator) throws PortalException {
        User user1 = this.userPersistence.findByPrimaryKey(userId1);
        return this.search(user1.getCompanyId(), null, 0, (LinkedHashMap<String, Object>)LinkedHashMapBuilder.put((Object)"socialMutualRelationType", (Object)new Long[]{userId1, socialRelationType, userId2, socialRelationType}).build(), start, end, orderByComparator);
    }

    public List<User> getSocialUsers(long userId1, long userId2, int start, int end, OrderByComparator<User> orderByComparator) throws PortalException {
        User user1 = this.userPersistence.findByPrimaryKey(userId1);
        return this.search(user1.getCompanyId(), null, 0, (LinkedHashMap<String, Object>)LinkedHashMapBuilder.put((Object)"socialMutualRelation", (Object)new Long[]{userId1, userId2}).build(), start, end, orderByComparator);
    }

    public int getSocialUsersCount(long userId, int socialRelationType, String socialRelationTypeComparator) throws PortalException {
        if (!socialRelationTypeComparator.equals("=") && !socialRelationTypeComparator.equals("!=")) {
            throw new IllegalArgumentException("Invalid social relation type comparator " + socialRelationTypeComparator);
        }
        User user = this.userPersistence.findByPrimaryKey(userId);
        return this.userFinder.countBySocialUsers(user.getCompanyId(), user.getUserId(), socialRelationType, socialRelationTypeComparator, 0);
    }

    public int getSocialUsersCount(long userId1, long userId2) throws PortalException {
        User user1 = this.userPersistence.findByPrimaryKey(userId1);
        return this.searchCount(user1.getCompanyId(), null, 0, LinkedHashMapBuilder.put((Object)"socialMutualRelation", (Object)new Long[]{userId1, userId2}).build());
    }

    public int getSocialUsersCount(long userId1, long userId2, int socialRelationType) throws PortalException {
        User user1 = this.userPersistence.findByPrimaryKey(userId1);
        return this.searchCount(user1.getCompanyId(), null, 0, LinkedHashMapBuilder.put((Object)"socialMutualRelationType", (Object)new Long[]{userId1, socialRelationType, userId2, socialRelationType}).build());
    }

    public User getUserByContactId(long contactId) throws PortalException {
        return this.userPersistence.findByContactId(contactId);
    }

    public User getUserByEmailAddress(long companyId, String emailAddress) throws PortalException {
        emailAddress = this.getLogin(emailAddress);
        return this.userPersistence.findByC_EA(companyId, emailAddress);
    }

    @Deprecated
    public User getUserByFacebookId(long companyId, long facebookId) throws PortalException {
        return this.userPersistence.findByC_FID(companyId, facebookId);
    }

    public User getUserByGoogleUserId(long companyId, String googleUserId) throws PortalException {
        return this.userPersistence.findByC_GUID(companyId, googleUserId);
    }

    public User getUserById(long userId) throws PortalException {
        return this.userPersistence.findByPrimaryKey(userId);
    }

    public User getUserById(long companyId, long userId) throws PortalException {
        return this.userPersistence.findByC_U(companyId, userId);
    }

    @Deprecated
    public User getUserByOpenId(long companyId, String openId) throws PortalException {
        return this.userPersistence.findByC_O(companyId, openId);
    }

    public User getUserByPortraitId(long portraitId) throws PortalException {
        return this.userPersistence.findByPortraitId(portraitId);
    }

    public User getUserByScreenName(long companyId, String screenName) throws PortalException {
        screenName = this.getLogin(screenName);
        return this.userPersistence.findByC_SN(companyId, screenName);
    }

    public int getUserGroupUsersCount(long userGroupId, int status) throws PortalException {
        UserGroup userGroup = this._userGroupPersistence.findByPrimaryKey(userGroupId);
        return this.searchCount(userGroup.getCompanyId(), null, status, LinkedHashMapBuilder.put((Object)"usersUserGroups", (Object)userGroupId).build());
    }

    public long getUserIdByEmailAddress(long companyId, String emailAddress) throws PortalException {
        emailAddress = StringUtil.toLowerCase((String)StringUtil.trim((String)emailAddress));
        User user = this.userPersistence.findByC_EA(companyId, emailAddress);
        return user.getUserId();
    }

    public long getUserIdByScreenName(long companyId, String screenName) throws PortalException {
        screenName = this.getLogin(screenName);
        User user = this.userPersistence.findByC_SN(companyId, screenName);
        return user.getUserId();
    }

    public List<User> getUsers(long companyId, boolean defaultUser, int status, int start, int end, OrderByComparator<User> orderByComparator) {
        return this.userPersistence.findByC_DU_S(companyId, defaultUser, status, start, end, orderByComparator);
    }

    public int getUsersCount(long companyId, boolean defaultUser, int status) {
        return this.userPersistence.countByC_DU_S(companyId, defaultUser, status);
    }

    public boolean hasPasswordPolicyUser(long passwordPolicyId, long userId) {
        return this._passwordPolicyRelLocalService.hasPasswordPolicyRel(passwordPolicyId, User.class.getName(), userId);
    }

    public boolean hasRoleUser(long companyId, String name, long userId, boolean inherited) throws PortalException {
        return this._roleLocalService.hasUserRole(userId, companyId, name, inherited);
    }

    public boolean isPasswordExpired(User user) throws PortalException {
        PasswordPolicy passwordPolicy = user.getPasswordPolicy();
        if (passwordPolicy != null && passwordPolicy.isExpireable()) {
            long currentTime = System.currentTimeMillis();
            long passwordModifiedTime = 0L;
            Date passwordModifiedDate = user.getPasswordModifiedDate();
            passwordModifiedTime = passwordModifiedDate == null ? currentTime : passwordModifiedDate.getTime();
            long elapsedTime = currentTime - passwordModifiedTime;
            return elapsedTime > passwordPolicy.getMaxAge() * 1000L;
        }
        return false;
    }

    public User loadGetDefaultUser(long companyId) throws PortalException {
        return this.userPersistence.findByC_DU(companyId, true);
    }

    public List<User> search(long companyId, String keywords, int status, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<User> orderByComparator) {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        if (!indexer.isIndexerEnabled() || !PropsValues.USERS_SEARCH_WITH_INDEX || this.isUseCustomSQL(params)) {
            return this.userFinder.findByKeywords(companyId, keywords, status, params, start, end, orderByComparator);
        }
        try {
            return UsersAdminUtil.getUsers((Hits)this.search(companyId, keywords, status, params, start, end, this.getSorts(orderByComparator)));
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public Hits search(long companyId, String keywords, int status, LinkedHashMap<String, Object> params, int start, int end, Sort sort) {
        return this.search(companyId, keywords, status, params, start, end, new Sort[]{sort});
    }

    public Hits search(long companyId, String keywords, int status, LinkedHashMap<String, Object> params, int start, int end, Sort[] sorts) {
        String firstName = null;
        String middleName = null;
        String lastName = null;
        String fullName = null;
        String screenName = null;
        String street = null;
        String city = null;
        String zip = null;
        String region = null;
        String country = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            firstName = keywords;
            middleName = keywords;
            lastName = keywords;
            fullName = keywords;
            screenName = keywords;
            street = keywords;
            city = keywords;
            zip = keywords;
            region = keywords;
            country = keywords;
        } else {
            andOperator = true;
        }
        if (params != null) {
            params.put("keywords", keywords);
        }
        try {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
            SearchContext searchContext = this.buildSearchContext(companyId, firstName, middleName, lastName, fullName, screenName, null, street, city, zip, region, country, status, params, andOperator, start, end, sorts);
            return indexer.search(searchContext);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public List<User> search(long companyId, String firstName, String middleName, String lastName, String screenName, String emailAddress, int status, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, OrderByComparator<User> orderByComparator) {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        if (!indexer.isIndexerEnabled() || !PropsValues.USERS_SEARCH_WITH_INDEX || this.isUseCustomSQL(params)) {
            return this.userFinder.findByC_FN_MN_LN_SN_EA_S(companyId, firstName, middleName, lastName, screenName, emailAddress, status, params, andSearch, start, end, orderByComparator);
        }
        try {
            return UsersAdminUtil.getUsers((Hits)this.search(companyId, firstName, middleName, lastName, screenName, emailAddress, status, params, andSearch, start, end, this.getSorts(orderByComparator)));
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public Hits search(long companyId, String firstName, String middleName, String lastName, String screenName, String emailAddress, int status, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) {
        return this.search(companyId, firstName, middleName, lastName, screenName, emailAddress, status, params, andSearch, start, end, new Sort[]{sort});
    }

    public Hits search(long companyId, String firstName, String middleName, String lastName, String screenName, String emailAddress, int status, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort[] sorts) {
        try {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
            SearchContext searchContext = this.buildSearchContext(companyId, firstName, middleName, lastName, null, screenName, emailAddress, null, null, null, null, null, status, params, andSearch, start, end, sorts);
            return indexer.search(searchContext);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public List<User> searchBySocial(long userId, int[] socialRelationTypes, String keywords, int start, int end) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        return this.userFinder.findByKeywords(user.getCompanyId(), keywords, 0, LinkedHashMapBuilder.put((Object)"socialRelationType", (Object)new Long[][]{{userId}, ArrayUtil.toLongArray((int[])socialRelationTypes)}).put((Object)"wildcardMode", (Object)WildcardMode.TRAILING).build(), start, end, null);
    }

    public List<User> searchBySocial(long companyId, long[] groupIds, String keywords, int start, int end) {
        return this.searchBySocial(companyId, groupIds, keywords, start, end, null);
    }

    public List<User> searchBySocial(long companyId, long[] groupIds, String keywords, int start, int end, OrderByComparator<User> orderByComparator) {
        return this.userFinder.findByKeywords(companyId, keywords, 0, LinkedHashMapBuilder.put((Object)"usersGroups", (Object)ArrayUtil.toLongArray((long[])groupIds)).put((Object)"wildcardMode", (Object)WildcardMode.TRAILING).build(), start, end, orderByComparator);
    }

    public List<User> searchBySocial(long[] groupIds, long userId, int[] socialRelationTypes, String keywords, int start, int end) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        return this.userFinder.findByKeywords(user.getCompanyId(), keywords, 0, LinkedHashMapBuilder.put((Object)"socialRelationType", (Object)new Long[][]{{userId}, ArrayUtil.toLongArray((int[])socialRelationTypes)}).put((Object)"socialRelationTypeUnionUserGroups", (Object)true).put((Object)"usersGroups", (Object)ArrayUtil.toLongArray((long[])groupIds)).put((Object)"wildcardMode", (Object)WildcardMode.TRAILING).build(), start, end, null);
    }

    public int searchCount(long companyId, String keywords, int status, LinkedHashMap<String, Object> params) {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        if (!indexer.isIndexerEnabled() || !PropsValues.USERS_SEARCH_WITH_INDEX || this.isUseCustomSQL(params)) {
            return this.userFinder.countByKeywords(companyId, keywords, status, params);
        }
        try {
            String firstName = null;
            String middleName = null;
            String lastName = null;
            String fullName = null;
            String screenName = null;
            String street = null;
            String city = null;
            String zip = null;
            String region = null;
            String country = null;
            boolean andOperator = false;
            if (Validator.isNotNull((String)keywords)) {
                firstName = keywords;
                middleName = keywords;
                lastName = keywords;
                fullName = keywords;
                screenName = keywords;
                street = keywords;
                city = keywords;
                zip = keywords;
                region = keywords;
                country = keywords;
            } else {
                andOperator = true;
            }
            if (params != null) {
                params.put("keywords", keywords);
            }
            SearchContext searchContext = this.buildSearchContext(companyId, firstName, middleName, lastName, fullName, screenName, null, street, city, zip, region, country, status, params, andOperator, -1, -1, null);
            return (int)indexer.searchCount(searchContext);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public int searchCount(long companyId, String firstName, String middleName, String lastName, String screenName, String emailAddress, int status, LinkedHashMap<String, Object> params, boolean andSearch) {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        if (!indexer.isIndexerEnabled() || !PropsValues.USERS_SEARCH_WITH_INDEX || this.isUseCustomSQL(params)) {
            return this.userFinder.countByC_FN_MN_LN_SN_EA_S(companyId, firstName, middleName, lastName, screenName, emailAddress, status, params, andSearch);
        }
        try {
            FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
            String fullName = fullNameGenerator.getFullName(firstName, middleName, lastName);
            SearchContext searchContext = this.buildSearchContext(companyId, firstName, middleName, lastName, fullName, screenName, emailAddress, null, null, null, null, null, status, params, true, -1, -1, null);
            return (int)indexer.searchCount(searchContext);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public Map<Long, Integer> searchCounts(long companyId, int status, long[] groupIds) {
        HashMap<Long, Integer> counts = new HashMap<Long, Integer>();
        LinkedHashMap params = null;
        try {
            for (long groupId : groupIds) {
                int count;
                Group group = this._groupPersistence.fetchByPrimaryKey(groupId);
                if (group == null || (count = this.userFinder.countByKeywords(companyId, null, status, params = group.isOrganization() ? LinkedHashMapBuilder.put((Object)"usersOrgs", (Object)group.getOrganizationId()).build() : (group.isUserGroup() ? LinkedHashMapBuilder.put((Object)"usersUserGroups", (Object)group.getClassPK()).build() : LinkedHashMapBuilder.put((Object)"usersGroups", (Object)groupId).build()))) <= 0) continue;
                counts.put(groupId, count);
            }
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
        return counts;
    }

    @Deprecated
    public List<User> searchSocial(long userId, int[] socialRelationTypes, String keywords, int start, int end) throws PortalException {
        return this.searchBySocial(userId, socialRelationTypes, keywords, start, end);
    }

    @Deprecated
    public List<User> searchSocial(long companyId, long[] groupIds, String keywords, int start, int end) {
        return this.searchBySocial(companyId, groupIds, keywords, start, end);
    }

    @Deprecated
    public List<User> searchSocial(long companyId, long[] groupIds, String keywords, int start, int end, OrderByComparator<User> orderByComparator) {
        return this.searchBySocial(companyId, groupIds, keywords, start, end, orderByComparator);
    }

    @Deprecated
    public List<User> searchSocial(long[] groupIds, long userId, int[] socialRelationTypes, String keywords, int start, int end) throws PortalException {
        return this.searchBySocial(groupIds, userId, socialRelationTypes, keywords, start, end);
    }

    public BaseModelSearchResult<User> searchUsers(long companyId, String keywords, int status, LinkedHashMap<String, Object> params, int start, int end, Sort sort) throws PortalException {
        return this.searchUsers(companyId, keywords, status, params, start, end, new Sort[]{sort});
    }

    public BaseModelSearchResult<User> searchUsers(long companyId, String keywords, int status, LinkedHashMap<String, Object> params, int start, int end, Sort[] sorts) throws PortalException {
        String firstName = null;
        String middleName = null;
        String lastName = null;
        String fullName = null;
        String screenName = null;
        String street = null;
        String city = null;
        String zip = null;
        String region = null;
        String country = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            firstName = keywords;
            middleName = keywords;
            lastName = keywords;
            fullName = keywords;
            screenName = keywords;
            street = keywords;
            city = keywords;
            zip = keywords;
            region = keywords;
            country = keywords;
        } else {
            andOperator = true;
        }
        if (params != null) {
            params.put("keywords", keywords);
        }
        SearchContext searchContext = this.buildSearchContext(companyId, firstName, middleName, lastName, fullName, screenName, null, street, city, zip, region, country, status, params, andOperator, start, end, sorts);
        return this.searchUsers(searchContext);
    }

    public BaseModelSearchResult<User> searchUsers(long companyId, String firstName, String middleName, String lastName, String screenName, String emailAddress, int status, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) throws PortalException {
        return this.searchUsers(companyId, firstName, middleName, lastName, screenName, emailAddress, status, params, andSearch, start, end, new Sort[]{sort});
    }

    public BaseModelSearchResult<User> searchUsers(long companyId, String firstName, String middleName, String lastName, String screenName, String emailAddress, int status, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort[] sorts) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, firstName, middleName, lastName, null, screenName, emailAddress, null, null, null, null, null, status, params, andSearch, start, end, sorts);
        return this.searchUsers(searchContext);
    }

    public void sendEmailAddressVerification(User user, String emailAddress, ServiceContext serviceContext) throws PortalException {
        Layout layout;
        if (user.isEmailAddressVerified() && StringUtil.equalsIgnoreCase((String)emailAddress, (String)user.getEmailAddress())) {
            return;
        }
        Ticket ticket = this._ticketLocalService.addDistinctTicket(user.getCompanyId(), User.class.getName(), user.getUserId(), 1, emailAddress, null, serviceContext);
        String verifyEmailAddressURL = StringBundler.concat((String[])new String[]{serviceContext.getPortalURL(), serviceContext.getPathMain(), "/portal/verify_email_address?ticketKey=", ticket.getKey()});
        long plid = serviceContext.getPlid();
        if (plid > 0L && (layout = this._layoutLocalService.fetchLayout(plid)) != null) {
            Group group = layout.getGroup();
            if (!layout.isPrivateLayout() && !group.isUser()) {
                verifyEmailAddressURL = verifyEmailAddressURL + "&p_l_id=" + serviceContext.getPlid();
            }
        }
        String fromAddress = PrefsPropsUtil.getString(user.getCompanyId(), "admin.email.from.address");
        String fromName = PrefsPropsUtil.getString(user.getCompanyId(), "admin.email.from.name");
        PortletPreferences companyPortletPreferences = PrefsPropsUtil.getPreferences(user.getCompanyId(), true);
        Map localizedSubjectMap = LocalizationUtil.getLocalizationMap((PortletPreferences)companyPortletPreferences, (String)"adminEmailVerificationSubject", (String)"admin.email.verification.subject");
        Map localizedBodyMap = LocalizationUtil.getLocalizationMap((PortletPreferences)companyPortletPreferences, (String)"adminEmailVerificationBody", (String)"admin.email.verification.body");
        String subject = this._getLocalizedValue(localizedSubjectMap, user.getLocale(), LocaleUtil.getDefault());
        String body = this._getLocalizedValue(localizedBodyMap, user.getLocale(), LocaleUtil.getDefault());
        Company company = this._companyLocalService.getCompany(user.getCompanyId());
        MailTemplateContextBuilder mailTemplateContextBuilder = MailTemplateFactoryUtil.createMailTemplateContextBuilder();
        mailTemplateContextBuilder.put("[$COMPANY_ID$]", String.valueOf(company.getCompanyId()));
        mailTemplateContextBuilder.put("[$COMPANY_MX$]", company.getMx());
        mailTemplateContextBuilder.put("[$COMPANY_NAME$]", HtmlUtil.escape((String)company.getName()));
        mailTemplateContextBuilder.put("[$EMAIL_VERIFICATION_CODE$]", HtmlUtil.escape((String)ticket.getKey()));
        mailTemplateContextBuilder.put("[$EMAIL_VERIFICATION_URL$]", verifyEmailAddressURL);
        mailTemplateContextBuilder.put("[$FROM_ADDRESS$]", fromAddress);
        mailTemplateContextBuilder.put("[$FROM_NAME$]", HtmlUtil.escape((String)fromName));
        mailTemplateContextBuilder.put("[$PORTAL_URL$]", serviceContext.getPortalURL());
        mailTemplateContextBuilder.put("[$REMOTE_ADDRESS$]", serviceContext.getRemoteAddr());
        mailTemplateContextBuilder.put("[$REMOTE_HOST$]", HtmlUtil.escape((String)serviceContext.getRemoteHost()));
        mailTemplateContextBuilder.put("[$TO_ADDRESS$]", emailAddress);
        mailTemplateContextBuilder.put("[$TO_NAME$]", HtmlUtil.escape((String)user.getFullName()));
        mailTemplateContextBuilder.put("[$USER_ID$]", String.valueOf(user.getUserId()));
        mailTemplateContextBuilder.put("[$USER_SCREENNAME$]", HtmlUtil.escape((String)user.getScreenName()));
        this._sendNotificationEmail(fromAddress, fromName, emailAddress, user, subject, body, mailTemplateContextBuilder.build());
    }

    public boolean sendPassword(long companyId, String emailAddress, String fromName, String fromAddress, String subject, String body, ServiceContext serviceContext) throws PortalException {
        Company company = this._companyPersistence.findByPrimaryKey(companyId);
        if (!company.isSendPasswordResetLink()) {
            throw new SendPasswordException.MustBeEnabled(company);
        }
        if (Validator.isNull((String)(emailAddress = StringUtil.toLowerCase((String)StringUtil.trim((String)emailAddress))))) {
            throw new UserEmailAddressException.MustNotBeNull();
        }
        User user = this.userPersistence.findByC_EA(companyId, emailAddress);
        PasswordPolicy passwordPolicy = user.getPasswordPolicy();
        Date expirationDate = null;
        if (passwordPolicy != null && passwordPolicy.getResetTicketMaxAge() > 0L) {
            expirationDate = new Date(System.currentTimeMillis() + passwordPolicy.getResetTicketMaxAge() * 1000L);
        }
        Ticket ticket = this._ticketLocalService.addDistinctTicket(companyId, User.class.getName(), user.getUserId(), 3, null, expirationDate, serviceContext);
        String passwordResetURL = StringBundler.concat((Object[])new Object[]{serviceContext.getPortalURL(), serviceContext.getPathMain(), "/portal/update_password?p_l_id=", serviceContext.getPlid(), "&ticketKey=", ticket.getKey()});
        this.sendPasswordNotification(user, companyId, null, passwordResetURL, fromName, fromAddress, subject, body, serviceContext);
        return false;
    }

    public boolean sendPasswordByEmailAddress(long companyId, String emailAddress) throws PortalException {
        User user = this.userPersistence.findByC_EA(companyId, emailAddress);
        return this.sendPassword(user.getCompanyId(), user.getEmailAddress(), null, null, null, null, ServiceContextThreadLocal.getServiceContext());
    }

    public boolean sendPasswordByScreenName(long companyId, String screenName) throws PortalException {
        User user = this.userPersistence.findByC_SN(companyId, screenName);
        return this.sendPassword(user.getCompanyId(), user.getEmailAddress(), null, null, null, null, ServiceContextThreadLocal.getServiceContext());
    }

    public boolean sendPasswordByUserId(long userId) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        return this.sendPassword(user.getCompanyId(), user.getEmailAddress(), null, null, null, null, ServiceContextThreadLocal.getServiceContext());
    }

    @Override
    public void setRoleUsers(long roleId, long[] userIds) throws PortalException {
        long[] oldUserIds = this._rolePersistence.getUserPrimaryKeys(roleId);
        Set updatedUserIdsSet = SetUtil.symmetricDifference((long[])userIds, (long[])oldUserIds);
        long[] updateUserIds = ArrayUtil.toLongArray((Collection)updatedUserIdsSet);
        this._rolePersistence.setUsers(roleId, userIds);
        this.reindex(updateUserIds);
    }

    @Override
    public void setUserGroupUsers(long userGroupId, long[] userIds) throws PortalException {
        long[] oldUserIds = this._userGroupPersistence.getUserPrimaryKeys(userGroupId);
        Set updatedUserIdsSet = SetUtil.symmetricDifference((long[])userIds, (long[])oldUserIds);
        long[] updateUserIds = ArrayUtil.toLongArray((Collection)updatedUserIdsSet);
        this._userGroupPersistence.setUsers(userGroupId, userIds);
        this.reindex(updateUserIds);
    }

    public void unsetGroupTeamsUsers(long groupId, long[] userIds) throws PortalException {
        List teams = this._teamPersistence.findByGroupId(groupId);
        for (Team team : teams) {
            this.unsetTeamUsers(team.getTeamId(), userIds);
        }
    }

    public void unsetGroupUsers(long groupId, long[] userIds, ServiceContext serviceContext) throws PortalException {
        this._userGroupRoleLocalService.deleteUserGroupRoles(userIds, groupId, 5);
        this._userGroupRoleLocalService.deleteUserGroupRoles(userIds, groupId, 2);
        this.unsetGroupTeamsUsers(groupId, userIds);
        this._groupPersistence.removeUsers(groupId, userIds);
        this.reindex(userIds);
        TransactionCommitCallbackUtil.registerCallback(() -> {
            Message message = new Message();
            message.put("groupId", (Object)groupId);
            message.put("userIds", (Object)userIds);
            MessageBusUtil.sendMessage((String)"liferay/subscription_clean_up", (Message)message);
            return null;
        });
    }

    public void unsetOrganizationUsers(long organizationId, long[] userIds) throws PortalException {
        Organization organization = this._organizationPersistence.findByPrimaryKey(organizationId);
        Group group = organization.getGroup();
        this._userGroupRoleLocalService.deleteUserGroupRoles(userIds, group.getGroupId());
        this._organizationPersistence.removeUsers(organizationId, userIds);
        this.reindex(userIds);
        TransactionCommitCallbackUtil.registerCallback(() -> {
            Message message = new Message();
            message.put("groupId", (Object)group.getGroupId());
            message.put("userIds", (Object)userIds);
            MessageBusUtil.sendMessage((String)"liferay/subscription_clean_up", (Message)message);
            return null;
        });
    }

    public void unsetPasswordPolicyUsers(long passwordPolicyId, long[] userIds) {
        block2: {
            long companyId = CompanyThreadLocal.getCompanyId();
            try {
                this._checkPasswordReset(this._passwordPolicyLocalService.getDefaultPasswordPolicy(companyId), userIds);
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)portalException, (Throwable)portalException);
            }
        }
        this._passwordPolicyRelLocalService.deletePasswordPolicyRels(passwordPolicyId, User.class.getName(), userIds);
    }

    public void unsetRoleUsers(long roleId, List<User> users) throws PortalException {
        Role role = this._rolePersistence.findByPrimaryKey(roleId);
        String roleName = role.getName();
        if (roleName.equals("Administrator") && this.getRoleUsersCount(role.getRoleId()) <= users.size()) {
            throw new RequiredRoleException.MustNotRemoveLastAdministator();
        }
        if (roleName.equals("User")) {
            throw new RequiredRoleException.MustNotRemoveUserRole();
        }
        this._rolePersistence.removeUsers(roleId, users);
        this.reindex(users);
    }

    public void unsetRoleUsers(long roleId, long[] userIds) throws PortalException {
        ArrayList<User> users = new ArrayList<User>(userIds.length);
        long[] lArray = userIds;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long userId = lArray[i];
            User user = this.userLocalService.fetchUser(userId.longValue());
            if (user == null) continue;
            users.add(user);
        }
        this.unsetRoleUsers(roleId, users);
    }

    public void unsetTeamUsers(long teamId, long[] userIds) throws PortalException {
        this._teamPersistence.removeUsers(teamId, userIds);
        this.reindex(userIds);
    }

    public void unsetUserGroupUsers(long userGroupId, long[] userIds) throws PortalException {
        this._userGroupPersistence.removeUsers(userGroupId, userIds);
        this.reindex(userIds);
    }

    public User updateAgreedToTermsOfUse(long userId, boolean agreedToTermsOfUse) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setAgreedToTermsOfUse(agreedToTermsOfUse);
        return (User)this.userPersistence.update((BaseModel)user);
    }

    public void updateAsset(long userId, User user, long[] assetCategoryIds, String[] assetTagNames) throws PortalException {
        User owner = this.userPersistence.findByPrimaryKey(userId);
        Company company = this._companyPersistence.findByPrimaryKey(owner.getCompanyId());
        Group companyGroup = company.getGroup();
        this._assetEntryLocalService.updateEntry(userId, companyGroup.getGroupId(), user.getCreateDate(), user.getModifiedDate(), User.class.getName(), user.getUserId(), user.getUuid(), 0L, assetCategoryIds, assetTagNames, true, false, null, null, null, null, null, user.getFullName(), null, null, null, null, 0, 0, null);
    }

    public User updateCreateDate(long userId, Date createDate) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setCreateDate(createDate);
        return (User)this.userPersistence.update((BaseModel)user);
    }

    @Indexable(type=IndexableType.REINDEX)
    public User updateEmailAddress(long userId, String password, String emailAddress1, String emailAddress2) throws PortalException {
        emailAddress1 = StringUtil.toLowerCase((String)StringUtil.trim((String)emailAddress1));
        emailAddress2 = StringUtil.toLowerCase((String)StringUtil.trim((String)emailAddress2));
        User user = this.userPersistence.findByPrimaryKey(userId);
        this.validateEmailAddress(user, emailAddress1, emailAddress2);
        this.setEmailAddress(user, password, user.getFirstName(), user.getMiddleName(), user.getLastName(), emailAddress1);
        user = (User)this.userPersistence.update((BaseModel)user);
        Contact contact = user.getContact();
        contact.setEmailAddress(user.getEmailAddress());
        this._contactPersistence.update((BaseModel)contact);
        return user;
    }

    @Indexable(type=IndexableType.REINDEX)
    public User updateEmailAddress(long userId, String password, String emailAddress1, String emailAddress2, ServiceContext serviceContext) throws PortalException {
        emailAddress1 = StringUtil.toLowerCase((String)StringUtil.trim((String)emailAddress1));
        emailAddress2 = StringUtil.toLowerCase((String)StringUtil.trim((String)emailAddress2));
        User user = this.userPersistence.findByPrimaryKey(userId);
        this.validateEmailAddress(user, emailAddress1, emailAddress2);
        Company company = this._companyPersistence.findByPrimaryKey(user.getCompanyId());
        if (company.isStrangersVerify() && !StringUtil.equalsIgnoreCase((String)emailAddress1, (String)user.getEmailAddress())) {
            this.sendEmailAddressVerification(user, emailAddress1, serviceContext);
        } else {
            this.setEmailAddress(user, password, user.getFirstName(), user.getMiddleName(), user.getLastName(), emailAddress1);
            user = (User)this.userPersistence.update((BaseModel)user);
            Contact contact = user.getContact();
            contact.setEmailAddress(user.getEmailAddress());
            this._contactPersistence.update((BaseModel)contact);
        }
        return user;
    }

    public User updateEmailAddressVerified(long userId, boolean emailAddressVerified) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setEmailAddressVerified(emailAddressVerified);
        return (User)this.userPersistence.update((BaseModel)user);
    }

    @Deprecated
    public User updateFacebookId(long userId, long facebookId) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setFacebookId(facebookId);
        return (User)this.userPersistence.update((BaseModel)user);
    }

    public User updateGoogleUserId(long userId, String googleUserId) throws PortalException {
        googleUserId = StringUtil.trim((String)googleUserId);
        User user = this.userPersistence.findByPrimaryKey(userId);
        this.validateGoogleUserId(user.getCompanyId(), userId, googleUserId);
        user.setGoogleUserId(googleUserId);
        return (User)this.userPersistence.update((BaseModel)user);
    }

    public void updateGroups(long userId, long[] newGroupIds, ServiceContext serviceContext) throws PortalException {
        boolean indexingEnabled = true;
        if (serviceContext != null) {
            indexingEnabled = serviceContext.isIndexingEnabled();
        }
        this.updateGroups(userId, newGroupIds, indexingEnabled);
    }

    public User updateIncompleteUser(long creatorUserId, long companyId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, Locale locale, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String jobTitle, boolean updateUserInformation, boolean sendEmail, ServiceContext serviceContext) throws PortalException {
        ServiceContext workflowServiceContext;
        User user = this.getUserByEmailAddress(companyId, emailAddress);
        if (user.getStatus() != 6) {
            throw new PortalException("Invalid user status");
        }
        User defaultUser = this.getDefaultUser(companyId);
        if (updateUserInformation) {
            autoScreenName = false;
            if (PrefsPropsUtil.getBoolean(companyId, "users.screen.name.always.autogenerate")) {
                autoScreenName = true;
            }
            this.validate(companyId, user.getUserId(), autoPassword, password1, password2, autoScreenName, screenName, emailAddress, null, firstName, middleName, lastName, null, locale);
            if (!autoPassword && (Validator.isNull((String)password1) || Validator.isNull((String)password2))) {
                throw new UserPasswordException.MustNotBeNull(user.getUserId());
            }
            if (autoScreenName) {
                ScreenNameGenerator screenNameGenerator = ScreenNameGeneratorFactory.getInstance();
                try {
                    screenName = screenNameGenerator.generate(companyId, user.getUserId(), emailAddress);
                }
                catch (Exception exception) {
                    throw new SystemException((Throwable)exception);
                }
            }
            FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
            String fullName = fullNameGenerator.getFullName(firstName, middleName, lastName);
            String greeting = LanguageUtil.format((Locale)locale, (String)"welcome-x", (Object)fullName, (boolean)false);
            if (Validator.isNotNull((String)password1)) {
                user.setPassword(PasswordEncryptorUtil.encrypt((String)password1));
                user.setPasswordUnencrypted(password1);
            }
            user.setPasswordEncrypted(true);
            PasswordPolicy passwordPolicy = defaultUser.getPasswordPolicy();
            if (passwordPolicy != null && passwordPolicy.isChangeable() && passwordPolicy.isChangeRequired()) {
                user.setPasswordReset(true);
            } else {
                user.setPasswordReset(false);
            }
            user.setScreenName(screenName);
            user.setLanguageId(locale.toString());
            user.setTimeZoneId(defaultUser.getTimeZoneId());
            user.setGreeting(greeting);
            user.setFirstName(firstName);
            user.setMiddleName(middleName);
            user.setLastName(lastName);
            user.setJobTitle(jobTitle);
            user.setExpandoBridgeAttributes(serviceContext);
            Date birthday = this.getBirthday(birthdayMonth, birthdayDay, birthdayYear);
            Contact contact = user.getContact();
            contact.setFirstName(firstName);
            contact.setMiddleName(middleName);
            contact.setLastName(lastName);
            contact.setPrefixId(prefixId);
            contact.setSuffixId(suffixId);
            contact.setMale(male);
            contact.setBirthday(birthday);
            contact.setJobTitle(jobTitle);
            this._contactPersistence.update((BaseModel)contact, serviceContext);
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
            indexer.reindex((Object)user);
        }
        user.setStatus(2);
        user = (User)this.userPersistence.update((BaseModel)user, serviceContext);
        long workflowUserId = creatorUserId;
        if (workflowUserId == user.getUserId()) {
            workflowUserId = defaultUser.getUserId();
        }
        if ((workflowServiceContext = serviceContext) == null) {
            workflowServiceContext = new ServiceContext();
        }
        workflowServiceContext.setAttribute("autoPassword", (Serializable)Boolean.valueOf(autoPassword));
        workflowServiceContext.setAttribute("passwordUnencrypted", (Serializable)((Object)password1));
        workflowServiceContext.setAttribute("sendEmail", (Serializable)Boolean.valueOf(sendEmail));
        WorkflowHandlerRegistryUtil.startWorkflowInstance((long)companyId, (long)workflowUserId, (String)User.class.getName(), (long)user.getUserId(), (Object)user, (ServiceContext)workflowServiceContext);
        return this.getUserByEmailAddress(companyId, emailAddress);
    }

    @Deprecated
    public User updateIncompleteUser(long creatorUserId, long companyId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, long facebookId, String openId, Locale locale, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String jobTitle, boolean updateUserInformation, boolean sendEmail, ServiceContext serviceContext) throws PortalException {
        User user = this.getUserByEmailAddress(companyId, emailAddress);
        if (facebookId > 0L) {
            autoPassword = false;
            if (password1 == null || password2 == null) {
                password2 = password1 = PwdGenerator.getPassword();
            }
            sendEmail = false;
        }
        if (updateUserInformation) {
            this.validateOpenId(companyId, user.getUserId(), openId);
        }
        user = this.userLocalService.updateIncompleteUser(creatorUserId, companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, updateUserInformation, sendEmail, serviceContext);
        user.setFacebookId(facebookId);
        user.setOpenId(openId);
        return this.userLocalService.updateUser(user);
    }

    @Indexable(type=IndexableType.REINDEX)
    public User updateJobTitle(long userId, String jobTitle) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setJobTitle(jobTitle);
        user = (User)this.userPersistence.update((BaseModel)user);
        Contact contact = this._contactPersistence.findByPrimaryKey(user.getContactId());
        contact.setJobTitle(jobTitle);
        this._contactPersistence.update((BaseModel)contact);
        return user;
    }

    @CTAware(onProduction=true)
    public User updateLastLogin(long userId, String loginIP) throws PortalException {
        String lastLoginIP;
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date lastLoginDate = user.getLoginDate();
        if (lastLoginDate == null) {
            lastLoginDate = new Date();
        }
        if ((lastLoginIP = user.getLoginIP()) == null) {
            lastLoginIP = loginIP;
        }
        user.setLoginDate(new Date());
        user.setLoginIP(loginIP);
        user.setLastLoginDate(lastLoginDate);
        user.setLastLoginIP(lastLoginIP);
        return this.resetFailedLoginAttempts(user, true);
    }

    public User updateLockout(User user, boolean lockout) throws PortalException {
        PasswordPolicy passwordPolicy = user.getPasswordPolicy();
        if (passwordPolicy == null || !passwordPolicy.isLockout()) {
            return user;
        }
        Date lockoutDate = null;
        if (lockout) {
            lockoutDate = new Date();
        }
        user.setLockout(lockout);
        user.setLockoutDate(lockoutDate);
        if (!lockout) {
            user.setFailedLoginAttempts(0);
        }
        return (User)this.userPersistence.update((BaseModel)user);
    }

    public User updateLockoutByEmailAddress(long companyId, String emailAddress, boolean lockout) throws PortalException {
        User user = this.getUserByEmailAddress(companyId, emailAddress);
        return this.updateLockout(user, lockout);
    }

    public User updateLockoutById(long userId, boolean lockout) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        return this.updateLockout(user, lockout);
    }

    public User updateLockoutByScreenName(long companyId, String screenName, boolean lockout) throws PortalException {
        User user = this.getUserByScreenName(companyId, screenName);
        return this.updateLockout(user, lockout);
    }

    @Indexable(type=IndexableType.REINDEX)
    public User updateModifiedDate(long userId, Date modifiedDate) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setModifiedDate(modifiedDate);
        return (User)this.userPersistence.update((BaseModel)user);
    }

    @Deprecated
    public User updateOpenId(long userId, String openId) throws PortalException {
        openId = StringUtil.trim((String)openId);
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setOpenId(openId);
        return (User)this.userPersistence.update((BaseModel)user);
    }

    public void updateOrganizations(long userId, long[] newOrganizationIds, ServiceContext serviceContext) throws PortalException {
        this.updateOrganizations(userId, newOrganizationIds, serviceContext.isIndexingEnabled());
    }

    public User updatePassword(long userId, String password1, String password2, boolean passwordReset) throws PortalException {
        return this.updatePassword(userId, password1, password2, passwordReset, false);
    }

    public User updatePassword(long userId, String password1, String password2, boolean passwordReset, boolean silentUpdate) throws PortalException {
        String newEncPwd = PasswordEncryptorUtil.encrypt((String)password1);
        User user = this.userPersistence.findByPrimaryKey(userId);
        if (!silentUpdate) {
            this.validatePassword(user.getCompanyId(), userId, password1, password2);
            this.trackPassword(user);
        }
        if (user.hasCompanyMx()) {
            this.mailService.updatePassword(user.getCompanyId(), userId, password1);
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (!silentUpdate || user.getPasswordModifiedDate() == null || !this._isPasswordUnchanged(user, password1, newEncPwd)) {
            Date modifiedDate = null;
            if (serviceContext != null) {
                modifiedDate = serviceContext.getModifiedDate();
            }
            if (modifiedDate != null) {
                user.setPasswordModifiedDate(modifiedDate);
            } else {
                user.setPasswordModifiedDate(new Date());
            }
        }
        user.setPassword(newEncPwd);
        user.setPasswordUnencrypted(password1);
        user.setPasswordEncrypted(true);
        user.setPasswordReset(passwordReset);
        user.setDigest(user.getDigest(password1));
        user.setGraceLoginCount(0);
        if (!silentUpdate) {
            user.setPasswordModified(true);
        }
        PasswordModificationThreadLocal.setPasswordModified((boolean)user.getPasswordModified());
        PasswordModificationThreadLocal.setPasswordUnencrypted((String)user.getPasswordUnencrypted());
        try {
            user = (User)this.userPersistence.update((BaseModel)user);
        }
        catch (ModelListenerException modelListenerException) {
            Throwable throwable = modelListenerException.getCause();
            if (LDAPSettingsUtil.isPasswordPolicyEnabled((long)user.getCompanyId())) {
                String[] errorPasswordHistoryKeywords;
                String msg = GetterUtil.getString((String)throwable.getMessage());
                for (String errorPasswordHistoryKeyword : errorPasswordHistoryKeywords = LDAPSettingsUtil.getErrorPasswordHistoryKeywords((long)user.getCompanyId())) {
                    if (!msg.contains(errorPasswordHistoryKeyword)) continue;
                    throw new UserPasswordException.MustNotBeRecentlyUsed(userId);
                }
            }
            throw new UserPasswordException.MustComplyWithModelListeners(userId, modelListenerException);
        }
        if (!silentUpdate) {
            user.setPasswordModified(false);
            this.sendPasswordNotification(user, user.getCompanyId(), password1, null, null, null, null, null, serviceContext);
        }
        this._invalidateTicket(user);
        return user;
    }

    public User updatePasswordManually(long userId, String password, boolean passwordEncrypted, boolean passwordReset, Date passwordModifiedDate) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setPassword(password);
        user.setPasswordEncrypted(passwordEncrypted);
        user.setPasswordReset(passwordReset);
        user.setPasswordModifiedDate(passwordModifiedDate);
        user.setDigest(user.getDigest(password));
        user = (User)this.userPersistence.update((BaseModel)user);
        this._invalidateTicket(user);
        return user;
    }

    public User updatePasswordReset(long userId, boolean passwordReset) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setPasswordReset(passwordReset);
        return (User)this.userPersistence.update((BaseModel)user);
    }

    public User updatePortrait(long userId, byte[] bytes) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        PortalUtil.updateImageId((BaseModel)user, (boolean)true, (byte[])bytes, (String)"portraitId", (long)_userFileUploadsSettings.getImageMaxSize(), (int)_userFileUploadsSettings.getImageMaxHeight(), (int)_userFileUploadsSettings.getImageMaxWidth());
        return (User)this.userPersistence.update((BaseModel)user);
    }

    public User updateReminderQuery(long userId, String question, String answer) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        this.validateReminderQuery(user.getCompanyId(), question, answer);
        user.setReminderQueryQuestion(question);
        user.setReminderQueryAnswer(answer);
        return (User)this.userPersistence.update((BaseModel)user);
    }

    @Indexable(type=IndexableType.REINDEX)
    public User updateScreenName(long userId, String screenName) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        screenName = this.getLogin(screenName);
        this.validateScreenName(user.getCompanyId(), userId, screenName);
        if (!StringUtil.equalsIgnoreCase((String)user.getScreenName(), (String)screenName)) {
            user.setDigest("");
        }
        user.setScreenName(screenName);
        user = (User)this.userPersistence.update((BaseModel)user);
        Group group = this._groupLocalService.getUserGroup(user.getCompanyId(), userId);
        this._groupLocalService.updateFriendlyURL(group.getGroupId(), "/" + screenName);
        return user;
    }

    public User updateStatus(long userId, int status, ServiceContext serviceContext) throws PortalException {
        String passwordUnencrypted;
        User user = this.userPersistence.findByPrimaryKey(userId);
        if (status == 0 && user.getStatus() != 0) {
            this.validateCompanyMaxUsers(user.getCompanyId());
        }
        if (Validator.isNotNull((String)(passwordUnencrypted = (String)((Object)serviceContext.getAttribute("passwordUnencrypted"))))) {
            user.setPasswordUnencrypted(passwordUnencrypted);
        }
        user.setStatus(status);
        user = (User)this.userPersistence.update((BaseModel)user, serviceContext);
        this.reindex(user);
        Group group = user.getGroup();
        if (status == 5) {
            group.setActive(false);
        } else {
            group.setActive(true);
        }
        this._groupLocalService.updateGroup(group);
        return user;
    }

    public User updateUser(long userId, String oldPassword, String newPassword1, String newPassword2, boolean passwordReset, String reminderQueryQuestion, String reminderQueryAnswer, String screenName, String emailAddress, boolean hasPortrait, byte[] portraitBytes, String languageId, String timeZoneId, String greeting, String comments, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String smsSn, String facebookSn, String jabberSn, String skypeSn, String twitterSn, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, List<UserGroupRole> userGroupRoles, long[] userGroupIds, ServiceContext serviceContext) throws PortalException {
        String uuid;
        boolean screenNameModified;
        String password = oldPassword;
        screenName = this.getLogin(screenName);
        emailAddress = StringUtil.toLowerCase((String)StringUtil.trim((String)emailAddress));
        facebookSn = StringUtil.toLowerCase((String)StringUtil.trim((String)facebookSn));
        jabberSn = StringUtil.toLowerCase((String)StringUtil.trim((String)jabberSn));
        skypeSn = StringUtil.toLowerCase((String)StringUtil.trim((String)skypeSn));
        twitterSn = StringUtil.toLowerCase((String)StringUtil.trim((String)twitterSn));
        EmailAddressGenerator emailAddressGenerator = EmailAddressGeneratorFactory.getInstance();
        if (emailAddressGenerator.isGenerated(emailAddress)) {
            emailAddress = "";
        }
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        this.validate(userId, screenName, emailAddress, null, firstName, middleName, lastName, smsSn, locale);
        User user = this.userPersistence.findByPrimaryKey(userId);
        Company company = this._companyPersistence.findByPrimaryKey(user.getCompanyId());
        if (!PropsValues.USERS_EMAIL_ADDRESS_REQUIRED && Validator.isNull((String)emailAddress)) {
            emailAddress = emailAddressGenerator.generate(user.getCompanyId(), userId);
        }
        if (Validator.isNotNull((String)newPassword1) || Validator.isNotNull((String)newPassword2)) {
            user = this.updatePassword(userId, newPassword1, newPassword2, passwordReset);
            password = newPassword1;
            user.setDigest(user.getDigest(password));
        }
        if (user.getContactId() <= 0L) {
            user.setContactId(this.counterLocalService.increment());
        }
        user.setPasswordReset(passwordReset);
        if (Validator.isNotNull((String)reminderQueryQuestion) && Validator.isNotNull((String)reminderQueryAnswer)) {
            user.setReminderQueryQuestion(reminderQueryQuestion);
            user.setReminderQueryAnswer(reminderQueryAnswer);
        }
        boolean bl = screenNameModified = !StringUtil.equalsIgnoreCase((String)user.getScreenName(), (String)screenName);
        if (screenNameModified) {
            user.setScreenName(screenName);
            user.setDigest("");
        }
        boolean sendEmailAddressVerification = false;
        if (company.isStrangersVerify() && !StringUtil.equalsIgnoreCase((String)emailAddress, (String)user.getEmailAddress())) {
            sendEmailAddressVerification = true;
        } else {
            this.setEmailAddress(user, password, firstName, middleName, lastName, emailAddress);
        }
        if (serviceContext != null && Validator.isNotNull((String)(uuid = serviceContext.getUuid()))) {
            user.setUuid(uuid);
        }
        Long ldapServerId = null;
        if (serviceContext != null) {
            ldapServerId = (Long)serviceContext.getAttribute("ldapServerId");
        }
        if (ldapServerId != null) {
            user.setLdapServerId(ldapServerId.longValue());
        }
        PortalUtil.updateImageId((BaseModel)user, (boolean)hasPortrait, (byte[])portraitBytes, (String)"portraitId", (long)_userFileUploadsSettings.getImageMaxSize(), (int)_userFileUploadsSettings.getImageMaxHeight(), (int)_userFileUploadsSettings.getImageMaxWidth());
        user.setLanguageId(languageId);
        user.setTimeZoneId(timeZoneId);
        user.setGreeting(greeting);
        user.setComments(comments);
        user.setFirstName(firstName);
        user.setMiddleName(middleName);
        user.setLastName(lastName);
        user.setJobTitle(jobTitle);
        user.setExpandoBridgeAttributes(serviceContext);
        user = (User)this.userPersistence.update((BaseModel)user, serviceContext);
        long contactId = user.getContactId();
        Contact contact = this._contactPersistence.fetchByPrimaryKey(contactId);
        if (contact == null) {
            contact = this._contactPersistence.create(contactId);
            contact.setCompanyId(user.getCompanyId());
            contact.setUserName("");
            contact.setClassName(User.class.getName());
            contact.setClassPK(user.getUserId());
            contact.setParentContactId(0L);
        }
        contact.setEmailAddress(user.getEmailAddress());
        contact.setFirstName(firstName);
        contact.setMiddleName(middleName);
        contact.setLastName(lastName);
        contact.setPrefixId(prefixId);
        contact.setSuffixId(suffixId);
        contact.setMale(male);
        contact.setBirthday(this.getBirthday(birthdayMonth, birthdayDay, birthdayYear));
        contact.setSmsSn(smsSn);
        contact.setFacebookSn(facebookSn);
        contact.setJabberSn(jabberSn);
        contact.setSkypeSn(skypeSn);
        contact.setTwitterSn(twitterSn);
        contact.setJobTitle(jobTitle);
        user.setContact((Contact)this._contactPersistence.update((BaseModel)contact, serviceContext));
        if (screenNameModified) {
            Group group = this._groupLocalService.getUserGroup(user.getCompanyId(), userId);
            this._groupLocalService.updateFriendlyURL(group.getGroupId(), "/" + screenName);
        }
        List previousUserGroupRoles = this._userGroupRolePersistence.findByUserId(userId);
        this.updateGroups(userId, groupIds, false);
        this.updateOrganizations(userId, organizationIds, false);
        if (roleIds != null) {
            roleIds = UsersAdminUtil.addRequiredRoles((User)user, (long[])roleIds);
            this.userPersistence.setRoles(userId, roleIds);
        }
        this.updateUserGroupRoles(user, groupIds, organizationIds, userGroupRoles, previousUserGroupRoles);
        if (userGroupIds != null) {
            this.userPersistence.setUserGroups(userId, userGroupIds);
        }
        this._announcementsDeliveryLocalService.getUserDeliveries(user.getUserId());
        if (serviceContext != null) {
            this.updateAsset(userId, user, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        }
        if (serviceContext == null || serviceContext.isIndexingEnabled()) {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
            indexer.reindex((Object)user);
        }
        if (serviceContext != null && sendEmailAddressVerification) {
            this.sendEmailAddressVerification(user, emailAddress, serviceContext);
        }
        return user;
    }

    @Deprecated
    public User updateUser(long userId, String oldPassword, String newPassword1, String newPassword2, boolean passwordReset, String reminderQueryQuestion, String reminderQueryAnswer, String screenName, String emailAddress, long facebookId, String openId, boolean hasPortrait, byte[] portraitBytes, String languageId, String timeZoneId, String greeting, String comments, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String smsSn, String facebookSn, String jabberSn, String skypeSn, String twitterSn, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, List<UserGroupRole> userGroupRoles, long[] userGroupIds, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.updateUser(userId, oldPassword, newPassword1, newPassword2, passwordReset, reminderQueryQuestion, reminderQueryAnswer, screenName, emailAddress, hasPortrait, portraitBytes, languageId, timeZoneId, greeting, comments, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, smsSn, facebookSn, jabberSn, skypeSn, twitterSn, jobTitle, groupIds, organizationIds, roleIds, userGroupRoles, userGroupIds, serviceContext);
        openId = StringUtil.trim((String)openId);
        this.validateOpenId(user.getCompanyId(), userId, openId);
        user.setFacebookId(facebookId);
        user.setOpenId(openId);
        return this.userLocalService.updateUser(user);
    }

    public void verifyEmailAddress(String ticketKey) throws PortalException {
        Ticket ticket = this._ticketLocalService.getTicket(ticketKey);
        if (ticket.isExpired() || ticket.getType() != 1) {
            throw new NoSuchTicketException("{ticketKey=" + ticketKey + "}");
        }
        User user = this.userPersistence.findByPrimaryKey(ticket.getClassPK());
        String emailAddress = ticket.getExtraInfo();
        if (!(emailAddress = StringUtil.toLowerCase((String)StringUtil.trim((String)emailAddress))).equals(user.getEmailAddress())) {
            User userWithSameEmailAddress = this.userPersistence.fetchByC_EA(user.getCompanyId(), emailAddress);
            if (userWithSameEmailAddress != null) {
                throw new UserEmailAddressException.MustNotBeDuplicate(user.getCompanyId(), user.getUserId(), emailAddress);
            }
            this.setEmailAddress(user, "", user.getFirstName(), user.getMiddleName(), user.getLastName(), emailAddress);
            Contact contact = user.getContact();
            contact.setEmailAddress(user.getEmailAddress());
            this._contactPersistence.update((BaseModel)contact);
        }
        user.setEmailAddressVerified(true);
        this.userPersistence.update((BaseModel)user);
        this._ticketLocalService.deleteTicket(ticket);
    }

    protected void addDefaultRolesAndTeams(long groupId, long[] userIds) throws PortalException {
        long[] defaultTeamIds;
        long[] defaultSiteRoleIds;
        ArrayList<Role> defaultSiteRoles = new ArrayList<Role>();
        Group group = this._groupLocalService.getGroup(groupId);
        UnicodeProperties typeSettingsUnicodeProperties = group.getTypeSettingsProperties();
        for (long defaultSiteRoleId : defaultSiteRoleIds = StringUtil.split((String)typeSettingsUnicodeProperties.getProperty("defaultSiteRoleIds"), (long)0L)) {
            Role defaultSiteRole = this._rolePersistence.fetchByPrimaryKey(defaultSiteRoleId);
            if (defaultSiteRole == null) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to find role " + defaultSiteRoleId));
                continue;
            }
            defaultSiteRoles.add(defaultSiteRole);
        }
        ArrayList<Team> defaultTeams = new ArrayList<Team>();
        for (long defaultTeamId : defaultTeamIds = StringUtil.split((String)typeSettingsUnicodeProperties.getProperty("defaultTeamIds"), (long)0L)) {
            Team defaultTeam = this._teamPersistence.findByPrimaryKey(defaultTeamId);
            if (defaultTeam == null) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to find team " + defaultTeamId));
                continue;
            }
            defaultTeams.add(defaultTeam);
        }
        if (!defaultSiteRoles.isEmpty()) {
            for (long userId : userIds) {
                HashSet<Long> userRoleIdsSet = new HashSet<Long>();
                for (Role role : defaultSiteRoles) {
                    userRoleIdsSet.add(role.getRoleId());
                }
                Object userRoleIds = ArrayUtil.toArray((Long[])userRoleIdsSet.toArray(new Long[0]));
                this._userGroupRoleLocalService.addUserGroupRoles(userId, groupId, (long[])userRoleIds);
            }
        }
        if (!defaultTeams.isEmpty()) {
            for (long userId : userIds) {
                HashSet<Long> userTeamIdsSet = new HashSet<Long>();
                for (Team team : defaultTeams) {
                    userTeamIdsSet.add(team.getTeamId());
                }
                long[] userTeamIds = ArrayUtil.toArray((Long[])userTeamIdsSet.toArray(new Long[0]));
                this.userPersistence.addTeams(userId, userTeamIds);
            }
        }
    }

    protected int authenticate(long companyId, String login, String password, String authType, Map<String, String[]> headerMap, Map<String, String[]> parameterMap, Map<String, Object> resultsMap) throws PortalException {
        if (PropsValues.AUTH_LOGIN_DISABLED) {
            return -1;
        }
        login = StringUtil.toLowerCase((String)StringUtil.trim((String)login));
        long userId = GetterUtil.getLong((String)login);
        if (authType.equals("emailAddress")) {
            if (Validator.isNull((String)login)) {
                throw new UserEmailAddressException.MustNotBeNull();
            }
        } else if (authType.equals("screenName")) {
            if (Validator.isNull((String)login)) {
                throw new UserScreenNameException.MustNotBeNull();
            }
        } else if (authType.equals("userId") && Validator.isNull((String)login)) {
            throw new UserIdException.MustNotBeNull();
        }
        if (Validator.isNull((String)password)) {
            throw new UserPasswordException.MustNotBeNull(userId);
        }
        int authResult = -1;
        if (authType.equals("emailAddress")) {
            authResult = AuthPipeline.authenticateByEmailAddress("auth.pipeline.pre", companyId, login, password, headerMap, parameterMap);
        } else if (authType.equals("screenName")) {
            authResult = AuthPipeline.authenticateByScreenName("auth.pipeline.pre", companyId, login, password, headerMap, parameterMap);
        } else if (authType.equals("userId")) {
            authResult = AuthPipeline.authenticateByUserId("auth.pipeline.pre", companyId, userId, password, headerMap, parameterMap);
        }
        User user = null;
        if (authType.equals("emailAddress")) {
            user = this.userPersistence.fetchByC_EA(companyId, login);
        } else if (authType.equals("screenName")) {
            user = this.userPersistence.fetchByC_SN(companyId, login);
        } else if (authType.equals("userId")) {
            user = this.userPersistence.fetchByPrimaryKey(GetterUtil.getLong((String)login));
        }
        if (user == null) {
            return 0;
        }
        if (!this.isUserAllowedToAuthenticate(user)) {
            return -1;
        }
        if (!(user = this._checkPasswordPolicy(user)).isPasswordEncrypted()) {
            user.setPassword(PasswordEncryptorUtil.encrypt((String)user.getPassword()));
            user.setPasswordEncrypted(true);
            user = (User)this.userPersistence.update((BaseModel)user);
        }
        boolean skipLiferayCheck = false;
        if (authResult == 2) {
            authResult = 1;
            skipLiferayCheck = true;
        } else if (authResult == 1 && PropsValues.AUTH_PIPELINE_ENABLE_LIFERAY_CHECK) {
            boolean authenticated = PwdAuthenticator.authenticate(login, password, user.getPassword());
            authResult = authenticated ? 1 : -1;
        }
        if (authResult == 1) {
            if (authType.equals("emailAddress")) {
                authResult = AuthPipeline.authenticateByEmailAddress("auth.pipeline.post", companyId, login, password, headerMap, parameterMap);
            } else if (authType.equals("screenName")) {
                authResult = AuthPipeline.authenticateByScreenName("auth.pipeline.post", companyId, login, password, headerMap, parameterMap);
            } else if (authType.equals("userId")) {
                authResult = AuthPipeline.authenticateByUserId("auth.pipeline.post", companyId, userId, password, headerMap, parameterMap);
            }
        }
        if (authResult == 1) {
            String newDigest;
            user = this.userPersistence.fetchByPrimaryKey(user.getUserId());
            String digest = user.getDigest();
            if ((skipLiferayCheck || !PropsValues.AUTH_PIPELINE_ENABLE_LIFERAY_CHECK || Validator.isNull((String)digest)) && !(newDigest = user.getDigest(password)).equals(digest)) {
                user.setDigest(newDigest);
                user = (User)this.userPersistence.update((BaseModel)user);
            }
        }
        if (authResult == -1) {
            authResult = this.handleAuthenticationFailure(login, authType, user, headerMap, parameterMap);
            user = this.userPersistence.fetchByPrimaryKey(user.getUserId());
        } else {
            user = this.resetFailedLoginAttempts(user);
        }
        if (resultsMap != null) {
            resultsMap.put("user", user);
            resultsMap.put("userId", user.getUserId());
        }
        return authResult;
    }

    protected SearchContext buildSearchContext(long companyId, String firstName, String middleName, String lastName, String fullName, String screenName, String emailAddress, String street, String city, String zip, String region, String country, int status, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort[] sorts) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAndSearch(andSearch);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (params != null) {
            Long groupId = (Long)params.get("groupId");
            if (groupId == null) {
                groupId = 0L;
            }
            attributes.put("groupId", groupId);
        }
        attributes.put("city", city);
        attributes.put("country", country);
        attributes.put("emailAddress", emailAddress);
        attributes.put("firstName", firstName);
        attributes.put("fullName", fullName);
        attributes.put("lastName", lastName);
        attributes.put("middleName", middleName);
        attributes.put("params", params);
        attributes.put("region", region);
        attributes.put("screenName", screenName);
        attributes.put("status", status);
        attributes.put("street", street);
        attributes.put("zip", zip);
        searchContext.setAttributes(attributes);
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setGroupIds(new long[]{-1L});
        if (params != null) {
            String keywords = (String)params.remove("keywords");
            if (Validator.isNotNull((String)keywords)) {
                searchContext.setKeywords(keywords);
            }
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                try {
                    attributes.putIfAbsent(entry.getKey(), (Serializable)entry.getValue());
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)exception, (Throwable)exception);
                }
            }
        }
        if (sorts != null) {
            searchContext.setSorts(sorts);
        }
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker != null) {
            searchContext.setUserId(permissionChecker.getUserId());
        }
        return searchContext;
    }

    protected User doCheckLockout(User user, PasswordPolicy passwordPolicy) throws PortalException {
        long requiredElapsedTime;
        long elapsedTime;
        if (!passwordPolicy.isLockout()) {
            return user;
        }
        Date date = new Date();
        int failedLoginAttempts = user.getFailedLoginAttempts();
        if (failedLoginAttempts > 0) {
            Date lastFailedLoginDate = user.getLastFailedLoginDate();
            long failedLoginTime = lastFailedLoginDate.getTime();
            elapsedTime = date.getTime() - failedLoginTime;
            requiredElapsedTime = passwordPolicy.getResetFailureCount() * 1000L;
            if (requiredElapsedTime != 0L && elapsedTime > requiredElapsedTime) {
                user.setFailedLoginAttempts(0);
                user = (User)this.userPersistence.update((BaseModel)user);
            }
        }
        if (user.isLockout()) {
            Date lockoutDate = user.getLockoutDate();
            long lockoutTime = lockoutDate.getTime();
            elapsedTime = date.getTime() - lockoutTime;
            requiredElapsedTime = passwordPolicy.getLockoutDuration() * 1000L;
            if (requiredElapsedTime != 0L && elapsedTime > requiredElapsedTime) {
                user.setLockout(false);
                user.setLockoutDate(null);
                user = (User)this.userPersistence.update((BaseModel)user);
            }
        }
        if (user.isLockout()) {
            throw new UserLockoutException.PasswordPolicyLockout(user, passwordPolicy);
        }
        return user;
    }

    protected User doCheckPasswordExpired(User user, PasswordPolicy passwordPolicy) throws PortalException {
        if (this.isPasswordExpired(user)) {
            int graceLoginCount = user.getGraceLoginCount();
            if (graceLoginCount < passwordPolicy.getGraceLimit()) {
                user.setGraceLoginCount(++graceLoginCount);
                user = (User)this.userPersistence.update((BaseModel)user);
            } else {
                user.setDigest("");
                user = (User)this.userPersistence.update((BaseModel)user);
                throw new PasswordExpiredException();
            }
        }
        if (passwordPolicy.isChangeable() && passwordPolicy.isChangeRequired() && user.getLastLoginDate() == null) {
            user.setPasswordReset(true);
            user = (User)this.userPersistence.update((BaseModel)user);
        }
        return user;
    }

    protected Date getBirthday(int birthdayMonth, int birthdayDay, int birthdayYear) throws PortalException {
        Date birthday = PortalUtil.getDate((int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, ContactBirthdayException.class);
        if (birthday.after(new Date())) {
            throw new ContactBirthdayException();
        }
        return birthday;
    }

    protected String getLogin(String login) {
        return StringUtil.lowerCase((String)StringUtil.trim((String)login));
    }

    protected Sort[] getSorts(OrderByComparator<User> orderByComparator) {
        if (orderByComparator == null) {
            return new Sort[0];
        }
        String[] orderByClauses = StringUtil.split((String)orderByComparator.getOrderBy());
        String[] orderByFields = orderByComparator.getOrderByFields();
        Sort[] sorts = new Sort[orderByFields.length];
        for (int i = 0; i < orderByFields.length; ++i) {
            boolean reverse = orderByClauses[i].contains("DESC");
            sorts[i] = new Sort(orderByFields[i], reverse);
        }
        return sorts;
    }

    protected int handleAuthenticationFailure(String login, String authType, User user, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) {
        if (user == null) {
            return 0;
        }
        try {
            if (authType.equals("emailAddress")) {
                AuthPipeline.onFailureByEmailAddress("auth.failure", user.getCompanyId(), user.getEmailAddress(), headerMap, parameterMap);
            } else if (authType.equals("screenName")) {
                AuthPipeline.onFailureByScreenName("auth.failure", user.getCompanyId(), user.getScreenName(), headerMap, parameterMap);
            } else if (authType.equals("userId")) {
                AuthPipeline.onFailureByUserId("auth.failure", user.getCompanyId(), user.getUserId(), headerMap, parameterMap);
            }
            user = this.userPersistence.fetchByPrimaryKey(user.getUserId());
            if (user == null) {
                return 0;
            }
            if (!LDAPSettingsUtil.isPasswordPolicyEnabled((long)user.getCompanyId())) {
                int maxFailures;
                PasswordPolicy passwordPolicy = user.getPasswordPolicy();
                int failedLoginAttempts = (user = this.userPersistence.fetchByPrimaryKey(user.getUserId())).getFailedLoginAttempts();
                if (failedLoginAttempts >= (maxFailures = passwordPolicy.getMaxFailure()) && maxFailures != 0) {
                    if (authType.equals("emailAddress")) {
                        AuthPipeline.onMaxFailuresByEmailAddress("auth.max.failures", user.getCompanyId(), user.getEmailAddress(), headerMap, parameterMap);
                    } else if (authType.equals("screenName")) {
                        AuthPipeline.onMaxFailuresByScreenName("auth.max.failures", user.getCompanyId(), user.getScreenName(), headerMap, parameterMap);
                    } else if (authType.equals("userId")) {
                        AuthPipeline.onMaxFailuresByUserId("auth.max.failures", user.getCompanyId(), user.getUserId(), headerMap, parameterMap);
                    }
                }
            }
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
        return -1;
    }

    protected boolean isUseCustomSQL(LinkedHashMap<String, Object> params) {
        if (MapUtil.isEmpty(params)) {
            return false;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            if (key.equals("inherit")) {
                if (!Boolean.TRUE.equals(entry.getValue())) continue;
                return true;
            }
            if (key.equals("noOrganizations")) {
                if (!Boolean.TRUE.equals(entry.getValue())) {
                    return true;
                }
                Object usersOrgsCount = params.get("usersOrgsCount");
                if (usersOrgsCount != null && GetterUtil.getLong((Object)usersOrgsCount) == 0L) continue;
                return true;
            }
            if (key.equals("groupId") || key.equals("accountEntryIds") || key.equals("usersGroups") || key.equals("usersOrgs") || key.equals("usersOrgsCount") || key.equals("usersRoles") || key.equals("usersTeams") || key.equals("usersUserGroups")) continue;
            return true;
        }
        return false;
    }

    protected boolean isUserAllowedToAuthenticate(User user) throws PortalException {
        if (user.isDefaultUser()) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Authentication is disabled for the default user");
            }
            return false;
        }
        if (!user.isActive()) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Authentication is disabled for inactive user " + user.getUserId()));
            }
            return false;
        }
        return true;
    }

    protected void notifyUser(User user, ServiceContext serviceContext) {
        if (!PrefsPropsUtil.getBoolean(user.getCompanyId(), "admin.email.user.added.enabled")) {
            return;
        }
        boolean autoPassword = GetterUtil.getBoolean((Object)serviceContext.getAttribute("autoPassword"));
        String fromAddress = PrefsPropsUtil.getString(user.getCompanyId(), "admin.email.from.address");
        String fromName = PrefsPropsUtil.getString(user.getCompanyId(), "admin.email.from.name");
        String passwordResetURL = "";
        String portalURL = serviceContext.getPortalURL();
        PortletPreferences companyPortletPreferences = PrefsPropsUtil.getPreferences(user.getCompanyId(), true);
        Map localizedSubjectMap = LocalizationUtil.getLocalizationMap((PortletPreferences)companyPortletPreferences, (String)"adminEmailUserAddedSubject", (String)"admin.email.user.added.subject");
        Map localizedBodyMap = null;
        if (!autoPassword) {
            localizedBodyMap = LocalizationUtil.getLocalizationMap((PortletPreferences)companyPortletPreferences, (String)"adminEmailUserAddedNoPasswordBody", (String)"admin.email.user.added.no.password.body");
        } else {
            Layout layout;
            Ticket ticket = this._ticketLocalService.addDistinctTicket(user.getCompanyId(), User.class.getName(), user.getUserId(), 3, null, null, serviceContext);
            String updatePasswordURL = "/portal/update_password?";
            long plid = serviceContext.getPlid();
            if (plid > 0L && (layout = this._layoutLocalService.fetchLayout(plid)) != null) {
                Group group = layout.getGroup();
                if (!layout.isPrivateLayout() && !group.isUser()) {
                    updatePasswordURL = updatePasswordURL + "p_l_id=" + serviceContext.getPlid() + "&";
                }
            }
            passwordResetURL = StringBundler.concat((String[])new String[]{serviceContext.getPortalURL(), serviceContext.getPathMain(), updatePasswordURL, "ticketKey=", ticket.getKey()});
            localizedBodyMap = LocalizationUtil.getLocalizationMap((PortletPreferences)companyPortletPreferences, (String)"adminEmailUserAddedResetPasswordBody", (String)"admin.email.user.added.reset.password.body");
        }
        String subject = this._getLocalizedValue(localizedSubjectMap, user.getLocale(), LocaleUtil.getDefault());
        String body = this._getLocalizedValue(localizedBodyMap, user.getLocale(), LocaleUtil.getDefault());
        MailTemplateContextBuilder mailTemplateContextBuilder = MailTemplateFactoryUtil.createMailTemplateContextBuilder();
        mailTemplateContextBuilder.put("[$FROM_ADDRESS$]", fromAddress);
        mailTemplateContextBuilder.put("[$FROM_NAME$]", HtmlUtil.escape((String)fromName));
        mailTemplateContextBuilder.put("[$PORTAL_URL$]", portalURL);
        mailTemplateContextBuilder.put("[$TO_ADDRESS$]", user.getEmailAddress());
        mailTemplateContextBuilder.put("[$TO_NAME$]", HtmlUtil.escape((String)user.getFullName()));
        mailTemplateContextBuilder.put("[$PASSWORD_SETUP_URL$]", passwordResetURL);
        mailTemplateContextBuilder.put("[$USER_ID$]", String.valueOf(user.getUserId()));
        mailTemplateContextBuilder.put("[$USER_SCREENNAME$]", HtmlUtil.escape((String)user.getScreenName()));
        MailTemplateContext mailTemplateContext = mailTemplateContextBuilder.build();
        try {
            this._sendNotificationEmail(fromAddress, fromName, user.getEmailAddress(), user, subject, body, mailTemplateContext);
        }
        catch (PortalException portalException) {
            ReflectionUtil.throwException((Throwable)portalException);
        }
    }

    protected void reindex(List<User> users) throws SearchException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        try {
            indexer.reindex(users);
        }
        catch (SearchException searchException) {
            throw new SystemException((Throwable)searchException);
        }
    }

    protected void reindex(long userId) throws SearchException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        User user = this.userLocalService.fetchUser(userId);
        indexer.reindex((Object)user);
    }

    protected void reindex(long[] userIds) throws SearchException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        ArrayList<User> users = new ArrayList<User>(userIds.length);
        long[] lArray = userIds;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long userId = lArray[i];
            User user = this.userLocalService.fetchUser(userId.longValue());
            users.add(user);
        }
        indexer.reindex(users);
    }

    protected void reindex(User user) throws SearchException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        indexer.reindex((Object)user);
    }

    protected User resetFailedLoginAttempts(User user) {
        return this.resetFailedLoginAttempts(user, false);
    }

    protected User resetFailedLoginAttempts(User user, boolean forceUpdate) {
        if (forceUpdate || user.getFailedLoginAttempts() > 0) {
            user.setFailedLoginAttempts(0);
            user = (User)this.userPersistence.update((BaseModel)user);
        }
        return user;
    }

    protected BaseModelSearchResult<User> searchUsers(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext);
            List users = UsersAdminUtil.getUsers((Hits)hits);
            if (users == null) continue;
            return new BaseModelSearchResult(users, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    protected void sendPasswordNotification(User user, long companyId, String newPassword, String passwordResetURL, String fromName, String fromAddress, String subject, String body, ServiceContext serviceContext) {
        if (Validator.isNull((String)fromName)) {
            fromName = PrefsPropsUtil.getString(companyId, "admin.email.from.name");
        }
        if (Validator.isNull((String)fromAddress)) {
            fromAddress = PrefsPropsUtil.getString(companyId, "admin.email.from.address");
        }
        String toName = user.getFullName();
        String toAddress = user.getEmailAddress();
        PortletPreferences companyPortletPreferences = PrefsPropsUtil.getPreferences(companyId, true);
        String bodyProperty = null;
        String prefix = null;
        String subjectProperty = null;
        if (Validator.isNotNull((String)passwordResetURL)) {
            bodyProperty = "admin.email.password.reset.body";
            prefix = "adminEmailPasswordReset";
            subjectProperty = "admin.email.password.reset.subject";
        } else {
            bodyProperty = "admin.email.password.changed.body";
            prefix = "adminEmailPasswordChanged";
            subjectProperty = "admin.email.password.changed.subject";
        }
        String localizedBody = body;
        if (Validator.isNull((String)body)) {
            Map localizedBodyMap = LocalizationUtil.getLocalizationMap((PortletPreferences)companyPortletPreferences, (String)(prefix + "Body"), (String)bodyProperty);
            localizedBody = this._getLocalizedValue(localizedBodyMap, user.getLocale(), LocaleUtil.getDefault());
        }
        String localizedSubject = subject;
        if (Validator.isNull((String)subject)) {
            Map localizedSubjectMap = LocalizationUtil.getLocalizationMap((PortletPreferences)companyPortletPreferences, (String)(prefix + "Subject"), (String)subjectProperty);
            localizedSubject = this._getLocalizedValue(localizedSubjectMap, user.getLocale(), LocaleUtil.getDefault());
        }
        MailTemplateContextBuilder mailTemplateContextBuilder = MailTemplateFactoryUtil.createMailTemplateContextBuilder();
        mailTemplateContextBuilder.put("[$FROM_ADDRESS$]", fromAddress);
        mailTemplateContextBuilder.put("[$FROM_NAME$]", HtmlUtil.escape((String)fromName));
        mailTemplateContextBuilder.put("[$PASSWORD_RESET_URL$]", passwordResetURL);
        mailTemplateContextBuilder.put("[$PORTAL_URL$]", serviceContext.getPortalURL());
        mailTemplateContextBuilder.put("[$REMOTE_ADDRESS$]", serviceContext.getRemoteAddr());
        mailTemplateContextBuilder.put("[$REMOTE_HOST$]", HtmlUtil.escape((String)serviceContext.getRemoteHost()));
        mailTemplateContextBuilder.put("[$TO_ADDRESS$]", toAddress);
        mailTemplateContextBuilder.put("[$TO_NAME$]", HtmlUtil.escape((String)toName));
        mailTemplateContextBuilder.put("[$USER_ID$]", String.valueOf(user.getUserId()));
        mailTemplateContextBuilder.put("[$USER_SCREENNAME$]", HtmlUtil.escape((String)user.getScreenName()));
        MailTemplateContext mailTemplateContext = mailTemplateContextBuilder.build();
        try {
            this._sendNotificationEmail(fromAddress, fromName, toAddress, user, localizedSubject, localizedBody, mailTemplateContext);
        }
        catch (PortalException portalException) {
            ReflectionUtil.throwException((Throwable)portalException);
        }
    }

    protected void setEmailAddress(User user, String password, String firstName, String middleName, String lastName, String emailAddress) throws PortalException {
        if (StringUtil.equalsIgnoreCase((String)emailAddress, (String)user.getEmailAddress())) {
            return;
        }
        long userId = user.getUserId();
        if (!user.hasCompanyMx() && user.hasCompanyMx(emailAddress) && Validator.isNotNull((String)password)) {
            this.mailService.addUser(user.getCompanyId(), userId, password, firstName, middleName, lastName, emailAddress);
        } else if (user.hasCompanyMx() && user.hasCompanyMx(emailAddress)) {
            this.mailService.updateEmailAddress(user.getCompanyId(), userId, emailAddress);
        } else if (user.hasCompanyMx() && !user.hasCompanyMx(emailAddress)) {
            this.mailService.deleteEmailAddress(user.getCompanyId(), userId);
        }
        user.setDigest("");
        user.setEmailAddress(emailAddress);
    }

    protected void trackPassword(User user) throws PortalException {
        String oldEncPwd = user.getPassword();
        if (!user.isPasswordEncrypted()) {
            oldEncPwd = PasswordEncryptorUtil.encrypt((String)user.getPassword());
        }
        this._passwordTrackerLocalService.trackPassword(user.getUserId(), oldEncPwd);
    }

    protected void unsetUserGroups(long userId, long[] groupIds) throws PortalException {
        List userGroupRoles = this._userGroupRolePersistence.findByUserId(userId);
        for (UserGroupRole userGroupRole : userGroupRoles) {
            Role role;
            if (!ArrayUtil.contains((long[])groupIds, (long)userGroupRole.getGroupId()) || (role = this._rolePersistence.findByPrimaryKey(userGroupRole.getRoleId())).getType() != 5 && role.getType() != 2) continue;
            this._userGroupRolePersistence.remove((BaseModel)userGroupRole);
        }
        List oldTeams = this.userPersistence.getTeams(userId);
        ArrayList<Team> removedFromTeams = new ArrayList<Team>();
        for (Team team : oldTeams) {
            if (!ArrayUtil.contains((long[])groupIds, (long)team.getGroupId())) continue;
            removedFromTeams.add(team);
        }
        if (!removedFromTeams.isEmpty()) {
            this.userPersistence.removeTeams(userId, removedFromTeams);
        }
        this.userPersistence.removeGroups(userId, groupIds);
        TransactionCommitCallbackUtil.registerCallback(() -> {
            Message message = new Message();
            message.put("groupIds", (Object)groupIds);
            message.put("userId", (Object)userId);
            MessageBusUtil.sendMessage((String)"liferay/subscription_clean_up", (Message)message);
            return null;
        });
    }

    protected void unsetUserOrganizations(long userId, long[] organizationIds) throws PortalException {
        long[] groupIds = new long[organizationIds.length];
        for (int i = 0; i < organizationIds.length; ++i) {
            Organization organization = this._organizationPersistence.findByPrimaryKey(organizationIds[i]);
            groupIds[i] = organization.getGroupId();
        }
        this._userGroupRoleLocalService.deleteUserGroupRoles(userId, groupIds);
        this._organizationLocalService.deleteUserOrganizations(userId, organizationIds);
        this.reindex(userId);
        TransactionCommitCallbackUtil.registerCallback(() -> {
            Message message = new Message();
            message.put("groupIds", (Object)groupIds);
            message.put("userId", (Object)userId);
            MessageBusUtil.sendMessage((String)"liferay/subscription_clean_up", (Message)message);
            return null;
        });
    }

    protected void updateGroups(long userId, long[] newGroupIds, boolean indexingEnabled) throws PortalException {
        if (newGroupIds == null) {
            return;
        }
        List oldGroupIds = ListUtil.fromArray((long[])this.getGroupPrimaryKeys(userId));
        for (long newGroupId : newGroupIds) {
            oldGroupIds.remove(newGroupId);
        }
        if (!oldGroupIds.isEmpty()) {
            this.unsetUserGroups(userId, ArrayUtil.toLongArray((Collection)oldGroupIds));
        }
        this.userPersistence.setGroups(userId, newGroupIds);
        for (long newGroupId : newGroupIds) {
            this.addDefaultRolesAndTeams(newGroupId, new long[]{userId});
        }
        if (indexingEnabled) {
            this.reindex(userId);
        }
    }

    protected void updateOrganizations(long userId, long[] newOrganizationIds, boolean indexingEnabled) throws PortalException {
        if (newOrganizationIds == null) {
            return;
        }
        List oldOrganizationIds = ListUtil.fromArray((long[])this.getOrganizationPrimaryKeys(userId));
        for (long newOrganizationId : newOrganizationIds) {
            oldOrganizationIds.remove(newOrganizationId);
        }
        if (!oldOrganizationIds.isEmpty()) {
            this.unsetUserOrganizations(userId, ArrayUtil.toLongArray((Collection)oldOrganizationIds));
        }
        this.userPersistence.setOrganizations(userId, newOrganizationIds);
        if (indexingEnabled) {
            this.reindex(userId);
        }
    }

    protected void updateUserGroupRoles(User user, long[] groupIds, long[] organizationIds, List<UserGroupRole> userGroupRoles, List<UserGroupRole> previousUserGroupRoles) throws PortalException {
        if (userGroupRoles == null) {
            return;
        }
        userGroupRoles = new ArrayList<UserGroupRole>(userGroupRoles);
        for (UserGroupRole userGroupRole : previousUserGroupRoles) {
            if (userGroupRoles.contains(userGroupRole)) {
                userGroupRoles.remove(userGroupRole);
                continue;
            }
            this._userGroupRoleLocalService.deleteUserGroupRole(userGroupRole);
        }
        if (ListUtil.isEmpty(userGroupRoles)) {
            return;
        }
        long[] validGroupIds = null;
        if (groupIds != null) {
            validGroupIds = ArrayUtil.clone((long[])groupIds);
        } else {
            List userGroups = this._groupLocalService.getUserGroups(user.getUserId(), true);
            int size = userGroups.size();
            validGroupIds = new long[size];
            for (int i = 0; i < size; ++i) {
                Group userGroup = (Group)userGroups.get(i);
                validGroupIds[i] = userGroup.getGroupId();
            }
        }
        if (organizationIds == null) {
            organizationIds = user.getOrganizationIds();
        }
        for (long organizationId : organizationIds) {
            Organization organization = this._organizationPersistence.findByPrimaryKey(organizationId);
            if (ArrayUtil.contains((long[])validGroupIds, (long)organization.getGroupId())) continue;
            validGroupIds = ArrayUtil.append((long[])validGroupIds, (long)organization.getGroupId());
        }
        Arrays.sort(validGroupIds);
        Object object = userGroupRoles.iterator();
        while (object.hasNext()) {
            UserGroupRole userGroupRole = (UserGroupRole)object.next();
            int count = Arrays.binarySearch(validGroupIds, userGroupRole.getGroupId());
            if (count < 0) continue;
            this._userGroupRoleLocalService.addUserGroupRole(userGroupRole);
        }
    }

    protected void validate(long companyId, long userId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, String openId, String firstName, String middleName, String lastName, long[] organizationIds, Locale locale) throws PortalException {
        User user;
        this.validateCompanyMaxUsers(companyId);
        if (!autoScreenName) {
            this.validateScreenName(companyId, userId, screenName);
        }
        if (!autoPassword) {
            PasswordPolicy passwordPolicy = this._passwordPolicyLocalService.getDefaultPasswordPolicy(companyId);
            PwdToolkitUtil.validate(companyId, 0L, password1, password2, passwordPolicy);
        }
        this.validateEmailAddress(companyId, emailAddress);
        if (Validator.isNotNull((String)emailAddress) && (user = this.userPersistence.fetchByC_EA(companyId, emailAddress)) != null && user.getUserId() != userId) {
            throw new UserEmailAddressException.MustNotBeDuplicate(companyId, emailAddress);
        }
        this.validateOpenId(companyId, userId, openId);
        this.validateFullName(companyId, firstName, middleName, lastName, locale);
        if (organizationIds != null) {
            for (long organizationId : organizationIds) {
                Organization organization = this._organizationPersistence.fetchByPrimaryKey(organizationId);
                if (organization != null) continue;
                throw new NoSuchOrganizationException("{organizationId=" + organizationId + "}");
            }
        }
    }

    protected void validate(long userId, String screenName, String emailAddress, String openId, String firstName, String middleName, String lastName, String smsSn, Locale locale) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        if (!StringUtil.equalsIgnoreCase((String)user.getScreenName(), (String)screenName)) {
            this.validateScreenName(user.getCompanyId(), userId, screenName);
        }
        this.validateEmailAddress(user.getCompanyId(), emailAddress);
        this.validateOpenId(user.getCompanyId(), userId, openId);
        if (!user.isDefaultUser()) {
            User userWithSameEmailAddress;
            if (Validator.isNotNull((String)emailAddress) && !StringUtil.equalsIgnoreCase((String)user.getEmailAddress(), (String)emailAddress) && (userWithSameEmailAddress = this.userPersistence.fetchByC_EA(user.getCompanyId(), emailAddress)) != null) {
                throw new UserEmailAddressException.MustNotBeDuplicate(user.getCompanyId(), userId, emailAddress);
            }
            this.validateFullName(user.getCompanyId(), firstName, middleName, lastName, locale);
        }
        if (Validator.isNotNull((String)smsSn) && !Validator.isEmailAddress((String)smsSn)) {
            throw new UserSmsException.MustBeEmailAddress(smsSn);
        }
    }

    protected void validateCompanyMaxUsers(long companyId) throws PortalException {
        Company company = this._companyPersistence.findByPrimaryKey(companyId);
        if (company.isSystem() || company.getMaxUsers() == 0) {
            return;
        }
        int userCount = this.searchCount(companyId, null, 0, null);
        if (userCount >= company.getMaxUsers()) {
            throw new CompanyMaxUsersException();
        }
    }

    protected void validateEmailAddress(long companyId, String emailAddress) throws PortalException {
        String[] reservedEmailAddresses;
        if (Validator.isNull((String)emailAddress) && !PropsValues.USERS_EMAIL_ADDRESS_REQUIRED) {
            return;
        }
        EmailAddressValidator emailAddressValidator = EmailAddressValidatorFactory.getInstance();
        if (!emailAddressValidator.validate(companyId, emailAddress)) {
            throw new UserEmailAddressException.MustValidate(emailAddress, emailAddressValidator);
        }
        String pop3User = PrefsPropsUtil.getString("mail.session.mail.pop3.user", PropsValues.MAIL_SESSION_MAIL_POP3_USER);
        if (StringUtil.equalsIgnoreCase((String)emailAddress, (String)pop3User)) {
            throw new UserEmailAddressException.MustNotBePOP3User(emailAddress);
        }
        for (String reservedEmailAddress : reservedEmailAddresses = PrefsPropsUtil.getStringArray(companyId, "admin.reserved.email.addresses", "\n", PropsValues.ADMIN_RESERVED_EMAIL_ADDRESSES)) {
            if (!StringUtil.equalsIgnoreCase((String)emailAddress, (String)reservedEmailAddress)) continue;
            throw new UserEmailAddressException.MustNotBeReserved(emailAddress, reservedEmailAddresses);
        }
    }

    protected void validateEmailAddress(User user, String emailAddress1, String emailAddress2) throws PortalException {
        User userWithSameEmailAddress;
        if (!emailAddress1.equals(emailAddress2)) {
            throw new UserEmailAddressException.MustBeEqual(user, emailAddress1, emailAddress2);
        }
        this.validateEmailAddress(user.getCompanyId(), emailAddress1);
        this.validateEmailAddress(user.getCompanyId(), emailAddress2);
        if (!StringUtil.equalsIgnoreCase((String)emailAddress1, (String)user.getEmailAddress()) && (userWithSameEmailAddress = this.userPersistence.fetchByC_EA(user.getCompanyId(), emailAddress1)) != null) {
            throw new UserEmailAddressException.MustNotBeDuplicate(user.getCompanyId(), user.getUserId(), emailAddress1);
        }
    }

    protected void validateFullName(long companyId, String firstName, String middleName, String lastName, Locale locale) throws PortalException {
        FullNameDefinition fullNameDefinition = FullNameDefinitionFactory.getInstance((Locale)locale);
        if (Validator.isNull((String)firstName)) {
            throw new ContactNameException.MustHaveFirstName();
        }
        if (Validator.isNull((String)middleName) && fullNameDefinition.isFieldRequired("middle-name")) {
            throw new ContactNameException.MustHaveMiddleName();
        }
        if (Validator.isNull((String)lastName) && fullNameDefinition.isFieldRequired("last-name")) {
            throw new ContactNameException.MustHaveLastName();
        }
        FullNameValidator fullNameValidator = FullNameValidatorFactory.getInstance();
        if (!fullNameValidator.validate(companyId, firstName, middleName, lastName)) {
            throw new ContactNameException.MustHaveValidFullName(fullNameValidator);
        }
    }

    protected void validateGoogleUserId(long companyId, long userId, String googleUserId) throws PortalException {
        if (Validator.isNull((String)googleUserId)) {
            return;
        }
        User user = this.userPersistence.fetchByC_GUID(companyId, googleUserId);
        if (user != null && user.getUserId() != userId) {
            throw new DuplicateGoogleUserIdException(StringBundler.concat((Object[])new Object[]{"New user ", userId, " conflicts with existing user ", userId, " who is already associated with Google user ID ", googleUserId}));
        }
    }

    protected void validateOpenId(long companyId, long userId, String openId) throws PortalException {
        if (Validator.isNull((String)openId)) {
            return;
        }
        User user = this.userPersistence.fetchByC_O(companyId, openId);
        if (user != null && user.getUserId() != userId) {
            throw new DuplicateOpenIdException("{userId=" + userId + "}");
        }
    }

    protected void validatePassword(long companyId, long userId, String password1, String password2) throws PortalException {
        if (Validator.isNull((String)password1) || Validator.isNull((String)password2)) {
            throw new UserPasswordException.MustNotBeNull(userId);
        }
        if (!password1.equals(password2)) {
            throw new UserPasswordException.MustMatch(userId);
        }
        PasswordPolicy passwordPolicy = this._passwordPolicyLocalService.getPasswordPolicyByUserId(userId);
        PwdToolkitUtil.validate(companyId, userId, password1, password2, passwordPolicy);
    }

    protected void validateReminderQuery(long companyId, String question, String answer) throws PortalException {
        if (!PrefsPropsUtil.getBoolean(companyId, "users.reminder.queries.enabled", PropsValues.USERS_REMINDER_QUERIES_ENABLED)) {
            return;
        }
        if (Validator.isNull((String)question)) {
            throw new UserReminderQueryException("Question is null");
        }
        if (Validator.isNull((String)answer)) {
            throw new UserReminderQueryException("Answer is null");
        }
    }

    protected void validateScreenName(long companyId, long userId, String screenName) throws PortalException {
        String[] reservedScreenNames;
        String[] anonymousNames;
        if (Validator.isNull((String)screenName)) {
            throw new UserScreenNameException.MustNotBeNull(userId);
        }
        ScreenNameValidator screenNameValidator = ScreenNameValidatorFactory.getInstance();
        if (!screenNameValidator.validate(companyId, screenName)) {
            throw new UserScreenNameException.MustValidate(userId, screenName, screenNameValidator);
        }
        if (Validator.isNumber((String)screenName) && !PropsValues.USERS_SCREEN_NAME_ALLOW_NUMERIC) {
            throw new UserScreenNameException.MustNotBeNumeric(userId, screenName);
        }
        for (String anonymousName : anonymousNames = BaseServiceImpl.ANONYMOUS_NAMES) {
            if (!StringUtil.equalsIgnoreCase((String)screenName, (String)anonymousName)) continue;
            throw new UserScreenNameException.MustNotBeReservedForAnonymous(userId, screenName, anonymousNames);
        }
        User user = this.userPersistence.fetchByC_SN(companyId, screenName);
        if (user != null && user.getUserId() != userId) {
            throw new UserScreenNameException.MustNotBeDuplicate(user.getUserId(), screenName);
        }
        String friendlyURL = FriendlyURLNormalizerUtil.normalize((String)("/" + screenName));
        int exceptionType = LayoutImpl.validateFriendlyURL(friendlyURL);
        if (exceptionType != -1) {
            throw new UserScreenNameException.MustProduceValidFriendlyURL(userId, screenName, exceptionType);
        }
        for (String reservedScreenName : reservedScreenNames = PrefsPropsUtil.getStringArray(companyId, "admin.reserved.screen.names", "\n", PropsValues.ADMIN_RESERVED_SCREEN_NAMES)) {
            if (!StringUtil.equalsIgnoreCase((String)screenName, (String)reservedScreenName)) continue;
            throw new UserScreenNameException.MustNotBeReserved(userId, screenName, reservedScreenNames);
        }
    }

    private User _checkPasswordPolicy(User user) throws PortalException {
        if (!LDAPSettingsUtil.isPasswordPolicyEnabled((long)user.getCompanyId())) {
            PasswordPolicy passwordPolicy = user.getPasswordPolicy();
            user = this.doCheckLockout(user, passwordPolicy);
            if (!PasswordModificationThreadLocal.isPasswordModified()) {
                user = this.doCheckPasswordExpired(user, passwordPolicy);
            }
        }
        return user;
    }

    private void _checkPasswordReset(PasswordPolicy passwordPolicy, long[] userIds) {
        if (passwordPolicy == null || passwordPolicy.isChangeable()) {
            return;
        }
        for (long userId : userIds) {
            try {
                this.updatePasswordReset(userId, false);
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)portalException, (Throwable)portalException);
            }
        }
    }

    private String _getLocalizedValue(Map<Locale, String> localizedValueMap, Locale locale, Locale fallbackLocale) {
        if (localizedValueMap == null) {
            return null;
        }
        String localizedValue = localizedValueMap.get(locale);
        if (Validator.isNotNull((String)localizedValue)) {
            return localizedValue;
        }
        return localizedValueMap.get(fallbackLocale);
    }

    private void _invalidateTicket(User user) throws PortalException {
        List tickets = this._ticketLocalService.getTickets(user.getCompanyId(), User.class.getName(), user.getUserId(), 3);
        for (Ticket ticket : tickets) {
            if (ticket.isExpired()) continue;
            this._ticketLocalService.updateTicket(ticket.getTicketId(), User.class.getName(), user.getUserId(), 3, ticket.getExtraInfo(), new Date());
        }
    }

    private boolean _isPasswordUnchanged(User user, String newPlaintextPwd, String newEncPwd) throws PwdEncryptorException {
        if (!user.isPasswordEncrypted()) {
            return newPlaintextPwd.equals(user.getPassword());
        }
        return newEncPwd.equals(user.getPassword());
    }

    private void _sendNotificationEmail(String fromAddress, String fromName, String toAddress, User toUser, String subject, String body, MailTemplateContext mailTemplateContext) throws PortalException {
        try {
            MailTemplate subjectTemplate = MailTemplateFactoryUtil.createMailTemplate((String)subject, (boolean)false);
            MailTemplate bodyTemplate = MailTemplateFactoryUtil.createMailTemplate((String)body, (boolean)true);
            MailMessage mailMessage = new MailMessage(new InternetAddress(fromAddress, fromName), new InternetAddress(toAddress, toUser.getFullName()), subjectTemplate.renderAsString(toUser.getLocale(), mailTemplateContext), bodyTemplate.renderAsString(toUser.getLocale(), mailTemplateContext), true);
            Company company = this._companyLocalService.getCompany(toUser.getCompanyId());
            mailMessage.setMessageId(PortalUtil.getMailId((String)company.getMx(), (String)"user", (Object[])new Object[]{System.currentTimeMillis()}));
            this.mailService.sendEmail(mailMessage);
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
    }
}

