/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.comparator.PortletNameComparator;
import com.liferay.portlet.PortletResourceAccessor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public class ComboServletStaticURLGenerator {
    private static final PortletNameComparator _portletNameComparator = new PortletNameComparator();
    private PortletResourceAccessor[] _portletResourceAccessors;
    private Predicate<String> _predicate = s -> true;
    private long _timestamp;
    private String _urlPrefix;
    private Set<String> _visitedURLs;

    public List<String> generate(List<Portlet> portlets) {
        ArrayList<String> urls = new ArrayList<String>();
        StringBundler sb = new StringBundler();
        long timestamp = this._timestamp;
        portlets = ListUtil.copy(portlets);
        portlets = ListUtil.sort((List)portlets, (Comparator)_portletNameComparator);
        for (Portlet portlet : portlets) {
            for (PortletResourceAccessor portletResourceAccessor : this._portletResourceAccessors) {
                List portletResources = (List)portletResourceAccessor.get(portlet);
                for (String portletResource : portletResources) {
                    if (!this._predicate.test(portletResource)) continue;
                    String url = portletResource;
                    if (!HttpUtil.hasProtocol((String)portletResource)) {
                        url = PortalUtil.getPathProxy() + portlet.getContextPath() + portletResource;
                    }
                    if (this._visitedURLs.contains(url)) continue;
                    if (HttpUtil.hasProtocol((String)portletResource)) {
                        urls.add(portletResource);
                    } else {
                        sb.append("&");
                        if (!portletResourceAccessor.isPortalResource()) {
                            sb.append(portlet.getPortletId());
                            sb.append(":");
                        }
                        sb.append(HtmlUtil.escapeURL((String)portletResource));
                        timestamp = Math.max(timestamp, portlet.getTimestamp());
                    }
                    this._visitedURLs.add(url);
                }
            }
        }
        if (sb.length() > 0) {
            String url = this._urlPrefix + sb.toString();
            url = HttpUtil.addParameter((String)url, (String)"t", (long)timestamp);
            urls.add(url);
        }
        return urls;
    }

    public void setPortletResourceAccessors(PortletResourceAccessor ... portletResourceAccessors) {
        this._portletResourceAccessors = portletResourceAccessors;
    }

    public void setPredicate(Predicate<String> predicate) {
        this._predicate = predicate;
    }

    public void setTimestamp(long timestamp) {
        this._timestamp = timestamp;
    }

    public void setURLPrefix(String urlPrefix) {
        this._urlPrefix = urlPrefix;
    }

    public void setVisitedURLs(Set<String> visitedURLs) {
        this._visitedURLs = visitedURLs;
    }
}

