/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.sharepoint.methods;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.sharepoint.Property;
import com.liferay.portal.sharepoint.ResponseElement;
import com.liferay.portal.sharepoint.SharepointRequest;
import com.liferay.portal.sharepoint.SharepointUtil;
import com.liferay.portal.sharepoint.methods.BaseMethodImpl;
import java.util.ArrayList;
import java.util.List;

public class UrlToWebUrlMethodImpl
extends BaseMethodImpl {
    private static final String _METHOD_NAME = "url to web url";
    private static final Log _log = LogFactoryUtil.getLog(UrlToWebUrlMethodImpl.class);

    @Override
    public String getMethodName() {
        return _METHOD_NAME;
    }

    @Override
    protected List<ResponseElement> getElements(SharepointRequest sharepointRequest) {
        ArrayList<ResponseElement> elements = new ArrayList<ResponseElement>();
        String url = sharepointRequest.getParameterValue("url");
        if (Validator.isNotNull((String)url)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Original URL " + url));
            }
            url = SharepointUtil.stripService(url, false);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Modified URL " + url));
            }
            elements.add(new Property("fileUrl", url));
            elements.add(new Property("webUrl", "/sharepoint"));
        } else if (_log.isInfoEnabled()) {
            _log.info((Object)("URL is " + url));
        }
        return elements;
    }
}

