/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.aop;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.aop.AopMethodInvocation;
import com.liferay.portal.kernel.aop.ChainableMethodAdvice;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.RetryAcceptor;
import com.liferay.portal.kernel.spring.aop.Property;
import com.liferay.portal.kernel.spring.aop.Retry;
import com.liferay.portal.util.PropsValues;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class RetryAdvice
extends ChainableMethodAdvice {
    private static final Log _log = LogFactoryUtil.getLog(RetryAdvice.class);

    public Object createMethodContext(Class<?> targetClass, Method method, Map<Class<? extends Annotation>, Annotation> annotations) {
        Retry retry = (Retry)annotations.get(Retry.class);
        if (retry == null) {
            return null;
        }
        int retries = retry.retries();
        if (retries < 0) {
            retries = PropsValues.RETRY_ADVICE_MAX_RETRIES;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Property property : retry.properties()) {
            properties.put(property.name(), property.value());
        }
        Class clazz = retry.acceptor();
        try {
            RetryAcceptor retryAcceptor = (RetryAcceptor)clazz.newInstance();
            return new RetryContext(retryAcceptor, properties, retries);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            _log.error((Object)reflectiveOperationException, (Throwable)reflectiveOperationException);
            return null;
        }
    }

    public Object invoke(AopMethodInvocation aopMethodInvocation, Object[] arguments) throws Throwable {
        int retries;
        RetryContext retryContext = (RetryContext)aopMethodInvocation.getAdviceMethodContext();
        RetryAcceptor retryAcceptor = retryContext._retryAcceptor;
        Map properties = retryContext._properties;
        int totalRetries = retries = retryContext._retries;
        if (retries >= 0) {
            ++retries;
        }
        Object returnValue = null;
        Throwable throwable1 = null;
        while (retries < 0 || retries-- > 0) {
            try {
                returnValue = aopMethodInvocation.proceed(arguments);
                if (!retryAcceptor.acceptResult(returnValue, properties)) {
                    return returnValue;
                }
                if (!_log.isWarnEnabled() || retries == 0) continue;
                String number = String.valueOf(retries);
                if (retries < 0) {
                    number = "unlimited";
                }
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Retry on ", aopMethodInvocation, " for ", number, " more times due to result ", returnValue}));
            }
            catch (Throwable throwable2) {
                throwable1 = throwable2;
                if (!retryAcceptor.acceptException(throwable2, properties)) {
                    throw throwable2;
                }
                if (!_log.isWarnEnabled() || retries == 0) continue;
                String number = String.valueOf(retries);
                if (retries < 0) {
                    number = "unlimited";
                }
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Retry on ", aopMethodInvocation, " for ", number, " more times due to exception ", throwable1}), throwable1);
            }
        }
        if (throwable1 != null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Give up retrying on ", aopMethodInvocation, " after ", totalRetries, " retries and rethrow last retry's exception ", throwable1}), throwable1);
            }
            throw throwable1;
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Give up retrying on ", aopMethodInvocation, " after ", totalRetries, " retries and returning the last retry's result ", returnValue}));
        }
        return returnValue;
    }

    private static class RetryContext {
        private final Map<String, String> _properties;
        private final int _retries;
        private final RetryAcceptor _retryAcceptor;

        private RetryContext(RetryAcceptor retryAcceptor, Map<String, String> properties, int retries) {
            this._retryAcceptor = retryAcceptor;
            this._properties = properties;
            this._retries = retries;
        }
    }
}

