/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseService;
import com.liferay.portal.util.PropsValues;

public class ServiceLocator {
    private static final Log _log = LogFactoryUtil.getLog(ServiceLocator.class);
    private static final ServiceLocator _serviceLocator = new ServiceLocator();

    public static ServiceLocator getInstance() {
        return _serviceLocator;
    }

    public Object findService(String serviceName) {
        Object object = SystemBundleUtil.callService((String)serviceName, obj -> obj);
        if (PropsValues.TEMPLATE_ENGINE_SERVICE_LOCATOR_RESTRICT && !(object instanceof BaseLocalService) && !(object instanceof BaseService)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Denied access to service \"", serviceName, "\" because it is not a Service Builder generated ", "service"}));
            }
            object = null;
        }
        return object;
    }

    @Deprecated
    public Object findService(String servletContextName, String serviceName) {
        return this.findService(serviceName);
    }

    private ServiceLocator() {
    }
}

