/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.FileComparator;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReader;
import com.liferay.portal.util.FileImpl;
import com.liferay.portal.xml.SAXReaderImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.oro.io.GlobFilenameFilter;
import org.apache.tools.ant.DirectoryScanner;

public class PluginsEnvironmentBuilder {
    private static final String _BRANCH = "master";
    private static final String[] _SOURCE_DIR_NAMES = new String[]{"docroot/WEB-INF/service", "docroot/WEB-INF/src", "src"};
    private static final String[] _TEST_TYPES = new String[]{"integration", "unit"};
    private static final FileImpl _fileImpl = FileImpl.getInstance();
    private static final SAXReader _saxReader = new SAXReaderImpl();

    public static void main(String[] args) throws Exception {
        try {
            File dir = new File(System.getProperty("plugins.env.dir"));
            new PluginsEnvironmentBuilder(dir);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public PluginsEnvironmentBuilder(File dir) throws Exception {
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(dir);
        directoryScanner.setIncludes(new String[]{"**\\liferay-plugin-package.properties"});
        directoryScanner.scan();
        String dirName = dir.getCanonicalPath();
        for (String fileName : directoryScanner.getIncludedFiles()) {
            this.setupWarProject(dirName, fileName);
        }
        directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(dir);
        directoryScanner.setIncludes(new String[]{"**\\build.xml"});
        directoryScanner.scan();
        for (String fileName : directoryScanner.getIncludedFiles()) {
            int x;
            String content = _fileImpl.read(dirName + "/" + fileName);
            boolean osgiProject = false;
            if (content.contains("../build-common-osgi-plugin.xml\" />") || content.contains("../tools/sdk/build-common-osgi-plugin.xml\" />")) {
                osgiProject = true;
            }
            boolean sharedProject = false;
            if (content.contains("<import file=\"../build-common-shared.xml\" />") || content.contains("../tools/sdk/build-common-shared.xml\" />")) {
                sharedProject = true;
            }
            List<String> dependencyJars = Collections.emptyList();
            if (osgiProject && (x = content.indexOf("osgi.ide.dependencies")) != -1) {
                x = content.indexOf("value=\"", x);
                x = content.indexOf("\"", x);
                int y = content.indexOf("\"", x + 1);
                dependencyJars = Arrays.asList(StringUtil.split((String)content.substring(x + 1, y)));
            }
            if (!osgiProject && !sharedProject) continue;
            this.setupJarProject(dirName, fileName, dependencyJars, sharedProject);
        }
    }

    @Deprecated
    protected void addClasspathEntry(com.liferay.portal.kernel.util.StringBundler sb, String jar) {
        this.addClasspathEntry(new StringBundler(sb.getStrings()), jar);
    }

    @Deprecated
    protected void addClasspathEntry(com.liferay.portal.kernel.util.StringBundler sb, String jar, Map<String, String> attributes) {
        this.addClasspathEntry(new StringBundler(sb.getStrings()), jar, attributes);
    }

    protected void addClasspathEntry(StringBundler sb, String jar) {
        this.addClasspathEntry(sb, jar, null);
    }

    protected void addClasspathEntry(StringBundler sb, String jar, Map<String, String> attributes) {
        sb.append("\t<classpathentry kind=\"lib\" path=\"");
        sb.append(jar);
        if (attributes == null || attributes.isEmpty()) {
            sb.append("\" />\n");
            return;
        }
        sb.append("\">\n\t\t<attributes>\n");
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            sb.append("\t\t\t<attribute name=\"");
            sb.append(entry.getKey());
            sb.append("\" value=\"");
            sb.append(entry.getValue());
            sb.append("\" />\n");
        }
        sb.append("\t\t</attributes>\n\t</classpathentry>\n");
    }

    @Deprecated
    protected void addIvyCacheJar(com.liferay.portal.kernel.util.StringBundler sb, String ivyDirName, String dependencyName, String version) throws Exception {
        this.addIvyCacheJar(new StringBundler(sb.getStrings()), ivyDirName, dependencyName, version);
    }

    protected void addIvyCacheJar(StringBundler sb, String ivyDirName, String dependencyName, String version) throws Exception {
        File[] files;
        String dirName;
        Document document;
        Element rootElement;
        Element dependenciesElement;
        String ivyFileName;
        String string = sb.toString();
        if (string.contains(dependencyName)) {
            System.out.println(StringBundler.concat((String[])new String[]{"Skipping duplicate ", dependencyName, " ", version}));
            return;
        }
        System.out.println(StringBundler.concat((String[])new String[]{"Adding ", dependencyName, " ", version}));
        if (version.equals("latest.integration")) {
            File dir = new File(ivyDirName + "/cache/" + dependencyName);
            File[] files2 = dir.listFiles();
            Arrays.sort(files2, new FileComparator());
            for (int i = files2.length - 1; i >= 0; --i) {
                String fileName;
                File file = files2[i];
                if (!file.isFile() || !(fileName = file.getName()).endsWith(".xml")) continue;
                version = fileName.substring(4, fileName.length() - 4);
                System.out.println("Substituting " + version + " for latest.integration");
            }
        }
        if (_fileImpl.exists(ivyFileName = StringBundler.concat((String[])new String[]{ivyDirName, "/cache/", dependencyName, "/ivy-", version, ".xml"})) && (dependenciesElement = (rootElement = (document = _saxReader.read(new File(ivyFileName))).getRootElement()).element("dependencies")) != null) {
            List dependencyElements = dependenciesElement.elements("dependency");
            for (Element dependencyElement : dependencyElements) {
                String conf = GetterUtil.getString((String)dependencyElement.attributeValue("conf"));
                if (!conf.startsWith("compile")) continue;
                String name = GetterUtil.getString((String)dependencyElement.attributeValue("name"));
                string = sb.toString();
                if (string.contains(name)) continue;
                String org = GetterUtil.getString((String)dependencyElement.attributeValue("org"));
                String rev = GetterUtil.getString((String)dependencyElement.attributeValue("rev"));
                this.addIvyCacheJar(sb, ivyDirName, org + "/" + name, rev);
            }
        }
        if (!_fileImpl.exists(dirName = StringBundler.concat((String[])new String[]{ivyDirName, "/cache/", dependencyName, "/bundles"})) && !_fileImpl.exists(dirName = StringBundler.concat((String[])new String[]{ivyDirName, "/cache/", dependencyName, "/jars"}))) {
            System.out.println("Unable to find jars in " + dirName);
            return;
        }
        File dir = new File(dirName);
        for (File file : files = dir.listFiles()) {
            String fileName;
            if (!file.isFile() || !(fileName = file.getName()).endsWith("-" + version + ".jar")) continue;
            int index = dirName.indexOf("/.ivy");
            String eclipseRelativeDirName = "/portal" + dirName.substring(index);
            this.addClasspathEntry(sb, eclipseRelativeDirName + "/" + fileName);
            return;
        }
        System.out.println(StringBundler.concat((String[])new String[]{"Unable to find jars in ", dirName, " for ", version}));
    }

    @Deprecated
    protected void addIvyCacheJars(com.liferay.portal.kernel.util.StringBundler sb, String content, String ivyDirName) throws Exception {
        this.addIvyCacheJars(new StringBundler(sb.getStrings()), content, ivyDirName);
    }

    protected void addIvyCacheJars(StringBundler sb, String content, String ivyDirName) throws Exception {
        Document document = _saxReader.read(content);
        Element rootElement = document.getRootElement();
        Element dependenciesElement = rootElement.element("dependencies");
        List dependencyElements = dependenciesElement.elements("dependency");
        for (Element dependencyElement : dependencyElements) {
            String conf = GetterUtil.getString((String)dependencyElement.attributeValue("conf"));
            if (!conf.equals("test->default")) continue;
            String name = GetterUtil.getString((String)dependencyElement.attributeValue("name"));
            String org = GetterUtil.getString((String)dependencyElement.attributeValue("org"));
            String rev = GetterUtil.getString((String)dependencyElement.attributeValue("rev"));
            this.addIvyCacheJar(sb, ivyDirName, org + "/" + name, rev);
        }
    }

    protected List<String> getCommonJars() {
        return ListUtil.fromArray((Object[])new String[]{"commons-logging.jar", "log4j-1.2-api.jar", "log4j-api.jar", "log4j-core.jar", "util-bridges.jar", "util-java.jar", "util-taglib.jar"});
    }

    protected List<String> getImportSharedJars(File projectDir) throws Exception {
        File buildXmlFile = new File(projectDir, "build.xml");
        String content = _fileImpl.read(buildXmlFile);
        int x = content.indexOf("import.shared");
        if (x == -1) {
            return new ArrayList<String>();
        }
        x = content.indexOf("value=\"", x);
        x = content.indexOf("\"", x);
        int y = content.indexOf("\" />", x);
        if (x == -1 || y == -1) {
            return new ArrayList<String>();
        }
        String[] importShared = StringUtil.split((String)content.substring(x + 1, y));
        if (importShared.length == 0) {
            return new ArrayList<String>();
        }
        ArrayList<String> jars = new ArrayList<String>();
        for (String currentImportShared : importShared) {
            jars.add(currentImportShared + ".jar");
            File currentImportSharedLibDir = new File(projectDir, "../../shared/" + currentImportShared + "/lib");
            if (!currentImportSharedLibDir.exists()) continue;
            for (File file : currentImportSharedLibDir.listFiles()) {
                jars.add(file.getName());
            }
        }
        return jars;
    }

    protected List<String> getPortalDependencyJars(Properties properties) {
        Object[] dependencyJars = StringUtil.split((String)properties.getProperty("portal-dependency-jars", properties.getProperty("portal.dependency.jars")));
        return ListUtil.fromArray((Object[])dependencyJars);
    }

    protected List<String> getRequiredDeploymentContextsJars(File libDir, Properties properties) throws Exception {
        String[] requiredDeploymentContexts;
        ArrayList<String> jars = new ArrayList<String>();
        for (String requiredDeploymentContext : requiredDeploymentContexts = StringUtil.split((String)properties.getProperty("required-deployment-contexts"))) {
            if (!_fileImpl.exists(StringBundler.concat((String[])new String[]{libDir.getCanonicalPath(), "/", requiredDeploymentContext, "-service.jar"}))) continue;
            jars.add(requiredDeploymentContext + "-service.jar");
        }
        return jars;
    }

    protected boolean hasModulesGitIgnore(String dirName) {
        int index = dirName.indexOf("/modules/");
        if (index == -1) {
            return false;
        }
        return _fileImpl.exists(dirName.substring(0, index) + "/modules/.gitignore");
    }

    protected void setupJarProject(String dirName, String fileName, List<String> dependencyJars, boolean sharedProject) throws Exception {
        File buildFile = new File(dirName + "/" + fileName);
        File projectDir = new File(buildFile.getParent());
        File libDir = new File(projectDir, "lib");
        if (!libDir.exists()) {
            libDir = new File(projectDir, "docroot/WEB-INF/lib");
        }
        this.writeEclipseFiles(libDir, projectDir, dependencyJars);
        List<String> importSharedJars = this.getImportSharedJars(projectDir);
        if (sharedProject && !importSharedJars.contains("portal-compat-shared.jar")) {
            importSharedJars.add("portal-compat-shared.jar");
        }
        File gitignoreFile = new File(projectDir.getCanonicalPath() + "/.gitignore");
        if (this.hasModulesGitIgnore(dirName)) {
            gitignoreFile.delete();
            return;
        }
        Object[] gitIgnores = importSharedJars.toArray(new String[0]);
        for (int i = 0; i < gitIgnores.length; ++i) {
            String gitIgnore = gitIgnores[i];
            gitIgnores[i] = gitIgnore = "/lib/" + gitIgnore;
        }
        if (gitIgnores.length > 0) {
            System.out.println("Updating " + gitignoreFile);
            _fileImpl.write(gitignoreFile, StringUtil.merge((Object[])gitIgnores, (String)"\n"));
        }
    }

    protected void setupWarProject(String dirName, String fileName) throws Exception {
        File propertiesFile = new File(dirName + "/" + fileName);
        Properties properties = new Properties();
        properties.load(new FileInputStream(propertiesFile));
        TreeSet<String> jars = new TreeSet<String>();
        jars.addAll(this.getCommonJars());
        List<String> dependencyJars = this.getPortalDependencyJars(properties);
        jars.addAll(dependencyJars);
        File projectDir = new File(propertiesFile.getParent() + "/../..");
        jars.addAll(this.getImportSharedJars(projectDir));
        File libDir = new File(propertiesFile.getParent() + "/lib");
        jars.addAll(this.getRequiredDeploymentContextsJars(libDir, properties));
        this.writeEclipseFiles(libDir, projectDir, dependencyJars);
        String libDirPath = StringUtil.replace((String)libDir.getPath(), (char)'\\', (char)'/');
        List ignores = ListUtil.fromFile((String)(libDir.getCanonicalPath() + "/../.gitignore"));
        if (libDirPath.contains("/ext/") || ignores.contains("/lib")) {
            return;
        }
        File gitignoreFile = new File(libDir.getCanonicalPath() + "/.gitignore");
        System.out.println("Updating " + gitignoreFile);
        Object[] gitIgnores = jars.toArray(new String[0]);
        for (int i = 0; i < gitIgnores.length; ++i) {
            String gitIgnore = gitIgnores[i];
            if (!Validator.isNotNull((String)gitIgnore) || gitIgnore.startsWith("/")) continue;
            gitIgnores[i] = "/" + gitIgnore;
        }
        _fileImpl.write(gitignoreFile, StringUtil.merge((Object[])gitIgnores, (String)"\n"));
    }

    protected void writeClasspathFile(File libDir, List<String> dependencyJars, String projectDirName, String projectName, boolean javaProject) throws Exception {
        String content;
        boolean bl;
        File classpathFile = new File(projectDirName + "/.classpath");
        if (!javaProject) {
            classpathFile.delete();
            return;
        }
        LinkedHashSet<String> globalJars = new LinkedHashSet<String>();
        List<String> portalJars = new ArrayList<String>();
        String libDirPath = StringUtil.replace((String)libDir.getPath(), (char)'\\', (char)'/');
        globalJars.add("portlet.jar");
        portalJars.addAll(dependencyJars);
        portalJars.add("commons-logging.jar");
        portalJars.add("log4j-1.2-api.jar");
        portalJars.add("log4j-api.jar");
        portalJars.add("log4j-core.jar");
        portalJars = ListUtil.unique(portalJars);
        Collections.sort(portalJars);
        Object[] customJarsArray = libDir.list((FilenameFilter)new GlobFilenameFilter("*.jar"));
        ArrayList customJars = null;
        if (customJarsArray != null) {
            customJars = ListUtil.fromArray((Object[])customJarsArray);
            for (String string : portalJars) {
                customJars.remove(string);
            }
            customJars.remove(projectName + "-service.jar");
            customJars.remove("util-bridges.jar");
            customJars.remove("util-java.jar");
            customJars.remove("util-taglib.jar");
            Collections.sort(customJars);
        } else {
            customJars = new ArrayList();
        }
        StringBundler sb = new StringBundler();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
        sb.append("<classpath>\n");
        for (String sourceDirName : _SOURCE_DIR_NAMES) {
            if (!_fileImpl.exists(projectDirName + "/" + sourceDirName)) continue;
            sb.append("\t<classpathentry excluding=\"**/.svn/**|.svn/\" ");
            sb.append("kind=\"src\" path=\"");
            sb.append(sourceDirName);
            sb.append("\" />\n");
        }
        sb.append("\t<classpathentry kind=\"src\" path=\"/portal\" />\n");
        sb.append("\t<classpathentry kind=\"con\" ");
        sb.append("path=\"org.eclipse.jdt.launching.JRE_CONTAINER\" />\n");
        boolean bl2 = false;
        for (String testType : _TEST_TYPES) {
            String testFolder = "test/" + testType;
            if (!_fileImpl.exists(projectDirName + "/" + testFolder)) continue;
            bl = true;
            sb.append("\t<classpathentry excluding=\"**/.svn/**|.svn/\" ");
            sb.append("kind=\"src\" path=\"");
            sb.append(testFolder);
            sb.append("\" />\n");
        }
        if (bl) {
            this.addClasspathEntry(sb, "/portal/lib/development/junit.jar");
            this.addClasspathEntry(sb, "/portal/lib/development/mockito.jar");
            this.addClasspathEntry(sb, "/portal/lib/development/powermock-api-mockito.jar");
            this.addClasspathEntry(sb, "/portal/lib/development/powermock-api-support.jar");
            this.addClasspathEntry(sb, "/portal/lib/development/powermock-core.jar");
            this.addClasspathEntry(sb, "/portal/lib/development/powermock-module-junit4.jar");
            this.addClasspathEntry(sb, "/portal/lib/development/powermock-module-junit4-common.jar");
            this.addClasspathEntry(sb, "/portal/lib/development/spring-test.jar");
            portalJars.add("commons-io.jar");
            portalJars.add("commons-lang.jar");
        }
        this.addClasspathEntry(sb, "/portal/lib/development/activation.jar");
        this.addClasspathEntry(sb, "/portal/lib/development/annotations.jar");
        this.addClasspathEntry(sb, "/portal/lib/development/jsp-api.jar");
        this.addClasspathEntry(sb, "/portal/lib/development/mail.jar");
        this.addClasspathEntry(sb, "/portal/lib/development/servlet-api.jar");
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (libDirPath.contains("/ext/")) {
            attributes.put("optional", "true");
        }
        for (String jar : globalJars) {
            this.addClasspathEntry(sb, "/portal/lib/global/" + jar, attributes);
        }
        portalJars = ListUtil.unique(portalJars);
        Collections.sort(portalJars);
        for (String jar : portalJars) {
            if (jar.equals("util-slf4j.jar")) continue;
            this.addClasspathEntry(sb, "/portal/lib/portal/" + jar, attributes);
        }
        this.addClasspathEntry(sb, "/portal/portal-kernel/portal-kernel.jar");
        this.addClasspathEntry(sb, "/portal/util-bridges/util-bridges.jar");
        this.addClasspathEntry(sb, "/portal/util-java/util-java.jar");
        if (portalJars.contains("util-slf4j.jar")) {
            this.addClasspathEntry(sb, "/portal/util-slf4j/util-slf4j.jar");
        }
        this.addClasspathEntry(sb, "/portal/util-taglib/util-taglib.jar");
        for (String jar : customJars) {
            if (libDirPath.contains("/tmp/WEB-INF/lib")) {
                this.addClasspathEntry(sb, "tmp/WEB-INF/lib/" + jar);
                continue;
            }
            if (libDirPath.contains("/docroot/WEB-INF/lib")) {
                this.addClasspathEntry(sb, "docroot/WEB-INF/lib/" + jar);
                continue;
            }
            this.addClasspathEntry(sb, "lib/" + jar);
        }
        File ivyXmlFile = new File(projectDirName, "ivy.xml");
        if (ivyXmlFile.exists() && (content = _fileImpl.read(ivyXmlFile)).contains("test->default")) {
            String ivyDirName = ".ivy";
            for (int i = 0; i < 10 && !_fileImpl.exists(ivyDirName); ++i) {
                ivyDirName = "../" + ivyDirName;
            }
            this.addIvyCacheJars(sb, content, ivyDirName);
        }
        sb.append("\t<classpathentry kind=\"output\" path=\"bin\" />\n");
        sb.append("</classpath>");
        System.out.println("Updating " + classpathFile);
        content = StringUtil.replace((String)sb.toString(), (String)"\"/portal", (String)"\"/portal-master");
        _fileImpl.write(classpathFile, content);
    }

    protected void writeEclipseFiles(File libDir, File projectDir, List<String> dependencyJars) throws Exception {
        String projectDirName = projectDir.getCanonicalPath();
        String projectName = StringUtil.extractLast((String)projectDirName, (char)File.separatorChar);
        boolean javaProject = false;
        for (String sourceDirName : _SOURCE_DIR_NAMES) {
            if (!_fileImpl.exists(projectDirName + "/" + sourceDirName)) continue;
            javaProject = true;
            break;
        }
        if (!javaProject) {
            System.out.println("Eclipse Java project will not be used because a source folder does not exist");
        }
        this.writeProjectFile(projectDirName, projectName, javaProject);
        this.writeClasspathFile(libDir, dependencyJars, projectDirName, projectName, javaProject);
        if (_fileImpl.exists(projectDirName + "/test")) {
            _fileImpl.write(projectDirName + "/.gitignore", "/test-classes\n/test-results");
        } else {
            _fileImpl.delete(projectDirName + "/.gitignore");
        }
    }

    protected void writeProjectFile(String projectDirName, String projectName, boolean javaProject) throws Exception {
        StringBundler sb = new StringBundler(19);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
        sb.append("<projectDescription>\n");
        sb.append("\t<name>");
        sb.append(projectName);
        sb.append("-");
        sb.append(_BRANCH);
        sb.append("</name>\n");
        sb.append("\t<comment></comment>\n");
        sb.append("\t<projects></projects>\n");
        sb.append("\t<buildSpec>\n");
        if (javaProject) {
            sb.append("\t\t<buildCommand>\n");
            sb.append("\t\t\t<name>org.eclipse.jdt.core.javabuilder</name>\n");
            sb.append("\t\t\t<arguments></arguments>\n");
            sb.append("\t\t</buildCommand>\n");
        }
        sb.append("\t</buildSpec>\n");
        sb.append("\t<natures>\n");
        if (javaProject) {
            sb.append("\t\t<nature>org.eclipse.jdt.core.javanature</nature>\n");
        }
        sb.append("\t</natures>\n");
        sb.append("</projectDescription>");
        File projectFile = new File(projectDirName + "/.project");
        System.out.println("Updating " + projectFile);
        _fileImpl.write(projectFile, sb.toString());
    }
}

