/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.util;

import com.liferay.petra.concurrent.NoticeableExecutorService;
import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.portal.kernel.dao.db.BaseDBProcess;
import com.liferay.portal.kernel.dao.db.DBProcess;
import com.liferay.portal.kernel.upgrade.BaseUpgradeCallable;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import java.util.ArrayList;
import java.util.concurrent.Future;

public class ParallelUpgradeSchemaUtil {
    private static volatile PortalExecutorManager _portalExecutorManager = (PortalExecutorManager)ServiceProxyFactory.newServiceTrackedInstance(PortalExecutorManager.class, ParallelUpgradeSchemaUtil.class, (String)"_portalExecutorManager", (boolean)true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(DBProcess dbProcess, String ... sqlFileNames) throws Exception {
        NoticeableExecutorService executorService = _portalExecutorManager.getPortalExecutor(ParallelUpgradeSchemaUtil.class.getName());
        ArrayList futures = new ArrayList(sqlFileNames.length);
        try {
            for (String sqlFileName : sqlFileNames) {
                futures.add(executorService.submit(new SQLExecutorUpgradeCallable(dbProcess, sqlFileName)));
            }
            for (Future future : futures) {
                future.get();
            }
        }
        finally {
            executorService.shutdown();
        }
    }

    @Deprecated
    public static void execute(String ... sqlFileNames) throws Exception {
        ParallelUpgradeSchemaUtil.execute((DBProcess)new BaseDBProcess(){}, sqlFileNames);
    }

    private static class SQLExecutorUpgradeCallable
    extends BaseUpgradeCallable<Void> {
        private final DBProcess _dbProcess;
        private final String _sqlFileName;

        protected Void doCall() throws Exception {
            try (LoggingTimer loggingTimer = new LoggingTimer(this._sqlFileName);){
                this._dbProcess.runSQLTemplate(this._sqlFileName, false);
            }
            return null;
        }

        private SQLExecutorUpgradeCallable(DBProcess dbProcess, String sqlFileName) {
            this._dbProcess = dbProcess;
            this._sqlFileName = sqlFileName;
        }
    }
}

