/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.NotificationThreadLocal;
import com.liferay.portal.kernel.util.VerifyThreadLocal;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.verify.VerifyException;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portlet.exportimport.staging.StagingAdvicesThreadLocal;

@Deprecated
public class VerifyProcessUtil {
    private static final Log _log = LogFactoryUtil.getLog(VerifyProcessUtil.class);

    public static boolean verifyProcess(boolean ranUpgradeProcess, boolean verified) throws VerifyException {
        int verifyFrequency = GetterUtil.getInteger((String)PropsUtil.get("verify.frequency"));
        if (verifyFrequency == -1 || verifyFrequency == 1 && !verified || ranUpgradeProcess) {
            return VerifyProcessUtil._verifyProcess();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean _verifyProcess() throws VerifyException {
        boolean ranVerifyProcess = false;
        NotificationThreadLocal.setEnabled((boolean)false);
        StagingAdvicesThreadLocal.setEnabled(false);
        VerifyThreadLocal.setVerifyInProgress((boolean)true);
        WorkflowThreadLocal.setEnabled((boolean)false);
        try {
            String[] verifyProcessClassNames;
            for (String verifyProcessClassName : verifyProcessClassNames = PropsUtil.getArray("verify.processes")) {
                boolean tempRanVerifyProcess = VerifyProcessUtil._verifyProcess(verifyProcessClassName);
                if (!tempRanVerifyProcess) continue;
                ranVerifyProcess = true;
            }
        }
        finally {
            NotificationThreadLocal.setEnabled((boolean)true);
            StagingAdvicesThreadLocal.setEnabled(true);
            VerifyThreadLocal.setVerifyInProgress((boolean)false);
            WorkflowThreadLocal.setEnabled((boolean)true);
        }
        return ranVerifyProcess;
    }

    private static boolean _verifyProcess(String verifyProcessClassName) throws VerifyException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Initializing verification " + verifyProcessClassName));
        }
        try {
            Class<?> clazz = Class.forName(verifyProcessClassName);
            VerifyProcess verifyProcess = (VerifyProcess)((Object)clazz.newInstance());
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Running verification " + verifyProcessClassName));
            }
            verifyProcess.verify();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Finished verification " + verifyProcessClassName));
            }
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            _log.error((Object)(verifyProcessClassName + " cannot be found"), (Throwable)classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            _log.error((Object)(verifyProcessClassName + " cannot be accessed"), (Throwable)illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            _log.error((Object)(verifyProcessClassName + " cannot be initiated"), (Throwable)instantiationException);
        }
        return false;
    }
}

