/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.zip;

import com.liferay.petra.io.StreamUtil;
import com.liferay.petra.io.unsync.UnsyncFilterInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.zip.ZipReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipReaderImpl
implements ZipReader {
    private static final Log _log = LogFactoryUtil.getLog(ZipReaderImpl.class);
    private final File _file;
    private File _tempFile;

    public ZipReaderImpl(File file) {
        this._file = file;
    }

    public ZipReaderImpl(InputStream inputStream) throws IOException {
        this(FileUtil.createTempFile((InputStream)inputStream));
        this._tempFile = this._file;
    }

    public void close() {
        if (this._tempFile != null) {
            this._tempFile.delete();
        }
    }

    public List<String> getEntries() {
        ArrayList<String> entries = new ArrayList<String>();
        try (ZipFile zipFile = new ZipFile(this._file);){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory()) continue;
                entries.add(zipEntry.getName());
            }
        }
        catch (IOException ioException) {
            throw new UncheckedIOException(ioException);
        }
        entries.sort(null);
        return entries;
    }

    public byte[] getEntryAsByteArray(String name) {
        if (Validator.isNull((String)name)) {
            return null;
        }
        try {
            return StreamUtil.toByteArray((InputStream)this.getEntryAsInputStream(name));
        }
        catch (IOException ioException) {
            _log.error((Object)ioException, (Throwable)ioException);
            return null;
        }
    }

    public InputStream getEntryAsInputStream(String name) {
        if (Validator.isNull((String)name)) {
            return null;
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        try {
            InputStream inputStream;
            final ZipFile zipFile = new ZipFile(this._file);
            ZipEntry zipEntry = zipFile.getEntry(name);
            if (zipEntry != null && !zipEntry.isDirectory() && (inputStream = zipFile.getInputStream(zipEntry)) != null) {
                return new UnsyncFilterInputStream(inputStream){

                    public void close() throws IOException {
                        super.close();
                        zipFile.close();
                    }
                };
            }
            zipFile.close();
            return null;
        }
        catch (IOException ioException) {
            throw new UncheckedIOException(ioException);
        }
    }

    public String getEntryAsString(String name) {
        if (Validator.isNull((String)name)) {
            return null;
        }
        byte[] bytes = this.getEntryAsByteArray(name);
        if (bytes != null) {
            return new String(bytes);
        }
        return null;
    }

    public List<String> getFolderEntries(String path) {
        if (Validator.isNull((String)path)) {
            return Collections.emptyList();
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        Path javaPath = Paths.get(path, new String[0]);
        javaPath = javaPath.normalize();
        path = javaPath.toString();
        ArrayList<String> entries = new ArrayList<String>();
        try (ZipFile zipFile = new ZipFile(this._file);){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory()) continue;
                String fileName = zipEntry.getName();
                int pos = fileName.lastIndexOf(47);
                String folderName = "";
                if (pos > 0) {
                    folderName = fileName.substring(0, pos);
                }
                if (!folderName.equals(path)) continue;
                entries.add(fileName);
            }
        }
        catch (IOException ioException) {
            throw new UncheckedIOException(ioException);
        }
        entries.sort(null);
        return entries;
    }
}

