/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.expando.service.impl;

import com.liferay.expando.kernel.exception.DuplicateTableNameException;
import com.liferay.expando.kernel.exception.TableNameException;
import com.liferay.expando.kernel.model.ExpandoTable;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.expando.service.base.ExpandoTableLocalServiceBaseImpl;
import java.util.List;

public class ExpandoTableLocalServiceImpl
extends ExpandoTableLocalServiceBaseImpl {
    public ExpandoTable addDefaultTable(long companyId, long classNameId) throws PortalException {
        return this.addTable(companyId, classNameId, "CUSTOM_FIELDS");
    }

    public ExpandoTable addDefaultTable(long companyId, String className) throws PortalException {
        return this.addTable(companyId, className, "CUSTOM_FIELDS");
    }

    public ExpandoTable addTable(long companyId, long classNameId, String name) throws PortalException {
        ExpandoTable expandoTable = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, name);
        if (expandoTable != null) {
            return expandoTable;
        }
        this.validate(companyId, 0L, classNameId, name);
        long tableId = this.counterLocalService.increment();
        ExpandoTable table = this.expandoTablePersistence.create(tableId);
        table.setCompanyId(companyId);
        table.setClassNameId(classNameId);
        table.setName(name);
        return (ExpandoTable)this.expandoTablePersistence.update((BaseModel)table);
    }

    public ExpandoTable addTable(long companyId, String className, String name) throws PortalException {
        return this.addTable(companyId, this.classNameLocalService.getClassNameId(className), name);
    }

    @Override
    public ExpandoTable deleteExpandoTable(ExpandoTable expandoTable) {
        this.deleteTable(expandoTable);
        return expandoTable;
    }

    public void deleteTable(ExpandoTable table) {
        this.expandoTablePersistence.remove((BaseModel)table);
        this.expandoColumnPersistence.removeByTableId(table.getTableId());
        this.expandoRowPersistence.removeByTableId(table.getTableId());
        this.expandoValuePersistence.removeByTableId(table.getTableId());
    }

    public void deleteTable(long tableId) throws PortalException {
        ExpandoTable table = this.expandoTablePersistence.findByPrimaryKey(tableId);
        this.deleteTable(table);
    }

    public void deleteTable(long companyId, long classNameId, String name) throws PortalException {
        ExpandoTable table = this.expandoTablePersistence.findByC_C_N(companyId, classNameId, name);
        this.deleteTable(table);
    }

    public void deleteTable(long companyId, String className, String name) throws PortalException {
        this.deleteTable(companyId, this.classNameLocalService.getClassNameId(className), name);
    }

    public void deleteTables(long companyId, long classNameId) {
        List tables = this.expandoTablePersistence.findByC_C(companyId, classNameId);
        for (ExpandoTable table : tables) {
            this.deleteTable(table);
        }
    }

    public void deleteTables(long companyId, String className) {
        this.deleteTables(companyId, this.classNameLocalService.getClassNameId(className));
    }

    public ExpandoTable fetchDefaultTable(long companyId, long classNameId) {
        return this.fetchTable(companyId, classNameId, "CUSTOM_FIELDS");
    }

    public ExpandoTable fetchDefaultTable(long companyId, String className) {
        return this.fetchTable(companyId, this.classNameLocalService.getClassNameId(className), "CUSTOM_FIELDS");
    }

    public ExpandoTable fetchTable(long companyId, long classNameId, String name) {
        return this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, name);
    }

    public ExpandoTable getDefaultTable(long companyId, long classNameId) throws PortalException {
        return this.getTable(companyId, classNameId, "CUSTOM_FIELDS");
    }

    public ExpandoTable getDefaultTable(long companyId, String className) throws PortalException {
        return this.getTable(companyId, this.classNameLocalService.getClassNameId(className), "CUSTOM_FIELDS");
    }

    public ExpandoTable getTable(long tableId) throws PortalException {
        return this.expandoTablePersistence.findByPrimaryKey(tableId);
    }

    public ExpandoTable getTable(long companyId, long classNameId, String name) throws PortalException {
        return this.expandoTablePersistence.findByC_C_N(companyId, classNameId, name);
    }

    public ExpandoTable getTable(long companyId, String className, String name) throws PortalException {
        return this.getTable(companyId, this.classNameLocalService.getClassNameId(className), name);
    }

    public List<ExpandoTable> getTables(long companyId, long classNameId) {
        return this.expandoTablePersistence.findByC_C(companyId, classNameId);
    }

    public List<ExpandoTable> getTables(long companyId, String className) {
        return this.getTables(companyId, this.classNameLocalService.getClassNameId(className));
    }

    public ExpandoTable updateTable(long tableId, String name) throws PortalException {
        ExpandoTable table = this.expandoTablePersistence.findByPrimaryKey(tableId);
        String tableName = table.getName();
        if (tableName.equals("CUSTOM_FIELDS")) {
            throw new TableNameException("Cannot rename CUSTOM_FIELDS");
        }
        this.validate(table.getCompanyId(), tableId, table.getClassNameId(), name);
        table.setName(name);
        return (ExpandoTable)this.expandoTablePersistence.update((BaseModel)table);
    }

    protected void validate(long companyId, long tableId, long classNameId, String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new TableNameException("Name is null");
        }
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, name);
        if (table != null && table.getTableId() != tableId) {
            throw new DuplicateTableNameException("{tableId=" + tableId + "}");
        }
    }
}

